/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.tree;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.ElementPresentationTemplate;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.tree.AbstractDomElementNode;
import com.intellij.util.xml.tree.BaseDomElementNode;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DomElementsGroupNode
extends AbstractDomElementNode {
    private final DomElement myParentElement;
    private final DomElement myRootDomElement;
    private final String myChildrenTagName;
    private final DomCollectionChildDescription myChildDescription;

    public DomElementsGroupNode(DomElement modelElement, DomCollectionChildDescription description, SimpleNode parent, DomElement rootDomElement) {
        super(modelElement, parent);
        this.myParentElement = modelElement;
        this.myChildDescription = description;
        this.myChildrenTagName = description.getXmlElementName();
        this.myRootDomElement = rootDomElement;
    }

    @NotNull
    public SimpleNode[] getChildren() {
        if (!this.myParentElement.isValid()) {
            if (NO_CHILDREN == null) {
                DomElementsGroupNode.$$$reportNull$$$0(0);
            }
            return NO_CHILDREN;
        }
        ArrayList<BaseDomElementNode> simpleNodes = new ArrayList<BaseDomElementNode>();
        for (DomElement domElement : this.myChildDescription.getStableValues(this.myParentElement)) {
            if (!this.shouldBeShown(domElement.getDomElementType())) continue;
            simpleNodes.add(new BaseDomElementNode(domElement, this.myRootDomElement, this));
        }
        SimpleNode[] simpleNodeArray = simpleNodes.toArray(new SimpleNode[0]);
        if (simpleNodeArray == null) {
            DomElementsGroupNode.$$$reportNull$$$0(1);
        }
        return simpleNodeArray;
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myParentElement, this.myChildrenTagName};
        if (objectArray == null) {
            DomElementsGroupNode.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    protected void doUpdate() {
        this.setUniformIcon(this.getNodeIcon());
        this.clearColoredText();
        boolean showErrors = this.hasErrors();
        int childrenCount = this.getChildren().length;
        if (childrenCount > 0) {
            SimpleTextAttributes textAttributes = showErrors ? this.getWavedAttributes(1) : new SimpleTextAttributes(1, SimpleTextAttributes.REGULAR_ATTRIBUTES.getFgColor());
            this.addColoredFragment(this.getNodeName(), textAttributes);
            this.addColoredFragment(" (" + childrenCount + ')', showErrors ? IdeBundle.message((String)"dom.elements.tree.childs.contain.errors", (Object[])new Object[0]) : null, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        } else {
            this.addColoredFragment(this.getNodeName(), SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        }
    }

    private boolean hasErrors() {
        if (!this.myParentElement.isValid()) {
            return false;
        }
        for (DomElement domElement : this.myChildDescription.getStableValues(this.myParentElement)) {
            DomElementAnnotationsManager annotationsManager = DomElementAnnotationsManager.getInstance(this.getProject());
            DomElementsProblemsHolder holder = annotationsManager.getCachedProblemHolder(domElement);
            List<DomElementProblemDescriptor> problems = holder.getProblems(domElement, true, HighlightSeverity.ERROR);
            if (problems.size() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getNodeName() {
        if (!this.myParentElement.isValid()) {
            return "";
        }
        return this.myChildDescription.getCommonPresentableName(this.myParentElement);
    }

    @Override
    public String getTagName() {
        return this.myChildrenTagName;
    }

    @Override
    public DomElement getDomElement() {
        return this.myParentElement;
    }

    public DomCollectionChildDescription getChildDescription() {
        return this.myChildDescription;
    }

    @Override
    public Icon getNodeIcon() {
        Class clazz = ReflectionUtil.getRawType((Type)this.myChildDescription.getType());
        ElementPresentationTemplate template = this.myChildDescription.getPresentationTemplate();
        if (template != null) {
            return template.createPresentation(null).getIcon();
        }
        return ElementPresentationManager.getIconForClass(clazz);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/xml/tree/DomElementsGroupNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObjects";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

