/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.printing;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.actions.printing.DarculaAwareGraph2DPrinter;
import com.intellij.openapi.graph.builder.actions.printing.PrintGraphAction;
import com.intellij.openapi.graph.builder.actions.printing.PrintOptionsDialog;
import com.intellij.openapi.graph.builder.actions.printing.PrintUtil;
import com.intellij.openapi.graph.option.OptionHandler;
import com.intellij.openapi.graph.view.BackgroundRenderer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.PrintPreviewPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterJob;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

@Deprecated
public class PrintPreviewAction
extends AbstractGraphAction<Graph2D> {
    public PrintPreviewAction() {
    }

    public PrintPreviewAction(Graph2D graph2D) {
        super(graph2D);
    }

    @Override
    public void actionPerformed(AnActionEvent e, Graph2D graph2D) {
        Project project = PrintPreviewAction.getProject(e);
        if (project == null) {
            return;
        }
        GraphBuilder builder = (GraphBuilder)((Object)e.getDataContext().getData(GraphBuilder.GRAPH_BUILDER_KEY));
        if (builder == null) {
            return;
        }
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PrintPreviewAction.actionPerformedImpl(builder, printJob);
    }

    public static void actionPerformedImpl(final GraphBuilder builder, final PrinterJob printJob) {
        final Project project = builder.getProject();
        final Graph2D graph2D = builder.getGraph();
        Graph2DView view = PrintPreviewAction.getGraph2DView(graph2D);
        final BackgroundRenderer renderer = view.getBackgroundRenderer();
        final DarculaAwareGraph2DPrinter gp = new DarculaAwareGraph2DPrinter(view);
        final PrintPreviewPanel panel = GraphManager.getGraphManager().createPrintPreviewPanel(printJob, gp, gp.getPosterColumns(), gp.getPosterColumns() * gp.getPosterRows(), printJob.defaultPage());
        panel.setThreadingEnabled(false);
        final OptionHandler options = PrintUtil.createPrintOptions();
        AbstractAction optionAction = new AbstractAction("Options..."){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PrintOptionsDialog dialog = new PrintOptionsDialog(project, options);
                if (!dialog.showAndGet()) {
                    return;
                }
                PrintUtil.initGraph2DPrinter(gp, options);
                panel.setPages(0, gp.getPosterColumns(), gp.getPosterColumns() * gp.getPosterRows());
            }
        };
        panel.addControlComponent(new JButton(optionAction));
        final JPanel panelComponent = panel.getJPanel();
        UIUtil.uiTraverser((Component)panelComponent).filter(JButton.class).filter(o -> o.getText().startsWith("Print")).consumeEach(o -> o.setVisible(false));
        new DialogWrapper(project){
            {
                super(arg0);
                this.setTitle(ActionsBundle.message((String)"action.Graph.print.preview", (Object[])new Object[0]));
                this.init();
                this.getOKAction().putValue("Name", "Print...");
            }

            protected String getDimensionServiceKey() {
                return "Diagram.Print.Preview.Dialog";
            }

            protected JComponent createCenterPanel() {
                PrintGraphAction.setupBackgroundBeforePrint(graph2D, renderer, builder);
                ApplicationManager.getApplication().invokeLater(() -> PrintGraphAction.rollbackBackgroundAfterPrint(renderer, builder));
                return panelComponent;
            }

            protected void doOKAction() {
                super.doOKAction();
                printJob.setPrintable(gp, panel.getPageFormat());
                PrintGraphAction.doPrint(graph2D, renderer, builder, printJob);
            }
        }.show();
    }

    @Override
    public void update(AnActionEvent e, Graph2D graph2D) {
        e.getPresentation().setText(ActionsBundle.message((String)"action.Graph.print.preview", (Object[])new Object[0]));
        e.getPresentation().setIcon(AllIcons.Graph.PrintPreview);
    }
}

