/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Locale;
import java.util.Set;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Exasol;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.ExasolExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.ExasolIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;

public class ExaJdbcHelper
extends JdbcHelperImpl {
    private static final Set<String> EXA_UNLIMITED_TYPES = ContainerUtilRt.newHashSet((Object[])new String[]{"integer", "clob", "blob", "boolean", "timestamp", "date", "double precision"});

    public ExaJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(Exasol.RDBMS, version, connection);
    }

    public ExaJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return ExaJdbcHelper.extractVersion(version);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull DataSource ds) {
        if (ds == null) {
            ExaJdbcHelper.$$$reportNull$$$0(0);
        }
        ExasolIntermediateFacade exasolIntermediateFacade = new ExasolIntermediateFacade(ds, 1, false, (DBExceptionRecognizer)ExasolExceptionRecognizer.INSTANCE);
        if (exasolIntermediateFacade == null) {
            ExaJdbcHelper.$$$reportNull$$$0(1);
        }
        return exasolIntermediateFacade;
    }

    @Override
    public boolean supportsLike() {
        return false;
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            ExaJdbcHelper.$$$reportNull$$$0(2);
        }
        if (e.typeName == null) {
            return;
        }
        String t = e.typeName.toLowerCase(Locale.ENGLISH);
        if (EXA_UNLIMITED_TYPES.contains(t)) {
            e.length = -1;
        } else if (t.startsWith("interval")) {
            e.length = e.scale == 0 ? -1 : e.scale;
            e.scale = 0;
        }
    }

    @Nullable
    static JdbcHelperImpl detect(@NotNull Connection delegate, @Nullable String product) throws Exception {
        if (delegate == null) {
            ExaJdbcHelper.$$$reportNull$$$0(3);
        }
        if (!JdbcNativeUtil.detectString(product, "exasol")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return ExaJdbcHelper.create(delegate);
    }

    @NotNull
    private static ExaJdbcHelper create(@NotNull Connection delegate) throws Exception {
        DatabaseMetaData md;
        if (delegate == null) {
            ExaJdbcHelper.$$$reportNull$$$0(4);
        }
        String versionStr = (md = delegate.getMetaData()) == null ? null : md.getDatabaseProductVersion();
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + versionStr);
        ExaJdbcHelper exaJdbcHelper = new ExaJdbcHelper(ExaJdbcHelper.extractVersion(versionStr), null);
        if (exaJdbcHelper == null) {
            ExaJdbcHelper.$$$reportNull$$$0(5);
        }
        return exaJdbcHelper;
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/ExaJdbcHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/ExaJdbcHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFacade";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

