/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ws.http.request.actions.HttpRequestBaseAction;
import com.intellij.ws.http.request.environment.HttpRequestEnvironment;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.run.HttpRequestRunConfigurationExecutor;
import com.intellij.ws.http.request.run.config.HttpRequestExecutionConfig;
import com.intellij.ws.http.request.run.config.HttpRequestRunConfiguration;
import com.intellij.ws.http.request.run.config.HttpRequestRuntimeConfigurationProducer;
import com.intellij.ws.http.request.run.config.HttpSingleRequestExecutionConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunHttpRequestAction
extends HttpRequestBaseAction {
    private HttpRequestRunConfigurationExecutor myExecutor;
    protected final HttpRequestExecutionConfig myConfig;

    public RunHttpRequestAction(@NotNull HttpRequestExecutionConfig config, @Nullable String initialEnv) {
        if (config == null) {
            RunHttpRequestAction.$$$reportNull$$$0(0);
        }
        this.myConfig = config;
        this.myExecutor = HttpRequestRunConfigurationExecutor.getInstance();
        this.getTemplatePresentation().setText(this.myConfig.getActionText(initialEnv));
    }

    protected void setExecutor(@NotNull HttpRequestRunConfigurationExecutor executor) {
        if (executor == null) {
            RunHttpRequestAction.$$$reportNull$$$0(1);
        }
        this.myExecutor = executor;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            RunHttpRequestAction.$$$reportNull$$$0(2);
        }
        if ((project = event.getProject()) == null) {
            return;
        }
        String environment = this.getSelectedEnvironment(project);
        HttpRequestEnvironment.setDefaultEnvName(project, environment);
        HttpRequestRuntimeConfigurationProducer producer = (HttpRequestRuntimeConfigurationProducer)RunConfigurationProducer.getInstance(HttpRequestRuntimeConfigurationProducer.class);
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)event.getDataContext());
        if (context.getLocation() == null) {
            return;
        }
        boolean wasCreated = false;
        RunnerAndConfigurationSettings runner = producer.findExistingConfigurationWithDefaultEnv(context);
        if (runner == null) {
            ConfigurationFromContext fromContext = producer.createConfigurationFromContext(context);
            if (fromContext == null) {
                return;
            }
            wasCreated = true;
            runner = fromContext.getConfigurationSettings();
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        if (wasCreated) {
            RunConfiguration configuration = runner.getConfiguration();
            HttpRequestRunConfiguration.Settings settings = ((HttpRequestRunConfiguration)configuration).getSettings();
            if (!settings.isDefaultEnvironment()) {
                RunHttpRequestAction.updateEnvironment(settings, environment);
            }
            runManager.setUniqueNameIfNeed(configuration);
            runManager.setTemporaryConfiguration(runner);
        }
        runManager.setSelectedConfiguration(runner);
        this.myExecutor.execute(project, runner);
    }

    private static void updateEnvironment(@NotNull HttpRequestRunConfiguration.Settings settings, @Nullable String environment) {
        if (settings == null) {
            RunHttpRequestAction.$$$reportNull$$$0(3);
        }
        if (StringUtil.isNotEmpty((String)environment)) {
            settings.setEnvironment(environment);
        } else {
            settings.setNoEnvironment();
        }
    }

    @Nullable
    public abstract String getSelectedEnvironment(@NotNull Project var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/http/request/run/RunHttpRequestAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setExecutor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateEnvironment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RunRequestWithoutEnvAction
    extends RunHttpRequestAction {
        private static final String ID = "HTTPClient.RunWithoutEnv";

        public RunRequestWithoutEnvAction(@NotNull HttpRequestExecutionConfig config) {
            if (config == null) {
                RunRequestWithoutEnvAction.$$$reportNull$$$0(0);
            }
            super(config, null);
        }

        public String getId() {
            return ID;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RunRequestWithoutEnvAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            e.getPresentation().setEnabledAndVisible(true);
            e.getPresentation().setText(this.getTemplatePresentation().getText(), false);
        }

        @Override
        public String getSelectedEnvironment(@NotNull Project project) {
            if (project == null) {
                RunRequestWithoutEnvAction.$$$reportNull$$$0(2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ws/http/request/run/RunHttpRequestAction$RunRequestWithoutEnvAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedEnvironment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RunRequestWithDefaultEnvAction
    extends RunHttpRequestAction {
        private static final String ID = "HTTPClient.RunWithDefaultEnv";

        public RunRequestWithDefaultEnvAction(@NotNull HttpRequest request) {
            if (request == null) {
                RunRequestWithDefaultEnvAction.$$$reportNull$$$0(0);
            }
            this(new HttpSingleRequestExecutionConfig(request));
        }

        public RunRequestWithDefaultEnvAction(@NotNull HttpRequestExecutionConfig config) {
            if (config == null) {
                RunRequestWithDefaultEnvAction.$$$reportNull$$$0(1);
            }
            super(config, null);
        }

        public String getId() {
            return ID;
        }

        public void update(@NotNull AnActionEvent e) {
            String defaultEnv;
            if (e == null) {
                RunRequestWithDefaultEnvAction.$$$reportNull$$$0(2);
            }
            super.update(e);
            Project project = e.getProject();
            String string = defaultEnv = project != null ? HttpRequestEnvironment.getDefaultEnvName(project) : null;
            if (StringUtil.isNotEmpty((String)defaultEnv)) {
                e.getPresentation().setText(this.myConfig.getActionText(defaultEnv), false);
                e.getPresentation().setEnabledAndVisible(true);
            } else {
                e.getPresentation().setEnabledAndVisible(false);
            }
        }

        @Override
        public String getSelectedEnvironment(@NotNull Project project) {
            if (project == null) {
                RunRequestWithDefaultEnvAction.$$$reportNull$$$0(3);
            }
            return HttpRequestEnvironment.getDefaultEnvName(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ws/http/request/run/RunHttpRequestAction$RunRequestWithDefaultEnvAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedEnvironment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RunRequestWithEnvAction
    extends RunHttpRequestAction {
        private static final String ID = "HTTPClient.RunWithSelectedEnv";
        private final String myEnvironment;

        public RunRequestWithEnvAction(@NotNull HttpRequestExecutionConfig config, @Nullable String environment) {
            if (config == null) {
                RunRequestWithEnvAction.$$$reportNull$$$0(0);
            }
            super(config, environment);
            this.myEnvironment = environment;
        }

        public String getId() {
            return ID;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RunRequestWithEnvAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            Project project = e.getProject();
            boolean isDefaultEnv = project != null && StringUtil.isNotEmpty((String)this.myEnvironment) && StringUtil.equals((CharSequence)this.myEnvironment, (CharSequence)HttpRequestEnvironment.getDefaultEnvName(project));
            e.getPresentation().setEnabledAndVisible(!isDefaultEnv);
            if (!isDefaultEnv) {
                e.getPresentation().setText(this.getTemplatePresentation().getText(), false);
            }
        }

        @Override
        public String getSelectedEnvironment(@NotNull Project project) {
            if (project == null) {
                RunRequestWithEnvAction.$$$reportNull$$$0(2);
            }
            return this.myEnvironment;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ws/http/request/run/RunHttpRequestAction$RunRequestWithEnvAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedEnvironment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

