/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.model.WaitResponse;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitContainerResultCallbackImpl
extends ResultCallbackTemplate<WaitContainerResultCallbackImpl, WaitResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaitContainerResultCallbackImpl.class);
    private WaitResponse waitResponse = null;

    public void onNext(WaitResponse waitResponse) {
        this.waitResponse = waitResponse;
        LOGGER.debug(waitResponse.toString());
    }

    public Integer awaitStatusCode() {
        try {
            this.awaitCompletion();
        }
        catch (InterruptedException e) {
            throw new DockerClientException("", (Throwable)e);
        }
        return this.getStatusCode();
    }

    public Integer awaitStatusCode(long timeout, TimeUnit timeUnit) throws TimeoutException {
        try {
            if (!this.awaitCompletion(timeout, timeUnit)) {
                throw new TimeoutException("Awaiting status code timeout.");
            }
        }
        catch (InterruptedException e) {
            throw new DockerClientException("Awaiting status code interrupted: ", (Throwable)e);
        }
        return this.getStatusCode();
    }

    private Integer getStatusCode() {
        if (this.waitResponse == null) {
            throw new DockerClientException("Error while wait container");
        }
        return this.waitResponse.getStatusCode();
    }
}

