/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.settings;

import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.settings.DockerPortBindingConfigurable;
import com.intellij.docker.settings.TableWithCardEditor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.Column;

public class DockerPortBindingsEditor
extends TableWithCardEditor<DockerPortBindingImpl, ColumnBase> {
    public DockerPortBindingsEditor() {
        super((Column[])new ColumnBase[]{new ContainerPortColumn(), new ProtocolColumn(), new HostIpColumn(), new HostPortColumn()});
    }

    @Override
    protected DockerPortBindingImpl createItem() {
        return new DockerPortBindingImpl();
    }

    @Override
    protected DockerPortBindingImpl cloneItem(DockerPortBindingImpl item) {
        return new DockerPortBindingImpl((DockerPortBinding)item);
    }

    @Override
    protected Configurable createItemConfigurable(DockerPortBindingImpl item) {
        return new DockerPortBindingConfigurable(item);
    }

    private static class HostPortColumn
    extends ColumnBase {
        HostPortColumn() {
            super("Host port");
        }

        public Object getColumnValue(DockerPortBindingImpl row) {
            Integer hostPort = row.getHostPort();
            return hostPort == null ? "" : hostPort.toString();
        }
    }

    private static class HostIpColumn
    extends ColumnBase {
        HostIpColumn() {
            super("Host IP");
        }

        public Object getColumnValue(DockerPortBindingImpl row) {
            return StringUtil.notNullize((String)row.getHostIp());
        }
    }

    private static class ProtocolColumn
    extends ColumnBase {
        ProtocolColumn() {
            super("Protocol");
        }

        public Object getColumnValue(DockerPortBindingImpl row) {
            return row.getProtocol();
        }
    }

    private static class ContainerPortColumn
    extends ColumnBase {
        ContainerPortColumn() {
            super("Container Port");
        }

        public Object getColumnValue(DockerPortBindingImpl row) {
            return Integer.toString(row.getContainerPort());
        }
    }

    public static abstract class ColumnBase
    extends Column<DockerPortBindingImpl> {
        public ColumnBase(String name) {
            super(name);
        }
    }
}

