/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseColorPanel;
import com.intellij.database.dataSource.DatabaseNameComponent;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.database.SqlDataSourceImpl;
import com.intellij.sql.database.SqlDataSourceManager;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDataSourceConfigurable
extends AbstractDataSourceConfigurable<SqlDataSourceManager, SqlDataSourceImpl> {
    private JPanel myRootPanel;
    private JPanel myNamePanel;
    private JPanel myDdlListPanel;
    private ComboBox<DbDataSource> myParentCombo;
    private DatabaseNameComponent myNameComponent;
    private JList<String> myDdlList;
    private final boolean myOnCreate;
    private final SqlDataSourceImpl myTempDataSource;
    private final Map<String, DbDataSource> myParentMap;

    public SqlDataSourceConfigurable(SqlDataSourceManager manager, SqlDataSourceImpl dataSource, Project project, boolean onCreate) {
        super(manager, dataSource, project);
        Function function2 = this::getParentDataSource;
        this.$$$setupUI$$$();
        this.myParentMap = FactoryMap.create((Function)function2);
        this.myTempDataSource = dataSource.copy();
        this.myOnCreate = onCreate;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameComponent.getPreferredFocusedComponent();
    }

    @NotNull
    private CollectionListModel<String> getUrlListModel() {
        CollectionListModel collectionListModel = (CollectionListModel)this.myDdlList.getModel();
        if (collectionListModel == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(0);
        }
        return collectionListModel;
    }

    @Override
    @NotNull
    public SqlDataSourceImpl getTempDataSource() {
        this.saveData(this.myTempDataSource);
        SqlDataSourceImpl sqlDataSourceImpl = this.myTempDataSource;
        if (sqlDataSourceImpl == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(1);
        }
        return sqlDataSourceImpl;
    }

    private void doChooseFiles() {
        VirtualFile[] roots = ProjectRootManager.getInstance((Project)this.myProject).getContentRoots();
        if (roots.length == 0) {
            Messages.showWarningDialog((Project)this.myProject, (String)"You have no directories, attached to your project", (String)"Nothing to Choose From");
            return;
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, true){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && file.isDirectory() || file.getFileType() == SqlFileType.INSTANCE;
            }
        };
        descriptor.setRoots(roots);
        descriptor.withTreeRootVisible(true);
        descriptor.setTitle(SqlMessages.message("dialog.title.choose.ddl.files", new Object[0]));
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.myProject, (VirtualFile)((VirtualFile)ContainerUtil.getFirstItem(((SqlDataSourceImpl)this.myDataSource).getFiles())), files -> {
            CollectionListModel<String> model = this.getUrlListModel();
            LinkedHashSet set = ContainerUtil.newLinkedHashSet((Iterable)model.toList());
            for (VirtualFile f : files) {
                if (f.isDirectory()) {
                    VfsUtilCore.processFilesRecursively((VirtualFile)f, file -> {
                        if (file.getFileType() == SqlFileType.INSTANCE) {
                            set.add(file.getUrl());
                        }
                        return true;
                    });
                    continue;
                }
                set.add(f.getUrl());
            }
            SqlDataSourceConfigurable.setItemsImpl(set, model);
        });
    }

    private static void setItemsImpl(Iterable<String> items, @NotNull CollectionListModel<String> model) {
        if (model == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(2);
        }
        int len = model.getSize();
        int i2 = 0;
        for (String s : items) {
            if (i2 < len) {
                model.setElementAt((Object)s, i2++);
                continue;
            }
            model.add((Object)s);
        }
        while (i2 < len) {
            model.removeRow(i2++);
        }
    }

    public static boolean checkGenericDialectUsage(final Project project, Collection<String> urls) {
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        SqlDialectMappings mappings = SqlDialectMappings.getInstance(project);
        final Ref selectFile = Ref.create(null);
        final ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(urls.size());
        for (String url : urls) {
            VirtualFile file = fileManager.findFileByUrl(url);
            if (file == null) continue;
            files.add(file);
            if (!selectFile.isNull() || mappings.getMapping(file) != SqlDialects.getGenericDialect()) continue;
            selectFile.set((Object)file);
        }
        if (!selectFile.isNull()) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (project.isDisposed()) {
                        return;
                    }
                    final SqlDialectsConfigurable configurable = new SqlDialectsConfigurable(project);
                    SingleConfigurableEditor editor = new SingleConfigurableEditor(project, (Configurable)configurable){

                        protected ValidationInfo doValidate() {
                            for (VirtualFile file : files) {
                                SqlLanguageDialect dialect = (SqlLanguageDialect)configurable.getNewMapping(file);
                                if (dialect != SqlDialects.getGenericDialect()) continue;
                                return new ValidationInfo(SqlMessages.message("generic.sql.dialect.usage.error.message", VfsUtilCore.urlToPath((String)file.getPresentableUrl()), StringUtil.escapeXml((String)SqlDialects.getGenericDialect().getDisplayName())));
                            }
                            return super.doValidate();
                        }

                        protected boolean postponeValidation() {
                            return false;
                        }
                    };
                    configurable.selectFile((VirtualFile)selectFile.get());
                    editor.show();
                }
            });
        }
        return true;
    }

    @Nls
    public String getDisplayName() {
        return this.getNameValue();
    }

    private String getNameValue() {
        return this.myNameComponent.getNameValue();
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.tools.datasource.properties";
    }

    @Nullable
    public JComponent createComponent() {
        this.myNameComponent = new DatabaseNameComponent(this, this.myController, new DatabaseColorPanel((AbstractDataSource)this.myDataSource, this.myManager, this.myProject, this.myController));
        this.myNamePanel.add((Component)this.myNameComponent.getComponent(), "Center");
        this.myNameComponent.getComponent().setBorder(null);
        this.myDdlList = new JBList((ListModel)new CollectionListModel((Object[])new String[0]));
        this.myDdlList.setCellRenderer((ListCellRenderer<String>)new ColoredListCellRenderer<String>(){

            protected void customizeCellRenderer(@NotNull JList list, String value, int index2, boolean selected, boolean hasFocus) {
                VirtualFile file;
                if (list == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((file = VirtualFileManager.getInstance().findFileByUrl(value)) != null) {
                    this.append(file.getPath(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.setIcon(file.isDirectory() ? PlatformIcons.FOLDER_ICON : VirtualFilePresentation.getIcon((VirtualFile)file));
                } else {
                    this.append(VfsUtilCore.urlToPath((String)value), SimpleTextAttributes.ERROR_ATTRIBUTES);
                    this.setIcon(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/sql/database/SqlDataSourceConfigurable$3", "customizeCellRenderer"));
            }
        });
        this.myDdlListPanel.add((Component)ToolbarDecorator.createDecorator(this.myDdlList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                SqlDataSourceConfigurable.this.doChooseFiles();
            }
        }).createPanel(), "Center");
        this.myRootPanel.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        return this.myRootPanel;
    }

    public void saveData(@NotNull SqlDataSourceImpl dataSource) {
        if (dataSource == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(3);
        }
        ListModel<String> model = this.myDdlList.getModel();
        ArrayList urls = ContainerUtil.newArrayList();
        int len = model.getSize();
        for (int i2 = 0; i2 < len; ++i2) {
            urls.add(model.getElementAt(i2));
        }
        this.myNameComponent.apply(dataSource);
        DasDataSource parent2 = (DasDataSource)this.myParentCombo.getSelectedItem();
        dataSource.setParentUniqueId(parent2 == null ? null : parent2.getUniqueId());
        dataSource.setUrls(urls);
    }

    public void apply() throws ConfigurationException {
        SqlDataSourceImpl tempDataSource = this.getTempDataSource();
        SqlDataSourceConfigurable.checkGenericDialectUsage(this.myProject, tempDataSource.getUrls());
        this.saveData((SqlDataSourceImpl)this.myDataSource);
        if (this.isNewDataSource()) {
            ((SqlDataSourceManager)this.myManager).addDataSource((SqlDataSourceImpl)this.myDataSource);
        }
        this.reinitDataSourceCombo();
    }

    @Override
    protected void reset(@NotNull SqlDataSourceImpl o) {
        if (o == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(4);
        }
        this.myNameComponent.reset(o);
        this.reinitDataSourceCombo();
        String parentUniqueId = o.getParentUniqueId();
        DbDataSource parent2 = StringUtil.isEmpty((String)parentUniqueId) ? null : this.myParentMap.get(parentUniqueId);
        this.myParentCombo.setSelectedItem((Object)parent2);
        SqlDataSourceConfigurable.setItemsImpl(o.getUrls(), this.getUrlListModel());
    }

    @NotNull
    private DbDataSource getParentDataSource(@NotNull String parentUniqueId) {
        DbPsiFacade facade;
        DbDataSource parentDataSource;
        if (parentUniqueId == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(5);
        }
        if ((parentDataSource = (facade = DbPsiFacade.getInstance((Project)this.myProject)).findDataSource(parentUniqueId)) != null) {
            DbDataSource dbDataSource = parentDataSource;
            if (dbDataSource == null) {
                SqlDataSourceConfigurable.$$$reportNull$$$0(6);
            }
            return dbDataSource;
        }
        SqlDataSourceImpl ds = new SqlDataSourceImpl("<invalid>", this.myProject, null);
        SqlDataSourceImpl.State state = new SqlDataSourceImpl.State();
        state.name = ds.getName();
        state.id = parentUniqueId;
        ds.loadState(state);
        DbDataSource dbDataSource = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(ds, SqlDataSourceManager.getInstance(this.myProject));
        if (dbDataSource == null) {
            SqlDataSourceConfigurable.$$$reportNull$$$0(7);
        }
        return dbDataSource;
    }

    protected void reinitDataSourceCombo() {
        String parentUniqueId = ((SqlDataSourceImpl)this.myDataSource).getParentUniqueId();
        DbDataSource parent2 = StringUtil.isEmpty((String)parentUniqueId) ? null : this.myParentMap.get(parentUniqueId);
        JBIterable existing = JBIterable.from((Iterable)DbPsiFacade.getInstance((Project)this.myProject).getDataSources()).filter(o -> o != parent2 && o.getDelegate() != this.myDataSource);
        if (!this.myOnCreate) {
            DatabaseDialectEx dialect = ((SqlDataSourceImpl)this.myDataSource).getDatabaseDialect();
            existing = existing.filter(dataSource -> DbImplUtil.getDatabaseDialect((DbElement)dataSource) == dialect);
        }
        DbUIUtil.configureDataSourceComboBox(this.myParentCombo, (Iterable<DbDataSource>)JBIterable.of((Object)parent2).append((Iterable)existing), true);
    }

    @Override
    public boolean isModified() {
        if (this.isNewDataSource()) {
            return true;
        }
        SqlDataSourceImpl tempDataSource = this.getTempDataSource();
        if (!StringUtil.equals((CharSequence)tempDataSource.getName(), (CharSequence)((SqlDataSourceImpl)this.myDataSource).getName())) {
            return true;
        }
        return !tempDataSource.equalConfiguration((SqlDataSourceImpl)this.myDataSource) || this.myNameComponent.isModified();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlDataSourceConfigurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentUniqueId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlListModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDataSource";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlDataSourceConfigurable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentDataSource";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setItemsImpl";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParentDataSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        ComboBox comboBox;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myNamePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Extend:");
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myParentCombo = comboBox = new ComboBox();
        jPanel4.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 0, new Dimension(40, -1), null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 1, null, null, null));
        this.myDdlListPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(ResourceBundle.getBundle("messages/SqlBundle").getString("title.border.ddl.files"));
        jPanel.add((Component)titledSeparator, "North");
        jBLabel.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

