/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Key;
import com.intellij.sql.util.NameTemplate;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorModelUtil {
    private static final Key<Boolean> STUB_FLAG = Key.create((String)"STUB_FLAG");

    @NotNull
    public static DeTable stubbize(@Nullable DeTable table, @Nullable DeObject parent2, @NotNull DeModel model) {
        if (model == null) {
            EditorModelUtil.$$$reportNull$$$0(0);
        }
        if (table != null) {
            DeTable deTable = table;
            if (deTable == null) {
                EditorModelUtil.$$$reportNull$$$0(1);
            }
            return deTable;
        }
        DeTable deTable = EditorModelUtil.setStub(new DeTable("", parent2, model));
        if (deTable == null) {
            EditorModelUtil.$$$reportNull$$$0(2);
        }
        return deTable;
    }

    @NotNull
    public static DeColumn stubbize(@Nullable DeColumn column2, @NotNull DeTable parent2, @NotNull DeModel model) {
        if (parent2 == null) {
            EditorModelUtil.$$$reportNull$$$0(3);
        }
        if (model == null) {
            EditorModelUtil.$$$reportNull$$$0(4);
        }
        DeColumn deColumn = EditorModelUtil.stubbize(column2, "", parent2, model);
        if (deColumn == null) {
            EditorModelUtil.$$$reportNull$$$0(5);
        }
        return deColumn;
    }

    @NotNull
    public static DeColumn stubbize(@Nullable DeColumn column2, @NotNull String name, @NotNull DeTable parent2, @NotNull DeModel model) {
        if (name == null) {
            EditorModelUtil.$$$reportNull$$$0(6);
        }
        if (parent2 == null) {
            EditorModelUtil.$$$reportNull$$$0(7);
        }
        if (model == null) {
            EditorModelUtil.$$$reportNull$$$0(8);
        }
        if (column2 != null) {
            DeColumn deColumn = column2;
            if (deColumn == null) {
                EditorModelUtil.$$$reportNull$$$0(9);
            }
            return deColumn;
        }
        DeColumn deColumn = EditorModelUtil.setStub(new DeColumn(name, parent2, model));
        if (deColumn == null) {
            EditorModelUtil.$$$reportNull$$$0(10);
        }
        return deColumn;
    }

    @NotNull
    public static <De extends DeObject> De setStub(@NotNull De object) {
        if (object == null) {
            EditorModelUtil.$$$reportNull$$$0(11);
        }
        STUB_FLAG.set(object.flags, (Object)Boolean.TRUE);
        De De = object;
        if (De == null) {
            EditorModelUtil.$$$reportNull$$$0(12);
        }
        return De;
    }

    public static boolean isStub(@Nullable DeObject object) {
        return object == null || STUB_FLAG.get(object.flags) == Boolean.TRUE;
    }

    @NotNull
    public static String makeUnique(String name, DeObject object) {
        DeObject tmp;
        for (tmp = object; tmp != null && tmp.getKind() != ObjectKind.SCHEMA; tmp = tmp.getParent()) {
        }
        Set names = ((JBTreeTraverser)((JBTreeTraverser)DasUtil.dasTraverser().withRoot((Object)tmp)).expandAndSkip(o -> o.getKind() != object.getKind())).traverse().filter(o -> o != object).transform(DasUtil.TO_NAME).toSet();
        if (!names.contains(name)) {
            String string = name;
            if (string == null) {
                EditorModelUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        int i2 = 2;
        while (true) {
            String n;
            if (!names.contains(n = name + "_" + i2)) {
                String string = n;
                if (string == null) {
                    EditorModelUtil.$$$reportNull$$$0(14);
                }
                return string;
            }
            ++i2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/models/EditorModelUtil";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/models/EditorModelUtil";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "stubbize";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "setStub";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "makeUnique";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "stubbize";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setStub";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class GeneratedNameHelper {
        private final DeObject myObject;
        private final NameTemplate myTemplate;
        private String myGenerated;

        public GeneratedNameHelper(@NotNull DeObject object, @NotNull NameTemplate template) {
            if (object == null) {
                GeneratedNameHelper.$$$reportNull$$$0(0);
            }
            if (template == null) {
                GeneratedNameHelper.$$$reportNull$$$0(1);
            }
            this.myObject = object;
            this.myTemplate = template;
            this.myGenerated = this.generateName();
        }

        @NotNull
        public String generateName() {
            String name = this.myTemplate.getName((DasObject)this.myObject);
            String string = EditorModelUtil.makeUnique(name, this.myObject);
            if (string == null) {
                GeneratedNameHelper.$$$reportNull$$$0(2);
            }
            return string;
        }

        private boolean isNotGeneratedYet() {
            return this.myObject.name.isEmpty() && (this.myObject.getEditedObject() == null || !this.myObject.getEditedObject().getName().isEmpty());
        }

        public boolean updateGenerated() {
            boolean updateObject = this.isNotGeneratedYet() || this.myObject.getName().equals(this.myGenerated);
            String generated = this.generateName();
            if (generated.equals(this.myObject.name)) {
                return false;
            }
            this.myGenerated = generated;
            if (updateObject) {
                this.myObject.name = this.myGenerated;
            }
            return updateObject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/models/EditorModelUtil$GeneratedNameHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/models/EditorModelUtil$GeneratedNameHelper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

