/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vfs;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.DatabaseVirtualFileSystem;
import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.sql.SqlFileType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.containers.JBIterable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(provider=ElementPresentation.class)
public class DatabaseElementVirtualFileImpl
extends VirtualFile
implements VirtualFilePathWrapper {
    private final String myDataSourceId;
    private final ObjectPath myPath;
    private boolean myWritable;
    private final boolean mySource;
    private Pair<Reference<DbElement>, Long> myCachedPsi;
    private volatile boolean myBusy;
    private volatile String myContent;

    protected DatabaseElementVirtualFileImpl(@NotNull String dataSourceId, @NotNull ObjectPath path, boolean source) {
        if (dataSourceId == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(0);
        }
        if (path == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(1);
        }
        this.myWritable = true;
        this.myDataSourceId = dataSourceId;
        this.myPath = path;
        this.mySource = source;
    }

    public boolean isSource() {
        return this.mySource;
    }

    @NotNull
    public String getPath() {
        String string = DatabaseVirtualFileSystem.getPath(this.myDataSourceId, this.myPath, this.mySource);
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.mySource ? this.getNameWithoutExtension() + ".sql" : this.getNameWithoutExtension();
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getNameWithoutExtension() {
        String string = DbSrcUtils.escapeChars(this.myPath.name);
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public String getDataSourceId() {
        return this.myDataSourceId;
    }

    public DbDataSource findDataSource(@NotNull Project project) {
        if (project == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(5);
        }
        return DbPsiFacade.getInstance((Project)project).findDataSource(this.myDataSourceId);
    }

    @NotNull
    public ObjectKind getObjectKind() {
        ObjectKind objectKind = this.myPath.kind;
        if (objectKind == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(6);
        }
        return objectKind;
    }

    @Nullable
    public DbElement findElement(@NotNull Project project) {
        if (project == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(7);
        }
        return this.findElementInner(this.findDataSource(project));
    }

    @Nullable
    DbDataSource findDataSourceInAnyProject() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            DbDataSource result2 = this.findDataSource(project);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    private DbElement findElementInner(@Nullable DbDataSource dataSource) {
        DbElement cached;
        if (dataSource == null) {
            return null;
        }
        if (this.myPath.kind == ObjectKind.ROOT) {
            return dataSource;
        }
        Project project = dataSource.getProject();
        long timestamp = DbPsiFacade.getInstance((Project)project).getModificationCount();
        Pair<Reference<DbElement>, Long> cachedPsi = this.myCachedPsi;
        DbElement dbElement = cached = cachedPsi != null && (Long)cachedPsi.second == timestamp ? (DbElement)((Reference)cachedPsi.first).get() : null;
        if (cached != null && cached.getProject() == project) {
            return cached;
        }
        DbElement found = ((DbDataSourceImpl)dataSource).findElement(this.myPath);
        this.myCachedPsi = found != null ? Pair.create(new WeakReference<DbElement>(found), (Object)timestamp) : null;
        return found;
    }

    @NotNull
    public FileType getFileType() {
        if (this.mySource) {
            SqlFileType sqlFileType = SqlFileType.INSTANCE;
            if (sqlFileType == null) {
                DatabaseElementVirtualFileImpl.$$$reportNull$$$0(8);
            }
            return sqlFileType;
        }
        if (DbImplUtil.isDataTable(this.myPath.kind)) {
            FileType fileType = super.getFileType();
            if (fileType == null) {
                DatabaseElementVirtualFileImpl.$$$reportNull$$$0(9);
            }
            return fileType;
        }
        if (DatabaseEditorHelper.isDefinitionAvailable(this.findElementInner(this.findDataSourceInAnyProject()))) {
            SqlFileType sqlFileType = SqlFileType.INSTANCE;
            if (sqlFileType == null) {
                DatabaseElementVirtualFileImpl.$$$reportNull$$$0(10);
            }
            return sqlFileType;
        }
        FileType fileType = super.getFileType();
        if (fileType == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(11);
        }
        return fileType;
    }

    @NotNull
    public DatabaseVirtualFileSystem getFileSystem() {
        DatabaseVirtualFileSystem databaseVirtualFileSystem = DatabaseVirtualFileSystem.getDatabaseFileSystem();
        if (databaseVirtualFileSystem == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(12);
        }
        return databaseVirtualFileSystem;
    }

    public boolean isWritable() {
        return this.myWritable;
    }

    public void setWritable(boolean writable) {
        boolean prev = this.myWritable;
        DbDataSource dataSource = !writable ? null : this.findDataSourceInAnyProject();
        boolean bl = this.myWritable = dataSource != null && dataSource.isWritable();
        if (prev != this.myWritable) {
            BulkFileListener publisher = (BulkFileListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
            List<VFilePropertyChangeEvent> events = Collections.singletonList(new VFilePropertyChangeEvent((Object)this, (VirtualFile)this, "writable", (Object)prev, (Object)this.myWritable, false));
            publisher.before(events);
            publisher.after(events);
        }
    }

    public final void setWritableInner(boolean writable) {
        this.myWritable = writable;
    }

    public boolean isDirectory() {
        return false;
    }

    public VirtualFile getParent() {
        ObjectPath parent2 = this.myPath.parent;
        return parent2 == null ? null : DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(DatabaseVirtualFileSystem.getPath(this.myDataSourceId, parent2, this.mySource));
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    public InputStream getInputStream() {
        return null;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        if (!this.getFileType().isBinary()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(){

                @Override
                public void close() {
                    DatabaseElementVirtualFileImpl.this.myContent = new String(this.buf, 0, this.count, DatabaseElementVirtualFileImpl.this.getCharset());
                    FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{DatabaseElementVirtualFileImpl.this});
                }
            };
            if (byteArrayOutputStream == null) {
                DatabaseElementVirtualFileImpl.$$$reportNull$$$0(13);
            }
            return byteArrayOutputStream;
        }
        throw new IOException("Unsupported operation");
    }

    public void setContent(@NotNull String content) {
        if (content == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(14);
        }
        this.myContent = content;
    }

    public String getContent() {
        return this.myContent;
    }

    public boolean isBusy() {
        return this.myBusy;
    }

    public void setBusy(boolean busy) {
        this.myBusy = busy;
    }

    @NotNull
    public byte[] contentsToByteArray() {
        byte[] byArray = this.myContent != null ? this.myContent.getBytes(this.getCharset()) : ArrayUtil.EMPTY_BYTE_ARRAY;
        if (byArray == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(15);
        }
        return byArray;
    }

    public long getModificationStamp() {
        return 0L;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getLength() {
        return 0L;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public boolean isValid() {
        return DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(this.getPath()) != null;
    }

    public boolean shouldBeValid() {
        DbDataSource dataSource = this.findDataSourceInAnyProject();
        if (dataSource == null || !dataSource.isValid()) {
            return false;
        }
        LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)dataSource);
        if (localDataSource != null && localDataSource.isLoading()) {
            return true;
        }
        return this.findElementInner(dataSource) != null;
    }

    private String validnessStatus() {
        DbDataSource dataSource = this.findDataSourceInAnyProject();
        if (dataSource == null) {
            return "DS not found";
        }
        if (!dataSource.isValid()) {
            return "DS invalid";
        }
        LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)dataSource);
        if (localDataSource != null && localDataSource.isLoading()) {
            return "DS loading";
        }
        if (this.findElementInner(dataSource) == null) {
            return "Element not found";
        }
        return "Valid";
    }

    @Nullable
    public static DatabaseElementVirtualFileImpl findFile(@Nullable DbElement element2, boolean source) {
        if (element2 == null || !element2.isValid()) {
            return null;
        }
        Project project = element2.getProject();
        String path = DatabaseElementVirtualFileImpl.getPath(element2, source);
        DatabaseElementVirtualFileImpl file = (DatabaseElementVirtualFileImpl)DatabaseVirtualFileSystem.getDatabaseFileSystem().findFileByPath(path);
        if (ApplicationManager.getApplication().isUnitTestMode() && file != null && file.findElement(project) != element2) {
            throw new AssertionError((Object)path);
        }
        return file;
    }

    public static String getPath(@NotNull Project project, @NotNull DasDataSource dataSource, @NotNull DasObject object, boolean source) {
        if (project == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(16);
        }
        if (dataSource == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(17);
        }
        if (object == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(18);
        }
        ObjectPath path = ObjectPaths.of(object, (CasingProvider)(object == dataSource ? null : dataSource.getModel()));
        return DatabaseVirtualFileSystem.getPath(dataSource.getUniqueId(), path, source);
    }

    private static String getPath(@NotNull DbElement element2, boolean source) {
        if (element2 == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(19);
        }
        return DatabaseElementVirtualFileImpl.getPath(element2.getProject(), (DasDataSource)element2.getDataSource(), (DasObject)element2, source);
    }

    public static String[] decodeQName(String name) {
        String[] strings = ArrayUtil.toStringArray((Collection)StringUtil.split((String)name, (String)".", (boolean)true, (boolean)false));
        int stringsLength = strings.length;
        for (int i2 = 0; i2 < stringsLength; ++i2) {
            strings[i2] = DatabaseElementVirtualFileImpl.unescape(strings[i2]);
        }
        return strings;
    }

    public static String escape(String name) {
        return name == null ? "" : StringUtil.replace((String)name, Arrays.asList("/", "&", "."), Arrays.asList("&eslash;", "&amp;", "&dot;"));
    }

    public static String unescape(String name) {
        return name == null ? "" : StringUtil.replace((String)name, Arrays.asList("&eslash;", "&amp;", "&dot;"), Arrays.asList("/", "&", "."));
    }

    public String getPresentableName() {
        return this.adjustPresentableName(this.myPath.name);
    }

    @NotNull
    public String getPresentablePath() {
        String string = this.adjustPresentableName(this.myPath.getDisplayName());
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private String adjustPresentableName(@NotNull String name) {
        if (name == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(21);
        }
        DbDataSource dataSource = this.findDataSourceInAnyProject();
        String string = (this.mySource ? name + " (DDL)" : name) + DatabaseElementVirtualFileImpl.getDataSourceText(dataSource, this.myPath.kind);
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private static String getDataSourceText(DbDataSource dataSource, ObjectKind kind) {
        String string = dataSource == null || kind == ObjectKind.ROOT ? "" : " [" + dataSource.getName() + "]";
        if (string == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(23);
        }
        return string;
    }

    public boolean enforcePresentableName() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DatabaseElementVirtualFileImpl file = (DatabaseElementVirtualFileImpl)((Object)o);
        if (this.mySource != file.mySource) {
            return false;
        }
        if (!this.myPath.equals((Object)file.myPath)) {
            return false;
        }
        return this.myDataSourceId.equals(file.myDataSourceId);
    }

    public int hashCode() {
        int result2 = this.myDataSourceId.hashCode();
        result2 = 31 * result2 + this.myPath.hashCode();
        result2 = 31 * result2 + (this.mySource ? 1 : 0);
        return result2;
    }

    public String toString() {
        return "DB VirtualFile: " + this.myPath.kind + ", " + this.getPresentableUrl() + " (" + this.validnessStatus() + ")";
    }

    public static String getEditorTabTitleImpl(@NotNull Project project, @NotNull VirtualFile file, @NotNull ObjectPath path, @Nullable DbDataSource dataSource) {
        boolean qualify;
        if (project == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(24);
        }
        if (file == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(25);
        }
        if (path == null) {
            DatabaseElementVirtualFileImpl.$$$reportNull$$$0(26);
        }
        int tabPlacement = UISettings.getInstance().getEditorTabPlacement();
        boolean bl = qualify = DatabaseSettings.getSettings().alwaysQualifyNames || tabPlacement == 2 || tabPlacement == 4 || JBIterable.of((Object[])FileEditorManager.getInstance((Project)project).getOpenFiles()).find(o -> {
            if (file == null) {
                DatabaseElementVirtualFileImpl.$$$reportNull$$$0(27);
            }
            return !file.equals(o) && o.getName().equals(file.getName());
        }) != null;
        if (file instanceof DatabaseElementVirtualFileImpl) {
            return qualify ? ((DatabaseElementVirtualFileImpl)file).getPresentablePath() : file.getPresentableName();
        }
        return (qualify ? path.getDisplayName() : path.getName()) + DatabaseElementVirtualFileImpl.getDataSourceText(dataSource, path.kind);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceId";
                break;
            }
            case 1: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/vfs/DatabaseElementVirtualFileImpl";
                break;
            }
            case 5: 
            case 7: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/vfs/DatabaseElementVirtualFileImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectKind";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustPresentableName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSourceText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 22: 
            case 23: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findDataSource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "adjustPresentableName";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTabTitleImpl";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getEditorTabTitleImpl$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ElementPresentation
    extends PresentationProvider<DatabaseElementVirtualFileImpl>
    implements EditorTabTitleProvider {
        public Icon getIcon(DatabaseElementVirtualFileImpl file) {
            DbElement element2 = file.findElementInner(file.findDataSourceInAnyProject());
            return element2 == null ? null : element2.getIcon();
        }

        @Nullable
        public String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file) {
            if (project == null) {
                ElementPresentation.$$$reportNull$$$0(0);
            }
            if (file == null) {
                ElementPresentation.$$$reportNull$$$0(1);
            }
            if (!(file instanceof DatabaseElementVirtualFileImpl)) {
                return null;
            }
            DatabaseElementVirtualFileImpl dbFile = (DatabaseElementVirtualFileImpl)file;
            return DatabaseElementVirtualFileImpl.getEditorTabTitleImpl(project, file, dbFile.myPath, dbFile.findDataSource(project));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/vfs/DatabaseElementVirtualFileImpl$ElementPresentation";
            objectArray[2] = "getEditorTabTitle";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

