/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceInfo;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.DatabaseModelLoader;
import com.intellij.database.dataSource.LegacyDeserializer;
import com.intellij.database.dataSource.srcStorage.DbSrcModelStorage;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.IntrospectionScope;
import com.intellij.database.introspection.IntrospectionScopes;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.NameVersion;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicModelListener;
import com.intellij.database.model.serialization.ModelSerializerKt;
import com.intellij.database.run.actions.TransactionAction;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.ElementBase;
import com.intellij.ui.GuiUtils;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.JDomReader;
import com.thoughtworks.xstream.io.xml.JDomWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import icons.DatabaseIcons;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Element;
import org.jdom.JDOMFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

public class LocalDataSource
extends AbstractDataSource
implements DatabaseConnectionPoint,
RawConnectionConfig,
Iconable {
    static final Logger LOG = Logger.getInstance((String)"com.intellij.database.dataSource.LocalDataSource");
    public static final String ELEMENT_NAME = "data-source";
    public static final String MY_ELEMENT_FLAG = "LOCAL";
    static final String MASTER_KEY = "MASTER_KEY";
    private static final String LIBRARIES_ELEMENT_NAME = "libraries";
    private static final String LIBRARY_ELEMENT_NAME = "library";
    private static final String USER_KEY = "user";
    private static final String PASSWORD_KEY = "password";
    private boolean myReadOnly;
    private boolean mySingleConnection;
    private boolean myCheckOutdated;
    private boolean myGlobal;
    private final DataSourceInfo myInfo;
    @NotNull
    private volatile DasModel myModel;
    private volatile boolean myLoading;
    private final AtomicInteger myBatchCounter;
    private String myDriverRef;
    private DatabaseDriver myDriver;
    private String myDriverClass;
    private String myUrl;
    private boolean mySecretStorage;
    private String myUsername;
    private String myEncodedPassword;
    @Deprecated
    public IntrospectionScope myResolveScope;
    private IntrospectionScope myIntrospectionScope;
    private Couple<String> myFakeCurrentSchema;
    private String myObjectPattern;
    private boolean myUseLegacyIntrospector;
    private DBIntrospectionOptions.SourceLoading mySourceLoading;
    @Nullable
    private String myVmOptions;
    @NotNull
    private final Map<String, String> myVmEnv;
    private final Map<String, String> myDriverProperties;
    @Deprecated
    private final List<SimpleClasspathElement> myClasspathElements;
    private boolean myAutoSynchronize;
    private boolean myAutoCommit;
    private int myIsolation;
    private boolean myDomainAuthentication;
    private boolean myConfiguredByUrl;
    @Nullable
    private DatabaseDriver.SchemaControl mySchemaControl;
    private boolean myRewriteBounds;
    private DataSourceSshTunnelConfiguration mySshConfiguration;
    private DataSourceSslConfiguration mySslCfg;
    private final Map<String, String> myAdditionalJdbcProperties;
    private boolean myAuthRequired;
    private boolean myImported;
    @Nullable
    private String myCodeStyleName;
    private final EventDispatcher<Listener> myDispatcher;
    private final BasicModelListener myModelListener;

    public LocalDataSource() {
        this.myInfo = new DataSourceInfo();
        this.myModel = DasUtil.emptyModel();
        this.myLoading = false;
        this.myBatchCounter = new AtomicInteger();
        this.myResolveScope = IntrospectionScope.EMPTY_SCOPE;
        this.myIntrospectionScope = IntrospectionScope.EMPTY_SCOPE;
        this.mySourceLoading = DBIntrospectionOptions.SourceLoading.USER_SOURCES;
        this.myVmEnv = ContainerUtil.newLinkedHashMap();
        this.myDriverProperties = ContainerUtil.newLinkedHashMap();
        this.myClasspathElements = ContainerUtil.newArrayList();
        this.myAutoCommit = true;
        this.myIsolation = TransactionAction.TxIsolation.DEFAULT.getIsolation();
        this.myConfiguredByUrl = false;
        this.myRewriteBounds = true;
        this.myAdditionalJdbcProperties = ContainerUtil.newHashMap();
        this.myAuthRequired = true;
        this.myImported = false;
        this.myDispatcher = EventDispatcher.create(Listener.class);
        this.myModelListener = (created, modified, removed) -> this.fireModelChangedInEDT();
    }

    public LocalDataSource(boolean imported) {
        this.myInfo = new DataSourceInfo();
        this.myModel = DasUtil.emptyModel();
        this.myLoading = false;
        this.myBatchCounter = new AtomicInteger();
        this.myResolveScope = IntrospectionScope.EMPTY_SCOPE;
        this.myIntrospectionScope = IntrospectionScope.EMPTY_SCOPE;
        this.mySourceLoading = DBIntrospectionOptions.SourceLoading.USER_SOURCES;
        this.myVmEnv = ContainerUtil.newLinkedHashMap();
        this.myDriverProperties = ContainerUtil.newLinkedHashMap();
        this.myClasspathElements = ContainerUtil.newArrayList();
        this.myAutoCommit = true;
        this.myIsolation = TransactionAction.TxIsolation.DEFAULT.getIsolation();
        this.myConfiguredByUrl = false;
        this.myRewriteBounds = true;
        this.myAdditionalJdbcProperties = ContainerUtil.newHashMap();
        this.myAuthRequired = true;
        this.myImported = false;
        this.myDispatcher = EventDispatcher.create(Listener.class);
        this.myModelListener = (created, modified, removed) -> this.fireModelChangedInEDT();
        this.myImported = imported;
    }

    public LocalDataSource(@NotNull DatabaseDriver driver, @NotNull String url) {
        if (driver == null) {
            LocalDataSource.$$$reportNull$$$0(0);
        }
        if (url == null) {
            LocalDataSource.$$$reportNull$$$0(1);
        }
        this.myInfo = new DataSourceInfo();
        this.myModel = DasUtil.emptyModel();
        this.myLoading = false;
        this.myBatchCounter = new AtomicInteger();
        this.myResolveScope = IntrospectionScope.EMPTY_SCOPE;
        this.myIntrospectionScope = IntrospectionScope.EMPTY_SCOPE;
        this.mySourceLoading = DBIntrospectionOptions.SourceLoading.USER_SOURCES;
        this.myVmEnv = ContainerUtil.newLinkedHashMap();
        this.myDriverProperties = ContainerUtil.newLinkedHashMap();
        this.myClasspathElements = ContainerUtil.newArrayList();
        this.myAutoCommit = true;
        this.myIsolation = TransactionAction.TxIsolation.DEFAULT.getIsolation();
        this.myConfiguredByUrl = false;
        this.myRewriteBounds = true;
        this.myAdditionalJdbcProperties = ContainerUtil.newHashMap();
        this.myAuthRequired = true;
        this.myImported = false;
        this.myDispatcher = EventDispatcher.create(Listener.class);
        this.myModelListener = (created, modified, removed) -> this.fireModelChangedInEDT();
        this.myDriver = driver;
        this.myUrl = url;
        this.myConfiguredByUrl = this.checkUrlOnly();
        this.myDriverClass = this.myDriver.getDriverClass();
        this.myDriverProperties.putAll(this.myDriver.getDriverProperties());
        this.mySecretStorage = true;
    }

    public LocalDataSource(String name, String driver, String url, String uid, String pwd) {
        this.myInfo = new DataSourceInfo();
        this.myModel = DasUtil.emptyModel();
        this.myLoading = false;
        this.myBatchCounter = new AtomicInteger();
        this.myResolveScope = IntrospectionScope.EMPTY_SCOPE;
        this.myIntrospectionScope = IntrospectionScope.EMPTY_SCOPE;
        this.mySourceLoading = DBIntrospectionOptions.SourceLoading.USER_SOURCES;
        this.myVmEnv = ContainerUtil.newLinkedHashMap();
        this.myDriverProperties = ContainerUtil.newLinkedHashMap();
        this.myClasspathElements = ContainerUtil.newArrayList();
        this.myAutoCommit = true;
        this.myIsolation = TransactionAction.TxIsolation.DEFAULT.getIsolation();
        this.myConfiguredByUrl = false;
        this.myRewriteBounds = true;
        this.myAdditionalJdbcProperties = ContainerUtil.newHashMap();
        this.myAuthRequired = true;
        this.myImported = false;
        this.myDispatcher = EventDispatcher.create(Listener.class);
        this.myModelListener = (created, modified, removed) -> this.fireModelChangedInEDT();
        this.setName(name);
        this.setDriverClass(driver);
        this.setUrl(url);
        this.myUsername = uid;
        this.myEncodedPassword = pwd == null ? null : PasswordUtil.encodePassword((String)pwd);
    }

    @Override
    public boolean isReadOnly() {
        return this.myReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.myReadOnly = readOnly;
    }

    public boolean shouldCheckOutdated() {
        return this.myCheckOutdated;
    }

    public void setCheckOutdated(boolean checkOutdated) {
        this.myCheckOutdated = checkOutdated;
    }

    public boolean isSingleConnection() {
        return this.mySingleConnection;
    }

    public void setSingleConnection(boolean singleConnection) {
        this.mySingleConnection = singleConnection;
    }

    @Override
    public boolean isGlobal() {
        return this.myGlobal;
    }

    public void setGlobal(boolean global) {
        this.myGlobal = global;
    }

    public boolean isRewriteBounds() {
        return this.myRewriteBounds;
    }

    public void setRewriteBounds(boolean rewriteBounds) {
        this.myRewriteBounds = rewriteBounds;
    }

    public void setSchemaControl(@Nullable DatabaseDriver.SchemaControl schemaControl) {
        this.mySchemaControl = schemaControl;
    }

    @NotNull
    public DatabaseDriver.SchemaControl getSchemaControl() {
        if (this.mySchemaControl != null) {
            DatabaseDriver.SchemaControl schemaControl = this.mySchemaControl;
            if (schemaControl == null) {
                LocalDataSource.$$$reportNull$$$0(2);
            }
            return schemaControl;
        }
        DatabaseDriver.SchemaControl schemaControl = this.getDriverSchemaControl();
        if (schemaControl == null) {
            LocalDataSource.$$$reportNull$$$0(3);
        }
        return schemaControl;
    }

    private DatabaseDriver.SchemaControl getDriverSchemaControl() {
        return this.myDriver == null ? DatabaseDriver.SchemaControl.AUTOMATIC : this.myDriver.getOption(DatabaseDriver.OPTION_SCHEMA_CONTROL);
    }

    public static void writeTag(@NotNull HierarchicalStreamWriter serializer, String name, String value) {
        if (serializer == null) {
            LocalDataSource.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)value)) {
            return;
        }
        serializer.startNode(name);
        serializer.setValue(value);
        serializer.endNode();
    }

    public static void writeTag(@NotNull HierarchicalStreamWriter serializer, String name, String a1, String v1, String a2, String v2) {
        if (serializer == null) {
            LocalDataSource.$$$reportNull$$$0(5);
        }
        serializer.startNode(name);
        if (a1 != null && StringUtil.isNotEmpty((String)v1)) {
            serializer.addAttribute(a1, v1);
        }
        if (a2 != null && StringUtil.isNotEmpty((String)v2)) {
            serializer.addAttribute(a2, v2);
        }
        serializer.endNode();
    }

    @NotNull
    public Dbms getDbms() {
        if (this.myInfo.dbms == null) {
            DataSourceInfo.initFamilyFromJdbc(this, this.myInfo);
        }
        Dbms dbms = this.myInfo.dbms;
        if (dbms == null) {
            LocalDataSource.$$$reportNull$$$0(6);
        }
        return dbms;
    }

    @NotNull
    public Version getVersion() {
        if (this.myInfo.exactVersion == null) {
            DataSourceInfo.initFamilyFromJdbc(this, this.myInfo);
        }
        Version version = this.myInfo.exactVersion;
        if (version == null) {
            LocalDataSource.$$$reportNull$$$0(7);
        }
        return version;
    }

    @NotNull
    public Version getExactDriverVersion() {
        if (this.myInfo.exactDriverVersion == null) {
            DataSourceInfo.initFamilyFromJdbc(this, this.myInfo);
        }
        Version version = this.myInfo.exactDriverVersion;
        if (version == null) {
            LocalDataSource.$$$reportNull$$$0(8);
        }
        return version;
    }

    @Override
    @Nullable
    public DatabaseDriver getDatabaseDriver() {
        return this.myDriver;
    }

    public void setDatabaseDriver(@Nullable DatabaseDriver databaseDriver) {
        if (this.myDriver == databaseDriver) {
            return;
        }
        this.myDriver = databaseDriver;
        this.myDriverClass = this.myDriver == null ? null : this.myDriver.getDriverClass();
    }

    @Nullable
    public String getUrl() {
        return this.myUrl;
    }

    public boolean isUseMasterKeyStorage() {
        return this.mySecretStorage;
    }

    public void setUseMasterKeyStorage(boolean useMasterKey) {
        this.mySecretStorage = useMasterKey;
    }

    public String getUsername() {
        return this.myUsername == null ? "" : this.myUsername;
    }

    @Deprecated
    public String getPassword() {
        if (this.myEncodedPassword == null) {
            return "";
        }
        return PasswordUtil.decodePassword((String)this.myEncodedPassword);
    }

    public void setAutoSynchronize(boolean autoSynchronize) {
        this.myAutoSynchronize = autoSynchronize;
    }

    public boolean isAutoSynchronize() {
        return this.myAutoSynchronize;
    }

    public boolean isAutoCommit() {
        return this.myAutoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.myAutoCommit = autoCommit;
    }

    public void setTxIsolation(int isolation) {
        this.myIsolation = isolation;
    }

    public int getTxIsolation() {
        return this.myIsolation;
    }

    public final Icon getIcon(@Iconable.IconFlags int flags) {
        Icon icon = this.getBaseIcon();
        return ElementBase.createLayeredIcon((Iconable)this, (Icon)icon, (int)(this.isReadOnly() ? 2048 : 0));
    }

    public Icon getBaseIcon() {
        return this.myDriver != null ? this.myDriver.getIcon(0) : DatabaseIcons.Dbms;
    }

    public void resolveDriver() {
        if (this.myDriver != null) {
            return;
        }
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        DatabaseDriver driver = null;
        if (this.myDriverRef != null && (driver = DatabaseDriverManager.getInstance().getDriver(this.myDriverRef)) == null) {
            LOG.warn(this.logMessage(this.getUniqueId() + "/" + this.getName() + ": failed to find driver with id \"" + this.myDriverRef + "\""));
        }
        if (driver == null) {
            driver = DbImplUtil.guessDatabaseDriver(this);
            if (driver == null) {
                LOG.warn(this.logMessage(this.getUniqueId() + "/" + this.getName() + ": failed to guess driver"));
            } else {
                LOG.debug(this.logMessage(this.getUniqueId() + "/" + this.getName() + ": using driver \"" + driver.getName() + "\" (" + driver.getId() + ")"));
            }
        }
        this.setDatabaseDriver(driver);
    }

    public void ensureDriverConfigured() {
        if (StringUtil.isEmpty((String)this.myDriverClass)) {
            return;
        }
        if (this.myDriver != null && this.acceptsDriver(this.myDriver)) {
            return;
        }
        DatabaseDriverManager driverManager = DatabaseDriverManager.getInstance();
        if (this.myDriver != null) {
            for (DatabaseDriver databaseDriver : driverManager.getDrivers()) {
                if (!this.acceptsDriver(databaseDriver)) continue;
                this.myDriver = databaseDriver;
                return;
            }
            this.myDriver = ((DatabaseDriverImpl)this.myDriver).copy(this.getName() + " driver", false);
        } else {
            this.myDriver = driverManager.createDriver(this.myDriverClass, this.myDriverClass, null);
        }
        ((DatabaseDriverImpl)this.myDriver).setAdditionalClasspathElements(this.myClasspathElements);
        driverManager.updateDriver(this.myDriver);
    }

    private boolean acceptsDriver(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            LocalDataSource.$$$reportNull$$$0(9);
        }
        if (!Comparing.equal((String)this.myDriverClass, (String)driver.getDriverClass())) {
            return false;
        }
        HashSet set = ContainerUtil.newHashSet();
        for (SimpleClasspathElement element2 : driver.getClasspathElements()) {
            for (String s : element2.getClassesRootUrls()) {
                set.add(PathUtil.getFileName((String)s));
            }
        }
        if (set.isEmpty()) {
            ((DatabaseDriverImpl)driver).setAdditionalClasspathElements(this.myClasspathElements);
            return true;
        }
        for (SimpleClasspathElement e : this.myClasspathElements) {
            for (String s : e.getClassesRootUrls()) {
                if (set.contains(PathUtil.getFileName((String)s))) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public IntrospectionScope getIntrospectionScope() {
        IntrospectionScope introspectionScope = this.myIntrospectionScope;
        if (introspectionScope == null) {
            LocalDataSource.$$$reportNull$$$0(10);
        }
        return introspectionScope;
    }

    public void setIntrospectionScope(@NotNull IntrospectionScope scope) {
        if (scope == null) {
            LocalDataSource.$$$reportNull$$$0(11);
        }
        this.myIntrospectionScope = scope;
    }

    @Nullable
    public Couple<String> getFakeCurrentSchema() {
        return this.myFakeCurrentSchema;
    }

    public void setFakeCurrentSchema(@Nullable Couple<String> fakeCurrentSchema) {
        this.myFakeCurrentSchema = fakeCurrentSchema != null && fakeCurrentSchema.first == null && fakeCurrentSchema.second == null ? null : fakeCurrentSchema;
    }

    @Deprecated
    @Nullable
    public String getEffectiveUrl(@NotNull Project project) {
        if (project == null) {
            LocalDataSource.$$$reportNull$$$0(12);
        }
        return DatabaseConnectionManager.getEffectiveUrl(this, JdbcDriverManager.getDriverManager(project));
    }

    @Override
    @NotNull
    public Properties getConnectionProperties() {
        Properties connectionProperties = new Properties();
        if (this.myDriver != null) {
            connectionProperties.putAll(this.myDriver.getDriverProperties());
        }
        for (Map.Entry<String, String> entry : this.myDriverProperties.entrySet()) {
            if (entry.getValue() == null) continue;
            connectionProperties.put(entry.getKey(), entry.getValue());
        }
        JdbcConsoleRunContext.addSslAndWinAuthProperties(this, connectionProperties);
        Properties properties = connectionProperties;
        if (properties == null) {
            LocalDataSource.$$$reportNull$$$0(13);
        }
        return properties;
    }

    public String getSourceName() {
        return MY_ELEMENT_FLAG;
    }

    public String getDriverClass() {
        if (this.myDriver != null) {
            return this.myDriver.getDriverClass();
        }
        return this.myDriverClass;
    }

    public void setDriverClass(String driver) {
        this.myDriverClass = driver;
    }

    public void setUrl(String url) {
        this.myUrl = url;
    }

    public void setUrlSmart(String url) {
        this.setUrl(url);
        this.setConfiguredByUrl(this.checkUrlOnly());
    }

    private boolean checkUrlOnly() {
        if (this.myUrl == null || this.myDriver == null) {
            return false;
        }
        StatelessJdbcUrlParser parser = JdbcUrlParserUtil.select(this.myDriver.getJDBCUrlParsers(), this.myUrl);
        if (parser == null) {
            return !StringUtil.isEmptyOrSpaces((String)this.myUrl);
        }
        JdbcUrlParser sparser = parser.createStateful();
        sparser.setUrlText(this.myUrl);
        return !sparser.isValid() || !StringUtil.isEmpty((String)sparser.getParameter(USER_KEY)) || !StringUtil.isEmpty((String)sparser.getParameter(PASSWORD_KEY));
    }

    public void setUsername(String username) {
        this.myUsername = username;
    }

    @Deprecated
    public void setPassword(String password) {
        this.myEncodedPassword = password == null ? null : PasswordUtil.encodePassword((String)password);
    }

    public String getDriverRef() {
        return this.myDriverRef;
    }

    public void serializeHeaderInner(@Nullable Project project, HierarchicalStreamWriter serializer, SaveMode mode) {
        PathMacroManager pathMacroManager = LocalDataSource.getPathMacroManager(project);
        if (mode.includeConfig()) {
            String driverClass;
            if (this.myDriver != null && !this.myDriver.getId().equals(this.myDriverClass) || this.myDriver == null && this.myDriverRef != null) {
                LocalDataSource.writeTag(serializer, "driver-ref", this.myDriver == null ? this.myDriverRef : this.myDriver.getId());
            }
            if (this.myAutoSynchronize) {
                LocalDataSource.writeTag(serializer, "synchronize", String.valueOf(true));
            }
            if (this.myImported) {
                LocalDataSource.writeTag(serializer, "imported", String.valueOf(true));
            }
            if (this.myConfiguredByUrl) {
                LocalDataSource.writeTag(serializer, "configured-by-url", String.valueOf(true));
            }
            if (!StringUtil.isEmpty((String)this.getComment())) {
                LocalDataSource.writeTag(serializer, "remarks", this.getComment());
            }
            if (!this.myAutoCommit) {
                LocalDataSource.writeTag(serializer, "auto-commit", String.valueOf(false));
            }
            if (this.myIsolation != TransactionAction.TxIsolation.DEFAULT.getIsolation()) {
                LocalDataSource.writeTag(serializer, "isolation", String.valueOf(this.myIsolation));
            }
            if (this.mySchemaControl != null && this.mySchemaControl != this.getDriverSchemaControl()) {
                LocalDataSource.writeTag(serializer, "schema-control", this.mySchemaControl.name());
            }
            if (!this.myRewriteBounds) {
                LocalDataSource.writeTag(serializer, "rewrite-bounds", String.valueOf(false));
            }
            if (StringUtil.isNotEmpty((String)(driverClass = this.getDriverClass()))) {
                LocalDataSource.writeTag(serializer, "jdbc-driver", driverClass);
            }
            if (StringUtil.isNotEmpty((String)this.myUrl)) {
                LocalDataSource.writeTag(serializer, "jdbc-url", pathMacroManager == null ? this.myUrl : pathMacroManager.collapsePathsRecursively(this.myUrl));
            }
            if (!this.myAdditionalJdbcProperties.isEmpty()) {
                serializer.startNode("jdbc-additional-properties");
                for (Map.Entry<String, String> entry : this.getAdditionalJdbcProperties().entrySet()) {
                    serializer.startNode("property");
                    serializer.addAttribute("name", entry.getKey());
                    serializer.addAttribute("value", entry.getValue());
                    serializer.endNode();
                }
                serializer.endNode();
            }
        }
        if (mode.includeLocalConfig()) {
            if (this.mySecretStorage) {
                LocalDataSource.writeTag(serializer, "secret-storage", StringUtil.toLowerCase((String)MASTER_KEY));
            }
            if (this.myDomainAuthentication) {
                LocalDataSource.writeTag(serializer, "domain-auth", String.valueOf(true));
            }
            if (!this.myAuthRequired) {
                LocalDataSource.writeTag(serializer, "auth-required", String.valueOf(false));
            }
            if (StringUtil.isNotEmpty((String)this.myUsername)) {
                LocalDataSource.writeTag(serializer, "user-name", this.myUsername);
            }
            if (this.myFakeCurrentSchema != null) {
                LocalDataSource.writeTag(serializer, "fake-current-schema", "db", (String)this.myFakeCurrentSchema.first, "sc", (String)this.myFakeCurrentSchema.second);
            }
            LocalDataSource.writeTag(serializer, "introspection-schemas", this.myIntrospectionScope.exportState());
            if (!this.myResolveScope.isEmpty()) {
                LocalDataSource.writeTag(serializer, "resolve-scope", IntrospectionScopes.invertIf(this.myResolveScope, this.getDbms().isMysql()).exportState());
            }
            if (!this.myResolveScope.isEmpty()) {
                LocalDataSource.writeTag(serializer, "unqualified-resolve-schemas", this.myResolveScope.exportState());
            }
            if (StringUtil.isNotEmpty((String)this.myObjectPattern)) {
                LocalDataSource.writeTag(serializer, "table-pattern", this.myObjectPattern);
            }
            if (this.myUseLegacyIntrospector) {
                LocalDataSource.writeTag(serializer, "legacy-introspector", "true");
            }
            if (this.mySourceLoading != DBIntrospectionOptions.SourceLoading.USER_SOURCES) {
                LocalDataSource.writeTag(serializer, "load-sources", StringUtil.toLowerCase((String)this.mySourceLoading.name()));
            }
        }
        if (mode.includeConfig()) {
            if (StringUtil.isNotEmpty((String)this.myVmOptions)) {
                LocalDataSource.writeTag(serializer, "vm-options", this.myVmOptions);
            }
            if (!this.myVmEnv.isEmpty()) {
                serializer.startNode("vm-env");
                for (Map.Entry<String, String> e : this.myVmEnv.entrySet()) {
                    LocalDataSource.writeTag(serializer, "property", "name", e.getKey(), "value", e.getValue());
                }
                serializer.endNode();
            }
            if (!this.myDriverProperties.isEmpty()) {
                serializer.startNode("driver-properties");
                for (Map.Entry<String, String> e : this.myDriverProperties.entrySet()) {
                    LocalDataSource.writeTag(serializer, "property", "name", e.getKey(), "value", e.getValue());
                }
                serializer.endNode();
            }
            if (StringUtil.isNotEmpty((String)this.myCodeStyleName) && !this.myCodeStyleName.equalsIgnoreCase("Default")) {
                LocalDataSource.writeTag(serializer, "code-style-scheme-name", this.myCodeStyleName);
            }
            if (!this.myClasspathElements.isEmpty()) {
                serializer.startNode(LIBRARIES_ELEMENT_NAME);
                for (SimpleClasspathElement classpathElement : this.myClasspathElements) {
                    Element element2 = new Element(LIBRARY_ELEMENT_NAME);
                    try {
                        classpathElement.serialize(element2);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (pathMacroManager != null) {
                        pathMacroManager.collapsePaths(element2);
                    }
                    new HierarchicalStreamCopier().copy((HierarchicalStreamReader)new JDomReader(element2), serializer);
                }
                serializer.endNode();
            }
        }
        if (mode.includeLocalConfig()) {
            if (this.mySshConfiguration != null && !this.mySshConfiguration.isEmpty()) {
                this.mySshConfiguration.serialize(serializer);
            }
            if (this.mySslCfg != null && !this.mySslCfg.isEmpty()) {
                this.mySslCfg.serialize(serializer);
            }
        }
    }

    @Nullable
    private static PathMacroManager getPathMacroManager(@Nullable Project project) {
        Application manager = project == null ? ApplicationManager.getApplication() : project;
        return manager == null ? null : PathMacroManager.getInstance((ComponentManager)manager);
    }

    public void deserialize(@Nullable Project project, @NotNull HierarchicalStreamReader reader, @NotNull SaveMode mode) {
        if (reader == null) {
            LocalDataSource.$$$reportNull$$$0(14);
        }
        if (mode == null) {
            LocalDataSource.$$$reportNull$$$0(15);
        }
        if (mode.includeConfig()) {
            this.myClasspathElements.clear();
        }
        this.deserializeInner(project, reader, mode);
    }

    private void deserializeInner(@Nullable Project project, @NotNull HierarchicalStreamReader reader, @NotNull SaveMode mode) {
        if (reader == null) {
            LocalDataSource.$$$reportNull$$$0(16);
        }
        if (mode == null) {
            LocalDataSource.$$$reportNull$$$0(17);
        }
        HashSet legacyTags = ContainerUtil.newHashSet((Object[])new String[]{"table", "procedure", "schema"});
        if (ELEMENT_NAME.equals(reader.getNodeName())) {
            this.setName(StringUtil.notNullize((String)reader.getAttribute("name")));
            if (mode.includeConfig()) {
                this.setReadOnly("true".equals(reader.getAttribute("read-only")));
                this.setCheckOutdated("true".equals(reader.getAttribute("check-outdated")));
                this.setSingleConnection("true".equals(reader.getAttribute("single-connection")));
                this.setGroupName(StringUtil.nullize((String)reader.getAttribute("group")));
            }
            this.setUniqueId(StringUtil.nullize((String)reader.getAttribute("uuid")));
            BasicModModel model = null;
            if (mode.includeDatabaseInfo()) {
                this.deserializeDatabaseInfo(reader, true);
            }
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                boolean skipMoveUp = false;
                String nodeName = reader.getNodeName();
                if (mode.includeDatabaseInfo() && "database-info".equals(nodeName)) {
                    this.deserializeDatabaseInfo(reader, false);
                } else if (mode.includeDatabaseInfo() && "case-sensitivity".equals(nodeName)) {
                    Case plain = Case.fromString((String)reader.getAttribute("plain-identifiers"), (Case)DasUtil.CASING_MIXED.plain);
                    Case quoted = Case.fromString((String)reader.getAttribute("quoted-identifiers"), (Case)DasUtil.CASING_MIXED.quoted);
                    this.myInfo.casing = Casing.create((Case)plain, (Case)quoted);
                } else if (mode.includeDatabaseInfo() && "extra-name-characters".equals(nodeName)) {
                    this.myInfo.extraNameCharacters = reader.getValue();
                } else if (mode.includeDatabaseInfo() && "identifier-quote-string".equals(nodeName)) {
                    this.myInfo.identifierQuoteString = reader.getValue();
                } else if (!this.deserializeHeaderInner(project, reader, mode) && mode.includeSchema()) {
                    String serializerName = reader.getAttribute("serializer");
                    if (serializerName == null && legacyTags.contains(nodeName)) {
                        serializerName = "legacy";
                        skipMoveUp = true;
                    }
                    if ("legacy".equals(serializerName)) {
                        model = this.deserializeLegacyFormat(project, reader);
                    } else if ("database-model".equals(nodeName)) {
                        model = ModelSerializerKt.deserialize(reader, DbSrcModelStorage.createFactory(project, this.getUniqueId()), this.getName());
                    }
                }
                if (skipMoveUp) continue;
                reader.moveUp();
            }
            if (mode.includeSchema() && model != null) {
                this.setModel(model);
                this.setLoading(false);
            }
        }
    }

    private void deserializeDatabaseInfo(@NotNull HierarchicalStreamReader xmlReader, boolean skipChildren) {
        if (xmlReader == null) {
            LocalDataSource.$$$reportNull$$$0(18);
        }
        this.myInfo.databaseVersion = new NameVersion(xmlReader.getAttribute("product"), xmlReader.getAttribute("version"));
        this.myInfo.jdbcVersion = xmlReader.getAttribute("jdbc-version");
        this.myInfo.driverVersion = new NameVersion(xmlReader.getAttribute("driver-name"), xmlReader.getAttribute("driver-version"));
        String family = (String)ObjectUtils.coalesce((Object)xmlReader.getAttribute("dbms"), (Object)xmlReader.getAttribute("family"));
        this.myInfo.dbms = family == null ? null : Dbms.byName((String)family);
        String version = xmlReader.getAttribute("exact-version");
        try {
            this.myInfo.exactVersion = version == null ? null : Version.parse((String)version);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String driverVersion = xmlReader.getAttribute("exact-driver-version");
        try {
            this.myInfo.exactDriverVersion = driverVersion == null ? null : Version.parse((String)driverVersion);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (skipChildren) {
            return;
        }
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String nodeName = xmlReader.getNodeName();
            if ("extra-name-characters".equals(nodeName)) {
                this.myInfo.extraNameCharacters = xmlReader.getValue();
            } else if ("identifier-quote-string".equals(nodeName)) {
                this.myInfo.identifierQuoteString = xmlReader.getValue();
            }
            xmlReader.moveUp();
        }
    }

    protected boolean deserializeHeaderInner(@Nullable Project project, HierarchicalStreamReader xmlReader, SaveMode mode) {
        if (!mode.includeConfig() && !mode.includeLocalConfig()) {
            return false;
        }
        if (project != null && project.isDisposed()) {
            throw new ProcessCanceledException();
        }
        PathMacroManager pathMacroManager = LocalDataSource.getPathMacroManager(project);
        String nodeName = xmlReader.getNodeName();
        if (LIBRARIES_ELEMENT_NAME.equals(nodeName)) {
            this.myClasspathElements.clear();
            while (xmlReader.hasMoreChildren()) {
                xmlReader.moveDown();
                if (LIBRARY_ELEMENT_NAME.equals(xmlReader.getNodeName())) {
                    JDomWriter writer = new JDomWriter((JDOMFactory)new DefaultJDOMFactory());
                    new HierarchicalStreamCopier().copy(xmlReader, (HierarchicalStreamWriter)writer);
                    Element element2 = (Element)ObjectUtils.assertNotNull((Object)((Element)ContainerUtil.getFirstItem((List)writer.getTopLevelNodes())));
                    if (pathMacroManager != null) {
                        pathMacroManager.expandPaths(element2);
                    }
                    this.myClasspathElements.addAll(SimpleClasspathElementFactory.createElements((Project)project, (Element)element2));
                }
                xmlReader.moveUp();
            }
        } else if (!"explain-plan-config".equals(nodeName)) {
            if ("driver-ref".equals(nodeName)) {
                this.myDriverRef = xmlReader.getValue();
            } else if ("synchronize".equals(nodeName)) {
                this.myAutoSynchronize = Boolean.valueOf(xmlReader.getValue());
            } else if ("imported".equals(nodeName)) {
                this.myImported = Boolean.valueOf(xmlReader.getValue());
            } else if ("configured-by-url".equals(nodeName)) {
                this.myConfiguredByUrl = Boolean.valueOf(xmlReader.getValue());
            } else if ("remarks".equals(nodeName)) {
                this.setComment(xmlReader.getValue());
            } else if ("auto-commit".equals(nodeName)) {
                this.myAutoCommit = Boolean.valueOf(xmlReader.getValue());
            } else if ("isolation".equals(nodeName)) {
                this.myIsolation = Integer.valueOf(xmlReader.getValue());
            } else if ("schema-control".equals(nodeName)) {
                this.mySchemaControl = DatabaseDriver.SchemaControl.valueOf(xmlReader.getValue());
            } else if ("rewrite-bounds".equals(nodeName)) {
                this.myRewriteBounds = Boolean.valueOf(xmlReader.getValue());
            } else if ("auth-required".equals(nodeName)) {
                this.myAuthRequired = Boolean.valueOf(xmlReader.getValue());
            } else if ("domain-auth".equals(nodeName)) {
                this.myDomainAuthentication = Boolean.valueOf(xmlReader.getValue());
            } else if (!"first-sync".equals(nodeName)) {
                if ("jdbc-driver".equals(nodeName)) {
                    this.myDriverClass = xmlReader.getValue();
                } else if ("jdbc-url".equals(nodeName)) {
                    this.myUrl = pathMacroManager == null ? xmlReader.getValue() : pathMacroManager.expandPath(xmlReader.getValue());
                } else if ("jdbc-additional-properties".equals(nodeName)) {
                    LocalDataSource.deserializeProperties(xmlReader, this.myAdditionalJdbcProperties);
                } else if ("secret-storage".equals(nodeName)) {
                    this.mySecretStorage = MASTER_KEY.equalsIgnoreCase(xmlReader.getValue());
                } else if ("user-name".equals(nodeName)) {
                    this.myUsername = xmlReader.getValue();
                } else if ("schema-pattern".equals(nodeName)) {
                    this.myIntrospectionScope = this.parseSchemaPattern(xmlReader.getValue());
                } else if ("default-schemas".equals(nodeName)) {
                    this.myResolveScope = this.parseSchemaPattern(xmlReader.getValue());
                } else if ("introspection-scope".equals(nodeName)) {
                    this.myIntrospectionScope = this.importOldScope(xmlReader.getValue());
                } else if ("resolve-scope".equals(nodeName)) {
                    this.myResolveScope = this.importOldScope(xmlReader.getValue());
                } else if ("introspection-schemas".equals(nodeName)) {
                    this.myIntrospectionScope = IntrospectionScopes.importScope(xmlReader.getValue());
                } else if ("unqualified-resolve-schemas".equals(nodeName)) {
                    this.myResolveScope = IntrospectionScopes.importScope(xmlReader.getValue());
                } else if ("fake-current-schema".equals(nodeName)) {
                    this.setFakeCurrentSchema((Couple<String>)Couple.of((Object)xmlReader.getAttribute("db"), (Object)xmlReader.getAttribute("sc")));
                } else if ("table-pattern".equals(nodeName)) {
                    this.myObjectPattern = xmlReader.getValue();
                } else if ("legacy-introspector".equals(nodeName)) {
                    this.myUseLegacyIntrospector = "true".equals(xmlReader.getValue());
                } else if ("load-sources".equals(nodeName)) {
                    this.mySourceLoading = DBIntrospectionOptions.SourceLoading.valueOf(StringUtil.toUpperCase((String)xmlReader.getValue()));
                } else if (!"default-dialect".equals(nodeName)) {
                    if ("vm-options".equals(nodeName)) {
                        this.myVmOptions = xmlReader.getValue();
                    } else if ("code-style-scheme-name".equals(nodeName)) {
                        this.myCodeStyleName = xmlReader.getValue();
                    } else if ("use-ssl".equals(nodeName) && Boolean.valueOf(xmlReader.getValue()).booleanValue()) {
                        if (this.mySslCfg == null) {
                            this.mySslCfg = new DataSourceSslConfiguration("", "", "", true);
                        } else {
                            this.mySslCfg.myEnabled = true;
                        }
                    } else if ("ssl-ca-cert".equals(nodeName) && !StringUtil.isEmptyOrSpaces((String)xmlReader.getValue())) {
                        if (this.mySslCfg == null) {
                            this.mySslCfg = new DataSourceSslConfiguration(xmlReader.getValue(), "", "", false);
                        } else {
                            this.mySslCfg.myCaCertPath = xmlReader.getValue();
                        }
                    } else if ("driver-properties".equals(nodeName)) {
                        LocalDataSource.deserializeProperties(xmlReader, this.myDriverProperties);
                    } else if ("vm-env".equals(nodeName)) {
                        LocalDataSource.deserializeProperties(xmlReader, this.myVmEnv);
                    } else if ("ssh-properties".equals(nodeName)) {
                        this.mySshConfiguration = DataSourceSshTunnelConfiguration.deserialize(xmlReader, this);
                    } else if ("ssl-config".equals(nodeName)) {
                        this.mySslCfg = DataSourceSslConfiguration.deserialize(xmlReader);
                    } else if ("test-user-password".equals(nodeName)) {
                        this.setPassword(xmlReader.getValue());
                    } else {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static void deserializeProperties(HierarchicalStreamReader xmlReader, Map<String, String> properties) {
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            if ("property".equals(xmlReader.getNodeName())) {
                properties.put(xmlReader.getAttribute("name"), xmlReader.getAttribute("value"));
            }
            xmlReader.moveUp();
        }
    }

    @NotNull
    private IntrospectionScope parseSchemaPattern(@Nullable String pattern) {
        Dbms family = Dbms.forConnection((RawConnectionConfig)this);
        IntrospectionScope introspectionScope = IntrospectionScopes.invertIf(IntrospectionScopes.fromSchemaPattern(pattern), family.isMysql());
        if (introspectionScope == null) {
            LocalDataSource.$$$reportNull$$$0(19);
        }
        return introspectionScope;
    }

    @NotNull
    private IntrospectionScope importOldScope(@Nullable String pattern) {
        Dbms family = Dbms.forConnection((RawConnectionConfig)this);
        IntrospectionScope introspectionScope = IntrospectionScopes.invertIf(IntrospectionScopes.importScope(pattern), family.isMysql());
        if (introspectionScope == null) {
            LocalDataSource.$$$reportNull$$$0(20);
        }
        return introspectionScope;
    }

    @NotNull
    public List<SimpleClasspathElement> getClasspathElements() {
        if (this.myDriver != null) {
            List<SimpleClasspathElement> list = this.myDriver.getClasspathElements();
            if (list == null) {
                LocalDataSource.$$$reportNull$$$0(21);
            }
            return list;
        }
        List<SimpleClasspathElement> list = Collections.emptyList();
        if (list == null) {
            LocalDataSource.$$$reportNull$$$0(22);
        }
        return list;
    }

    @Deprecated
    public void setClasspathElements(List<SimpleClasspathElement> classpathElements) {
        this.myClasspathElements.clear();
        this.myClasspathElements.addAll(classpathElements);
    }

    @Deprecated
    @NotNull
    public List<SimpleClasspathElement> getOwnClasspath() {
        List<SimpleClasspathElement> list = this.myClasspathElements;
        if (list == null) {
            LocalDataSource.$$$reportNull$$$0(23);
        }
        return list;
    }

    public String getDefaultDialect() {
        if (this.myDriver != null) {
            return this.myDriver.getSqlDialect();
        }
        return null;
    }

    @Nullable
    public String getVmOptions() {
        return this.myVmOptions;
    }

    public void setVmOptions(@Nullable String vmOptions) {
        this.myVmOptions = vmOptions;
    }

    @NotNull
    public Map<String, String> getDriverProperties() {
        Map<String, String> map = this.myDriverProperties;
        if (map == null) {
            LocalDataSource.$$$reportNull$$$0(24);
        }
        return map;
    }

    public String getObjectPattern() {
        return this.myObjectPattern;
    }

    public boolean useLegacyIntrospector() {
        return this.myUseLegacyIntrospector;
    }

    public void setUseLegacyIntrospector(boolean useLegacyIntrospector) {
        this.myUseLegacyIntrospector = useLegacyIntrospector;
    }

    @NotNull
    public DBIntrospectionOptions.SourceLoading getSourceLoading() {
        DBIntrospectionOptions.SourceLoading sourceLoading = this.mySourceLoading;
        if (sourceLoading == null) {
            LocalDataSource.$$$reportNull$$$0(25);
        }
        return sourceLoading;
    }

    public void setSourceLoading(@NotNull DBIntrospectionOptions.SourceLoading sourceLoading) {
        if (sourceLoading == null) {
            LocalDataSource.$$$reportNull$$$0(26);
        }
        this.mySourceLoading = sourceLoading;
    }

    public void setObjectPattern(String objectPattern) {
        this.myObjectPattern = objectPattern;
    }

    @Nullable
    public DataSourceSshTunnelConfiguration getSshConfiguration() {
        return this.mySshConfiguration;
    }

    public void setSshConfiguration(DataSourceSshTunnelConfiguration configuration) {
        this.mySshConfiguration = configuration;
    }

    @Nullable
    public DataSourceSslConfiguration getSslCfg() {
        return this.mySslCfg;
    }

    public void setSslCfg(DataSourceSslConfiguration sslCfg) {
        this.mySslCfg = sslCfg;
    }

    public boolean isDomainAuthentication() {
        return this.myDomainAuthentication;
    }

    public void setDomainAuthentication(boolean domainAuthentication) {
        this.myDomainAuthentication = domainAuthentication;
    }

    @NotNull
    public LocalDataSource copy() {
        StringBuffer buffer = this.copySettings(null);
        LocalDataSource clone = LocalDataSource.createDataSourceFromSettings(buffer, null);
        this.copyExtraParametersTo(clone);
        LocalDataSource localDataSource = clone;
        if (localDataSource == null) {
            LocalDataSource.$$$reportNull$$$0(27);
        }
        return localDataSource;
    }

    public StringBuffer copySettings(@Nullable Project project) {
        StringWriter writer = new StringWriter();
        CompactWriter serializer = new CompactWriter((Writer)writer);
        this.serialize(project, (HierarchicalStreamWriter)serializer, SaveMode.WITHOUT_SCHEMA);
        serializer.close();
        return writer.getBuffer();
    }

    @NotNull
    public static LocalDataSource createDataSourceFromSettings(@NotNull StringBuffer settings, @Nullable Project project) {
        if (settings == null) {
            LocalDataSource.$$$reportNull$$$0(28);
        }
        LocalDataSource clone = new LocalDataSource();
        clone.deserialize(project, (HierarchicalStreamReader)new XppReader((Reader)new StringReader(settings.toString()), (XmlPullParser)new MXParser()), SaveMode.WITHOUT_SCHEMA);
        clone.setUniqueId(null);
        clone.resolveDriver();
        LocalDataSource localDataSource = clone;
        if (localDataSource == null) {
            LocalDataSource.$$$reportNull$$$0(29);
        }
        return localDataSource;
    }

    private void copyExtraParametersTo(@NotNull LocalDataSource ds) {
        if (ds == null) {
            LocalDataSource.$$$reportNull$$$0(30);
        }
        ds.setGlobal(this.isGlobal());
        ds.setDatabaseDriver(this.getDatabaseDriver());
        ds.setIntrospectionScope(this.getIntrospectionScope());
        ds.setUseMasterKeyStorage(this.isUseMasterKeyStorage());
        ds.setUsername(this.getUsername());
    }

    @Nullable
    public RawConnectionConfig getConnectionConfig() {
        return this;
    }

    public boolean equalConfiguration(@NotNull LocalDataSource o) {
        boolean hasSsl2;
        boolean hasSsh2;
        if (o == null) {
            LocalDataSource.$$$reportNull$$$0(31);
        }
        if (this.isConfiguredByUrl() != o.isConfiguredByUrl()) {
            return false;
        }
        if (this.isImported() != o.isImported()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getComment(), (CharSequence)o.getComment())) {
            return false;
        }
        if (this.isAuthRequired() != o.isAuthRequired()) {
            return false;
        }
        if (this.getSchemaControl() != o.getSchemaControl()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.getUrl()), (CharSequence)StringUtil.nullize((String)o.getUrl()))) {
            return false;
        }
        if (this.isAutoSynchronize() != o.isAutoSynchronize()) {
            return false;
        }
        if (this.isReadOnly() != o.isReadOnly()) {
            return false;
        }
        if (this.shouldCheckOutdated() != o.shouldCheckOutdated()) {
            return false;
        }
        if (this.isAutoCommit() != o.isAutoCommit()) {
            return false;
        }
        if (this.getTxIsolation() != o.getTxIsolation()) {
            return false;
        }
        if (this.isGlobal() != o.isGlobal()) {
            return false;
        }
        if (!LocalDataSource.driversEqual(this.getDatabaseDriver(), o.getDatabaseDriver())) {
            return false;
        }
        if (this.isDomainAuthentication() != o.isDomainAuthentication()) {
            return false;
        }
        if (!this.getDriverProperties().equals(o.getDriverProperties())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getDriverClass(), (CharSequence)o.getDriverClass())) {
            return false;
        }
        if (!Comparing.equal((Object)this.getIntrospectionScope(), (Object)o.getIntrospectionScope())) {
            return false;
        }
        if (!Comparing.equal(this.getFakeCurrentSchema(), o.getFakeCurrentSchema())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getObjectPattern(), (CharSequence)o.getObjectPattern())) {
            return false;
        }
        if (this.myUseLegacyIntrospector != o.useLegacyIntrospector()) {
            return false;
        }
        if (this.mySourceLoading != o.getSourceLoading()) {
            return false;
        }
        if (this.myRewriteBounds != o.isRewriteBounds()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myVmOptions), (CharSequence)StringUtil.nullize((String)o.myVmOptions))) {
            return false;
        }
        if (!LocalDataSource.equals(this.myVmEnv, o.myVmEnv)) {
            return false;
        }
        if (!LocalDataSource.equals(this.getAdditionalJdbcProperties(), o.getAdditionalJdbcProperties())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.myCodeStyleName, (CharSequence)o.myCodeStyleName)) {
            return false;
        }
        if (this.isSingleConnection() != o.isSingleConnection()) {
            return false;
        }
        boolean hasSsh1 = this.mySshConfiguration != null && !this.mySshConfiguration.isEmpty();
        boolean bl = hasSsh2 = o.mySshConfiguration != null && !o.mySshConfiguration.isEmpty();
        if (hasSsh1 != hasSsh2) {
            return false;
        }
        if (hasSsh1 && !this.mySshConfiguration.equalConfiguration(o.mySshConfiguration)) {
            return false;
        }
        boolean hasSsl1 = this.mySslCfg != null && !this.mySslCfg.isEmpty();
        boolean bl2 = hasSsl2 = o.mySslCfg != null && !o.mySslCfg.isEmpty();
        if (hasSsl1 != hasSsl2) {
            return false;
        }
        return !hasSsl1 || this.mySslCfg.equalConfiguration(o.mySslCfg);
    }

    private static boolean driversEqual(@Nullable DatabaseDriver a, @Nullable DatabaseDriver b2) {
        if (a == null || b2 == null) {
            return a == b2;
        }
        return Comparing.equal((String)a.getId(), (String)b2.getId());
    }

    private static <K, V> boolean equals(@NotNull Map<K, V> m1, @NotNull Map<K, V> m2) {
        if (m1 == null) {
            LocalDataSource.$$$reportNull$$$0(32);
        }
        if (m2 == null) {
            LocalDataSource.$$$reportNull$$$0(33);
        }
        for (Map.Entry<K, V> entry : m1.entrySet()) {
            if (Comparing.equal(entry.getValue(), m2.get(entry.getKey()))) continue;
            return false;
        }
        for (Map.Entry<K, V> entry : m2.entrySet()) {
            if (Comparing.equal(entry.getValue(), m1.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public void setAdditionalJdbcProperties(@NotNull Map<String, String> additionalJdbcProperties) {
        if (additionalJdbcProperties == null) {
            LocalDataSource.$$$reportNull$$$0(34);
        }
        this.myAdditionalJdbcProperties.clear();
        this.myAdditionalJdbcProperties.putAll(additionalJdbcProperties);
    }

    @Override
    @NotNull
    public Map<String, String> getAdditionalJdbcProperties() {
        Map<String, String> map = this.myAdditionalJdbcProperties;
        if (map == null) {
            LocalDataSource.$$$reportNull$$$0(35);
        }
        return map;
    }

    public boolean isAuthRequired() {
        return this.myAuthRequired;
    }

    public void setAuthRequired(boolean authRequired) {
        this.myAuthRequired = authRequired;
    }

    public boolean isImported() {
        return this.myImported;
    }

    public boolean isConfiguredByUrl() {
        return this.myConfiguredByUrl;
    }

    public void setConfiguredByUrl(boolean configuredByUrl) {
        this.myConfiguredByUrl = configuredByUrl;
    }

    @NotNull
    public Map<String, String> getVmEnv() {
        Map<String, String> map = this.myVmEnv;
        if (map == null) {
            LocalDataSource.$$$reportNull$$$0(36);
        }
        return map;
    }

    public void setVmEnv(@NotNull Map<String, String> vmEnv) {
        if (vmEnv == null) {
            LocalDataSource.$$$reportNull$$$0(37);
        }
        this.myVmEnv.clear();
        this.myVmEnv.putAll(vmEnv);
    }

    @Override
    @NotNull
    public String toString() {
        String str = super.toString();
        String dialect = this.getDefaultDialect();
        String string = str = str + (dialect != null && !dialect.isEmpty() ? " (" + dialect + ")" : " (unknown dialect)");
        if (string == null) {
            LocalDataSource.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    public DasModel getModel() {
        DasModel dasModel = this.myModel;
        if (dasModel == null) {
            LocalDataSource.$$$reportNull$$$0(39);
        }
        return dasModel;
    }

    public void setModel(@NotNull DasModel model) {
        if (model == null) {
            LocalDataSource.$$$reportNull$$$0(40);
        }
        if (this.myModel == model) {
            return;
        }
        if (this.myModel instanceof BasicModModel) {
            ((BasicModModel)this.myModel).removeListener(this.myModelListener);
        }
        if (model instanceof BasicModel) {
            this.myIntrospectionScope = DatabaseModelLoader.updateIntrospectionScope((BasicModel)model, this.myIntrospectionScope, true);
        }
        this.myModel = model;
        this.incModificationCount();
        if (this.myModel instanceof BasicModModel) {
            ((BasicModModel)this.myModel).addListener(this.myModelListener);
        }
        this.fireModelChangedInEDT();
    }

    private void fireModelChangedInEDT() {
        GuiUtils.invokeLaterIfNeeded(() -> {
            for (Listener listener : this.myDispatcher.getListeners()) {
                try {
                    listener.dataSourceModelUpdated(this);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error(this.logMessage(e));
                }
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    public void addListener(@NotNull Listener listener) {
        if (listener == null) {
            LocalDataSource.$$$reportNull$$$0(41);
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(@NotNull Listener listener) {
        if (listener == null) {
            LocalDataSource.$$$reportNull$$$0(42);
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public void clearModel() {
        BasicModModel basicModel = (BasicModModel)ObjectUtils.tryCast((Object)this.myModel, BasicModModel.class);
        if (basicModel != null) {
            DbImplUtil.performSrcOperation(basicModel, TransactionGuard.getInstance().getContextTransaction(), false, basicModel::clearModel);
        } else {
            this.setModel(DasUtil.emptyModel());
        }
    }

    public void forgetCachedSchemas() {
        LOG.info(this.logMessage("forgetting cached schemas"));
        this.clearModel();
    }

    public void serialize(@Nullable Project project, @NotNull HierarchicalStreamWriter serializer, @NotNull SaveMode mode) {
        if (serializer == null) {
            LocalDataSource.$$$reportNull$$$0(43);
        }
        if (mode == null) {
            LocalDataSource.$$$reportNull$$$0(44);
        }
        serializer.startNode(ELEMENT_NAME);
        this.serializeHeader(project, serializer, mode);
        if (mode.includeSchema()) {
            ModelSerializerKt.serialize(this.getModel(), serializer);
        }
        serializer.endNode();
        serializer.flush();
    }

    public void serializeHeader(Project project, @NotNull HierarchicalStreamWriter serializer, @NotNull SaveMode mode) {
        if (serializer == null) {
            LocalDataSource.$$$reportNull$$$0(45);
        }
        if (mode == null) {
            LocalDataSource.$$$reportNull$$$0(46);
        }
        if (mode.includeConfig()) {
            serializer.addAttribute("source", this.getSourceName());
        }
        serializer.addAttribute("name", StringUtil.notNullize((String)this.getName()));
        if (mode.includeConfig()) {
            if (this.isReadOnly()) {
                serializer.addAttribute("read-only", String.valueOf(this.isReadOnly()));
            }
            if (this.shouldCheckOutdated()) {
                serializer.addAttribute("check-outdated", String.valueOf(this.shouldCheckOutdated()));
            }
            if (this.isSingleConnection()) {
                serializer.addAttribute("single-connection", String.valueOf(this.isSingleConnection()));
            }
            if (StringUtil.isNotEmpty((String)this.getGroupName())) {
                serializer.addAttribute("group", this.getGroupName());
            }
        }
        serializer.addAttribute("uuid", StringUtil.notNullize((String)this.getUniqueId()));
        if (mode.includeDatabaseInfo()) {
            DataSourceInfo info = this.getInfo();
            serializer.startNode("database-info");
            serializer.addAttribute("product", info.databaseVersion.name);
            serializer.addAttribute("version", info.databaseVersion.version);
            serializer.addAttribute("jdbc-version", StringUtil.notNullize((String)info.jdbcVersion));
            serializer.addAttribute("driver-name", info.driverVersion.name);
            serializer.addAttribute("driver-version", info.driverVersion.version);
            if (info.dbms != null) {
                serializer.addAttribute("dbms", info.dbms.getName());
            }
            if (info.exactVersion != null) {
                serializer.addAttribute("exact-version", info.exactVersion.toString(1, Integer.MAX_VALUE));
            }
            if (info.exactDriverVersion != null && info.exactDriverVersion != Version.ZERO) {
                serializer.addAttribute("exact-driver-version", info.exactDriverVersion.toString(1, Integer.MAX_VALUE));
            }
            if (info.extraNameCharacters != null) {
                LocalDataSource.writeTag(serializer, "extra-name-characters", info.extraNameCharacters);
            }
            if (info.identifierQuoteString != null) {
                LocalDataSource.writeTag(serializer, "identifier-quote-string", info.identifierQuoteString);
            }
            serializer.endNode();
            if (info.casing.plain != DasUtil.CASING_MIXED.plain || info.casing.quoted != DasUtil.CASING_MIXED.quoted) {
                serializer.startNode("case-sensitivity");
                serializer.addAttribute("plain-identifiers", StringUtil.toLowerCase((String)info.casing.plain.name()));
                serializer.addAttribute("quoted-identifiers", StringUtil.toLowerCase((String)info.casing.quoted.name()));
                serializer.endNode();
            }
        }
        this.serializeHeaderInner(project, serializer, mode);
    }

    public void deserialize(Project project, Reader reader) {
        this.deserialize(project, (HierarchicalStreamReader)new XppReader(reader, (XmlPullParser)new MXParser()), SaveMode.ALL);
    }

    protected BasicModModel deserializeLegacyFormat(@Nullable Project project, @NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            LocalDataSource.$$$reportNull$$$0(47);
        }
        Dbms dbms = (Dbms)ObjectUtils.chooseNotNull((Object)DbImplUtil.guessDbms(this.getConnectionConfig()), (Object)Dbms.UNKNOWN);
        return LegacyDeserializer.deserialize(reader, DbSrcModelStorage.createFactory(project, this.getUniqueId()), dbms, this.getIntrospectionScope(), this.myResolveScope);
    }

    public void performBatch(Runnable runnable) {
        this.myBatchCounter.incrementAndGet();
        try {
            runnable.run();
        }
        finally {
            if (this.myBatchCounter.decrementAndGet() == 0) {
                this.fireModelChangedInEDT();
            }
        }
    }

    void copyDatabaseInfo(@NotNull LocalDataSource other) {
        if (other == null) {
            LocalDataSource.$$$reportNull$$$0(48);
        }
        this.myInfo.copyFrom(other.getInfo());
    }

    public boolean isLoading() {
        return this.myLoading;
    }

    public boolean isInBatch() {
        return this.myBatchCounter.get() != 0;
    }

    public void setLoading(boolean loading) {
        this.myLoading = loading;
    }

    @Override
    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource = this;
        if (localDataSource == null) {
            LocalDataSource.$$$reportNull$$$0(49);
        }
        return localDataSource;
    }

    @NotNull
    public NameVersion getDatabaseVersion() {
        NameVersion nameVersion = this.getInfo().databaseVersion;
        if (nameVersion == null) {
            LocalDataSource.$$$reportNull$$$0(50);
        }
        return nameVersion;
    }

    @NotNull
    public NameVersion getDriverVersion() {
        NameVersion nameVersion = this.getInfo().driverVersion;
        if (nameVersion == null) {
            LocalDataSource.$$$reportNull$$$0(51);
        }
        return nameVersion;
    }

    public String getJDBCVersion() {
        return this.getInfo().jdbcVersion;
    }

    public Casing getCaseModes() {
        return this.getInfo().casing;
    }

    DataSourceInfo getInfo() {
        return this.myInfo;
    }

    @Nullable
    public String getCodeStyleName() {
        return this.myCodeStyleName;
    }

    public void setCodeStyleName(@Nullable String codeStyleName) {
        this.myCodeStyleName = codeStyleName;
    }

    @NotNull
    public String logMessage(@NotNull String message2) {
        if (message2 == null) {
            LocalDataSource.$$$reportNull$$$0(52);
        }
        String string = "Data source \"" + this.getName() + "\" {" + this.getUniqueId() + "}: " + message2;
        if (string == null) {
            LocalDataSource.$$$reportNull$$$0(53);
        }
        return string;
    }

    @NotNull
    public String logMessage(@NotNull Throwable e) {
        if (e == null) {
            LocalDataSource.$$$reportNull$$$0(54);
        }
        String string = this.logMessage("exception " + e.getClass().getSimpleName() + ": " + e.getMessage());
        if (string == null) {
            LocalDataSource.$$$reportNull$$$0(55);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/LocalDataSource";
                break;
            }
            case 4: 
            case 5: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 16: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 15: 
            case 17: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlReader";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceLoading";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m1";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m2";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalJdbcProperties";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmEnv";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/LocalDataSource";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaControl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExactDriverVersion";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntrospectionScope";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionProperties";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSchemaPattern";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "importOldScope";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasspathElements";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnClasspath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getDriverProperties";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceLoading";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataSourceFromSettings";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalJdbcProperties";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmEnv";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSource";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseVersion";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getDriverVersion";
                break;
            }
            case 53: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "logMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeTag";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDriver";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setIntrospectionScope";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveUrl";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "deserializeInner";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "deserializeDatabaseInfo";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setSourceLoading";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createDataSourceFromSettings";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "copyExtraParametersTo";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "equalConfiguration";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalJdbcProperties";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setVmEnv";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "serializeHeader";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "deserializeLegacyFormat";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "copyDatabaseInfo";
                break;
            }
            case 52: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "logMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum SaveMode {
        ALL,
        CONFIG,
        LOCAL_CONFIG,
        WITHOUT_SCHEMA,
        SCHEMA;


        public boolean includeSchema() {
            return this == ALL || this == SCHEMA;
        }

        public boolean includeConfig() {
            return this == ALL || this == CONFIG || this == WITHOUT_SCHEMA;
        }

        public boolean includeLocalConfig() {
            return this == ALL || this == LOCAL_CONFIG || this == WITHOUT_SCHEMA;
        }

        public boolean includeDatabaseInfo() {
            return this.includeSchema() || this.includeLocalConfig();
        }
    }

    public static interface Listener
    extends EventListener {
        public void dataSourceModelUpdated(@NotNull LocalDataSource var1);
    }
}

