/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.actions.AssignColorAction;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.Objects;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseColorPanel
extends JPanel {
    private static final String CUSTOM = "Custom...";
    private static final String NO_COLOR = "No color";
    private static final int ICON_SIZE = EmptyIcon.ICON_16.getIconWidth();
    private static final String SHORTCUT_ACTION = "ExpandExpandableComponent";
    private static final Color ICON_COLOR = JBColor.namedColor((String)"Component.iconColor", (Color)ColorUtil.withAlpha((Color)new JBColor(8358801, 8358801), (double)0.5));
    private static final Color ICON_COLOR_HOVERED = JBColor.namedColor((String)"Component.hoverIconColor", (Color)ColorUtil.withAlpha((Color)new JBColor(8358801, 8358801), (double)0.9));
    @Nullable
    private String myColorString;
    @NotNull
    private final AbstractDataSource myDataSource;
    @NotNull
    private final DataSourceManager<?> myManager;
    @NotNull
    private final Project myProject;
    @NotNull
    private final DatabaseConfigEditor myController;
    private List<String> myStandardColors;
    private ExtendableTextField myTextField;

    public DatabaseColorPanel(@NotNull AbstractDataSource source, @NotNull DataSourceManager<?> manager, @NotNull Project project, @NotNull DatabaseConfigEditor controller) {
        if (source == null) {
            DatabaseColorPanel.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DatabaseColorPanel.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DatabaseColorPanel.$$$reportNull$$$0(2);
        }
        if (controller == null) {
            DatabaseColorPanel.$$$reportNull$$$0(3);
        }
        this.myColorString = null;
        this.myDataSource = source;
        this.myManager = manager;
        this.myProject = project;
        this.myController = controller;
        this.setLayout(new BorderLayout());
        @NotNull ComboBox colorComboBox = new ComboBox((ComboBoxModel)new MyComboBoxModel());
        colorComboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<String>(){

            public void customize(JList list, String value, int index2, boolean selected, boolean hasFocus) {
                if (value == DatabaseColorPanel.NO_COLOR || value == DatabaseColorPanel.CUSTOM && (DatabaseColorPanel.this.myColorString == null || DatabaseColorPanel.this.getStandardColors().contains(DatabaseColorPanel.this.myColorString))) {
                    return;
                }
                Color color = DatabaseColorPanel.getColor(value == DatabaseColorPanel.CUSTOM ? DatabaseColorPanel.this.myColorString : value, DatabaseColorPanel.this.myProject);
                this.setIcon(DatabaseColorPanel.createColorIcon(color));
            }
        });
        this.add((Component)colorComboBox, "Center");
        this.myStandardColors = this.getStandardColors();
    }

    @NotNull
    static Icon createColorIcon(@Nullable Color color) {
        Object object = color == null ? EmptyIcon.ICON_16 : new RoundColorIcon(ICON_SIZE, color);
        if (object == null) {
            DatabaseColorPanel.$$$reportNull$$$0(4);
        }
        return object;
    }

    @NotNull
    Icon createColorIcon(final boolean hovered) {
        RoundColorIcon roundColorIcon = new RoundColorIcon(ICON_SIZE, ICON_COLOR){

            @Override
            public void paintIcon(Component component, Graphics g, int i2, int j) {
                Color color;
                Color color2 = DatabaseColorPanel.this.myColorString != null ? DatabaseColorPanel.getColor(DatabaseColorPanel.this.myColorString, DatabaseColorPanel.this.myProject) : (color = hovered ? ICON_COLOR_HOVERED : DatabaseColorPanel.this.myTextField.getBackground());
                Color borderColor = DatabaseColorPanel.this.myColorString != null ? ICON_COLOR : (hovered ? ICON_COLOR_HOVERED : ICON_COLOR);
                this.doPaint(g, i2, j, color, borderColor);
            }
        };
        if (roundColorIcon == null) {
            DatabaseColorPanel.$$$reportNull$$$0(5);
        }
        return roundColorIcon;
    }

    private List<String> getStandardColors() {
        if (this.myStandardColors == null) {
            this.myStandardColors = ContainerUtil.newArrayList((Iterable)FileColorManager.getInstance((Project)this.myProject).getColorNames());
        }
        return this.myStandardColors;
    }

    public void apply(@NotNull AbstractDataSource source) {
        if (source == null) {
            DatabaseColorPanel.$$$reportNull$$$0(6);
        }
        WriteAction.run(() -> {
            if (source == null) {
                DatabaseColorPanel.$$$reportNull$$$0(18);
            }
            DatabaseColorManager.setColorName(this.getElement(source), this.myColorString, false, false);
        });
        AssignColorAction.updateOpenFileEditors(this.myProject);
        AssignColorAction.updateDatabaseToolwindow(this.myProject);
    }

    public void reset(@NotNull AbstractDataSource source) {
        if (source == null) {
            DatabaseColorPanel.$$$reportNull$$$0(7);
        }
        this.myColorString = DatabaseColorManager.getColorName(this.getElement(source), (Ref<Boolean>)Ref.create((Object)false));
        if (this.myTextField != null) {
            this.myTextField.repaint();
        }
    }

    void setChosenColor(@Nullable String string) {
        this.myColorString = string;
        if (this.myTextField != null) {
            this.myTextField.repaint();
        }
        this.myController.clearModifiedCache();
    }

    @NotNull
    private DbElement getElement(@NotNull AbstractDataSource source) {
        if (source == null) {
            DatabaseColorPanel.$$$reportNull$$$0(8);
        }
        DbDataSource dbDataSource = ((DbPsiFacadeImpl)DbPsiFacade.getInstance((Project)this.myProject)).createDataSourceWrapperElement(source, this.myManager);
        if (dbDataSource == null) {
            DatabaseColorPanel.$$$reportNull$$$0(9);
        }
        return dbDataSource;
    }

    public boolean isModified() {
        return !Objects.equals(DatabaseColorManager.getColorName(this.getElement(this.myDataSource), (Ref<Boolean>)Ref.create((Object)false)), this.myColorString);
    }

    @NotNull
    private static Color getColor(@Nullable String curColorName, @NotNull Project project) {
        Color color;
        if (project == null) {
            DatabaseColorPanel.$$$reportNull$$$0(10);
        }
        if (curColorName == null) {
            Color color2 = UIUtil.getInactiveTextFieldBackgroundColor();
            if (color2 == null) {
                DatabaseColorPanel.$$$reportNull$$$0(11);
            }
            return color2;
        }
        Color color3 = FileColorManager.getInstance((Project)project).getColor(curColorName);
        if (color3 != null) {
            Color color4 = color3;
            if (color4 == null) {
                DatabaseColorPanel.$$$reportNull$$$0(12);
            }
            return color4;
        }
        try {
            color = ColorUtil.fromHex((String)curColorName);
        }
        catch (Exception e) {
            Color color5 = UIUtil.getInactiveTextFieldBackgroundColor();
            if (color5 == null) {
                DatabaseColorPanel.$$$reportNull$$$0(14);
            }
            return color5;
        }
        if (color == null) {
            DatabaseColorPanel.$$$reportNull$$$0(13);
        }
        return color;
    }

    @Nullable
    static KeyboardShortcut getExtensionKeyboardShortcut() {
        AnAction baseAction = ActionManager.getInstance().getAction(SHORTCUT_ACTION);
        return baseAction == null ? null : (KeyboardShortcut)JBIterable.of((Object[])baseAction.getShortcutSet().getShortcuts()).filter(KeyboardShortcut.class).first();
    }

    @NotNull
    public ExtendableTextComponent.Extension createExtension(@NotNull ExtendableTextField textField) {
        if (textField == null) {
            DatabaseColorPanel.$$$reportNull$$$0(15);
        }
        if (this.myTextField != null) {
            throw new AssertionError();
        }
        this.myTextField = textField;
        Ext ext = new Ext();
        if (ext == null) {
            DatabaseColorPanel.$$$reportNull$$$0(16);
        }
        return ext;
    }

    @Nullable
    public static ExtendableTextComponent.Extension getExtension(@NotNull ExtendableTextField field) {
        if (field == null) {
            DatabaseColorPanel.$$$reportNull$$$0(17);
        }
        return (ExtendableTextComponent.Extension)JBIterable.from((Iterable)field.getExtensions()).filter(Ext.class).first();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseColorPanel";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseColorPanel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createColorIcon";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getColor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createExtension";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$apply$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Ext
    implements ExtendableTextComponent.Extension {
        final Icon icon;
        final Icon iconHovered;

        private Ext() {
            this.icon = DatabaseColorPanel.this.createColorIcon(false);
            this.iconHovered = DatabaseColorPanel.this.createColorIcon(true);
        }

        public Icon getIcon(boolean hovered) {
            return hovered ? this.iconHovered : this.icon;
        }

        public String getTooltip() {
            return "Choose Color (" + KeymapUtil.getFirstKeyboardShortcutText((String)DatabaseColorPanel.SHORTCUT_ACTION) + ")";
        }

        public int getIconGap() {
            return 3;
        }

        public Runnable getActionOnClick() {
            return this::perform;
        }

        private void perform() {
            FileColorManager colorManager = FileColorManager.getInstance((Project)DatabaseColorPanel.this.myProject);
            JBIterable values2 = JBIterable.of((Object)DatabaseColorPanel.NO_COLOR).append((Iterable)colorManager.getColorNames()).append(DatabaseColorPanel.this.myColorString != null && !colorManager.getColorNames().contains(DatabaseColorPanel.this.myColorString) ? DatabaseColorPanel.this.myColorString : null).append((Object)DatabaseColorPanel.CUSTOM);
            JBIterable icons = values2.map(o -> o == DatabaseColorPanel.NO_COLOR || o == DatabaseColorPanel.CUSTOM ? null : colorManager.getColor(o)).map(DatabaseColorPanel::createColorIcon);
            BaseListPopupStep<String> popupStep = new BaseListPopupStep<String>("", values2.toList(), icons.toList()){

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @Nullable
                public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                    if (selectedValue == DatabaseColorPanel.CUSTOM) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            Color color = ColorChooser.chooseColor((Component)DatabaseColorPanel.this.myTextField, (String)"Choose Color", (Color)DatabaseColorPanel.getColor(DatabaseColorPanel.this.myColorString, DatabaseColorPanel.this.myProject));
                            if (color != null) {
                                DatabaseColorPanel.this.setChosenColor(ColorUtil.toHex((Color)color));
                            }
                        }, ModalityState.stateForComponent((Component)DatabaseColorPanel.this.myTextField));
                    } else {
                        DatabaseColorPanel.this.setChosenColor(selectedValue == DatabaseColorPanel.NO_COLOR ? null : selectedValue);
                    }
                    return super.onChosen((Object)selectedValue, finalChoice);
                }
            };
            popupStep.setDefaultOptionIndex(values2.indexOf(Conditions.equalTo((Object)DatabaseColorPanel.this.myColorString)));
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)popupStep);
            ExtendableTextComponent.Extension extension = (ExtendableTextComponent.Extension)ObjectUtils.notNull((Object)DatabaseColorPanel.getExtension(DatabaseColorPanel.this.myTextField));
            Rectangle bounds = ((TextFieldWithPopupHandlerUI)DatabaseColorPanel.this.myTextField.getUI()).getExtensionIconBounds(extension);
            Point point = bounds.getLocation();
            point.y += bounds.width + JBUI.scale((int)2);
            popup.show(new RelativePoint((Component)DatabaseColorPanel.this.myTextField, point));
        }
    }

    private class MyComboBoxModel
    implements ComboBoxModel<String> {
        private MyComboBoxModel() {
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (anItem == DatabaseColorPanel.CUSTOM) {
                Color color = ColorChooser.chooseColor((Component)DatabaseColorPanel.this, (String)"Choose Color", (Color)DatabaseColorPanel.getColor(DatabaseColorPanel.this.myColorString, DatabaseColorPanel.this.myProject));
                if (color != null) {
                    DatabaseColorPanel.this.myColorString = ColorUtil.toHex((Color)color);
                }
            } else if (anItem == DatabaseColorPanel.NO_COLOR) {
                DatabaseColorPanel.this.myColorString = null;
            } else {
                DatabaseColorPanel.this.myColorString = (String)anItem;
            }
            DatabaseColorPanel.this.myController.clearModifiedCache();
        }

        @Override
        public String getSelectedItem() {
            if (DatabaseColorPanel.this.myColorString == null) {
                return DatabaseColorPanel.NO_COLOR;
            }
            if (DatabaseColorPanel.this.getStandardColors().contains(DatabaseColorPanel.this.myColorString)) {
                return DatabaseColorPanel.this.myColorString;
            }
            return DatabaseColorPanel.CUSTOM;
        }

        @Override
        public int getSize() {
            return DatabaseColorPanel.this.getStandardColors().size() + 2;
        }

        @Override
        public String getElementAt(int index2) {
            if (index2 == 0) {
                return DatabaseColorPanel.NO_COLOR;
            }
            int i2 = 0;
            for (String color : DatabaseColorPanel.this.getStandardColors()) {
                if (i2 + 1 == index2) {
                    return color;
                }
                ++i2;
            }
            return DatabaseColorPanel.CUSTOM;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }

    private static class RoundColorIcon
    extends ColorIcon {
        final Color borderColor;

        RoundColorIcon(int size, @NotNull Color color) {
            if (color == null) {
                RoundColorIcon.$$$reportNull$$$0(0);
            }
            this(size, color, ICON_COLOR);
        }

        RoundColorIcon(int size, @NotNull Color color, @NotNull Color borderColor) {
            if (color == null) {
                RoundColorIcon.$$$reportNull$$$0(1);
            }
            if (borderColor == null) {
                RoundColorIcon.$$$reportNull$$$0(2);
            }
            super(size, color, true);
            this.borderColor = borderColor;
        }

        public void paintIcon(Component component, Graphics g, int i2, int j) {
            this.doPaint(g, i2, j, this.getIconColor(), this.borderColor);
        }

        void doPaint(Graphics g, int i2, int j, Color color, Color borderColor) {
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
            int dim = this.getIconWidth() - 2;
            g.setColor(color);
            g.fillOval(i2 + 1, j + 1, dim, dim);
            g.setColor(borderColor);
            g.drawOval(i2 + 1, j + 1, dim, dim);
            config.restore();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "color";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "borderColor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dataSource/DatabaseColorPanel$RoundColorIcon";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

