/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class GitRebaseEntry {
    private static final Logger log = Logger.getInstance((String)GitRebaseEntry.class.getName());
    private final String myCommit;
    private final String mySubject;
    private Action myAction;

    GitRebaseEntry(String action, String commit2, String subject) {
        this(Action.fromString(action), commit2, subject);
    }

    GitRebaseEntry(Action action, String commit2, String subject) {
        this.myCommit = commit2;
        this.mySubject = subject;
        this.myAction = action;
    }

    public String getCommit() {
        return this.myCommit;
    }

    public String getSubject() {
        return this.mySubject;
    }

    public Action getAction() {
        return this.myAction;
    }

    public void setAction(Action action) {
        if (action == null) {
            log.error("The action must not be null");
        } else {
            this.myAction = action;
        }
    }

    public static enum Action {
        PICK("pick", 'p'),
        EDIT("edit", 'e'),
        SKIP("skip", 's'),
        SQUASH("squash", 'q'),
        REWORD("reword", 'r'),
        FIXUP("fixup", 'f');

        @NotNull
        private final String myText;
        private final char myMnemonic;

        private Action(String text, char mnemonic) {
            if (text == null) {
                Action.$$$reportNull$$$0(0);
            }
            this.myText = text;
            this.myMnemonic = mnemonic;
        }

        public char getMnemonic() {
            return this.myMnemonic;
        }

        public String toString() {
            return this.myText;
        }

        @NotNull
        static Action fromString(@NonNls @NotNull String actionName) {
            Action action;
            if (actionName == null) {
                Action.$$$reportNull$$$0(1);
            }
            try {
                action = Action.valueOf(actionName.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                log.error((Throwable)e);
                Action action2 = PICK;
                if (action2 == null) {
                    Action.$$$reportNull$$$0(3);
                }
                return action2;
            }
            if (action == null) {
                Action.$$$reportNull$$$0(2);
            }
            return action;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/rebase/GitRebaseEntry$Action";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/rebase/GitRebaseEntry$Action";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "fromString";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

