/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.UtilKt;
import git4idea.GitUtil;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitSmartOperationDialog;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.util.GitPreservingProcess;
import git4idea.util.GitUIUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitCheckoutOperation
extends GitBranchOperation {
    @NotNull
    private final String myStartPointReference;
    private final boolean myDetach;
    private final boolean myRefShouldBeValid;
    @Nullable
    private final String myNewBranch;

    GitCheckoutOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<GitRepository> repositories, @NotNull String startPointReference, boolean detach, boolean refShouldBeValid, @Nullable String newBranch) {
        if (project == null) {
            GitCheckoutOperation.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitCheckoutOperation.$$$reportNull$$$0(1);
        }
        if (uiHandler == null) {
            GitCheckoutOperation.$$$reportNull$$$0(2);
        }
        if (repositories == null) {
            GitCheckoutOperation.$$$reportNull$$$0(3);
        }
        if (startPointReference == null) {
            GitCheckoutOperation.$$$reportNull$$$0(4);
        }
        super(project, git, uiHandler, repositories);
        this.myStartPointReference = startPointReference;
        this.myDetach = detach;
        this.myRefShouldBeValid = refShouldBeValid;
        this.myNewBranch = newBranch;
    }

    @Override
    protected void execute() {
        GitCheckoutOperation.saveAllDocuments();
        boolean fatalErrorHappened = false;
        this.branchWillChange();
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)this.getOperationName());){
            while (this.hasMoreRepositories() && !fatalErrorHappened) {
                GitRepository repository = this.next();
                VirtualFile root = repository.getRoot();
                Collection<Change> changes = GitChangeUtils.getDiff(repository, "HEAD", this.myStartPointReference, false);
                GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.CHECKOUT);
                GitSimpleEventDetector unmergedFiles = new GitSimpleEventDetector(GitSimpleEventDetector.Event.UNMERGED_PREVENTING_CHECKOUT);
                GitSimpleEventDetector unknownPathspec = new GitSimpleEventDetector(GitSimpleEventDetector.Event.INVALID_REFERENCE);
                GitUntrackedFilesOverwrittenByOperationDetector untrackedOverwrittenByCheckout = new GitUntrackedFilesOverwrittenByOperationDetector(root);
                GitCommandResult result2 = this.myGit.checkout(repository, this.myStartPointReference, this.myNewBranch, false, this.myDetach, localChangesDetector, unmergedFiles, unknownPathspec, untrackedOverwrittenByCheckout);
                if (result2.success()) {
                    GitUtil.updateAndRefreshVfs(repository, changes);
                    this.markSuccessful(repository);
                    continue;
                }
                if (unmergedFiles.hasHappened()) {
                    this.fatalUnmergedFilesError();
                    fatalErrorHappened = true;
                    continue;
                }
                if (localChangesDetector.wasMessageDetected()) {
                    boolean smartCheckoutSucceeded = this.smartCheckoutOrNotify(repository, localChangesDetector);
                    if (smartCheckoutSucceeded) continue;
                    fatalErrorHappened = true;
                    continue;
                }
                if (untrackedOverwrittenByCheckout.wasMessageDetected()) {
                    this.fatalUntrackedFilesError(repository.getRoot(), untrackedOverwrittenByCheckout.getRelativeFilePaths());
                    fatalErrorHappened = true;
                    continue;
                }
                if (!this.myRefShouldBeValid && unknownPathspec.hasHappened()) {
                    this.markSkip(repository);
                    continue;
                }
                this.fatalError(this.getCommonErrorTitle(), result2.getErrorOutputAsJoinedString());
                fatalErrorHappened = true;
            }
        }
        if (!fatalErrorHappened) {
            if (this.wereSuccessful()) {
                if (!this.wereSkipped()) {
                    this.notifySuccess();
                } else {
                    String mentionSuccess = this.getSuccessMessage() + GitUtil.mention(this.getSuccessfulRepositories(), 4);
                    String mentionSkipped = this.wereSkipped() ? "<br>Revision not found" + GitUtil.mention(this.getSkippedRepositories(), 4) : "";
                    VcsNotifier.getInstance((Project)this.myProject).notifySuccess("", mentionSuccess + mentionSkipped + "<br><a href='rollback'>Rollback</a>", (NotificationListener)new RollbackOperationNotificationListener());
                }
                this.updateRecentBranch(this.myStartPointReference);
            } else {
                LOG.assertTrue(!this.myRefShouldBeValid);
                this.notifyError("Couldn't checkout " + this.myStartPointReference, "Revision not found" + GitUtil.mention(this.getSkippedRepositories(), 4));
            }
        }
    }

    private boolean smartCheckoutOrNotify(@NotNull GitRepository repository, @NotNull GitMessageWithFilesDetector localChangesOverwrittenByCheckout) {
        Collection<String> absolutePaths;
        if (repository == null) {
            GitCheckoutOperation.$$$reportNull$$$0(5);
        }
        if (localChangesOverwrittenByCheckout == null) {
            GitCheckoutOperation.$$$reportNull$$$0(6);
        }
        Pair<List<GitRepository>, List<Change>> conflictingRepositoriesAndAffectedChanges = this.getConflictingRepositoriesAndAffectedChanges(repository, localChangesOverwrittenByCheckout, (String)this.myCurrentHeads.get(repository), this.myStartPointReference);
        List allConflictingRepositories = (List)conflictingRepositoriesAndAffectedChanges.getFirst();
        List affectedChanges = (List)conflictingRepositoriesAndAffectedChanges.getSecond();
        GitSmartOperationDialog.Choice decision = this.myUiHandler.showSmartOperationDialog(this.myProject, affectedChanges, absolutePaths = GitUtil.toAbsolute(repository.getRoot(), localChangesOverwrittenByCheckout.getRelativeFilePaths()), "checkout", "&Force Checkout");
        if (decision == GitSmartOperationDialog.Choice.SMART) {
            boolean smartCheckedOutSuccessfully = this.smartCheckout(allConflictingRepositories, this.myStartPointReference, this.myNewBranch, this.getIndicator());
            if (smartCheckedOutSuccessfully) {
                for (GitRepository conflictingRepository : allConflictingRepositories) {
                    this.markSuccessful(conflictingRepository);
                    GitUtil.updateAndRefreshVfs(conflictingRepository);
                }
                return true;
            }
            return false;
        }
        if (decision == GitSmartOperationDialog.Choice.FORCE) {
            boolean forceCheckoutSucceeded = this.checkoutOrNotify(allConflictingRepositories, this.myStartPointReference, this.myNewBranch, true);
            if (forceCheckoutSucceeded) {
                this.markSuccessful((GitRepository[])ArrayUtil.toObjectArray((Collection)allConflictingRepositories, GitRepository.class));
                GitUtil.updateAndRefreshVfs((GitRepository[])ArrayUtil.toObjectArray((Collection)allConflictingRepositories, GitRepository.class));
            }
            return forceCheckoutSucceeded;
        }
        this.fatalLocalChangesError(this.myStartPointReference);
        return false;
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        String previousBranch = (String)UtilKt.getIfSingle(this.getSuccessfulRepositories().stream().map(this.myCurrentHeads::get).distinct());
        if (previousBranch == null) {
            previousBranch = "previous branch";
        }
        String rollBackProposal = "You may rollback (checkout back to " + previousBranch + ") not to let branches diverge.";
        String string = "However checkout has succeeded for the following " + this.repositories() + ":<br/>" + this.successfulRepositoriesJoined() + "<br/>" + rollBackProposal;
        if (string == null) {
            GitCheckoutOperation.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getOperationName() {
        if ("checkout" == null) {
            GitCheckoutOperation.$$$reportNull$$$0(8);
        }
        return "checkout";
    }

    @Override
    protected void rollback() {
        GitCompoundResult checkoutResult = new GitCompoundResult(this.myProject);
        GitCompoundResult deleteResult = new GitCompoundResult(this.myProject);
        for (GitRepository repository : this.getSuccessfulRepositories()) {
            GitCommandResult result2 = this.myGit.checkout(repository, (String)this.myCurrentHeads.get(repository), null, true, false, new GitLineHandlerListener[0]);
            checkoutResult.append(repository, result2);
            if (result2.success() && this.myNewBranch != null) {
                deleteResult.append(repository, this.myGit.branchDelete(repository, this.myNewBranch, true, new GitLineHandlerListener[0]));
            }
            GitUtil.updateAndRefreshVfs(repository);
        }
        if (!checkoutResult.totalSuccess() || !deleteResult.totalSuccess()) {
            StringBuilder message = new StringBuilder();
            if (!checkoutResult.totalSuccess()) {
                message.append("Errors during checkout: ");
                message.append(checkoutResult.getErrorOutputWithReposIndication());
            }
            if (!deleteResult.totalSuccess()) {
                message.append("Errors during deleting ").append(GitUIUtil.code(this.myNewBranch)).append(": ");
                message.append(deleteResult.getErrorOutputWithReposIndication());
            }
            VcsNotifier.getInstance((Project)this.myProject).notifyError("Error during rollback", message.toString());
        }
    }

    @NotNull
    private String getCommonErrorTitle() {
        String string = "Couldn't checkout " + this.myStartPointReference;
        if (string == null) {
            GitCheckoutOperation.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        if (this.myNewBranch == null) {
            String string = String.format("Checked out <b><code>%s</code></b>", this.myStartPointReference);
            if (string == null) {
                GitCheckoutOperation.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = String.format("Checked out new branch <b><code>%s</code></b> from <b><code>%s</code></b>", this.myNewBranch, this.myStartPointReference);
        if (string == null) {
            GitCheckoutOperation.$$$reportNull$$$0(11);
        }
        return string;
    }

    private boolean smartCheckout(@NotNull List<GitRepository> repositories, @NotNull String reference, @Nullable String newBranch, @NotNull ProgressIndicator indicator) {
        if (repositories == null) {
            GitCheckoutOperation.$$$reportNull$$$0(12);
        }
        if (reference == null) {
            GitCheckoutOperation.$$$reportNull$$$0(13);
        }
        if (indicator == null) {
            GitCheckoutOperation.$$$reportNull$$$0(14);
        }
        AtomicBoolean result2 = new AtomicBoolean();
        GitPreservingProcess preservingProcess = new GitPreservingProcess(this.myProject, this.myGit, GitUtil.getRootsFromRepositories(repositories), "checkout", reference, GitVcsSettings.UpdateChangesPolicy.STASH, indicator, () -> {
            if (repositories == null) {
                GitCheckoutOperation.$$$reportNull$$$0(17);
            }
            if (reference == null) {
                GitCheckoutOperation.$$$reportNull$$$0(18);
            }
            result2.set(this.checkoutOrNotify(repositories, reference, newBranch, false));
        });
        preservingProcess.execute();
        return result2.get();
    }

    private boolean checkoutOrNotify(@NotNull List<GitRepository> repositories, @NotNull String reference, @Nullable String newBranch, boolean force) {
        if (repositories == null) {
            GitCheckoutOperation.$$$reportNull$$$0(15);
        }
        if (reference == null) {
            GitCheckoutOperation.$$$reportNull$$$0(16);
        }
        GitCompoundResult compoundResult = new GitCompoundResult(this.myProject);
        for (GitRepository repository : repositories) {
            compoundResult.append(repository, this.myGit.checkout(repository, reference, newBranch, force, this.myDetach, new GitLineHandlerListener[0]));
        }
        if (compoundResult.totalSuccess()) {
            return true;
        }
        this.notifyError("Couldn't checkout " + reference, compoundResult.getErrorOutputWithReposIndication());
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiHandler";
                break;
            }
            case 3: 
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPointReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localChangesOverwrittenByCheckout";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitCheckoutOperation";
                break;
            }
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitCheckoutOperation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackProposal";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonErrorTitle";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "smartCheckoutOrNotify";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "smartCheckout";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkoutOrNotify";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$smartCheckout$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RollbackOperationNotificationListener
    implements NotificationListener {
        private RollbackOperationNotificationListener() {
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                RollbackOperationNotificationListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                RollbackOperationNotificationListener.$$$reportNull$$$0(1);
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equalsIgnoreCase("rollback")) {
                GitCheckoutOperation.this.rollback();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "git4idea/branch/GitCheckoutOperation$RollbackOperationNotificationListener";
            objectArray[2] = "hyperlinkUpdate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

