/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.update;

import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.IFileInfo;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class UpdateFileInfo
implements IFileInfo {
    private final FileObject fileObject;
    private final File file;
    private String type;
    private Entry entry;

    public UpdateFileInfo(FileObject fileObject, File file) {
        BugLog.getInstance().assertNotNull(fileObject);
        BugLog.getInstance().assertNotNull(file);
        this.fileObject = fileObject;
        this.file = file;
    }

    @Override
    public FileObject getFileObject() {
        return this.fileObject;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.type);
        buffer.append("  ");
        if (this.isDirectory()) {
            buffer.append("Directory ");
        }
        buffer.append(this.file != null ? this.file.getAbsolutePath() : "null");
        return buffer.toString();
    }

    public File getFile() {
        return this.file;
    }

    public Entry getEntry() {
        return this.entry;
    }

    public String getType() {
        return this.type;
    }

    void setEntry(Entry entry) {
        this.entry = entry;
    }

    void setType(@NonNls String type) {
        this.type = type;
    }

    private boolean isDirectory() {
        File file = this.getFile();
        if (file == null) {
            return false;
        }
        return file.isDirectory();
    }
}

