/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberElementFactory;
import org.jetbrains.plugins.cucumber.psi.GherkinFeature;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordTable;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.psi.i18n.JsonGherkinKeywordProvider;

public class GherkinElementFactory {
    private static final Logger LOG = Logger.getInstance((String)GherkinElementFactory.class.getName());

    private GherkinElementFactory() {
    }

    public static GherkinFeature createFeatureFromText(Project project, @NotNull String text) {
        PsiElement[] list;
        if (text == null) {
            GherkinElementFactory.$$$reportNull$$$0(0);
        }
        for (PsiElement psiElement : list = GherkinElementFactory.getTopLevelElements(project, text)) {
            if (!(psiElement instanceof GherkinFeature)) continue;
            return (GherkinFeature)psiElement;
        }
        LOG.error("Failed to create Feature from text:\n" + text);
        return null;
    }

    public static GherkinStepsHolder createScenarioFromText(Project project, String language, @NotNull String text) {
        if (text == null) {
            GherkinElementFactory.$$$reportNull$$$0(1);
        }
        GherkinKeywordProvider provider = JsonGherkinKeywordProvider.getKeywordProvider();
        GherkinKeywordTable keywordsTable = provider.getKeywordsTable(language);
        String featureText = "# language: " + language + "\n" + keywordsTable.getFeatureSectionKeyword() + ": Dummy\n" + text;
        GherkinFeature feature = GherkinElementFactory.createFeatureFromText(project, featureText);
        return feature.getScenarios()[0];
    }

    public static PsiElement[] getTopLevelElements(Project project, @NotNull String text) {
        if (text == null) {
            GherkinElementFactory.$$$reportNull$$$0(2);
        }
        return CucumberElementFactory.createTempPsiFile(project, text).getChildren();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "text";
        objectArray2[1] = "org/jetbrains/plugins/cucumber/psi/GherkinElementFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFeatureFromText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createScenarioFromText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTopLevelElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

