/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.descriptor;

import com.intellij.psi.PsiElement;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.psi.css.descriptor.CssContextType;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CssElementDescriptor {
    @NotNull
    public CssVersion getCssVersion();

    @NotNull
    public BrowserVersion[] getBrowsers();

    public boolean isAllowedInContextType(@NotNull CssContextType var1);

    @NotNull
    public String getId();

    @NotNull
    public String getPresentableName();

    @NotNull
    public String getDescription();

    @Nullable
    public String getDocumentationString(@Nullable PsiElement var1);

    @NotNull
    public String getElementTypeName();

    @Nullable
    public String getSpecificationUrl();

    @NotNull
    public CssContextType[] getAllowedContextTypes();

    @Nullable
    public Icon getIcon();

    public static enum CssVersion {
        UNKNOWN("UNKNOWN", 0),
        CSS_1("CSS 1.0", 1),
        CSS_2("CSS 2.0", 2),
        CSS_2_1("CSS 2.1", 3),
        CSS_3_0("CSS 3.0", 4),
        CSS_4_0("CSS 4.0", 5),
        CSS_3_0_MOZILLA("CSS3 Mozilla", 0),
        CSS_3_0_SAFARI("CSS3 Safari", 0),
        CSS_3_0_OPERA("CSS3 Opera", 0);

        @NotNull
        private final String myPresentableName;
        private final int myValue;

        private CssVersion(String presentableName, int myValue) {
            if (presentableName == null) {
                CssVersion.$$$reportNull$$$0(0);
            }
            this.myPresentableName = presentableName;
            this.myValue = myValue;
        }

        @NotNull
        public String getPresentableName() {
            String string = this.myPresentableName;
            if (string == null) {
                CssVersion.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public static CssVersion fromString(@Nullable String string) {
            if ("1.0".equals(string)) {
                CssVersion cssVersion = CSS_1;
                if (cssVersion == null) {
                    CssVersion.$$$reportNull$$$0(2);
                }
                return cssVersion;
            }
            if ("2.0".equals(string)) {
                CssVersion cssVersion = CSS_2;
                if (cssVersion == null) {
                    CssVersion.$$$reportNull$$$0(3);
                }
                return cssVersion;
            }
            if ("2.1".equals(string)) {
                CssVersion cssVersion = CSS_2_1;
                if (cssVersion == null) {
                    CssVersion.$$$reportNull$$$0(4);
                }
                return cssVersion;
            }
            if ("3.0".equals(string)) {
                CssVersion cssVersion = CSS_3_0;
                if (cssVersion == null) {
                    CssVersion.$$$reportNull$$$0(5);
                }
                return cssVersion;
            }
            if ("4.0".equals(string)) {
                CssVersion cssVersion = CSS_4_0;
                if (cssVersion == null) {
                    CssVersion.$$$reportNull$$$0(6);
                }
                return cssVersion;
            }
            CssVersion cssVersion = UNKNOWN;
            if (cssVersion == null) {
                CssVersion.$$$reportNull$$$0(7);
            }
            return cssVersion;
        }

        public int value() {
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/descriptor/CssElementDescriptor$CssVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/descriptor/CssElementDescriptor$CssVersion";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

