/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.testing.rspec;

import b.h.la;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.testing.BddTestsUtil;
import org.jetbrains.plugins.ruby.testing.rspec.codeInsight.RSpecCallTypeProvider;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.TestUnitUtil;

public class RSpecUtil {
    private static final Function<String, String> F;
    @NonNls
    public static final String RSPEC_GEM_NAME = "rspec";
    @NonNls
    public static final String RSPEC2_CORE_GEM_NAME = "rspec-core";
    @NonNls
    private static final String[] a;
    @NonNls
    private static final String[] e;
    @NonNls
    public static final String RSPEC_RAILS_GEM_NAME = "rspec-rails";
    @NonNls
    private static final String[] G;
    @NonNls
    private static final String O = "rspec-rails";
    @NonNls
    private static final String g = "rspec_on_rails";
    @NonNls
    public static final String SPECS_FOLDER = "spec";
    @NonNls
    public static final String SPEC_TEST_FILE_SUFFIX = "_spec.rb";
    @NonNls
    private static final String z = "rspec";
    @NonNls
    public static final String RSPEC_GEM_EXECUTABLE_API_1x = "spec";
    @NonNls
    private static final String D = "RSpec::Core::ExampleGroup.example";
    @NonNls
    private static final String A = "RSpec::Core::ExampleGroup.specify";
    @NonNls
    private static final String d = "RSpec::Core::ExampleGroup.it";
    @NonNls
    private static final String P = "RSpec::Core::Subject::ExampleGroupMethods.its";
    @NonNls
    private static final String E = "RSpec::Core::ExampleGroup.pending";
    @NonNls
    private static final String W = "RSpec::Core::ExampleGroup.focused";
    @NonNls
    private static final String H = "Spec::Example::ExampleGroupMethods.example";
    @NonNls
    private static final String l = "Spec::Example::ExampleGroupMethods.xexample";
    @NonNls
    private static final String L = "Spec::Example::ExampleGroupMethods.specify";
    @NonNls
    private static final String r = "Spec::Example::ExampleGroupMethods.xspecify";
    @NonNls
    private static final String N = "Spec::Example::ExampleGroupMethods.it";
    @NonNls
    private static final String b = "Spec::Example::ExampleGroupMethods.xit";
    @NonNls
    private static final String M = "RSpec::Core::ObjectExtensions.describe";
    @NonNls
    private static final String J = "Spec::DSL::Main.describe";
    @NonNls
    private static final String c = "Spec::Extensions::Main.describe";
    @NonNls
    private static final String R = "RSpec::Core::ExampleGroup.describe";
    @NonNls
    private static final String K = "Spec::Example::ExampleGroupMethods.describe";
    @NonNls
    private static final Set<String> B;
    @NonNls
    private static final Set<String> y;
    @NonNls
    private static final Set<String> t;
    @NonNls
    private static final Set<String> h;
    @NonNls
    private static final Set<String> j;
    @NonNls
    private static final Set<String> s;
    @NonNls
    private static final Set<String> I;
    @NonNls
    private static final Set<String> U;
    @NonNls
    private static final Set<String> p;
    public static final String LET_CALL_NAME = "let";
    public static final String LET_BEFORE_CALL_NAME = "let!";
    public static final String SUBJECT_CALL_NAME = "subject";
    private static final Set<String> q;
    @NonNls
    public static final Set<String> CLASS_CONTEXT_CALLS;
    @NonNls
    public static final Set<String> INSTANCE_CONTEXT_CALLS;
    private static final FQN m;
    private static final FQN o;
    private static final FQN C;
    private static final FQN i;
    private static final FQN v;
    private static final Pattern f;
    private static final String x = "pending";
    private static final String[] V;
    private static final String[] Q;
    private static final Set<String> k;
    private static final String[] n;
    private static final Set<String> w;
    private static final String[] u;
    private static final Set<String> T;
    private static final Set<String> S;
    public static final String GENERATORS_R30_PREFIX = "rspec:";
    public static final String RSPEC2_GEM_FIRST_BETA_VERSION = "2.0.0.beta.1";
    public static final String RSPEC3_GEM_FIRST_BETA_VERSION = "3.0.0.beta.1";
    public static final String RSPEC_RAILS_36_GEM_FIRST_BETA_VERSION = "3.6.0.beta.1";
    public static final String RSPEC_RAILS_40_GEM_FIRST_BETA_VERSION = "4.0.0.beta.1";
    public static final String RSPEC_RAILS_MARKER_SCRIPT = "spec/spec_helper.rb";
    public static final String RSPEC3_RAILS_MARKER_SCRIPT = "spec/rails_helper.rb";
    private static final long X;

    private RSpecUtil() {
    }

    @NotNull
    public static String getRailsSpecFolderPathOrUrl(@NotNull String railsAppRootPathOrUlr) {
        long l2 = X ^ 0x3CA3B65CB0C7L;
        if (railsAppRootPathOrUlr == null) {
            RSpecUtil.a(0);
        }
        String string = railsAppRootPathOrUlr + '/' + "spec";
        if (string == null) {
            RSpecUtil.a(1);
        }
        return string;
    }

    public static boolean isRSpecRailsSupportInstalledInRailsProject(@NotNull String rorAppHomeDirUrl) {
        long l2 = X ^ 0x7E9BDD509B0AL;
        if (rorAppHomeDirUrl == null) {
            RSpecUtil.a(2);
        }
        return RailsUtil.getPathIfFileExists(rorAppHomeDirUrl, RSPEC_RAILS_MARKER_SCRIPT) != null || RailsUtil.getPathIfFileExists(rorAppHomeDirUrl, RSPEC3_RAILS_MARKER_SCRIPT) != null;
    }

    public static boolean isRSpecSupportEnabled(@NotNull Module module) {
        if (module == null) {
            RSpecUtil.a(3);
        }
        return GemUtil.isGemOrRailsPluginSupportEnabled(module, e, V) || GemUtil.isGemOrRailsPluginSupportEnabled(module, G, Q) || GemUtil.isGemOrRailsPluginSupportEnabled(module, a, a) || RSpecUtil.isRSpecRailsSupportEnabled(module);
    }

    public static boolean isRSpecRailsSupportEnabled(@NotNull Module module) {
        if (module == null) {
            RSpecUtil.a(4);
        }
        if (!RailsFacetUtil.hasRailsSupport(module)) {
            return false;
        }
        return GemUtil.isGemOrRailsPluginSupportEnabled(module, G, Q);
    }

    public static boolean isRSpecRailsSupportProbablyEnabled(@NotNull Module module, @NotNull Sdk sdk) {
        if (module == null) {
            RSpecUtil.a(5);
        }
        if (sdk == null) {
            RSpecUtil.a(6);
        }
        if (!RailsFacetUtil.hasRailsSupport(module)) {
            return false;
        }
        return GemUtil.isGemOrRailsPluginSupportProbablyEnabled(module, sdk, G, Q);
    }

    public static boolean isRSpecTestFile(Project project, @Nullable VirtualFile file) {
        if (!RSpecUtil.isFileWithRSpecTestFileName(file)) {
            return false;
        }
        return RSpecUtil.isRSpecSupportLoaded(project);
    }

    public static boolean isTestUnitWithRSpecFile(Project project, @NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            RSpecUtil.a(7);
        }
        if ((virtualFile = file.getVirtualFile()) == null || !TestUnitUtil.isFileWithValidTestUnitFileName(virtualFile)) {
            return false;
        }
        return RSpecUtil.isTestUnitWithRSpecSupportLoaded(project, file);
    }

    public static boolean isTestUnitWithRSpecSupportLoaded(Project project, @Nullable PsiFile invocationPoint) {
        return RSpecUtil.isRSpecSupportLoaded(project) && RubyFQNUtil.findContainerByFQN(project, Type.MODULE.asSet(), C, (PsiElement)invocationPoint) instanceof RModule;
    }

    public static boolean isRSpecRailsTestFile(Project project, @Nullable VirtualFile file) {
        if (!RSpecUtil.isFileWithRSpecTestFileName(file)) {
            return false;
        }
        return RSpecUtil.a(project);
    }

    public static boolean isFileWithRSpecTestFileName(@Nullable VirtualFile file) {
        long l2 = X ^ 0x3E5E9B572C1EL;
        return file != null && !file.isDirectory() && file.getName().endsWith(SPEC_TEST_FILE_SUFFIX);
    }

    public static boolean underSpecDirectory(@Nullable VirtualFile file) {
        long l2 = X ^ 0x20FCE42628CAL;
        return file != null && file.getPath().contains("/spec/");
    }

    @Nullable
    public static String determinePreferredSpecExecutablePath(@Nullable Module module, @Nullable Sdk alternativeSdk, @Nullable String forceRSpeGemVersion) {
        Object object;
        long l2 = X ^ 0x299CD9BEDBB5L;
        if (module != null && RailsFacetUtil.hasRailsSupport(module) && (object = RailsUtil.getRailsScriptExecutablePath(module, "spec")) != null) {
            return object;
        }
        Object object2 = alternativeSdk == null ? (module != null ? RModuleUtil.getInstance().findRubySdkForModule(module) : null) : (object = alternativeSdk);
        if (object != null) {
            return RSpecUtil.a(module, object, forceRSpeGemVersion);
        }
        return null;
    }

    @Nullable
    public static String determineCurrentExampleName(@NotNull PsiElement psiElement, final boolean forExamplesFilter) {
        BddTestsUtil.ExampleNameBuilder exampleNameBuilder;
        GemInfo gemInfo;
        String string;
        BddTestsUtil.GroupNameBuilder groupNameBuilder;
        boolean bl2;
        if (psiElement == null) {
            RSpecUtil.a(8);
        }
        if (!(bl2 = BddTestsUtil.gatherGroupsAndExampleNames(psiElement, groupNameBuilder = new BddTestsUtil.GroupNameBuilder(u, string = (gemInfo = RSpecUtil.getAttachedRSpecGem(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement))) != null ? gemInfo.getVersion() : null){
            final /* synthetic */ String val$rspecVersion;
            private static final long c = la.a(-4731886151702719994L, 3477158560406465292L, MethodHandles.lookup().lookupClass()).a(24774610125971L);
            {
                this.val$rspecVersion = string;
                super(exampleCallsFqns);
            }

            @Override
            @NotNull
            public String getFullGroupName() {
                String string;
                long l2 = c ^ 0x182333622054L;
                StringBuilder stringBuilder = new StringBuilder();
                List<? extends RPsiElement> list2 = this.getPartsInReversedOrder();
                int n2 = list2.size();
                if (n2 > 0) {
                    RPsiElement rPsiElement = list2.get(n2 - 1);
                    string = 1.getArgText(rPsiElement);
                    if (string != null && string.startsWith("::") && rPsiElement instanceof RTopConstReference) {
                        stringBuilder.append(string.substring(2));
                    } else {
                        stringBuilder.append(string);
                    }
                }
                for (int i10 = n2 - 2; i10 >= 0; --i10) {
                    string = 1.getArgText(list2.get(i10));
                    if (!RSpecUtil.a(string, list2.get(i10 + 1), this.val$rspecVersion)) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(string);
                }
                String string2 = stringBuilder.toString();
                if (string2 == null) {
                    1.b(0);
                }
                return string2;
            }

            private static /* synthetic */ void b(int n2) {
                long l2 = c ^ 0xD959409D8B4L;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/testing/rspec/RSpecUtil$1", "getFullGroupName"));
            }
        }, exampleNameBuilder = new BddTestsUtil.ExampleNameBuilder(n){
            private static final long c = la.a(84347455473146912L, -2508183843638775527L, MethodHandles.lookup().lookupClass()).a(13467155482170L);

            @Override
            public void register(@NotNull RubyPsiInterpreter interpreter) {
                if (interpreter == null) {
                    2.b(0);
                }
                super.register(interpreter);
                interpreter.registerCallable(new PsiCallable(){

                    @Override
                    public void processCall(RCallArguments arguments) {
                        PsiElement psiElement = arguments.getRCallElement();
                        RBlockCall rBlockCall = psiElement instanceof RPsiElement ? RBlockCallNavigator.getByCall((RPsiElement)psiElement) : null;
                        myExampleShortName = StringUtil.notNullize(rBlockCall != null ? RSpecUtil.determineItsExampleFullName(rBlockCall, forExamplesFilter) : null);
                    }
                }, ArrayUtil.toStringArray((Collection)h));
            }

            private static /* synthetic */ void b(int n2) {
                long l2 = c ^ 0x3A9735489908L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "org/jetbrains/plugins/ruby/testing/rspec/RSpecUtil$2", "register"));
            }
        }))) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(groupNameBuilder.getFullGroupName());
        String string2 = exampleNameBuilder.getExampleShortName();
        if (string2 != null) {
            stringBuilder.append(' ').append(string2);
        }
        return stringBuilder.toString();
    }

    private static boolean a(@Nullable String string, @NotNull RPsiElement rPsiElement, @Nullable String string2) {
        long l2 = X ^ 0x5FEA3799C987L;
        if (rPsiElement == null) {
            RSpecUtil.a(9);
        }
        if (!(VersionComparatorUtil.compare((String)string2, (String)"2.12.0") <= 0 || rPsiElement instanceof RConstant || rPsiElement instanceof RColonReference || rPsiElement instanceof RTopConstReference)) {
            return false;
        }
        return f.matcher(string).find();
    }

    @Nullable
    public static String determineItsExampleFullName(@NotNull RBlockCall blockCall, boolean forExamplesFilter) {
        String string;
        RPossibleCall rPossibleCall;
        if (blockCall == null) {
            RSpecUtil.a(10);
        }
        if (!((rPossibleCall = blockCall.getCall()) instanceof RCall)) {
            return null;
        }
        List list2 = ((RCall)rPossibleCall).getArguments();
        String string2 = null;
        if (list2.size() == 1) {
            List list3;
            string = (RPsiElement)list2.get(0);
            if (string instanceof RArray && (list3 = ((RArray)string).getElements()).size() == 1) {
                string = (RPsiElement)list3.get(0);
            }
            string2 = RubyPsiUtil.getElementText((PsiElement)string);
        }
        string = RSpecUtil.determineItsExampleMatcherName(blockCall);
        return forExamplesFilter ? string2 : string2 + (string != null ? " " + string : "");
    }

    public static boolean isInExampleScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.a(11);
        }
        return RubyPsiInterpreter.isInResolvableCallScope(psiElement, T, S);
    }

    public static boolean isProbablyInExampleScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.a(12);
        }
        return RubyPsiInterpreter.isInCallScope(psiElement, k, w);
    }

    public static boolean isProbablyInInstanceContextScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.a(13);
        }
        return RubyPsiInterpreter.isInCallScope(psiElement, INSTANCE_CONTEXT_CALLS, w);
    }

    public static boolean isProbablyInExampleGroupScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.a(14);
        }
        return RubyPsiInterpreter.isInCallScope(psiElement, w, k);
    }

    public static boolean isExampleGroupCall(@NotNull RPossibleCall call) {
        if (call == null) {
            RSpecUtil.a(15);
        }
        if (!(call instanceof RBlockCall)) {
            return false;
        }
        String string = call.getCommand();
        return string != null && (B.contains(string) || y.contains(string));
    }

    public static boolean isExampleCall(@NotNull RPossibleCall call) {
        String string;
        if (call == null) {
            RSpecUtil.a(16);
        }
        return (string = call.getCommand()) != null && (t.contains(string) || j.contains(string) || h.contains(string));
    }

    public static boolean isDisabledExampleCall(@NotNull RPossibleCall call) {
        String string;
        if (call == null) {
            RSpecUtil.a(17);
        }
        return (string = call.getCommand()) != null && j.contains(string);
    }

    public static boolean isExampleBeforeAfterCall(@NotNull RPossibleCall call) {
        if (call == null) {
            RSpecUtil.a(18);
        }
        if (!(call instanceof RBlockCall)) {
            return false;
        }
        String string = call.getCommand();
        return string != null && I.contains(string);
    }

    public static boolean isSharedExampleGroup(@NotNull RPossibleCall call) {
        if (call == null) {
            RSpecUtil.a(19);
        }
        if (!(call instanceof RBlockCall)) {
            return false;
        }
        String string = call.getCommand();
        return string != null && U.contains(string);
    }

    public static boolean isSharedGroupRef(@NotNull RPossibleCall call) {
        String string;
        if (call == null) {
            RSpecUtil.a(20);
        }
        return (string = call.getCommand()) != null && p.contains(string);
    }

    public static boolean isExampleSubjectCall(@NotNull RPossibleCall call) {
        String string;
        if (call == null) {
            RSpecUtil.a(21);
        }
        return (string = call.getCommand()) != null && h.contains(string);
    }

    public static boolean isPendingExampleCall(@NotNull RPossibleCall call) {
        PsiElement[] psiElementArray;
        long l2 = X ^ 0x17FA60DC2E57L;
        if (call == null) {
            RSpecUtil.a(22);
        }
        if (!RSpecUtil.isExampleCall(call) || RSpecUtil.isDisabledExampleCall(call)) {
            return false;
        }
        String string = call.getCommand();
        if (string != null && s.contains(string)) {
            return true;
        }
        RBlockCall rBlockCall = call instanceof RBlockCall ? (RBlockCall)call : RBlockCallNavigator.getByCall((RPsiElement)call);
        if (rBlockCall == null) {
            return true;
        }
        RCodeBlock rCodeBlock = rBlockCall.getBlock();
        RCompoundStatement rCompoundStatement = rCodeBlock.getCompoundStatement();
        for (PsiElement psiElement : psiElementArray = rCompoundStatement.getChildren()) {
            if (!(psiElement instanceof RBlockCall ? x.equals(((RBlockCall)psiElement).getCommand()) : (psiElement instanceof RCall ? x.equals(((RCall)psiElement).getCommand()) : psiElement instanceof RIdentifier && x.equals(psiElement.getText())))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<RPsiElement> collectAllExamplesFrom(@NotNull RPsiElement root) {
        if (root == null) {
            RSpecUtil.a(23);
        }
        ArrayList arrayList = new ArrayList();
        RSpecUtil.a(root, arrayList);
        List<Object> list2 = arrayList.size() > 0 ? arrayList : Collections.emptyList();
        if (list2 == null) {
            RSpecUtil.a(24);
        }
        return list2;
    }

    @Nullable
    private static String a(@Nullable Module module, @NotNull Sdk sdk, @Nullable String string) {
        GemInfo gemInfo;
        long l2 = X ^ 0x4650C4BFA530L;
        if (sdk == null) {
            RSpecUtil.a(25);
        }
        GemInfo gemInfo2 = gemInfo = (gemInfo = RSpecUtil.getAttachedRSpecGem(module)) == null ? GemSearchUtil.findGem(module, sdk, "rspec", null) : gemInfo;
        if (gemInfo == null) {
            return null;
        }
        boolean bl2 = StringUtil.isEmpty((String)string) ? !RSpecUtil.c(gemInfo.getVersion()) : !RSpecUtil.c(string);
        String string2 = bl2 ? "rspec" : "spec";
        String string3 = bl2 ? RSPEC2_CORE_GEM_NAME : "rspec";
        return RubyGemExecutionContext.getScriptPath(sdk, module, string3, string2);
    }

    @Nullable
    public static GemInfo getAttachedRSpecGem(@Nullable Module module) {
        long l2 = X ^ 0x7E8B161E760DL;
        if (module == null) {
            return null;
        }
        GemInfo gemInfo = GemManager.findGem(module, "rspec");
        if (gemInfo != null) {
            return gemInfo;
        }
        return GemManager.findGem(module, RSPEC2_CORE_GEM_NAME);
    }

    @Nullable
    public static GemInfo getAttachedRSpecRailsGem(@Nullable Module module) {
        long l2 = X ^ 0x51EB813D0F95L;
        if (module == null) {
            return null;
        }
        return GemManager.findGem(module, "rspec-rails");
    }

    public static boolean isRSpec1xAttached(@Nullable Module module) {
        GemInfo gemInfo = RSpecUtil.getAttachedRSpecGem(module);
        return gemInfo != null && RSpecUtil.c(gemInfo.getVersion());
    }

    private static boolean c(String string) {
        long l2 = X ^ 0x5938958BA173L;
        return VersionComparatorUtil.compare((String)string, (String)RSPEC2_GEM_FIRST_BETA_VERSION) < 0;
    }

    public static boolean isRSpec2xGemAttached(@NotNull Module module) {
        GemInfo gemInfo;
        if (module == null) {
            RSpecUtil.a(26);
        }
        return (gemInfo = RSpecUtil.getAttachedRSpecGem(module)) != null && !RSpecUtil.c(gemInfo.getVersion());
    }

    private static boolean b(String string) {
        long l2 = X ^ 0x1BB505D2876CL;
        return VersionComparatorUtil.compare((String)string, (String)RSPEC3_GEM_FIRST_BETA_VERSION) >= 0;
    }

    public static boolean isRSpec20SupportLoaded(Project project) {
        return RubyFQNUtil.findContainerByFQN(project, Type.CLASS.asSet(), m, null) instanceof RClass;
    }

    public static boolean isRSpec1xSupportLoaded(Project project) {
        return RubyFQNUtil.findContainerByFQN(project, Type.CLASS.asSet(), o, null) instanceof RClass;
    }

    public static boolean isRSpecSupportLoaded(Project project) {
        return RSpecUtil.isRSpec20SupportLoaded(project) || RSpecUtil.isRSpec1xSupportLoaded(project);
    }

    private static boolean a(Project project) {
        return RubyFQNUtil.findContainerByFQN(project, Type.MODULE.asSet(), i, null) instanceof RModule || RubyFQNUtil.findContainerByFQN(project, Type.MODULE.asSet(), v, null) instanceof RModule;
    }

    public static boolean isRailsRSpec36plusGemAttached(@NotNull Module module) {
        GemInfo gemInfo;
        long l2 = X ^ 0x7076FDF8F56CL;
        if (module == null) {
            RSpecUtil.a(27);
        }
        return (gemInfo = RSpecUtil.getAttachedRSpecRailsGem(module)) != null && VersionComparatorUtil.compare((String)gemInfo.getVersion(), (String)RSPEC_RAILS_36_GEM_FIRST_BETA_VERSION) >= 0 && VersionComparatorUtil.compare((String)gemInfo.getVersion(), (String)RSPEC_RAILS_40_GEM_FIRST_BETA_VERSION) < 0;
    }

    public static void collectChildren(RPsiElement root, List<? super RPsiElement> nodeElements, List<? super RPsiElement> exampleLikeElements, boolean allowOnlyExampleLeafs) {
        block7: {
            block6: {
                PsiElement[] psiElementArray;
                if (!(root instanceof RBlockCall)) break block6;
                RBlockCall rBlockCall = (RBlockCall)root;
                if (!RSpecUtil.isExampleGroupCall((RPossibleCall)rBlockCall) && !RSpecUtil.isSharedExampleGroup((RPossibleCall)rBlockCall)) break block7;
                RCompoundStatement rCompoundStatement = rBlockCall.getBlock().getCompoundStatement();
                for (PsiElement psiElement : psiElementArray = rCompoundStatement.getChildren()) {
                    if (psiElement instanceof RPossibleCall) {
                        RPossibleCall rPossibleCall = (RPossibleCall)psiElement;
                        if (RSpecUtil.isExampleGroupCall(rPossibleCall) || RSpecUtil.isSharedExampleGroup(rPossibleCall)) {
                            nodeElements.add((RPsiElement)rPossibleCall);
                            continue;
                        }
                        if ((allowOnlyExampleLeafs || !RSpecUtil.isExampleBeforeAfterCall(rPossibleCall)) && !RSpecUtil.isExampleCall(rPossibleCall) && !RSpecUtil.isSharedGroupRef(rPossibleCall)) continue;
                        exampleLikeElements.add((RPsiElement)rPossibleCall);
                        continue;
                    }
                    if (!(psiElement instanceof RContainer) || psiElement instanceof RObjectClass) continue;
                    nodeElements.add((RPsiElement)((RContainer)psiElement));
                }
                break block7;
            }
            if (root instanceof RContainer) {
                List list2 = ((RContainer)root).getStatements();
                for (RPsiElement rPsiElement : list2) {
                    if (rPsiElement instanceof RBlockCall) {
                        RBlockCall rBlockCall = (RBlockCall)rPsiElement;
                        if (!RSpecUtil.isExampleGroupCall((RPossibleCall)rBlockCall) && !RSpecUtil.isSharedExampleGroup((RPossibleCall)rBlockCall)) continue;
                        nodeElements.add((RPsiElement)rPsiElement);
                        continue;
                    }
                    if (!(rPsiElement instanceof RContainer) || rPsiElement instanceof RObjectClass) continue;
                    nodeElements.add((RPsiElement)rPsiElement);
                }
            }
        }
    }

    private static void a(@NotNull RPsiElement rPsiElement, List<? super RPsiElement> list2) {
        if (rPsiElement == null) {
            RSpecUtil.a(28);
        }
        ArrayList arrayList = new ArrayList();
        RSpecUtil.collectChildren(rPsiElement, arrayList, list2, true);
        for (RPsiElement rPsiElement2 : arrayList) {
            RSpecUtil.a(rPsiElement2, list2);
        }
    }

    @Nullable
    public static RPossibleCall getSimpleCoveringExampleOrBeforeAfterScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RSpecUtil.a(29);
        }
        return RubyPsiInterpreter.getSimpleCoveringCodeBlockScope(psiElement, INSTANCE_CONTEXT_CALLS, CLASS_CONTEXT_CALLS);
    }

    @Nullable
    public static RBlockCall getSimpleCoveringExampleGroupScope(@NotNull PsiElement psiElement) {
        RPossibleCall rPossibleCall;
        if (psiElement == null) {
            RSpecUtil.a(30);
        }
        if ((rPossibleCall = RubyPsiInterpreter.getSimpleCoveringCodeBlockScope(psiElement, CLASS_CONTEXT_CALLS, INSTANCE_CONTEXT_CALLS)) instanceof RBlockCall) {
            return (RBlockCall)rPossibleCall;
        }
        return null;
    }

    @Nullable
    public static VirtualFile getRSpecLibFolder(Module module) {
        long l2 = X ^ 0x27CA34C646C3L;
        return GemUtil.getGemOrRailsPluginLibDir(module, "rspec", V);
    }

    @Nullable
    public static String determineItsExampleMatcherName(@Nullable RBlockCall itsBlockCall) {
        if (itsBlockCall == null) {
            return null;
        }
        RCompoundStatement rCompoundStatement = itsBlockCall.getBlock().getCompoundStatement();
        List list2 = rCompoundStatement.getStatements();
        if (!list2.isEmpty()) {
            RPsiElement rPsiElement = (RPsiElement)list2.get(list2.size() - 1);
            String string = rPsiElement.getText();
            return string.replace("\n", " ").replace("_", " ");
        }
        return null;
    }

    private static Set<String> a(String ... stringArray) {
        if (stringArray == null) {
            RSpecUtil.a(31);
        }
        return Collections.unmodifiableSet(Sets.newHashSet((Object[])stringArray));
    }

    private static Set<String> a(Collection<String> ... collectionArray) {
        if (collectionArray == null) {
            RSpecUtil.a(32);
        }
        HashSet hashSet = Sets.newHashSet();
        for (Collection<String> collection : collectionArray) {
            hashSet.addAll(collection);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public static boolean isShouldCall(RubyCallType<?> type) {
        long l2 = X ^ 0x215BE52FDB22L;
        return type != RubyCallType.UNKNOWN && ("should".equals(type.getCommandName()) || "should_not".equals(type.getCommandName()));
    }

    public static boolean underShouldCall(RCall call) {
        RCall rCall = (RCall)PsiTreeUtil.getParentOfType((PsiElement)call, RCall.class, (boolean)true, (Class[])new Class[]{RCompoundStatement.class});
        return rCall != null && RSpecUtil.isShouldCall(rCall.getCallType());
    }

    @Nullable
    public static RCall findLetCall(@NotNull PsiElement element) {
        RCall rCall;
        if (element == null) {
            RSpecUtil.a(33);
        }
        if (element instanceof RCall) {
            rCall = (RCall)element;
        } else {
            if (!(element instanceof RSymbol)) {
                return null;
            }
            if (!(element.getParent().getParent() instanceof RCall)) {
                return null;
            }
            rCall = (RCall)element.getParent().getParent();
        }
        return RSpecCallTypeProvider.LET_CALL == rCall.getCallType() ? rCall : null;
    }

    static {
        X = la.a(6181376999440238813L, -6428463840256947549L, MethodHandles.lookup().lookupClass()).a(97794609061615L);
        long l2 = X ^ 0x3DF91070A0CL;
        F = string -> {
            long l2 = X ^ 0x7381462F6F19L;
            return "RSpec." + string;
        };
        a = new String[]{RSPEC2_CORE_GEM_NAME};
        e = new String[]{"rspec"};
        G = new String[]{"rspec-rails"};
        B = RSpecUtil.a("feature", "describe", "context", "shared_examples", "shared_context");
        y = RSpecUtil.a(Collections2.transform(B, F));
        t = RSpecUtil.a("it", "scenario", "example", "specify", x, "focused");
        h = RSpecUtil.a(new String[]{"its"});
        j = RSpecUtil.a("xit", "xexample", "xspecify");
        s = RSpecUtil.a(new String[]{x});
        I = RSpecUtil.a("before", "after", "setup", "teardown", "append_before", "prepend_after");
        U = RSpecUtil.a("shared_examples_for", "share_examples_for", "share_as");
        p = RSpecUtil.a("it_should_behave_like", "it_behaves_like", "include_examples", "include_context");
        q = RSpecUtil.a(LET_CALL_NAME, LET_BEFORE_CALL_NAME, SUBJECT_CALL_NAME);
        CLASS_CONTEXT_CALLS = RSpecUtil.a(B, y);
        INSTANCE_CONTEXT_CALLS = RSpecUtil.a(t, j, I, h, U, p, q);
        m = FQN.Builder.fromString((String)"RSpec::Core::ExampleGroup");
        o = FQN.Builder.fromString((String)"Spec::Example::ExampleGroup");
        C = FQN.Builder.fromString((String)"Spec::Test::Unit");
        i = FQN.Builder.fromString((String)"RSpec::Rails");
        v = FQN.Builder.fromString((String)"Spec::Rails::Example");
        f = Pattern.compile("^(\\s|\\.|#|::)");
        V = new String[]{"rspec "};
        Q = new String[]{"rspec-rails", g};
        k = RSpecUtil.a(t, j, h, s);
        n = ArrayUtil.toStringArray(k);
        w = RSpecUtil.a(B, y);
        u = ArrayUtil.toStringArray(w);
        T = RSpecUtil.a("RSpec::Its.its", "RSpec::Core::MemoizedHelpers::ClassMethods.its", P, D, A, d, E, W, H, l, L, r, N, b);
        S = RSpecUtil.a(M, J, c, R, K);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = X ^ 0x2C839AFA0B25L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 24: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsAppRootPathOrUlr";
                break;
            }
            case 1: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/testing/rspec/RSpecUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rorAppHomeDirUrl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockCall";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collections";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/testing/rspec/RSpecUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRailsSpecFolderPathOrUrl";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllExamplesFrom";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRailsSpecFolderPathOrUrl";
                break;
            }
            case 1: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isRSpecRailsSupportInstalledInRailsProject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRSpecSupportEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isRSpecRailsSupportEnabled";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isRSpecRailsSupportProbablyEnabled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isTestUnitWithRSpecFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "determineCurrentExampleName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMethodDescriptionAfterModule";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "determineItsExampleFullName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInExampleScope";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isProbablyInExampleScope";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isProbablyInInstanceContextScope";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isProbablyInExampleGroupScope";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isExampleGroupCall";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isExampleCall";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isDisabledExampleCall";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isExampleBeforeAfterCall";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isSharedExampleGroup";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isSharedGroupRef";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isExampleSubjectCall";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isPendingExampleCall";
                break;
            }
            case 23: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "collectAllExamplesFrom";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getRSpecGemExecutablePath";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isRSpec2xGemAttached";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isRailsRSpec36plusGemAttached";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleCoveringExampleOrBeforeAfterScope";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleCoveringExampleGroupScope";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "newSet";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findLetCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

