/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.ui;

import b.h.la;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.invoke.MethodHandles;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public class RubySdkRenderer
implements ListCellRenderer<Object> {
    public static final String SEPARATOR = "!!!separator!!!";
    public static final EmptyBorder EMPTY_BORDER;
    private final String a;
    private final boolean c;
    private final boolean b;
    private final JLabel e;
    private boolean d;
    private static final long f;

    public RubySdkRenderer(boolean showHomePath, boolean showLanguageLevel) {
        long l2 = f ^ 0x46BFD86EA2DEL;
        this(RBundle.message((String)"sdk.renderer.no.sdk.chosen"), showHomePath, showLanguageLevel);
    }

    public RubySdkRenderer(String nullText, boolean showHomePath, boolean showLanguageLevel) {
        this.e = new MyJLabel();
        this.e.setOpaque(true);
        this.e.setBorder(EMPTY_BORDER);
        this.a = nullText;
        this.c = showHomePath;
        this.b = showLanguageLevel;
    }

    public void customize(Object value) {
        long l2 = f ^ 0x2C8A6ACB71FEL;
        if (value != null) {
            if (value instanceof Sdk) {
                Sdk sdk = (Sdk)value;
                this.a(((SdkType)sdk.getSdkType()).getIcon());
                String string = RubySdkRenderer.getSdkText(sdk, this.c, this.b);
                this.a(string);
                if (!RubySdkUtil.isSDKValid(sdk)) {
                    this.a((Color)JBColor.RED);
                } else {
                    this.a(UIUtil.getListForeground());
                }
            } else if (SEPARATOR.equals(value)) {
                this.a();
            } else if (value instanceof LanguageLevel) {
                this.a(((LanguageLevel)value).getShortName());
            } else {
                this.a(value.toString());
            }
        } else {
            this.a(UIUtil.getListForeground());
            this.a(this.a);
            this.a(RubySdkType.getInstance().getIcon());
        }
    }

    @Override
    public final Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Object object = GraphicsUtil.getAntialiasingType((JComponent)list2);
        if (object != null) {
            GraphicsUtil.setAntialiasingType((JComponent)this.e, (Object)object);
        }
        if (isSelected) {
            this.e.setBackground(list2.getSelectionBackground());
            this.e.setForeground(list2.getSelectionForeground());
        } else {
            this.e.setBackground(list2.getBackground());
            this.e.setForeground(list2.getForeground());
        }
        this.e.setFont(list2.getFont());
        this.d = false;
        this.customize(value);
        if (this.d) {
            return ListCellRendererWrapper.createSeparator(null);
        }
        return this.e;
    }

    public static String getSdkText(@Nullable Sdk sdk) {
        return RubySdkRenderer.getSdkText(sdk, true, true);
    }

    public static String getSdkText(@Nullable Sdk sdk, boolean showHomePath, boolean showLanguageLevel) {
        Object object;
        String string;
        long l2 = f ^ 0x51A18CBC35D0L;
        if (sdk == null) {
            return "";
        }
        VirtualFile virtualFile = VfsUtil.getUserHomeDir();
        StringBuilder stringBuilder = new StringBuilder(sdk.getName().replaceAll("\\s\\(.*\\)", ""));
        if (showHomePath) {
            string = sdk.getHomePath();
            if (string == null) {
                return "";
            }
            if (!RVMSupportUtil.isRVMInterpreter(sdk)) {
                object = virtualFile == null ? string : string.replaceFirst(Pattern.quote(virtualFile.getPath()), "~");
                stringBuilder.append(" (").append(RubySdkUtil.getRubySdkAdditionalData(sdk).getSdkSystemAccessor().toSystemDependentName((String)object)).append(")");
            }
        }
        if (showLanguageLevel && !RubySdkUtil.isMRISdk(sdk) && (string = sdk.getSdkAdditionalData()) instanceof RubySdkAdditionalData) {
            object = (RubySdkAdditionalData)((Object)string);
            stringBuilder.append(" [").append(((RubySdkAdditionalData)object).getLanguageLevel().getShortName()).append("]");
        }
        return stringBuilder.toString();
    }

    public static void installSdkNameSpeedSearch(JComboBox sdkComboBox) {
        new ComboboxSpeedSearch(sdkComboBox){

            protected String getElementText(Object element) {
                if (element instanceof Sdk) {
                    return RubySdkRenderer.getSdkText((Sdk)element);
                }
                return super.toString();
            }
        }.setComparator(new SpeedSearchComparator(false));
    }

    private void a() {
        this.d = true;
    }

    private void a(@Nullable Icon icon) {
        this.e.setIcon(icon);
    }

    private void a(@Nullable String string) {
        this.e.setText(string);
    }

    private void a(@Nullable Color color) {
        this.e.setForeground(color);
    }

    static {
        f = la.a(4527723461312111415L, -7375837008236901816L, MethodHandles.lookup().lookupClass()).a(255628472480971L);
        EMPTY_BORDER = new EmptyBorder(1, 1, 1, 1);
    }

    private static class MyJLabel
    extends JLabel {
        private MyJLabel() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension;
            if (this.getText() == null || this.getText().isEmpty()) {
                this.setText(" ");
                dimension = super.getPreferredSize();
                this.setText("");
            } else {
                dimension = super.getPreferredSize();
            }
            return dimension;
        }
    }
}

