/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.annotator;

import b.h.la;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.motion.RubyMotionUtil;
import org.jetbrains.plugins.ruby.rdoc.RDocHighlighter;
import org.jetbrains.plugins.ruby.rdoc.yard.references.YARDReferenceProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefManager;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlighter;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.ruby19.Ruby19TokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.Ruby19ElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyStubElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.LexicalBNF;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils.ErrorMsg;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RFloatConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RIntegerConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RNumericConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RWords;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocId;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RYieldStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElseBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentDestructing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RNamedArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RRangeExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.RSymbolNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.blocks.RCompoundStatementNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.names.RNameNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RSelfAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBraceBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RArgumentToBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RArrayToArguments;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RHashToArguments;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RLambdaCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.controlStructures.RBlockLocalVariables;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public class RubyAnnotatorVisitor
extends RubyElementVisitor {
    private static final ProcessingContext b;
    private final AnnotationHolder a;
    private final Set<String> d;
    private static final TokenSet c;
    private static final long e;

    public RubyAnnotatorVisitor(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            RubyAnnotatorVisitor.b(0);
        }
        this.a = holder;
        this.d = ParamDefManager.getInstance().getMethodNames();
    }

    private void a(PsiElement psiElement, TextAttributesKey textAttributesKey) {
        String string = ApplicationManager.getApplication().isUnitTestMode() ? textAttributesKey.getExternalName() : null;
        this.a.createInfoAnnotation(psiElement, string).setTextAttributes(textAttributesKey);
    }

    public void visitElement(PsiElement element) {
        ProgressManager.checkCanceled();
        super.visitElement(element);
    }

    @Override
    public void visitRAliasStatement(RAliasStatement rAliasStatement) {
        long l2 = e ^ 0x46613360E0A6L;
        ProgressManager.checkCanceled();
        RPsiElement rPsiElement = rAliasStatement.getPsiNewName();
        if (rPsiElement instanceof RGlobalVariable && ((RGlobalVariable)rPsiElement).getGlobalVariableType() == RGlobalVariable.Type.NTH_REFERENCE) {
            this.a.createErrorAnnotation((PsiElement)rAliasStatement, RBundle.message((String)"annotation.error.cannot.make.alias.for.nth.variable"));
        }
    }

    @Override
    public void visitRFName(RFName rFName) {
        ProgressManager.checkCanceled();
        if (RSymbolNavigator.getSymbolByObject((PsiElement)rFName) == null) {
            this.a((PsiElement)rFName, RubyHighlighter.METHOD_NAME);
        }
    }

    private static boolean a(@NotNull RPsiElement rPsiElement) {
        RName rName;
        if (rPsiElement == null) {
            RubyAnnotatorVisitor.b(1);
        }
        if ((rName = RNameNavigator.getRName((PsiElement)rPsiElement)) == null) {
            return false;
        }
        if (rName.getNode().getElementType() == RubyElementTypes.SUPER_CLASS) {
            return rPsiElement.getParent().equals(rName);
        }
        return true;
    }

    @Override
    public void visitRIdentifier(@NotNull RIdentifier rIdentifier) {
        long l2 = e ^ 0x10D607FB4435L;
        if (rIdentifier == null) {
            RubyAnnotatorVisitor.b(2);
        }
        ProgressManager.checkCanceled();
        if (RubyAnnotatorVisitor.a((RPsiElement)rIdentifier)) {
            this.a.createErrorAnnotation((PsiElement)rIdentifier, RBundle.message((String)"annotation.error.class.module.name.must.be.constant"));
        }
        if (rIdentifier.isParameter()) {
            this.a((PsiElement)rIdentifier, RubyHighlighter.PARAMETER);
        } else if (rIdentifier.isLocalVariable()) {
            this.a((PsiElement)rIdentifier, RubyHighlighter.LOCAL_VARIABLE);
        } else if (RCompoundStatementNavigator.isStatement((PsiElement)rIdentifier) || RBlockCallNavigator.getByCall((RPsiElement)rIdentifier) != null) {
            RubyCallType rubyCallType = rIdentifier.getCallType();
            this.a((PsiElement)rIdentifier, rIdentifier.getName(), rubyCallType);
        }
    }

    @Override
    public void visitRName(RName name) {
        RContainer rContainer = (RContainer)PsiTreeUtil.getParentOfType((PsiElement)name, RContainer.class);
        if (rContainer instanceof RClass || rContainer instanceof RModule) {
            this.a(PsiTreeUtil.getDeepestLast((PsiElement)name), RubyHighlighter.CONSTANT_DECLARATION);
        }
    }

    @Override
    public void visitRConstant(RConstant rConstant) {
        String string;
        String string2;
        long l2 = e ^ 0x5336BF346C7AL;
        ProgressManager.checkCanceled();
        if (LanguageLevel.RUBY26.isGreaterThan(rConstant.getLanguageLevel()) && !(string2 = rConstant.getText()).isEmpty() && string2.codePointAt(0) > 90 && RubyAnnotatorVisitor.a((RPsiElement)rConstant)) {
            this.a.createErrorAnnotation((PsiElement)rConstant, RBundle.message((String)"annotation.error.class.module.name.must.be.constant.unicode"));
        }
        String string3 = string = (string2 = RReferenceNavigator.getRRefenceOrTopReference((PsiElement)rConstant)) != null ? string2 : rConstant;
        if (RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)string) != null || RSelfAssignmentExpressionNavigator.getSelfAssignmentByLeftPart((PsiElement)string) != null) {
            this.a((PsiElement)rConstant, RubyHighlighter.CONSTANT_DECLARATION);
        }
    }

    public void visitComment(PsiComment comment) {
        PsiReference[] psiReferenceArray;
        for (PsiReference psiReference : psiReferenceArray = YARDReferenceProvider.getInstance().getReferencesByElement((PsiElement)comment, b)) {
            int n2 = comment.getTextRange().getStartOffset();
            TextRange textRange = psiReference.getRangeInElement();
            TextRange textRange2 = textRange.shiftRight(n2);
            this.a.createInfoAnnotation(textRange2, null).setTextAttributes(RDocHighlighter.IDENTIFIER);
        }
        super.visitComment(comment);
    }

    private void a(PsiElement psiElement, String string, RubyCallType<?> rubyCallType) {
        if (rubyCallType != RubyCallTypes.UNKNOWN) {
            this.a(psiElement, RubyHighlighter.RUBY_SPECIFIC_CALL);
        } else if (this.d.contains(string)) {
            this.a(psiElement, RubyHighlighter.RUBY_PARAMDEF_CALL);
        }
    }

    @Override
    public void visitRCall(RCall rCall) {
        long l2 = e ^ 0x1D312FCB993EL;
        ProgressManager.checkCanceled();
        PsiElement psiElement = rCall.getPsiCommand();
        if (psiElement instanceof RPossibleCall) {
            psiElement = ((RPossibleCall)psiElement).getPsiCommand();
        }
        if (psiElement != null) {
            this.a(psiElement, psiElement.getText(), rCall.getCallType());
        }
        boolean bl2 = RubyMotionUtil.getInstance().hasMacRubySupport((PsiElement)rCall);
        boolean bl3 = false;
        boolean bl4 = false;
        for (RPsiElement rPsiElement : rCall.getArguments()) {
            IElementType iElementType = rPsiElement.getNode().getElementType();
            if (iElementType == RubyElementTypes.ASSOC) {
                bl3 = true;
                if (!bl4) continue;
                this.a.createErrorAnnotation(rPsiElement.getTextRange(), RBundle.message((String)"annotation.error.unexpected.named.arg"));
                continue;
            }
            if (!bl3 || iElementType == RubyStubElementTypes.DO_BLOCK_CALL || LexicalBNF.COMMANDS.contains(iElementType) || iElementType == RubyElementTypes.ARG_TO_BLOCK) continue;
            if (!bl2 && iElementType != Ruby19ElementTypes.HASH_TO_ARGS) {
                this.a.createErrorAnnotation(rPsiElement.getTextRange(), ErrorMsg.expected(RubyTokenTypes.tASSOC));
                continue;
            }
            bl4 = true;
        }
    }

    @Override
    public void visitRClass(RClass rClass) {
        long l2 = e ^ 0xADF095C498AL;
        ProgressManager.checkCanceled();
        if (rClass.getParentContainer() instanceof RMethod) {
            this.a.createErrorAnnotation(rClass.getFirstChild(), RBundle.message((String)"annotation.error.class.in.method"));
        }
    }

    @Override
    public void visitRModule(RModule rModule) {
        long l2 = e ^ 0x6EFD11B91D3CL;
        ProgressManager.checkCanceled();
        if (rModule.getParentContainer() instanceof RMethod) {
            this.a.createErrorAnnotation(rModule.getFirstChild(), RBundle.message((String)"annotation.error.module.in.method"));
        }
    }

    @Override
    public void visitRArgument(RArgument rParameter) {
        long l2 = e ^ 0x136E7F09B6EBL;
        ProgressManager.checkCanceled();
        PsiElement psiElement = rParameter.getFirstChild();
        if (psiElement instanceof RConstant) {
            this.a.createErrorAnnotation((PsiElement)rParameter, RBundle.message((String)"annotation.error.formal.arg.cannot.be.constant"));
        }
        if (psiElement instanceof RInstanceVariable) {
            this.a.createErrorAnnotation((PsiElement)rParameter, RBundle.message((String)"annotation.error.formal.arg.cannot.be.inst.var"));
        }
        if (psiElement instanceof RGlobalVariable) {
            this.a.createErrorAnnotation((PsiElement)rParameter, RBundle.message((String)"annotation.error.formal.arg.cannot.be.global.var"));
        }
        if (psiElement instanceof RClassVariable) {
            this.a.createErrorAnnotation((PsiElement)rParameter, RBundle.message((String)"annotation.error.formal.arg.cannot.be.class.var"));
        }
        if (rParameter.getType() == ArgumentInfo.Type.HASH && LanguageLevel.RUBY20.isGreaterThan(rParameter.getLanguageLevel())) {
            this.a.createErrorAnnotation((PsiElement)rParameter, RBundle.message((String)"annotation.error.unsupported.named.arg"));
        }
    }

    @Override
    public void visitRAssocKey(RAssocKey rAssocKey) {
        ProgressManager.checkCanceled();
        this.a((PsiElement)rAssocKey, RubyHighlighter.HASH_KEY);
    }

    @Override
    public void visitRAssoc(RAssoc rAssoc) {
        RPsiElement rPsiElement = rAssoc.getKey();
        if (rPsiElement instanceof RSymbol) {
            this.a((PsiElement)rPsiElement, RubyHighlighter.HASH_KEY);
        }
        super.visitRAssoc(rAssoc);
    }

    @Override
    public void visitRNamedArgument(@NotNull RNamedArgument namedArgument) {
        long l2 = e ^ 0x5AFD73B006DCL;
        if (namedArgument == null) {
            RubyAnnotatorVisitor.b(3);
        }
        ProgressManager.checkCanceled();
        PsiElement psiElement = namedArgument.getFirstChild().getNextSibling();
        if (psiElement instanceof PsiWhiteSpace) {
            this.a.createErrorAnnotation(psiElement, RBundle.message((String)"annotation.error.unexpected.named.arg"));
        }
        if (RubyMotionUtil.getInstance().hasMacRubySupport((PsiElement)namedArgument)) {
            PsiElement[] psiElementArray = namedArgument.getChildren();
            if (psiElementArray.length == 2) {
                PsiElement psiElement2 = psiElementArray[1];
                if (!(psiElement2 instanceof RIdentifier)) {
                    this.a.createErrorAnnotation(psiElement2, "identifier expected");
                }
            } else {
                PsiElement psiElement3 = PsiTreeUtil.nextLeaf((PsiElement)namedArgument);
                this.a.createErrorAnnotation((PsiElement)(psiElement3 != null ? psiElement3 : namedArgument), "identifier expected");
            }
        } else {
            LanguageLevel languageLevel = namedArgument.getLanguageLevel();
            if (LanguageLevel.RUBY20.isGreaterThan(languageLevel)) {
                this.a.createErrorAnnotation((PsiElement)namedArgument, RBundle.message((String)"annotation.error.unsupported.named.arg"));
            } else if (LanguageLevel.RUBY21.isGreaterThan(languageLevel) && namedArgument.getValue() == null) {
                PsiElement psiElement4 = PsiTreeUtil.nextLeaf((PsiElement)namedArgument);
                this.a.createErrorAnnotation((PsiElement)(psiElement4 != null ? psiElement4 : namedArgument), ErrorMsg.EXPRESSION_EXPECTED_MESSAGE);
            }
        }
    }

    @Override
    public void visitRSymbols(@NotNull RWords rSymbols) {
        long l2 = e ^ 0x7EB35293A25DL;
        if (rSymbols == null) {
            RubyAnnotatorVisitor.b(4);
        }
        ProgressManager.checkCanceled();
        if (LanguageLevel.RUBY20.isGreaterThan(rSymbols.getLanguageLevel())) {
            this.a.createErrorAnnotation((PsiElement)rSymbols, RBundle.message((String)"annotation.error.unsupported.i"));
        }
    }

    @Override
    public void visitRDSymbols(@NotNull RWords rdSymbols) {
        long l2 = e ^ 0x7C865FBE9046L;
        if (rdSymbols == null) {
            RubyAnnotatorVisitor.b(5);
        }
        ProgressManager.checkCanceled();
        if (LanguageLevel.RUBY20.isGreaterThan(rdSymbols.getLanguageLevel())) {
            this.a.createErrorAnnotation((PsiElement)rdSymbols, RBundle.message((String)"annotation.error.unsupported.i_u"));
        }
    }

    @Override
    public void visitRLambdaCall(@NotNull RLambdaCall rLambdaCall) {
        long l2 = e ^ 0x6A76EFF2FE70L;
        if (rLambdaCall == null) {
            RubyAnnotatorVisitor.b(6);
        }
        ProgressManager.checkCanceled();
        if (rLambdaCall.getLanguageLevel() == LanguageLevel.RUBY18) {
            PsiElement psiElement = RubyPsiUtil.getChildByFilter((PsiElement)rLambdaCall, RubyTokenTypes.tLPAREN, 0);
            assert (psiElement != null);
            this.a.createErrorAnnotation(psiElement, ErrorMsg.expected(RBundle.message((String)"parsing.operation")));
        }
        super.visitRLambdaCall(rLambdaCall);
    }

    @Override
    public void visitBlockLocalVariable(@NotNull RBlockLocalVariables rBlockLocalVariables) {
        long l2 = e ^ 0x411436B6991CL;
        if (rBlockLocalVariables == null) {
            RubyAnnotatorVisitor.b(7);
        }
        ProgressManager.checkCanceled();
        if (rBlockLocalVariables.getLanguageLevel() == LanguageLevel.RUBY18) {
            this.a.createErrorAnnotation((PsiElement)rBlockLocalVariables, RBundle.message((String)"annotation.error.unsupported.block.local.vars"));
        }
        super.visitBlockLocalVariable(rBlockLocalVariables);
    }

    @Override
    public void visitRAssocList(@NotNull RAssocList rAssocList) {
        RTopLevelContainer rTopLevelContainer;
        if (rAssocList == null) {
            RubyAnnotatorVisitor.b(8);
        }
        ProgressManager.checkCanceled();
        if (LanguageLevel.RUBY18.isLessThan(rAssocList.getLanguageLevel()) && ((rTopLevelContainer = (RTopLevelContainer)PsiTreeUtil.getParentOfType((PsiElement)rAssocList, RTopLevelContainer.class)) == null || rTopLevelContainer.checkHashes())) {
            for (RPsiElement rPsiElement : rAssocList.getElements()) {
                IElementType iElementType = rPsiElement.getNode().getElementType();
                if (c.contains(iElementType)) continue;
                this.a.createErrorAnnotation((PsiElement)rPsiElement, ErrorMsg.expected(RubyTokenTypes.tASSOC));
            }
        }
        super.visitRAssocList(rAssocList);
    }

    @Override
    public void visitRHashToArguments(@NotNull RHashToArguments rHashToArguments) {
        long l2 = e ^ 0x724A981D6CECL;
        if (rHashToArguments == null) {
            RubyAnnotatorVisitor.b(9);
        }
        ProgressManager.checkCanceled();
        if (LanguageLevel.RUBY20.isGreaterThan(rHashToArguments.getLanguageLevel())) {
            this.a.createErrorAnnotation((PsiElement)rHashToArguments, RBundle.message((String)"annotation.error.unsupported.hash.to.arguments"));
        }
        super.visitRHashToArguments(rHashToArguments);
    }

    @Override
    public void visitRListOfExpressions(@NotNull RListOfExpressions rListOfExpressions) {
        PsiElement psiElement;
        if (rListOfExpressions == null) {
            RubyAnnotatorVisitor.b(10);
        }
        ProgressManager.checkCanceled();
        if (rListOfExpressions.getLanguageLevel() == LanguageLevel.RUBY18 && ((psiElement = rListOfExpressions.getParent()) instanceof RArray || psiElement instanceof RArrayIndexing)) {
            boolean bl2 = false;
            boolean bl3 = false;
            for (PsiElement psiElement2 : rListOfExpressions.getChildren()) {
                if (!bl3 && psiElement2 instanceof RArrayToArguments) {
                    if (bl2) {
                        bl3 = true;
                        this.a.createErrorAnnotation(psiElement2, ErrorMsg.expected(RubyTokenTypes.tRBRACK));
                    }
                    bl2 = true;
                    continue;
                }
                if (!(psiElement2 instanceof RArgumentToBlock)) continue;
                this.a.createErrorAnnotation(psiElement2, ErrorMsg.expected(RubyTokenTypes.tRBRACK));
            }
        }
        super.visitRListOfExpressions(rListOfExpressions);
    }

    @Override
    public void visitRArgumentDestructing(@NotNull RArgumentDestructing rArgumentDestructing) {
        if (rArgumentDestructing == null) {
            RubyAnnotatorVisitor.b(11);
        }
        ProgressManager.checkCanceled();
        if (rArgumentDestructing.getLanguageLevel() == LanguageLevel.RUBY18) {
            PsiElement psiElement = rArgumentDestructing.getFirstChild();
            assert (psiElement.getNode().getElementType() == RubyTokenTypes.tLPAREN);
            this.a.createErrorAnnotation(psiElement, ErrorMsg.unexpected(RubyTokenTypes.tLPAREN));
        }
        super.visitRArgumentDestructing(rArgumentDestructing);
    }

    @Override
    public void visitRIntegerConstant(@NotNull RIntegerConstant rIntegerConstant) {
        if (rIntegerConstant == null) {
            RubyAnnotatorVisitor.b(12);
        }
        this.a((RNumericConstant)rIntegerConstant);
    }

    @Override
    public void visitRFloatConstant(@NotNull RFloatConstant rFloatConstant) {
        if (rFloatConstant == null) {
            RubyAnnotatorVisitor.b(13);
        }
        this.a((RNumericConstant)rFloatConstant);
    }

    private void a(@NotNull RNumericConstant rNumericConstant) {
        PsiElement psiElement;
        long l2 = e ^ 0x2927AD519060L;
        if (rNumericConstant == null) {
            RubyAnnotatorVisitor.b(14);
        }
        ProgressManager.checkCanceled();
        if (LanguageLevel.RUBY21.isGreaterThan(rNumericConstant.getLanguageLevel()) && (psiElement = rNumericConstant.getModifier()) != null) {
            this.a.createErrorAnnotation(psiElement, RBundle.message((String)"annotation.error.unsupported.numeric.modifiers"));
        }
    }

    @Override
    public void visitRBraceBlockCall(@NotNull RBraceBlockCall rBraceBlockCall) {
        PsiElement psiElement;
        IElementType iElementType;
        RPossibleCall rPossibleCall;
        if (rBraceBlockCall == null) {
            RubyAnnotatorVisitor.b(15);
        }
        if ((rPossibleCall = rBraceBlockCall.getCall()) instanceof RCall && !TokenBNF.tRBRACES.contains(iElementType = (psiElement = PsiTreeUtil.getDeepestLast((PsiElement)rPossibleCall.getNode().getPsi())).getNode().getElementType())) {
            this.a.createErrorAnnotation(rBraceBlockCall.getBlock().getFirstChild(), ErrorMsg.unexpected(RubyTokenTypes.tLBRACE));
        }
        super.visitRBraceBlockCall(rBraceBlockCall);
    }

    @Override
    public void visitRReference(RReference rReference) {
        RubyCallType rubyCallType = rReference.getCallType();
        if (rubyCallType != RubyCallType.UNKNOWN) {
            this.a((PsiElement)rReference.getValue(), null, rubyCallType);
        }
        super.visitRReference(rReference);
    }

    @Override
    public void visitRDotReference(RDotReference rDotReference) {
        long l2 = e ^ 0x43E86F277280L;
        if (rDotReference.isSafeNavigation() && LanguageLevel.RUBY23.isGreaterThan(rDotReference.getLanguageLevel())) {
            ASTNode aSTNode = rDotReference.getNode().findChildByType(Ruby19TokenTypes.tDOTQ);
            if (aSTNode == null) {
                Logger.getInstance(RubyAnnotatorVisitor.class).warn("Safe navigation without tDOTQ");
            } else {
                this.a.createErrorAnnotation(aSTNode, RBundle.message((String)"annotation.error.unsupported.safe.navigation"));
            }
        }
        super.visitRDotReference(rDotReference);
    }

    @Override
    public void visitRHeredocId(RHeredocId heredocId) {
        long l2 = e ^ 0x4D6D1E6D5708L;
        if ("<<~".equals(heredocId.getIdPrefix()) && LanguageLevel.RUBY23.isGreaterThan(heredocId.getLanguageLevel())) {
            this.a.createErrorAnnotation((PsiElement)heredocId, RBundle.message((String)"annotation.error.unsupported.squiggly.heredoc"));
        }
        super.visitRHeredocId(heredocId);
    }

    @Override
    public void visitRDoCodeBlock(RDoCodeBlock rDoCodeBlock) {
        List<PsiElement> list2;
        long l2 = e ^ 0x4B586144F5C0L;
        RBodyStatement rBodyStatement = rDoCodeBlock.getBodyStatement();
        if (rBodyStatement != null && !(list2 = RubyPsiUtil.getChildrenByFilter((PsiElement)rBodyStatement, RubyElementTypes.RESCUE_CONTAINERS)).isEmpty() && LanguageLevel.RUBY25.isGreaterThan(rBodyStatement.getLanguageLevel())) {
            for (PsiElement psiElement : list2) {
                this.a.createErrorAnnotation(psiElement, RBundle.message((String)"annotation.error.unsupported.rescue.in.do.block"));
            }
        }
        super.visitRDoCodeBlock(rDoCodeBlock);
    }

    @Override
    public void visitRRangeExpression(RRangeExpression rRangeExpression) {
        long l2 = e ^ 0x5FA754B05483L;
        if (rRangeExpression.getRightOperand() == null && LanguageLevel.RUBY26.isGreaterThan(rRangeExpression.getLanguageLevel())) {
            this.a.createErrorAnnotation((PsiElement)rRangeExpression, RBundle.message((String)"annotation.error.unsupported.endless.range"));
        }
        super.visitRRangeExpression(rRangeExpression);
    }

    @Override
    public void visitRArgumentToBlock(@NotNull RArgumentToBlock rArgumentToBlock) {
        PsiElement psiElement;
        long l2 = e ^ 0x4B7E519962E0L;
        if (rArgumentToBlock == null) {
            RubyAnnotatorVisitor.b(16);
        }
        if ((psiElement = rArgumentToBlock.getParent()) instanceof RListOfExpressions && psiElement.getParent() instanceof RYieldStatement) {
            this.a.createErrorAnnotation((PsiElement)rArgumentToBlock, RBundle.message((String)"annotation.error.block.given.to.yield"));
        }
        super.visitRArgumentToBlock(rArgumentToBlock);
    }

    @Override
    public void visitRArgumentList(RArgumentList list2) {
        this.a(list2.getArguments(), Collections.emptyList());
        super.visitRArgumentList(list2);
    }

    @Override
    public void visitRCodeBlock(RCodeBlock codeBlock) {
        RBlockArgumentList rBlockArgumentList = codeBlock.getBlockArguments();
        RBlockLocalVariables rBlockLocalVariables = codeBlock.getBlockLocalVariables();
        this.a(rBlockArgumentList != null ? rBlockArgumentList.getArguments() : Collections.emptyList(), rBlockLocalVariables != null ? rBlockLocalVariables.getVariables() : Collections.emptyList());
        super.visitRCodeBlock(codeBlock);
    }

    @Override
    public void visitRBodyStatement(RBodyStatement rBodyStatement) {
        long l2 = e ^ 0x44DCAE07DC16L;
        ProgressManager.checkCanceled();
        RElseBlock rElseBlock = rBodyStatement.getElseBlock();
        if (rElseBlock != null && rBodyStatement.getRescueBlocks().isEmpty()) {
            HighlightSeverity highlightSeverity = LanguageLevel.RUBY26.isGreaterThan(rBodyStatement.getLanguageLevel()) ? HighlightSeverity.WARNING : HighlightSeverity.ERROR;
            this.a.createAnnotation(highlightSeverity, rElseBlock.getTextRange(), RBundle.message((String)"annotation.error.else.without.rescue.is.useless"));
        }
        super.visitRBodyStatement(rBodyStatement);
    }

    private void a(List<RArgument> list2, List<RIdentifier> list3) {
        long l2 = e ^ 0x4A4D1591747EL;
        HashSet<String> hashSet = new HashSet<String>(list2.size());
        for (RArgument rArgument : list2) {
            String string = rArgument.getName();
            if ("_".equals(string) || hashSet.add(string)) continue;
            this.a.createErrorAnnotation((PsiElement)rArgument, RBundle.message((String)"annotation.error.duplicated.arg.name"));
        }
        for (RIdentifier rIdentifier : list3) {
            if (hashSet.add(rIdentifier.getName())) continue;
            this.a.createErrorAnnotation((PsiElement)rIdentifier, RBundle.message((String)"annotation.error.duplicated.arg.name"));
        }
    }

    static {
        e = la.a(5454443787816497513L, -5390096502647045804L, MethodHandles.lookup().lookupClass()).a(278496547802719L);
        b = new ProcessingContext();
        c = TokenSet.create((IElementType[])new IElementType[]{RubyElementTypes.ASSOC, RubyElementTypes.HEREDOC_VALUE, Ruby19ElementTypes.HASH_TO_ARGS});
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = e ^ 0x24778E7576C5L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rIdentifier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedArgument";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rSymbols";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rdSymbols";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rLambdaCall";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBlockLocalVariables";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rAssocList";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rHashToArguments";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rListOfExpressions";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rArgumentDestructing";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rIntegerConstant";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rFloatConstant";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rNumericConstant";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBraceBlockCall";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rArgumentToBlock";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/annotator/RubyAnnotatorVisitor";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isClassName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRIdentifier";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRNamedArgument";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRSymbols";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRDSymbols";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRLambdaCall";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBlockLocalVariable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRAssocList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRHashToArguments";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRListOfExpressions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRArgumentDestructing";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRIntegerConstant";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRFloatConstant";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRNumericConstant";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRBraceBlockCall";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRArgumentToBlock";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

