/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types;

import b.h.la;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.TypedSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.collections.RCollectionTypeImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.collections.RHashType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RFrozenType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RSymbolTypeImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.primitive.RBooleanType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.primitive.RFloatType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.primitive.RIntegerType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public class RTypeFactory {
    private static final Logger a;
    private static final long b;

    private RTypeFactory() {
    }

    public static RType createTypeClassName(@NotNull String className, @NotNull RPsiElement usage) {
        if (className == null) {
            RTypeFactory.a(0);
        }
        if (usage == null) {
            RTypeFactory.a(1);
        }
        return RTypeFactory.createTypeBySymbol(SymbolUtil.findConstantByFQN(usage.getProject(), Type.CLASS, className, null), usage);
    }

    public static RType createTypeClassName(Project project, @NotNull String className, @NotNull Context context) {
        if (className == null) {
            RTypeFactory.a(2);
        }
        if (context == null) {
            RTypeFactory.a(3);
        }
        return RTypeFactory.createTypeBySymbol(SymbolUtil.findConstantByFQN(project, Type.CLASS, className, null), context);
    }

    public static RType createTypeBySymbol(@Nullable Symbol symbol, @NotNull RPsiElement element) {
        if (element == null) {
            RTypeFactory.a(4);
        }
        if (symbol == null) {
            return REmptyType.INSTANCE;
        }
        RContainer rContainer = element.getParentContainer();
        if (rContainer instanceof RMethod && !(rContainer instanceof RSingletonMethod) && (rContainer = rContainer.getParentContainer()) instanceof RClass && RContainerUtil.isInheritor((RClass)rContainer, symbol.getFQNWithNesting().getFullPath())) {
            return RTypeFactory.createTypeBySymbol(symbol, Context.INSTANCE_PROTECTED);
        }
        return RTypeFactory.createTypeBySymbol(symbol, Context.INSTANCE);
    }

    @NotNull
    public static RType createTypeBySymbol(@Nullable Symbol symbol, @NotNull Context context) {
        long l2 = b ^ 0x36197F5F3330L;
        if (context == null) {
            RTypeFactory.a(5);
        }
        if (symbol == null) {
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                RTypeFactory.a(6);
            }
            return rEmptyType;
        }
        if (symbol instanceof TypedSymbol) {
            RType rType = ((TypedSymbol)symbol).getType(context);
            if (rType == null) {
                RTypeFactory.a(7);
            }
            return rType;
        }
        Type type = symbol.getType();
        if (Types.METHODS_LIKE.contains(type)) {
            if (a.isDebugEnabled()) {
                a.debug("Method like symbol isn't expected here. It should be processed earlier. Symbol [" + symbol.getType() + "] fqn : " + symbol.getFQNWithNesting());
            }
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                RTypeFactory.a(8);
            }
            return rEmptyType;
        }
        if (type == Type.CLASS && ("Array".equals(symbol.getName()) || "Range".equals(symbol.getName()))) {
            RCollectionTypeImpl rCollectionTypeImpl = new RCollectionTypeImpl(new RSymbolTypeImpl(symbol, context), REmptyType.INSTANCE);
            if (rCollectionTypeImpl == null) {
                RTypeFactory.a(9);
            }
            return rCollectionTypeImpl;
        }
        if (Types.MODULE_OR_CLASS_OR_FILE.contains(type)) {
            RType rType = RSymbolTypeImpl.create(symbol, context);
            if (rType == null) {
                RTypeFactory.a(10);
            }
            return rType;
        }
        REmptyType rEmptyType = REmptyType.INSTANCE;
        if (rEmptyType == null) {
            RTypeFactory.a(11);
        }
        return rEmptyType;
    }

    @Deprecated
    @NotNull
    public static RType createNilType(@NotNull Project project) {
        if (project == null) {
            RTypeFactory.a(12);
        }
        REmptyType rEmptyType = REmptyType.INSTANCE;
        if (rEmptyType == null) {
            RTypeFactory.a(13);
        }
        return rEmptyType;
    }

    @NotNull
    public static RType createTrueType(@NotNull Project project) {
        if (project == null) {
            RTypeFactory.a(14);
        }
        RBooleanType rBooleanType = RBooleanType.getTrueType(project);
        if (rBooleanType == null) {
            RTypeFactory.a(15);
        }
        return rBooleanType;
    }

    @NotNull
    public static RType createFalseType(@NotNull Project project) {
        if (project == null) {
            RTypeFactory.a(16);
        }
        RBooleanType rBooleanType = RBooleanType.getFalseType(project);
        if (rBooleanType == null) {
            RTypeFactory.a(17);
        }
        return rBooleanType;
    }

    @NotNull
    public static RType createBoolType(@NotNull Project project) {
        if (project == null) {
            RTypeFactory.a(18);
        }
        RType rType = RTypeUtil.union(RTypeFactory.createTrueType(project), RTypeFactory.createFalseType(project));
        if (rType == null) {
            RTypeFactory.a(19);
        }
        return rType;
    }

    @NotNull
    public static RType createStringType(@NotNull Project project) {
        long l2 = b ^ 0x50FA8BD97EA2L;
        if (project == null) {
            RTypeFactory.a(20);
        }
        RType rType = RTypeFactory.createTypeByFQN(project, "String");
        if (rType == null) {
            RTypeFactory.a(21);
        }
        return rType;
    }

    @NotNull
    public static RType createStringType(@NotNull RPsiElement usage) {
        long l2 = b ^ 0x6561D4BCEA11L;
        if (usage == null) {
            RTypeFactory.a(22);
        }
        boolean bl2 = false;
        PsiFile psiFile = usage.getContainingFile();
        if (psiFile instanceof RFile && psiFile.isValid()) {
            bl2 = Boolean.parseBoolean((String)((RFile)psiFile).getPragmas().get("frozen_string_literal"));
        }
        RType rType = RTypeFactory.createTypeClassName("String", usage);
        RType rType2 = bl2 ? new RFrozenType(rType) : rType;
        if (rType2 == null) {
            RTypeFactory.a(23);
        }
        return rType2;
    }

    @NotNull
    public static RType createIntType(@NotNull Project project) {
        if (project == null) {
            RTypeFactory.a(24);
        }
        RIntegerType rIntegerType = new RIntegerType(project, LanguageLevel.RUBY25);
        if (rIntegerType == null) {
            RTypeFactory.a(25);
        }
        return rIntegerType;
    }

    @NotNull
    public static RType createIntType(@NotNull PsiElement usage) {
        if (usage == null) {
            RTypeFactory.a(26);
        }
        LanguageLevel languageLevel = RubyLanguageLevelPusher.getInstance().getLanguageLevelByElement(usage);
        RIntegerType rIntegerType = new RIntegerType(usage.getProject(), languageLevel != null ? languageLevel : LanguageLevel.DEFAULT);
        if (rIntegerType == null) {
            RTypeFactory.a(27);
        }
        return rIntegerType;
    }

    public static RType createFloatType(@NotNull Project project) {
        if (project == null) {
            RTypeFactory.a(28);
        }
        return new RFloatType(project);
    }

    @NotNull
    public static RType createArrayType(@NotNull Project project, @NotNull RType elementType) {
        long l2 = b ^ 0x2EE555D35542L;
        if (project == null) {
            RTypeFactory.a(29);
        }
        if (elementType == null) {
            RTypeFactory.a(30);
        }
        RType rType = RTypeFactory.createRCollectionType(project, elementType, "Array");
        if (rType == null) {
            RTypeFactory.a(31);
        }
        return rType;
    }

    @NotNull
    public static RType createRangeType(@NotNull Project project, @NotNull RType elementType) {
        long l2 = b ^ 0xE9415515B7FL;
        if (project == null) {
            RTypeFactory.a(32);
        }
        if (elementType == null) {
            RTypeFactory.a(33);
        }
        RType rType = RTypeFactory.createRCollectionType(project, elementType, "Range");
        if (rType == null) {
            RTypeFactory.a(34);
        }
        return rType;
    }

    @NotNull
    public static RType createSetType(@NotNull Project project, @NotNull RType elementType) {
        long l2 = b ^ 0x19827A0AB636L;
        if (project == null) {
            RTypeFactory.a(35);
        }
        if (elementType == null) {
            RTypeFactory.a(36);
        }
        RType rType = RTypeFactory.createRCollectionType(project, elementType, "Set");
        if (rType == null) {
            RTypeFactory.a(37);
        }
        return rType;
    }

    @NotNull
    public static RType createHashType(@NotNull Project project, @NotNull RType keyType, @NotNull RType valueType) {
        Symbol symbol;
        long l2 = b ^ 0x2D39C9CC4617L;
        if (project == null) {
            RTypeFactory.a(38);
        }
        if (keyType == null) {
            RTypeFactory.a(39);
        }
        if (valueType == null) {
            RTypeFactory.a(40);
        }
        if ((symbol = SymbolUtil.findConstantByFQN(project, "Hash")) == null) {
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                RTypeFactory.a(41);
            }
            return rEmptyType;
        }
        RSymbolTypeImpl rSymbolTypeImpl = new RSymbolTypeImpl(symbol, Context.INSTANCE);
        RHashType rHashType = new RHashType(rSymbolTypeImpl, keyType, valueType, project);
        if (rHashType == null) {
            RTypeFactory.a(42);
        }
        return rHashType;
    }

    @NotNull
    public static RType createRCollectionType(@NotNull Project project, @NotNull RType elementType, @NotNull String collectionFQN) {
        Symbol symbol;
        if (project == null) {
            RTypeFactory.a(43);
        }
        if (elementType == null) {
            RTypeFactory.a(44);
        }
        if (collectionFQN == null) {
            RTypeFactory.a(45);
        }
        if ((symbol = SymbolUtil.findConstantByFQN(project, collectionFQN)) == null) {
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                RTypeFactory.a(46);
            }
            return rEmptyType;
        }
        RSymbolTypeImpl rSymbolTypeImpl = new RSymbolTypeImpl(symbol, Context.INSTANCE);
        RCollectionTypeImpl rCollectionTypeImpl = new RCollectionTypeImpl(rSymbolTypeImpl, elementType);
        if (rCollectionTypeImpl == null) {
            RTypeFactory.a(47);
        }
        return rCollectionTypeImpl;
    }

    @NotNull
    public static RType createOrType(RPsiElement element1, RPsiElement element2) {
        REmptyType rEmptyType;
        REmptyType rEmptyType2 = rEmptyType = element1 instanceof RExpression ? ((RExpression)element1).getType() : REmptyType.INSTANCE;
        if (element2 instanceof RExpression) {
            RType rType = RTypeUtil.union(rEmptyType, ((RExpression)element2).getType());
            if (rType == null) {
                RTypeFactory.a(48);
            }
            return rType;
        }
        REmptyType rEmptyType3 = rEmptyType;
        if (rEmptyType3 == null) {
            RTypeFactory.a(49);
        }
        return rEmptyType3;
    }

    @NotNull
    public static RType createTypeByFQN(@NotNull Project project, @NotNull String fqn) {
        if (project == null) {
            RTypeFactory.a(50);
        }
        if (fqn == null) {
            RTypeFactory.a(51);
        }
        RType rType = RTypeFactory.createTypeByFQN(project, fqn, (PsiElement)null);
        if (rType == null) {
            RTypeFactory.a(52);
        }
        return rType;
    }

    @NotNull
    public static RType createTypeByFQN(@NotNull Project project, @NotNull String fqn, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            RTypeFactory.a(53);
        }
        if (fqn == null) {
            RTypeFactory.a(54);
        }
        RType rType = RTypeFactory.createTypeByFQN(project, fqn, Context.INSTANCE, invocationPoint);
        if (rType == null) {
            RTypeFactory.a(55);
        }
        return rType;
    }

    @NotNull
    public static RType createTypeByFQN(@NotNull Project project, @NotNull String fqn, @NotNull Context context) {
        if (project == null) {
            RTypeFactory.a(56);
        }
        if (fqn == null) {
            RTypeFactory.a(57);
        }
        if (context == null) {
            RTypeFactory.a(58);
        }
        RType rType = RTypeFactory.createTypeByFQN(project, fqn, context, null);
        if (rType == null) {
            RTypeFactory.a(59);
        }
        return rType;
    }

    @NotNull
    public static RType createTypeByFQN(@NotNull Project project, @NotNull String fqn, @NotNull Context context, @Nullable PsiElement invocationPoint) {
        Symbol symbol;
        long l2 = b ^ 0x5DEF35BB8DF3L;
        if (project == null) {
            RTypeFactory.a(60);
        }
        if (fqn == null) {
            RTypeFactory.a(61);
        }
        if (context == null) {
            RTypeFactory.a(62);
        }
        if ((symbol = SymbolUtil.findConstantByFQN(project, FQN.of((String)fqn), invocationPoint)) == null) {
            if (ApplicationManager.getApplication().isInternal()) {
                a.info("Cannot create type by fqn: " + fqn);
            }
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                RTypeFactory.a(63);
            }
            return rEmptyType;
        }
        RType rType = RTypeFactory.createTypeBySymbol(symbol, context);
        if (rType == null) {
            RTypeFactory.a(64);
        }
        return rType;
    }

    @Nullable
    public static RType createTypeForPrimitiveTypes(Project project, String typeName, @Nullable PsiElement invocationPoint) {
        long l2 = b ^ 0x717CF77E66DDL;
        if ("Numeric".equalsIgnoreCase(typeName) || "Integer".equalsIgnoreCase(typeName) || "int".equalsIgnoreCase(typeName)) {
            return invocationPoint != null ? RTypeFactory.createIntType(invocationPoint) : RTypeFactory.createIntType(project);
        }
        if ("str".equalsIgnoreCase(typeName) || "String".equals(typeName)) {
            return invocationPoint instanceof RPsiElement ? RTypeFactory.createStringType((RPsiElement)invocationPoint) : RTypeFactory.createStringType(project);
        }
        if ("Boolean".equalsIgnoreCase(typeName)) {
            return RTypeFactory.createBoolType(project);
        }
        if ("TrueClass".equals(typeName)) {
            return RTypeFactory.createTrueType(project);
        }
        if ("FalseClass".equals(typeName)) {
            return RTypeFactory.createFalseType(project);
        }
        if ("NilClass".equals(typeName)) {
            return RTypeFactory.createNilType(project);
        }
        return null;
    }

    public static RType createNotTypedObjectSymbolType(Project project) {
        long l2 = b ^ 0x52F0CEF76042L;
        RType rType = RTypeFactory.createTypeByFQN(project, "Object");
        if (rType instanceof RSymbolTypeImpl) {
            ((RSymbolTypeImpl)rType).setTyped(false);
        }
        return rType;
    }

    static {
        b = la.a(5458641991276414090L, 4022613868470043106L, MethodHandles.lookup().lookupClass()).a(127943455536085L);
        a = Logger.getInstance(RTypeFactory.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x79ACFF551782L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 31: 
            case 34: 
            case 37: 
            case 41: 
            case 42: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 55: 
            case 59: 
            case 63: 
            case 64: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 31: 
            case 34: 
            case 37: 
            case 41: 
            case 42: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 55: 
            case 59: 
            case 63: 
            case 64: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 3: 
            case 5: 
            case 58: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 31: 
            case 34: 
            case 37: 
            case 41: 
            case 42: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 55: 
            case 59: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/RTypeFactory";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 24: 
            case 28: 
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 43: 
            case 50: 
            case 53: 
            case 56: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 30: 
            case 33: 
            case 36: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyType";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueType";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionFQN";
                break;
            }
            case 51: 
            case 54: 
            case 57: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/RTypeFactory";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeBySymbol";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createNilType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createTrueType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createFalseType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createBoolType";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createStringType";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createIntType";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayType";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeType";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createSetType";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createHashType";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createRCollectionType";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrType";
                break;
            }
            case 52: 
            case 55: 
            case 59: 
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeByFQN";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTypeClassName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTypeBySymbol";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 31: 
            case 34: 
            case 37: 
            case 41: 
            case 42: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 55: 
            case 59: 
            case 63: 
            case 64: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createNilType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createTrueType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createFalseType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createBoolType";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createStringType";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createIntType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createFloatType";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createArrayType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createRangeType";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createSetType";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createHashType";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createRCollectionType";
                break;
            }
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "createTypeByFQN";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 31: 
            case 34: 
            case 37: 
            case 41: 
            case 42: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 55: 
            case 59: 
            case 63: 
            case 64: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

