/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.preload.spring;

import b.h.la;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;

@State(name="SpringUtil", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class SpringUtil
implements PersistentStateComponent<Element> {
    @NonNls
    public static final String SPRING_BINARY_NAME = "spring";
    @NonNls
    public static final String SPRING_PRE_LOADER_OPTION_FIELD = "SPRING_PRE_LOADER_OPTION";
    public boolean SPRING_PRE_LOADER_OPTION = true;
    public static final String SPRING_TMP_PATH_VARIABLE = "SPRING_TMP_PATH";
    public static final String SPRING_SERVER_COMMAND_ENV = "SPRING_SERVER_COMMAND";
    public static final String SPRING_SERVER_COMMAND = "spring server";
    private static final Logger a;
    @NonNls
    private static final String b = "spring";
    @NonNls
    private static final String c = "DISABLE_SPRING";
    private static final long d;

    public Element getState() {
        long l2 = d ^ 0x1E79A6197A7BL;
        Element element = new Element("state");
        element.setAttribute(SPRING_PRE_LOADER_OPTION_FIELD, Boolean.toString(this.SPRING_PRE_LOADER_OPTION));
        return element;
    }

    public void loadState(@NotNull Element state) {
        long l2 = d ^ 0x3F25D4101B58L;
        if (state == null) {
            SpringUtil.a(0);
        }
        this.SPRING_PRE_LOADER_OPTION = Boolean.parseBoolean(state.getAttributeValue(SPRING_PRE_LOADER_OPTION_FIELD));
    }

    public static SpringUtil getInstance(Project project) {
        return (SpringUtil)ServiceManager.getService((Project)project, SpringUtil.class);
    }

    public static boolean isSpringAvailable(@Nullable Module module) {
        if (module == null || !SpringUtil.getInstance((Project)module.getProject()).SPRING_PRE_LOADER_OPTION) {
            return false;
        }
        return SpringUtil.a(module);
    }

    private static boolean a(@Nullable Module module) {
        long l2 = d ^ 0x5B40839E7AB8L;
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        return module != null && SpringUtil.a(sdk) && GemSearchUtil.findGem(module, "spring") != null;
    }

    private static boolean a(@Nullable Sdk sdk) {
        return sdk != null && RubySdkUtil.isMRISdk(sdk) && !RubySdkUtil.getRubySdkAdditionalData(sdk).getSdkSystemAccessor().isWindows() && !ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    public static void disableSpring(@NotNull Map<String, String> env, @Nullable Module module) {
        long l2 = d ^ 0x14D66CAE8430L;
        if (env == null) {
            SpringUtil.a(1);
        }
        if (SpringUtil.a(module)) {
            a.info("Disabling Spring");
            env.put(c, "true");
        }
    }

    public static void customizeSpring(@Nullable Module module, @NotNull Map<String, String> env) {
        long l2 = d ^ 0x7B28B0164B5FL;
        if (env == null) {
            SpringUtil.a(2);
        }
        if (module != null && !module.getProject().isDisposed() && !SpringUtil.isSpringAvailable(module)) {
            SpringUtil.disableSpring(env, module);
            return;
        }
        String string = FileUtil.getTempDirectory() + "/RMSpring";
        a.info("Moving Spring to " + string);
        env.putIfAbsent(SPRING_TMP_PATH_VARIABLE, string);
        a.info("Setup 'spring server' mode");
        env.putIfAbsent(SPRING_SERVER_COMMAND_ENV, SPRING_SERVER_COMMAND);
    }

    @Nullable
    public static String getSpringExecutable(@Nullable Module module, @Nullable Sdk sdk) {
        long l2 = d ^ 0x3E95D43BA889L;
        if (module != null && !SpringUtil.getInstance((Project)module.getProject()).SPRING_PRE_LOADER_OPTION) {
            return null;
        }
        return RubyGemExecutionContext.getScriptPath(sdk, module, "spring", "spring");
    }

    public static boolean isTestFrameworkEnabled(@Nullable Module module, @NotNull SupportedTestFramework framework) {
        if (framework == null) {
            SpringUtil.a(3);
        }
        if (module == null) {
            return false;
        }
        if (!SpringUtil.isSpringAvailable(module)) {
            return false;
        }
        return GemSearchUtil.findGem(module, SpringUtil.a(framework)) != null;
    }

    @NotNull
    private static String a(@NotNull SupportedTestFramework supportedTestFramework) {
        long l2 = d ^ 0x75EC746AB956L;
        if (supportedTestFramework == null) {
            SpringUtil.a(4);
        }
        switch (supportedTestFramework) {
            case TEST_UNIT: 
            case SHOULDA: {
                if ("spring-commands-testunit" == null) {
                    SpringUtil.a(5);
                }
                return "spring-commands-testunit";
            }
            case RSPEC: {
                if ("spring-commands-rspec" == null) {
                    SpringUtil.a(6);
                }
                return "spring-commands-rspec";
            }
            case CUCUMBER: {
                if ("spring-commands-cucumber" == null) {
                    SpringUtil.a(7);
                }
                return "spring-commands-cucumber";
            }
        }
        throw new IllegalArgumentException("Unexpected test framework " + (Object)((Object)supportedTestFramework));
    }

    public static void stopSpring(@NotNull Module module, boolean isModal) {
        Sdk sdk;
        long l2 = d ^ 0x1AF218C67A54L;
        if (module == null) {
            SpringUtil.a(8);
        }
        if ((sdk = RModuleUtil.getInstance().findRubySdkForModule(module)) == null || !SpringUtil.a(sdk)) {
            return;
        }
        VirtualFile virtualFile = RailsFacetUtil.getRailsAppHomeDir(module);
        if (virtualFile != null) {
            final Runnable runnable = () -> {
                long l2 = d ^ 0x50BBFB851CDCL;
                if (module == null) {
                    SpringUtil.a(9);
                }
                try {
                    ((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)RubyGemExecutionContext.create(sdk, "spring").withModule(module)).withGemScriptName("spring").withWorkingDir(virtualFile)).withExecutionMode((ExecutionMode)new ExecutionModes.BackGroundMode(RBundle.message((String)"rails.spring.stop.title")))).withArguments("stop")).executeScript();
                }
                catch (ExecutionException executionException) {
                    a.warn("Cannot stop spring; " + executionException.getMessage());
                }
            };
            if (isModal) {
                ProgressManager.getInstance().run((Task)new Task.Modal(module.getProject(), RBundle.message((String)"rails.spring.stop.title"), true){
                    private static final long a = la.a(5975213973116264181L, 8951383861661085470L, MethodHandles.lookup().lookupClass()).a(113301262212448L);

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.a(0);
                        }
                        runnable.run();
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0x3CABB4A183A4L;
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/rails/preload/spring/SpringUtil$1", "run"));
                    }
                });
            } else {
                BackgroundTaskUtil.executeOnPooledThread((Disposable)module, (Runnable)runnable);
            }
        }
    }

    static {
        d = la.a(-215978153920866221L, -3962577878605775567L, MethodHandles.lookup().lookupClass()).a(174842208288956L);
        a = Logger.getInstance(SpringUtil.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0xBCDA1754284L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/preload/spring/SpringUtil";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/preload/spring/SpringUtil";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestCommandSupportGemName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "disableSpring";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "customizeSpring";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTestFrameworkEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTestCommandSupportGemName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "stopSpring";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$stopSpring$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

