/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.jruby.warbler.helpers;

import b.h.la;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.StandardFileSystems;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.GemSearchUtil;
import org.jetbrains.plugins.ruby.jruby.warbler.model.config.WarblerConfigModel;
import org.jetbrains.plugins.ruby.jruby.warbler.model.validation.WarblerConfigProblem;
import org.jetbrains.plugins.ruby.jruby.warbler.model.validation.WarblerEnvironmentProblem;
import org.jetbrains.plugins.ruby.jruby.warbler.model.validation.WarblerEnvironmentProblemEnum;

public class WarblerValidatorHelper {
    private static final long a = la.a(6623977363618202621L, 2752598568523875161L, MethodHandles.lookup().lookupClass()).a(66563783086725L);

    private WarblerValidatorHelper() {
    }

    @Nullable
    public static WarblerEnvironmentProblem checkEnvironment(@NotNull Module module) {
        Sdk sdk;
        long l2 = a ^ 0x586512BAA24AL;
        if (module == null) {
            WarblerValidatorHelper.a(0);
        }
        if ((sdk = ModuleRootManager.getInstance((Module)module).getSdk()) == null || !sdk.getName().toLowerCase(Locale.US).contains("jruby")) {
            return new WarblerEnvironmentProblem(RBundle.message((String)"warbler.validation.error.jruby.sdk.not.found"), RBundle.message((String)"warbler.validation.error.jruby.sdk.not.found.fix.title"), WarblerEnvironmentProblemEnum.WRONG_SDK);
        }
        GemInfo gemInfo = GemSearchUtil.findGem(module, sdk, "rails");
        if (gemInfo == null || !gemInfo.isValid()) {
            return new WarblerEnvironmentProblem(RBundle.message((String)"warbler.validation.error.rails.not.found"), RBundle.message((String)"warbler.validation.error.rails.not.found.fix.title"), WarblerEnvironmentProblemEnum.RAILS_NOT_FOUND);
        }
        gemInfo = GemSearchUtil.findGem(module, sdk, "warbler");
        if (gemInfo == null || !gemInfo.isValid()) {
            return new WarblerEnvironmentProblem(RBundle.message((String)"warbler.validation.error.warbler.not.found"), RBundle.message((String)"warbler.validation.error.warbler.not.found.fix.title"), WarblerEnvironmentProblemEnum.WARBLER_NOT_FOUND);
        }
        return null;
    }

    @Nullable
    public static WarblerConfigProblem checkConfig(@NotNull WarblerConfigModel config) {
        long l2 = a ^ 0x641F7EC7D200L;
        if (config == null) {
            WarblerValidatorHelper.a(1);
        }
        if (!StandardFileSystems.local().isValidName(config.getFileName())) {
            return new WarblerConfigProblem(RBundle.message((String)"warbler.validation.error.fileName"));
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x7B6DCD80A035L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/jruby/warbler/helpers/WarblerValidatorHelper";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkEnvironment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConfig";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

