/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import b.h.la;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsHighlightingUtil;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomElementProblemDescriptorImpl
implements DomElementProblemDescriptor {
    private static final Logger g;
    private final DomElement f;
    private final HighlightSeverity d;
    private final String b;
    private final LocalQuickFix[] e;
    private List<Annotation> c;
    private Pair<TextRange, PsiElement> a;
    public static final Pair<TextRange, PsiElement> NO_PROBLEM;
    private final ProblemHighlightType h;
    private static final long k;

    public DomElementProblemDescriptorImpl(@NotNull DomElement domElement, String message, HighlightSeverity type) {
        if (domElement == null) {
            DomElementProblemDescriptorImpl.a(0);
        }
        this(domElement, message, type, LocalQuickFix.EMPTY_ARRAY);
    }

    public DomElementProblemDescriptorImpl(@NotNull DomElement domElement, String message, HighlightSeverity type, @Nullable TextRange textRange) {
        if (domElement == null) {
            DomElementProblemDescriptorImpl.a(1);
        }
        this(domElement, message, type, textRange, null, LocalQuickFix.EMPTY_ARRAY);
    }

    public DomElementProblemDescriptorImpl(@NotNull DomElement domElement, String message, HighlightSeverity type, LocalQuickFix ... fixes) {
        if (domElement == null) {
            DomElementProblemDescriptorImpl.a(2);
        }
        if (fixes == null) {
            DomElementProblemDescriptorImpl.a(3);
        }
        this(domElement, message, type, (TextRange)null, (ProblemHighlightType)null, fixes);
    }

    public DomElementProblemDescriptorImpl(@NotNull DomElement domElement, String message, HighlightSeverity type, @Nullable TextRange textRange, ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        long l2 = k ^ 0x47B85C97DCBBL;
        if (domElement == null) {
            DomElementProblemDescriptorImpl.a(4);
        }
        if (fixes == null) {
            DomElementProblemDescriptorImpl.a(5);
        }
        this.f = domElement;
        XmlElement xmlElement = domElement.getXmlElement();
        if (xmlElement == null || !ApplicationManager.getApplication().isUnitTestMode()) {
            // empty if block
        }
        this.d = type;
        this.b = message;
        LocalQuickFix[] localQuickFixArray = this.e = ArrayUtil.contains(null, (Object[])fixes) ? (LocalQuickFix[])ContainerUtil.mapNotNull((Object[])fixes, (Function)FunctionUtil.id(), (Object[])LocalQuickFix.EMPTY_ARRAY) : fixes;
        if (textRange != null) {
            PsiElement psiElement = this.a();
            g.assertTrue(psiElement != null, (Object)"Problems with explicit text range can't be created for DOM elements without underlying XML element");
            assert (psiElement.isValid());
            this.a = Pair.create((Object)textRange, (Object)psiElement);
        }
        this.h = highlightType;
    }

    @NotNull
    public DomElement getDomElement() {
        DomElement domElement = this.f;
        if (domElement == null) {
            DomElementProblemDescriptorImpl.a(6);
        }
        return domElement;
    }

    @NotNull
    public HighlightSeverity getHighlightSeverity() {
        HighlightSeverity highlightSeverity = this.d;
        if (highlightSeverity == null) {
            DomElementProblemDescriptorImpl.a(7);
        }
        return highlightSeverity;
    }

    @NotNull
    public String getDescriptionTemplate() {
        String string = this.b == null ? "" : this.b;
        if (string == null) {
            DomElementProblemDescriptorImpl.a(8);
        }
        return string;
    }

    @NotNull
    public LocalQuickFix[] getFixes() {
        if (this.e == null) {
            DomElementProblemDescriptorImpl.a(9);
        }
        return this.e;
    }

    @NotNull
    public final List<Annotation> getAnnotations() {
        if (this.c == null) {
            this.c = ContainerUtil.createMaybeSingletonList((Object)DomElementsHighlightingUtil.createAnnotation(this));
        }
        List<Annotation> list2 = this.c;
        if (list2 == null) {
            DomElementProblemDescriptorImpl.a(10);
        }
        return list2;
    }

    public void highlightWholeElement() {
        PsiElement psiElement = this.a();
        if (psiElement instanceof XmlAttributeValue) {
            assert (psiElement.isValid()) : psiElement;
            PsiElement psiElement2 = psiElement.getParent();
            this.a = Pair.create((Object)new TextRange(0, psiElement2.getTextLength()), (Object)psiElement2);
        } else if (psiElement != null) {
            assert (psiElement.isValid()) : psiElement;
            XmlTag xmlTag = (XmlTag)(psiElement instanceof XmlTag ? psiElement : psiElement.getParent());
            this.a = new Pair((Object)new TextRange(0, xmlTag.getTextLength()), (Object)xmlTag);
        }
    }

    public Pair<TextRange, PsiElement> getProblemRange() {
        PsiElement psiElement;
        if (this.a == null) {
            this.a = this.computeProblemRange();
        }
        if ((psiElement = (PsiElement)this.a.second) != null) {
            PsiUtilCore.ensureValid((PsiElement)psiElement);
        }
        return this.a;
    }

    @NotNull
    protected Pair<TextRange, PsiElement> computeProblemRange() {
        PsiElement psiElement = this.a();
        if (psiElement != null) {
            String string;
            assert (psiElement.isValid()) : psiElement;
            if (psiElement instanceof XmlTag) {
                Pair pair = DomUtil.getProblemRange((XmlTag)((XmlTag)psiElement));
                if (pair == null) {
                    DomElementProblemDescriptorImpl.a(11);
                }
                return pair;
            }
            int n2 = psiElement.getTextRange().getLength();
            TextRange textRange = TextRange.from((int)0, (int)n2);
            if (psiElement instanceof XmlAttributeValue && StringUtil.isNotEmpty((String)(string = ((XmlAttributeValue)psiElement).getValue()))) {
                textRange = TextRange.from((int)psiElement.getText().indexOf(string), (int)string.length());
            }
            Pair pair = Pair.create((Object)textRange, (Object)psiElement);
            if (pair == null) {
                DomElementProblemDescriptorImpl.a(12);
            }
            return pair;
        }
        XmlTag xmlTag = this.b();
        if (xmlTag != null) {
            Pair pair = DomUtil.getProblemRange((XmlTag)xmlTag);
            if (pair == null) {
                DomElementProblemDescriptorImpl.a(13);
            }
            return pair;
        }
        Pair<TextRange, PsiElement> pair = NO_PROBLEM;
        if (pair == null) {
            DomElementProblemDescriptorImpl.a(14);
        }
        return pair;
    }

    public String toString() {
        long l2 = k ^ 0x6EE95670A418L;
        return this.f + "; " + this.b;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        DomElementProblemDescriptorImpl domElementProblemDescriptorImpl = (DomElementProblemDescriptorImpl)o2;
        if (this.f != null ? !this.f.equals(domElementProblemDescriptorImpl.f) : domElementProblemDescriptorImpl.f != null) {
            return false;
        }
        if (!this.b.equals(domElementProblemDescriptorImpl.b)) {
            return false;
        }
        return this.d.equals((Object)domElementProblemDescriptorImpl.d);
    }

    public int hashCode() {
        int n2 = this.f != null ? this.f.hashCode() : 0;
        n2 = 31 * n2 + this.d.hashCode();
        n2 = 31 * n2 + this.b.hashCode();
        return n2;
    }

    @Nullable
    private PsiElement a() {
        XmlText[] xmlTextArray;
        if (this.f instanceof DomFileElement) {
            return ((DomFileElement)this.f).getFile();
        }
        if (this.f instanceof GenericAttributeValue) {
            GenericAttributeValue genericAttributeValue = (GenericAttributeValue)this.f;
            XmlAttributeValue xmlAttributeValue = genericAttributeValue.getXmlAttributeValue();
            return xmlAttributeValue != null && StringUtil.isNotEmpty((String)xmlAttributeValue.getText()) ? xmlAttributeValue : genericAttributeValue.getXmlElement();
        }
        XmlTag xmlTag = this.f.getXmlTag();
        if (this.f instanceof GenericValue && xmlTag != null && (xmlTextArray = xmlTag.getValue().getTextElements()).length > 0) {
            return xmlTextArray[0];
        }
        return xmlTag;
    }

    @Nullable
    private XmlTag b() {
        for (DomElement domElement = this.f.getParent(); domElement != null; domElement = domElement.getParent()) {
            if (domElement.getXmlTag() == null) continue;
            return domElement.getXmlTag();
        }
        return null;
    }

    @Nullable
    public ProblemHighlightType getHighlightType() {
        return this.h;
    }

    static {
        k = la.a(-6352103670245146099L, 2300055441974379864L, MethodHandles.lookup().lookupClass()).a(241966709081327L);
        long l2 = k ^ 0x28CF283C7EE6L;
        g = Logger.getInstance((String)"#com.intellij.util.xml.highlighting.DomElementProblemDescriptorImpl");
        NO_PROBLEM = new Pair(null, null);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = k ^ 0x7C22AAC60222L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domElement";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/DomElementProblemDescriptorImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/DomElementProblemDescriptorImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightSeverity";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionTemplate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeProblemRange";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

