/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.utils.Flags;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class BfsUtil {
    public static int getCorrespondingParent(@NotNull LiteLinearGraph graph2, int startNode, int endNode, @NotNull Flags visited) {
        int emptyCount;
        List<Integer> candidates;
        if (graph2 == null) {
            BfsUtil.$$$reportNull$$$0(0);
        }
        if (visited == null) {
            BfsUtil.$$$reportNull$$$0(1);
        }
        if ((candidates = graph2.getNodes(startNode, LiteLinearGraph.NodeFilter.DOWN)).size() == 1) {
            return candidates.get(0);
        }
        if (candidates.contains(endNode)) {
            return endNode;
        }
        ArrayList<LinkedList> queues = new ArrayList<LinkedList>(candidates.size());
        for (int candidate : candidates) {
            queues.add(ContainerUtil.newLinkedList((Object[])new Integer[]{candidate}));
        }
        visited.setAll(false);
        do {
            emptyCount = 0;
            for (Queue queue2 : queues) {
                if (queue2.isEmpty()) {
                    ++emptyCount;
                    continue;
                }
                boolean found = BfsUtil.runNextBfsStep(graph2, queue2, visited, endNode);
                if (!found) continue;
                return candidates.get(queues.indexOf(queue2));
            }
        } while (emptyCount < queues.size());
        return candidates.get(0);
    }

    private static boolean runNextBfsStep(@NotNull LiteLinearGraph graph2, @NotNull Queue<Integer> queue2, @NotNull Flags visited, int target2) {
        if (graph2 == null) {
            BfsUtil.$$$reportNull$$$0(2);
        }
        if (queue2 == null) {
            BfsUtil.$$$reportNull$$$0(3);
        }
        if (visited == null) {
            BfsUtil.$$$reportNull$$$0(4);
        }
        while (!queue2.isEmpty()) {
            Integer node = queue2.poll();
            if (visited.get(node)) continue;
            visited.set(node, true);
            List<Integer> next = graph2.getNodes(node, LiteLinearGraph.NodeFilter.DOWN);
            if (next.contains(target2)) {
                return true;
            }
            queue2.addAll(next);
            return false;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/graph/utils/BfsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCorrespondingParent";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "runNextBfsStep";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

