/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.FileNameIndexService;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilenameIndex {
    @Deprecated
    @NonNls
    public static final ID<String, Void> NAME = ID.create((String)"FilenameIndex");

    @NotNull
    public static String[] getAllFilenames(@Nullable Project project) {
        THashSet names = new THashSet();
        FilenameIndex.getService().processAllFileNames((Processor<String>)((Processor)arg_0 -> FilenameIndex.lambda$getAllFilenames$0((Set)names, arg_0)), (GlobalSearchScope)(project == null ? new EverythingGlobalScope() : GlobalSearchScope.allScope((Project)project)), null);
        String[] stringArray = ArrayUtil.toStringArray((Collection)names);
        if (stringArray == null) {
            FilenameIndex.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    public static void processAllFileNames(@NotNull Processor<String> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (processor2 == null) {
            FilenameIndex.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(2);
        }
        FilenameIndex.getService().processAllFileNames(processor2, scope, filter);
    }

    @NotNull
    public static Collection<VirtualFile> getVirtualFilesByName(Project project, @NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(4);
        }
        Collection<VirtualFile> collection = FilenameIndex.getService().getVirtualFilesByName(project, name, scope, null);
        if (collection == null) {
            FilenameIndex.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public static Collection<VirtualFile> getVirtualFilesByName(Project project, @NotNull String name, boolean caseSensitively, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(7);
        }
        if (caseSensitively) {
            Collection<VirtualFile> collection = FilenameIndex.getVirtualFilesByName(project, name, scope);
            if (collection == null) {
                FilenameIndex.$$$reportNull$$$0(8);
            }
            return collection;
        }
        Set<VirtualFile> set = FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, project, null);
        if (set == null) {
            FilenameIndex.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    public static PsiFile[] getFilesByName(@NotNull Project project, @NotNull String name, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(10);
        }
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(12);
        }
        PsiFile[] psiFileArray = (PsiFile[])FilenameIndex.getFilesByName(project, name, scope, false);
        if (psiFileArray == null) {
            FilenameIndex.$$$reportNull$$$0(13);
        }
        return psiFileArray;
    }

    public static boolean processFilesByName(@NotNull String name, boolean directories, @NotNull Processor<? super PsiFileSystemItem> processor2, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(14);
        }
        if (processor2 == null) {
            FilenameIndex.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(16);
        }
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(17);
        }
        return FilenameIndex.processFilesByName(name, directories, true, processor2, scope, project, idFilter);
    }

    public static boolean processFilesByName(@NotNull String name, boolean directories, boolean caseSensitively, @NotNull Processor<? super PsiFileSystemItem> processor2, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        Collection<VirtualFile> files2;
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(18);
        }
        if (processor2 == null) {
            FilenameIndex.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(20);
        }
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(21);
        }
        if ((files2 = caseSensitively ? FilenameIndex.getService().getVirtualFilesByName(project, name, scope, idFilter) : FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, project, idFilter)).isEmpty()) {
            return false;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        int processedFiles = 0;
        for (VirtualFile file2 : files2) {
            PsiDirectory dir;
            if (!file2.isValid()) continue;
            if (!directories && !file2.isDirectory()) {
                PsiFile psiFile = psiManager.findFile(file2);
                if (psiFile == null) continue;
                if (!processor2.process((Object)psiFile)) {
                    return true;
                }
                ++processedFiles;
                continue;
            }
            if (!directories || !file2.isDirectory() || (dir = psiManager.findDirectory(file2)) == null) continue;
            if (!processor2.process((Object)dir)) {
                return true;
            }
            ++processedFiles;
        }
        return processedFiles > 0;
    }

    @NotNull
    private static Set<VirtualFile> getVirtualFilesByNameIgnoringCase(@NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(22);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(23);
        }
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(24);
        }
        THashSet keys = new THashSet();
        FileNameIndexService fileNameIndexService = FilenameIndex.getService();
        fileNameIndexService.processAllFileNames((Processor<String>)((Processor)arg_0 -> FilenameIndex.lambda$getVirtualFilesByNameIgnoringCase$1(name, (Set)keys, arg_0)), scope, idFilter);
        THashSet files2 = new THashSet();
        for (String each : keys) {
            files2.addAll(fileNameIndexService.getVirtualFilesByName(project, each, scope, idFilter));
        }
        THashSet tHashSet = files2;
        if (tHashSet == null) {
            FilenameIndex.$$$reportNull$$$0(25);
        }
        return tHashSet;
    }

    @NotNull
    public static PsiFileSystemItem[] getFilesByName(@NotNull Project project, @NotNull String name, @NotNull GlobalSearchScope scope, boolean directories) {
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(26);
        }
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(27);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(28);
        }
        SmartList result2 = new SmartList();
        Processor processor2 = Processors.cancelableCollectProcessor((Collection)result2);
        FilenameIndex.processFilesByName(name, directories, (Processor<? super PsiFileSystemItem>)processor2, scope, project, null);
        if (directories) {
            PsiFileSystemItem[] psiFileSystemItemArray = (PsiFileSystemItem[])ArrayUtil.toObjectArray((Collection)result2, PsiFileSystemItem.class);
            if (psiFileSystemItemArray == null) {
                FilenameIndex.$$$reportNull$$$0(29);
            }
            return psiFileSystemItemArray;
        }
        PsiFileSystemItem[] psiFileSystemItemArray = (PsiFileSystemItem[])result2.toArray((Object[])PsiFile.EMPTY_ARRAY);
        if (psiFileSystemItemArray == null) {
            FilenameIndex.$$$reportNull$$$0(30);
        }
        return psiFileSystemItemArray;
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project, @NotNull String ext) {
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(31);
        }
        if (ext == null) {
            FilenameIndex.$$$reportNull$$$0(32);
        }
        Collection<VirtualFile> collection = FilenameIndex.getAllFilesByExt(project, ext, GlobalSearchScope.allScope((Project)project));
        if (collection == null) {
            FilenameIndex.$$$reportNull$$$0(33);
        }
        return collection;
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project, @NotNull String ext, @NotNull GlobalSearchScope searchScope) {
        int len;
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(34);
        }
        if (ext == null) {
            FilenameIndex.$$$reportNull$$$0(35);
        }
        if (searchScope == null) {
            FilenameIndex.$$$reportNull$$$0(36);
        }
        if ((len = ext.length()) == 0) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                FilenameIndex.$$$reportNull$$$0(37);
            }
            return list2;
        }
        ext = "." + ext;
        ++len;
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        for (String name : FilenameIndex.getAllFilenames(project)) {
            int length = name.length();
            if (length <= len || !name.substring(length - len).equalsIgnoreCase(ext)) continue;
            files2.addAll(FilenameIndex.getVirtualFilesByName(project, name, searchScope));
        }
        ArrayList<VirtualFile> arrayList = files2;
        if (arrayList == null) {
            FilenameIndex.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    static FileNameIndexService getService() {
        return (FileNameIndexService)ServiceManager.getService(FileNameIndexService.class);
    }

    private static /* synthetic */ boolean lambda$getVirtualFilesByNameIgnoringCase$1(@NotNull String name, Set keys, String value) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(39);
        }
        if (name.equalsIgnoreCase(value)) {
            keys.add(value);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getAllFilenames$0(Set names, String s) {
        names.add(s);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/FilenameIndex";
                break;
            }
            case 1: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 12: 
            case 16: 
            case 20: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 14: 
            case 18: 
            case 22: 
            case 27: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 17: 
            case 21: 
            case 24: 
            case 26: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFilenames";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/FilenameIndex";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFilesByName";
                break;
            }
            case 13: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByName";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFilesByNameIgnoringCase";
                break;
            }
            case 33: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFilesByExt";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processAllFileNames";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFilesByName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByName";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processFilesByName";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFilesByNameIgnoringCase";
                break;
            }
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAllFilesByExt";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getVirtualFilesByNameIgnoringCase$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

