/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretVisualAttributes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectedCaret
implements Caret {
    private final EditorWindow myEditorWindow;
    final Caret myDelegate;

    InjectedCaret(EditorWindow window, Caret delegate) {
        this.myEditorWindow = window;
        this.myDelegate = delegate;
    }

    @NotNull
    public Editor getEditor() {
        EditorWindow editorWindow = this.myEditorWindow;
        if (editorWindow == null) {
            InjectedCaret.$$$reportNull$$$0(0);
        }
        return editorWindow;
    }

    @NotNull
    public CaretModel getCaretModel() {
        CaretModel caretModel = this.myEditorWindow.getCaretModel();
        if (caretModel == null) {
            InjectedCaret.$$$reportNull$$$0(1);
        }
        return caretModel;
    }

    public Caret getDelegate() {
        return this.myDelegate;
    }

    public boolean isValid() {
        return this.myDelegate.isValid();
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean scrollToCaret) {
        this.myDelegate.moveCaretRelatively(columnShift, lineShift, withSelection, scrollToCaret);
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            InjectedCaret.$$$reportNull$$$0(2);
        }
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(pos);
        this.myDelegate.moveToLogicalPosition(hostPos);
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            InjectedCaret.$$$reportNull$$$0(3);
        }
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(this.myEditorWindow.visualToLogicalPosition(pos));
        this.myDelegate.moveToLogicalPosition(hostPos);
    }

    public void moveToOffset(int offset) {
        this.moveToOffset(offset, false);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        int hostOffset = this.myEditorWindow.getDocument().injectedToHost(offset);
        this.myDelegate.moveToOffset(hostOffset, locateBeforeSoftWrap);
    }

    public boolean isUpToDate() {
        return this.myDelegate.isUpToDate();
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        LogicalPosition hostPos = this.myDelegate.getLogicalPosition();
        LogicalPosition logicalPosition = this.myEditorWindow.hostToInjected(hostPos);
        if (logicalPosition == null) {
            InjectedCaret.$$$reportNull$$$0(4);
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        LogicalPosition logicalPosition = this.getLogicalPosition();
        VisualPosition visualPosition = this.myEditorWindow.logicalToVisualPosition(logicalPosition);
        if (visualPosition == null) {
            InjectedCaret.$$$reportNull$$$0(5);
        }
        return visualPosition;
    }

    public int getOffset() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getOffset());
    }

    public int getVisualLineStart() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getVisualLineStart());
    }

    public int getVisualLineEnd() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getVisualLineEnd());
    }

    public int getSelectionStart() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getSelectionStart());
    }

    @NotNull
    public VisualPosition getSelectionStartPosition() {
        VisualPosition visualPosition = this.myDelegate.getSelectionStartPosition();
        if (visualPosition == null) {
            InjectedCaret.$$$reportNull$$$0(6);
        }
        return visualPosition;
    }

    public int getSelectionEnd() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getSelectionEnd());
    }

    @NotNull
    public VisualPosition getSelectionEndPosition() {
        VisualPosition visualPosition = this.myDelegate.getSelectionEndPosition();
        if (visualPosition == null) {
            InjectedCaret.$$$reportNull$$$0(7);
        }
        return visualPosition;
    }

    @Nullable
    public String getSelectedText() {
        return this.myDelegate.getSelectedText();
    }

    public int getLeadSelectionOffset() {
        return this.myEditorWindow.getDocument().hostToInjected(this.myDelegate.getLeadSelectionOffset());
    }

    @NotNull
    public VisualPosition getLeadSelectionPosition() {
        VisualPosition visualPosition = this.myDelegate.getLeadSelectionPosition();
        if (visualPosition == null) {
            InjectedCaret.$$$reportNull$$$0(8);
        }
        return visualPosition;
    }

    public boolean hasSelection() {
        return this.myDelegate.hasSelection();
    }

    public void setSelection(int startOffset, int endOffset) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(hostRange.getStartOffset(), hostRange.getEndOffset());
    }

    public void setSelection(int startOffset, int endOffset, boolean updateSystemSelection) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(hostRange.getStartOffset(), hostRange.getEndOffset(), updateSystemSelection);
    }

    public void setSelection(int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(hostRange.getStartOffset(), endPosition, hostRange.getEndOffset());
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(startPosition, hostRange.getStartOffset(), endPosition, hostRange.getEndOffset());
    }

    public void setSelection(@Nullable VisualPosition startPosition, int startOffset, @Nullable VisualPosition endPosition, int endOffset, boolean updateSystemSelection) {
        TextRange hostRange = this.myEditorWindow.getDocument().injectedToHost((TextRange)new ProperTextRange(startOffset, endOffset));
        this.myDelegate.setSelection(startPosition, hostRange.getStartOffset(), endPosition, hostRange.getEndOffset(), updateSystemSelection);
    }

    public void removeSelection() {
        this.myDelegate.removeSelection();
    }

    public void selectLineAtCaret() {
        this.myDelegate.selectLineAtCaret();
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        this.myDelegate.selectWordAtCaret(honorCamelWordsSettings);
    }

    @Nullable
    public Caret clone(boolean above) {
        Caret clone = this.myDelegate.clone(above);
        return clone == null ? null : new InjectedCaret(this.myEditorWindow, clone);
    }

    public void dispose() {
        this.myDelegate.dispose();
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            InjectedCaret.$$$reportNull$$$0(9);
        }
        if (value == null) {
            InjectedCaret.$$$reportNull$$$0(10);
        }
        Object object = this.myDelegate.putUserDataIfAbsent(key, value);
        if (object == null) {
            InjectedCaret.$$$reportNull$$$0(11);
        }
        return (T)object;
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            InjectedCaret.$$$reportNull$$$0(12);
        }
        return this.myDelegate.replace(key, oldValue, newValue);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            InjectedCaret.$$$reportNull$$$0(13);
        }
        return (T)this.myDelegate.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            InjectedCaret.$$$reportNull$$$0(14);
        }
        this.myDelegate.putUserData(key, value);
    }

    public boolean isAtRtlLocation() {
        return this.myDelegate.isAtRtlLocation();
    }

    public boolean isAtBidiRunBoundary() {
        return this.myDelegate.isAtBidiRunBoundary();
    }

    @NotNull
    public CaretVisualAttributes getVisualAttributes() {
        CaretVisualAttributes caretVisualAttributes = this.myDelegate.getVisualAttributes();
        if (caretVisualAttributes == null) {
            InjectedCaret.$$$reportNull$$$0(15);
        }
        return caretVisualAttributes;
    }

    public void setVisualAttributes(@NotNull CaretVisualAttributes attributes) {
        if (attributes == null) {
            InjectedCaret.$$$reportNull$$$0(16);
        }
        this.myDelegate.setVisualAttributes(attributes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/InjectedCaret";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretModel";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/InjectedCaret";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicalPosition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualPosition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionStartPosition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionEndPosition";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadSelectionPosition";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "moveToLogicalPosition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "moveToVisualPosition";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setVisualAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

