/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowConfirmationOptionImpl;
import com.intellij.openapi.vcs.VcsShowOptionsSettingImpl;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OptionsAndConfirmations {
    private final Map<String, VcsShowOptionsSettingImpl> myOptions = new LinkedHashMap<String, VcsShowOptionsSettingImpl>();
    private final Map<String, VcsShowConfirmationOptionImpl> myConfirmations = new LinkedHashMap<String, VcsShowConfirmationOptionImpl>();

    public void init(Convertor<String, VcsShowConfirmationOption.Value> initOptions) {
        this.createSettingFor(VcsConfiguration.StandardOption.ADD);
        this.createSettingFor(VcsConfiguration.StandardOption.REMOVE);
        this.createSettingFor(VcsConfiguration.StandardOption.CHECKOUT);
        this.createSettingFor(VcsConfiguration.StandardOption.UPDATE);
        this.createSettingFor(VcsConfiguration.StandardOption.STATUS);
        this.createSettingFor(VcsConfiguration.StandardOption.EDIT);
        this.myConfirmations.put(VcsConfiguration.StandardConfirmation.ADD.getId(), new VcsShowConfirmationOptionImpl(VcsConfiguration.StandardConfirmation.ADD.getId(), VcsBundle.message((String)"label.text.when.files.created.with.idea", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}), VcsBundle.message((String)"radio.after.creation.do.not.add", (Object[])new Object[0]), VcsBundle.message((String)"radio.after.creation.show.options", (Object[])new Object[0]), VcsBundle.message((String)"radio.after.creation.add.silently", (Object[])new Object[0])));
        this.myConfirmations.put(VcsConfiguration.StandardConfirmation.REMOVE.getId(), new VcsShowConfirmationOptionImpl(VcsConfiguration.StandardConfirmation.REMOVE.getId(), VcsBundle.message((String)"label.text.when.files.are.deleted.with.idea", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()}), VcsBundle.message((String)"radio.after.deletion.do.not.remove", (Object[])new Object[0]), VcsBundle.message((String)"radio.after.deletion.show.options", (Object[])new Object[0]), VcsBundle.message((String)"radio.after.deletion.remove.silently", (Object[])new Object[0])));
        this.restoreReadConfirm(VcsConfiguration.StandardConfirmation.ADD, initOptions);
        this.restoreReadConfirm(VcsConfiguration.StandardConfirmation.REMOVE, initOptions);
    }

    private void restoreReadConfirm(VcsConfiguration.StandardConfirmation confirm, Convertor<String, VcsShowConfirmationOption.Value> initOptions) {
        VcsShowConfirmationOption.Value initValue = (VcsShowConfirmationOption.Value)initOptions.convert((Object)confirm.getId());
        if (initValue != null) {
            this.getConfirmation(confirm).setValue(initValue);
        }
    }

    @NotNull
    public VcsShowConfirmationOptionImpl getConfirmation(VcsConfiguration.StandardConfirmation option) {
        VcsShowConfirmationOptionImpl vcsShowConfirmationOptionImpl = this.myConfirmations.get(option.getId());
        if (vcsShowConfirmationOptionImpl == null) {
            OptionsAndConfirmations.$$$reportNull$$$0(0);
        }
        return vcsShowConfirmationOptionImpl;
    }

    private void createSettingFor(VcsConfiguration.StandardOption option) {
        if (!this.myOptions.containsKey(option.getId())) {
            this.myOptions.put(option.getId(), new VcsShowOptionsSettingImpl(option));
        }
    }

    @NotNull
    public VcsShowSettingOption getOptions(VcsConfiguration.StandardOption option) {
        VcsShowSettingOption vcsShowSettingOption = this.myOptions.get(option.getId());
        if (vcsShowSettingOption == null) {
            OptionsAndConfirmations.$$$reportNull$$$0(1);
        }
        return vcsShowSettingOption;
    }

    public List<VcsShowOptionsSettingImpl> getAllOptions() {
        return new ArrayList<VcsShowOptionsSettingImpl>(this.myOptions.values());
    }

    public List<VcsShowConfirmationOptionImpl> getAllConfirmations() {
        return new ArrayList<VcsShowConfirmationOptionImpl>(this.myConfirmations.values());
    }

    @NotNull
    public VcsShowSettingOption getOrCreateCustomOption(@NotNull String vcsActionName, @NotNull AbstractVcs vcs) {
        if (vcsActionName == null) {
            OptionsAndConfirmations.$$$reportNull$$$0(2);
        }
        if (vcs == null) {
            OptionsAndConfirmations.$$$reportNull$$$0(3);
        }
        VcsShowOptionsSettingImpl option = this.getOrCreateOption(vcsActionName);
        option.addApplicableVcs(vcs);
        VcsShowOptionsSettingImpl vcsShowOptionsSettingImpl = option;
        if (vcsShowOptionsSettingImpl == null) {
            OptionsAndConfirmations.$$$reportNull$$$0(4);
        }
        return vcsShowOptionsSettingImpl;
    }

    private VcsShowOptionsSettingImpl getOrCreateOption(String actionName) {
        if (!this.myOptions.containsKey(actionName)) {
            this.myOptions.put(actionName, new VcsShowOptionsSettingImpl(actionName));
        }
        return this.myOptions.get(actionName);
    }

    Map<String, VcsShowOptionsSettingImpl> getOptions() {
        return this.myOptions;
    }

    Map<String, VcsShowConfirmationOptionImpl> getConfirmations() {
        return this.myConfirmations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/projectlevelman/OptionsAndConfirmations";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsActionName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfirmation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/projectlevelman/OptionsAndConfirmations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateCustomOption";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCustomOption";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

