/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.model;

import com.intellij.openapi.editor.richcopy.model.MarkupHandler;
import com.intellij.util.io.CompactDataInput;
import com.intellij.util.io.CompactDataOutput;
import java.io.IOException;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;

public class OutputInfoSerializer {
    private static final int TEXT_ID = 0;
    private static final int STYLE_ID = 1;
    private static final int FOREGROUND_ID = 2;
    private static final int BACKGROUND_ID = 3;
    private static final int FONT_ID = 4;

    public static class InputStream {
        private final CompactDataInput myInputStream;
        private final java.io.InputStream myUnderlyingInputStream;
        private int myCurrentOffset;

        public InputStream(java.io.InputStream stream) {
            this.myUnderlyingInputStream = new LZ4BlockInputStream(stream);
            this.myInputStream = new CompactDataInput(this.myUnderlyingInputStream);
        }

        public void read(MarkupHandler handler2) throws Exception {
            byte id = this.myInputStream.readByte();
            switch (id) {
                case 0: {
                    int endOffset;
                    int startOffset;
                    this.myCurrentOffset = startOffset = this.myCurrentOffset + this.myInputStream.readInt();
                    this.myCurrentOffset = endOffset = this.myCurrentOffset + this.myInputStream.readInt();
                    handler2.handleText(startOffset, endOffset);
                    break;
                }
                case 1: {
                    handler2.handleStyle(this.myInputStream.readInt());
                    break;
                }
                case 2: {
                    handler2.handleForeground(this.myInputStream.readInt());
                    break;
                }
                case 3: {
                    handler2.handleBackground(this.myInputStream.readInt());
                    break;
                }
                case 4: {
                    handler2.handleFont(this.myInputStream.readInt());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown tag id: " + id);
                }
            }
        }

        public void close() throws IOException {
            this.myUnderlyingInputStream.close();
        }
    }

    public static class OutputStream
    implements MarkupHandler {
        private final CompactDataOutput myOutputStream;
        private final java.io.OutputStream myUnderlyingOutputStream;
        private int myCurrentOffset;

        public OutputStream(java.io.OutputStream stream) {
            this.myUnderlyingOutputStream = new LZ4BlockOutputStream(stream);
            this.myOutputStream = new CompactDataOutput(this.myUnderlyingOutputStream);
        }

        public void close() throws IOException {
            this.myUnderlyingOutputStream.close();
        }

        @Override
        public void handleText(int startOffset, int endOffset) throws IOException {
            this.myOutputStream.write(0);
            this.myOutputStream.writeInt(startOffset - this.myCurrentOffset);
            this.myOutputStream.writeInt(endOffset - startOffset);
            this.myCurrentOffset = endOffset;
        }

        @Override
        public void handleForeground(int foregroundId) throws IOException {
            this.myOutputStream.write(2);
            this.myOutputStream.writeInt(foregroundId);
        }

        @Override
        public void handleBackground(int backgroundId) throws IOException {
            this.myOutputStream.write(3);
            this.myOutputStream.writeInt(backgroundId);
        }

        @Override
        public void handleFont(int fontNameId) throws IOException {
            this.myOutputStream.write(4);
            this.myOutputStream.writeInt(fontNameId);
        }

        @Override
        public void handleStyle(int style) throws IOException {
            this.myOutputStream.write(1);
            this.myOutputStream.writeInt(style);
        }

        @Override
        public boolean canHandleMore() {
            return true;
        }
    }
}

