/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.DisplayChangeDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.reference.SoftReference;
import com.intellij.util.ReflectionUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.VolatileImage;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class IdeRepaintManager
extends RepaintManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.HackyRepaintManager");
    private Map<GraphicsConfiguration, VolatileImage> myImagesMap;
    WeakReference<JComponent> myLastComponent;

    public IdeRepaintManager() {
        DisplayChangeDetector.getInstance().addListener(new DisplayChangeHandler());
    }

    @Override
    public Image getVolatileOffscreenBuffer(Component c, int proposedWidth, int proposedHeight) {
        Image buffer = super.getVolatileOffscreenBuffer(c, proposedWidth, proposedHeight);
        this.clearLeakyImages(false);
        return buffer;
    }

    private synchronized void clearLeakyImages(boolean force) {
        if (this.myImagesMap == null) {
            this.myImagesMap = (Map)ReflectionUtil.getField(RepaintManager.class, (Object)this, Map.class, (String)"volatileMap");
        }
        if (force || this.myImagesMap.size() > 3) {
            Dimension size = this.getDoubleBufferMaximumSize();
            this.setDoubleBufferMaximumSize(new Dimension(0, 0));
            this.setDoubleBufferMaximumSize(size);
        }
    }

    @Override
    public void addInvalidComponent(JComponent invalidComponent) {
        this.checkThreadViolations(invalidComponent);
        super.addInvalidComponent(invalidComponent);
    }

    @Override
    public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
        this.checkThreadViolations(c);
        super.addDirtyRegion(c, x, y, w, h);
    }

    private void checkThreadViolations(JComponent c) {
        if (!SwingUtilities.isEventDispatchThread() && c.isShowing()) {
            StackTraceElement[] stackTrace;
            boolean repaint = false;
            boolean fromSwing = false;
            boolean swingKnownNonAwtOperations = false;
            Exception exception = new Exception();
            for (StackTraceElement st : stackTrace = exception.getStackTrace()) {
                String className = st.getClassName();
                String methodName = st.getMethodName();
                if (repaint && className.startsWith("javax.swing.")) {
                    fromSwing = true;
                }
                if (repaint && "imageUpdate".equals(methodName)) {
                    swingKnownNonAwtOperations = true;
                }
                if ("read".equals(methodName) && className.startsWith("javax.swing.JEditorPane") || "setCharacterAttributes".equals(methodName) && className.startsWith("javax.swing.text.DefaultStyledDocument")) {
                    swingKnownNonAwtOperations = true;
                    break;
                }
                if (!"repaint".equals(methodName)) continue;
                repaint = true;
                fromSwing = false;
            }
            if (swingKnownNonAwtOperations) {
                return;
            }
            if (repaint && !fromSwing) {
                return;
            }
            if (SoftReference.dereference(this.myLastComponent) == c) {
                return;
            }
            this.myLastComponent = new WeakReference<JComponent>(c);
            LOG.warn("Access to realized (ever shown) UI components should be done only from the AWT event dispatch thread, revalidate(), invalidate() & repaint() is ok from any thread", (Throwable)exception);
        }
    }

    private class DisplayChangeHandler
    implements DisplayChangeDetector.Listener,
    Runnable {
        private DisplayChangeHandler() {
        }

        @Override
        public void displayChanged() {
            EventQueue.invokeLater(this);
        }

        @Override
        public void run() {
            IdeRepaintManager.this.clearLeakyImages(true);
        }
    }
}

