/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.DependantSpacingImpl;
import com.intellij.formatting.FormattingProgressCallback;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.engine.BlockRangesMap;
import com.intellij.formatting.engine.DependentSpacingEngine;
import com.intellij.formatting.engine.IndentAdjuster;
import com.intellij.formatting.engine.State;
import com.intellij.formatting.engine.WrapBlocksState;
import com.intellij.formatting.engine.WrapProcessor;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AdjustWhiteSpacesState
extends State {
    private final FormattingProgressCallback myProgressCallback;
    private final WrapBlocksState myWrapBlocksState;
    private LeafBlockWrapper myCurrentBlock;
    private DependentSpacingEngine myDependentSpacingEngine;
    private WrapProcessor myWrapProcessor;
    private BlockRangesMap myBlockRangesMap;
    private IndentAdjuster myIndentAdjuster;
    private final boolean myReformatContext;
    private Set<Alignment> myAlignmentsInsideRangesToModify = null;
    private final HashSet<WhiteSpace> myAlignAgain = new HashSet();
    private LeafBlockWrapper myFirstBlock;

    public AdjustWhiteSpacesState(WrapBlocksState state, FormattingProgressCallback progressCallback, boolean isReformatContext) {
        this.myWrapBlocksState = state;
        this.myProgressCallback = progressCallback;
        this.myReformatContext = isReformatContext;
    }

    @Override
    public void prepare() {
        if (this.myWrapBlocksState != null) {
            this.myCurrentBlock = this.myFirstBlock = this.myWrapBlocksState.getFirstBlock();
            this.myDependentSpacingEngine = this.myWrapBlocksState.getDependentSpacingEngine();
            this.myWrapProcessor = this.myWrapBlocksState.getWrapProcessor();
            this.myIndentAdjuster = this.myWrapBlocksState.getIndentAdjuster();
            this.myBlockRangesMap = this.myWrapBlocksState.getBlockRangesMap();
            this.myAlignmentsInsideRangesToModify = this.myWrapBlocksState.getAlignmentsInsideRangesToModify();
        }
    }

    public LeafBlockWrapper getCurrentBlock() {
        return this.myCurrentBlock;
    }

    @Override
    public void doIteration() {
        LeafBlockWrapper blockToProcess = this.myCurrentBlock;
        this.processToken();
        if (blockToProcess != null) {
            this.myProgressCallback.afterProcessingBlock(blockToProcess);
        }
        if (this.myCurrentBlock != null) {
            return;
        }
        if (this.myAlignAgain.isEmpty()) {
            this.setDone(true);
        } else {
            this.myAlignAgain.clear();
            this.myDependentSpacingEngine.clear();
            this.myCurrentBlock = this.myFirstBlock;
        }
    }

    private boolean isReformatSelectedRangesContext() {
        return this.myReformatContext && !ContainerUtil.isEmpty(this.myAlignmentsInsideRangesToModify);
    }

    private void defineAlignOffset(LeafBlockWrapper block) {
        AbstractBlockWrapper current = this.myCurrentBlock;
        do {
            AlignmentImpl alignment;
            if ((alignment = current.getAlignment()) != null) {
                alignment.setOffsetRespBlock(block);
            }
            if ((current = current.getParent()) != null) continue;
            return;
        } while (current.getStartOffset() == this.myCurrentBlock.getStartOffset());
    }

    private void onCurrentLineChanged() {
        this.myWrapProcessor.onCurrentLineChanged();
    }

    private boolean isCurrentBlockAlignmentUsedInRangesToModify() {
        AbstractBlockWrapper block = this.myCurrentBlock;
        AlignmentImpl alignment = this.myCurrentBlock.getAlignment();
        while (alignment == null) {
            if ((block = block.getParent()) == null || block.getStartOffset() != this.myCurrentBlock.getStartOffset()) {
                return false;
            }
            alignment = block.getAlignment();
        }
        return this.myAlignmentsInsideRangesToModify.contains((Object)alignment);
    }

    private static List<TextRange> getDependentRegionRangesAfterCurrentWhiteSpace(SpacingImpl spaceProperty, WhiteSpace whiteSpace) {
        if (!(spaceProperty instanceof DependantSpacingImpl)) {
            return ContainerUtil.emptyList();
        }
        if (whiteSpace.isReadOnly() || whiteSpace.isLineFeedsAreReadOnly()) {
            return ContainerUtil.emptyList();
        }
        DependantSpacingImpl spacing = (DependantSpacingImpl)spaceProperty;
        return ContainerUtil.filter(spacing.getDependentRegionRanges(), dependencyRange -> whiteSpace.getStartOffset() < dependencyRange.getEndOffset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processToken() {
        List<TextRange> ranges;
        SpacingImpl spaceProperty = this.myCurrentBlock.getSpaceProperty();
        WhiteSpace whiteSpace = this.myCurrentBlock.getWhiteSpace();
        if (this.isReformatSelectedRangesContext() && this.isCurrentBlockAlignmentUsedInRangesToModify() && whiteSpace.isReadOnly() && spaceProperty != null && !spaceProperty.isReadOnly()) {
            whiteSpace.setReadOnly(false);
            whiteSpace.setLineFeedsAreReadOnly(true);
        }
        whiteSpace.arrangeLineFeeds(spaceProperty, this.myBlockRangesMap);
        if (!whiteSpace.containsLineFeeds()) {
            whiteSpace.arrangeSpaces(spaceProperty);
        }
        try {
            LeafBlockWrapper newBlock = this.myWrapProcessor.processWrap(this.myCurrentBlock);
            if (newBlock != null) {
                this.myCurrentBlock = newBlock;
                return;
            }
        }
        finally {
            if (whiteSpace.containsLineFeeds()) {
                this.onCurrentLineChanged();
            }
        }
        LeafBlockWrapper newCurrentBlock = this.myIndentAdjuster.adjustIndent(this.myCurrentBlock);
        if (newCurrentBlock != null) {
            this.myCurrentBlock = newCurrentBlock;
            this.onCurrentLineChanged();
            return;
        }
        this.defineAlignOffset(this.myCurrentBlock);
        if (this.myCurrentBlock.containsLineFeeds()) {
            this.onCurrentLineChanged();
        }
        if (!(ranges = AdjustWhiteSpacesState.getDependentRegionRangesAfterCurrentWhiteSpace(spaceProperty, whiteSpace)).isEmpty()) {
            this.myDependentSpacingEngine.registerUnresolvedDependentSpacingRanges(spaceProperty, ranges);
        }
        if (!whiteSpace.isIsReadOnly() && this.myDependentSpacingEngine.shouldReformatPreviouslyLocatedDependentSpacing(whiteSpace)) {
            this.myAlignAgain.add(whiteSpace);
        } else if (!this.myAlignAgain.isEmpty()) {
            this.myAlignAgain.remove(whiteSpace);
        }
        this.myCurrentBlock = this.myCurrentBlock.getNextBlock();
    }
}

