/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Condition;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum HighlightingLevel {
    INSPECTIONS("Inspections", AllIcons.Ide.HectorOn, (Condition<RangeHighlighter>)((Condition)rangeHighlighter -> true)),
    ADVANCED("Syntax", AllIcons.Ide.HectorSyntax, (Condition<RangeHighlighter>)((Condition)rangeHighlighter -> {
        if (rangeHighlighter.getLayer() > 3000) {
            return false;
        }
        HighlightInfo info = HighlightInfo.fromRangeHighlighter(rangeHighlighter);
        return info == null || info.getSeverity().compareTo(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING) < 0;
    })),
    SIMPLE("None", AllIcons.Ide.HectorOff, (Condition<RangeHighlighter>)((Condition)rangeHighlighter -> rangeHighlighter.getLayer() <= 1000));

    @NotNull
    private final String myText;
    @Nullable
    private final Icon myIcon;
    @NotNull
    private final Condition<RangeHighlighter> myCondition;

    private HighlightingLevel(@NotNull String text, Icon icon, Condition<RangeHighlighter> condition) {
        if (text == null) {
            HighlightingLevel.$$$reportNull$$$0(0);
        }
        if (condition == null) {
            HighlightingLevel.$$$reportNull$$$0(1);
        }
        this.myText = text;
        this.myIcon = icon;
        this.myCondition = condition;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            HighlightingLevel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public Condition<RangeHighlighter> getCondition() {
        Condition<RangeHighlighter> condition = this.myCondition;
        if (condition == null) {
            HighlightingLevel.$$$reportNull$$$0(3);
        }
        return condition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/base/HighlightingLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/base/HighlightingLevel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

