/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class RenameFileFix
implements IntentionAction,
LocalQuickFix {
    private final String myNewFileName;

    public RenameFileFix(@NotNull String newFileName) {
        if (newFileName == null) {
            RenameFileFix.$$$reportNull$$$0(0);
        }
        this.myNewFileName = newFileName;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"rename.file.fix", (Object[])new Object[0]);
        if (string == null) {
            RenameFileFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            RenameFileFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"rename.file.fix", (Object[])new Object[0]);
        if (string == null) {
            RenameFileFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiFile file2;
        if (project == null) {
            RenameFileFix.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            RenameFileFix.$$$reportNull$$$0(5);
        }
        if (this.isAvailable(project, null, file2 = descriptor.getPsiElement().getContainingFile())) {
            WriteCommandAction.writeCommandAction((Project)project).run(() -> {
                if (project == null) {
                    RenameFileFix.$$$reportNull$$$0(8);
                }
                this.invoke(project, null, file2);
            });
        }
    }

    public final boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            RenameFileFix.$$$reportNull$$$0(6);
        }
        if (file2 == null || !file2.isValid()) {
            return false;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        VirtualFile parent = vFile.getParent();
        if (parent == null) {
            return false;
        }
        VirtualFile newVFile = parent.findChild(this.myNewFileName);
        return newVFile == null || newVFile.equals(vFile);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            RenameFileFix.$$$reportNull$$$0(7);
        }
        VirtualFile vFile = file2.getVirtualFile();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
        FileDocumentManager.getInstance().saveDocument(document);
        try {
            vFile.rename((Object)file2.getManager(), this.myNewFileName);
        }
        catch (IOException e) {
            MessagesEx.error(project, e.getMessage()).showLater();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/RenameFileFix";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/RenameFileFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyFix$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

