/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.FilePosition;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class FileNavigatable
implements Navigatable {
    private final Project myProject;
    private final NullableLazyValue<Navigatable> myValue;
    private final FilePosition myFilePosition;

    public FileNavigatable(Project project, FilePosition filePosition) {
        this.myProject = project;
        this.myFilePosition = filePosition;
        this.myValue = new NullableLazyValue<Navigatable>(){

            @Nullable
            protected Navigatable compute() {
                return FileNavigatable.this.getDescriptor();
            }
        };
    }

    public void navigate(boolean requestFocus) {
        Navigatable descriptor = (Navigatable)this.myValue.getValue();
        if (descriptor != null) {
            descriptor.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        Navigatable descriptor = (Navigatable)this.myValue.getValue();
        if (descriptor != null) {
            return descriptor.canNavigate();
        }
        return false;
    }

    public boolean canNavigateToSource() {
        Navigatable descriptor = (Navigatable)this.myValue.getValue();
        if (descriptor != null) {
            return descriptor.canNavigateToSource();
        }
        return false;
    }

    @Nullable
    private Navigatable getDescriptor() {
        OpenFileDescriptor descriptor = null;
        VirtualFile file2 = VfsUtil.findFileByIoFile((File)this.myFilePosition.getFile(), (boolean)false);
        if (file2 != null) {
            descriptor = new OpenFileDescriptor(this.myProject, file2, this.myFilePosition.getStartLine(), this.myFilePosition.getStartColumn());
        }
        return descriptor;
    }
}

