/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.dataflow;

import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.sixrr.inspectjs.dataflow.VariableUsedVisitor;

public class VariableAccessUtils {
    public static boolean mayEvaluateToVariable(JSExpression expression, JSVariable variable) {
        if (expression == null) {
            return false;
        }
        if (expression instanceof JSParenthesizedExpression) {
            JSExpression containedExpression = ((JSParenthesizedExpression)expression).getInnerExpression();
            return VariableAccessUtils.mayEvaluateToVariable(containedExpression, variable);
        }
        if (expression instanceof JSDefinitionExpression) {
            JSExpression containedExpression = ((JSDefinitionExpression)expression).getExpression();
            return VariableAccessUtils.mayEvaluateToVariable(containedExpression, variable);
        }
        if (expression instanceof JSConditionalExpression) {
            JSConditionalExpression conditional = (JSConditionalExpression)expression;
            JSExpression thenExpression = conditional.getThen();
            JSExpression elseExpression = conditional.getElse();
            return VariableAccessUtils.mayEvaluateToVariable(thenExpression, variable) || VariableAccessUtils.mayEvaluateToVariable(elseExpression, variable);
        }
        if (!(expression instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement referent = ((PsiReference)expression).resolve();
        if (referent == null) {
            return false;
        }
        return referent.equals(variable);
    }

    public static boolean variableIsUsed(JSVariable variable, PsiElement context) {
        if (context == null) {
            return false;
        }
        VariableUsedVisitor visitor = new VariableUsedVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isUsed();
    }
}

