/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSReferencingMutableVariableFromClosureInspection
extends JSInspection {
    private static final Set<String> ARRAY_METHODS = ContainerUtil.newHashSet((Object[])new String[]{"each", "forEach", "reduce", "reduceRight", "every", "filter", "map", "some"});

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.referencing.mutable.variable.from.closure.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSReferencingMutableVariableFromClosureInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSFunctionDeclaration(JSFunction node) {
                this.validate((JSExecutionScope)node);
            }

            public void visitJSFunctionExpression(JSFunctionExpression node) {
                this.validate((JSExecutionScope)node);
            }

            public void visitJSFile(JSFile file2) {
                this.validate((JSExecutionScope)file2);
            }

            public void visitJSEmbeddedContent(JSEmbeddedContent embeddedContent) {
                this.validate((JSExecutionScope)embeddedContent);
            }

            private void validate(JSExecutionScope scope) {
                ResultSink sink = new ResultSink(null){

                    @Override
                    public String getName() {
                        return null;
                    }
                };
                SinkResolveProcessor<ResultSink> processor = new SinkResolveProcessor<ResultSink>(sink){

                    @Override
                    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                        if (element == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (state == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if (!(element instanceof JSVariable) || element instanceof JSParameter || element instanceof ImplicitJSVariableImpl) {
                            return true;
                        }
                        return super.execute(element, state);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "element";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "state";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/lang/javascript/inspections/JSReferencingMutableVariableFromClosureInspection$1$2";
                        objectArray[2] = "execute";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                processor.setLocalResolve(true);
                scope.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), scope.getFirstChild(), (PsiElement)scope);
                List<PsiElement> results = sink.getResults();
                if (results == null) {
                    return;
                }
                THashSet usedNames = new THashSet();
                THashSet usedVars = new THashSet();
                for (PsiElement element : results) {
                    String name = ResolveProcessor.getName(element);
                    if (name == null) continue;
                    usedNames.add(name);
                    usedVars.add(element);
                }
                scope.acceptChildren((PsiElementVisitor)new JSRecursiveElementVisitor((Set)usedNames, (Set)usedVars, scope){
                    private JSLoopStatement myLoopStatement;
                    private Set<PsiElement> changedInCurrentLoop;
                    private boolean hasClosuresInLoop;
                    private boolean shouldRescanFunctions;
                    private JSFunction myFunction;
                    final /* synthetic */ Set val$usedNames;
                    final /* synthetic */ Set val$usedVars;
                    final /* synthetic */ JSExecutionScope val$scope;
                    {
                        this.val$usedNames = set;
                        this.val$usedVars = set2;
                        this.val$scope = jSExecutionScope;
                    }

                    public void visitJSReferenceExpression(JSReferenceExpression node) {
                        PsiElement resolve;
                        String referencedName;
                        if (node.getQualifier() == null && (referencedName = node.getReferencedName()) != null && this.val$usedNames.contains(referencedName) && (resolve = node.resolve()) != null && this.val$usedVars.contains(resolve) && this.myLoopStatement != null) {
                            ReadWriteAccessDetector.Access access = JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node);
                            if (access != ReadWriteAccessDetector.Access.Read && this.myFunction == null) {
                                this.addChangedNode(resolve);
                            }
                            if (resolve instanceof JSVariable && ((JSVariable)resolve).hasBlockScope()) {
                                return;
                            }
                            if (this.myFunction != this.val$scope && this.myFunction != null && this.hasClosuresInLoop && access == ReadWriteAccessDetector.Access.Read && this.changedInCurrentLoop != null && this.changedInCurrentLoop.contains(resolve)) {
                                this.shouldRescanFunctions = false;
                                boolean closureJustForIteration = false;
                                PsiElement element = this.myFunction.getParent();
                                if (element instanceof JSArgumentList && (element = element.getParent()) instanceof JSCallExpression && (element = ((JSCallExpression)element).getMethodExpression()) instanceof JSReferenceExpression) {
                                    String calledFunName = ((JSReferenceExpression)element).getReferenceName();
                                    closureJustForIteration = ARRAY_METHODS.contains(calledFunName);
                                }
                                if (!closureJustForIteration) {
                                    holder.registerProblem((PsiElement)node, JSBundle.message((String)"javascript.mutable.variable.accessible.from.closure", (Object[])new Object[0]), new LocalQuickFix[0]);
                                }
                            }
                        }
                        super.visitJSReferenceExpression(node);
                    }

                    private void addChangedNode(PsiElement resolve) {
                        if (this.changedInCurrentLoop == null) {
                            this.changedInCurrentLoop = new THashSet(2);
                        }
                        this.changedInCurrentLoop.add(resolve);
                        this.shouldRescanFunctions = true;
                    }

                    public void visitJSVariable(JSVariable node) {
                        String name = node.getName();
                        if (name != null && this.val$usedNames.contains(name) && this.myLoopStatement != null && !(node instanceof JSParameter) && !node.hasBlockScope()) {
                            this.addChangedNode((PsiElement)node);
                        }
                        super.visitJSVariable(node);
                    }

                    public void visitJSWhileStatement(JSWhileStatement node) {
                        this.proceedWithLoop((JSLoopStatement)node);
                    }

                    public void visitJSForInStatement(JSForInStatement node) {
                        this.proceedWithLoop((JSLoopStatement)node);
                    }

                    public void visitJSForStatement(JSForStatement node) {
                        this.proceedWithLoop((JSLoopStatement)node);
                    }

                    public void visitJSDoWhileStatement(JSDoWhileStatement node) {
                        this.proceedWithLoop((JSLoopStatement)node);
                    }

                    public void visitJSFunctionExpression(JSFunctionExpression node) {
                        if (this.immediatelyCalled((PsiElement)node)) {
                            super.visitJSFunctionExpression(node);
                            return;
                        }
                        this.proceedWithFunction((JSFunction)node);
                    }

                    private boolean immediatelyCalled(PsiElement node) {
                        PsiElement parent = node.getParent();
                        while (parent instanceof JSParenthesizedExpression) {
                            node = parent;
                            parent = node.getParent();
                        }
                        return parent instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() == node;
                    }

                    public void visitJSFunctionDeclaration(JSFunction node) {
                        this.proceedWithFunction(node);
                    }

                    private void proceedWithFunction(JSFunction node) {
                        JSFunction prev = this.myFunction;
                        this.myFunction = node;
                        if (this.myLoopStatement != null) {
                            this.hasClosuresInLoop = true;
                        }
                        this.visitJSElement((JSElement)node);
                        this.myFunction = prev;
                    }

                    private void proceedWithLoop(JSLoopStatement node) {
                        Set<PsiElement> changed = this.changedInCurrentLoop;
                        this.changedInCurrentLoop = null;
                        if (changed != null) {
                            this.changedInCurrentLoop = new THashSet(changed);
                        }
                        JSLoopStatement prev = this.myLoopStatement;
                        this.myLoopStatement = node;
                        boolean prevHasClosuresInLoop = this.hasClosuresInLoop;
                        boolean prevShouldRescanFunctions = this.shouldRescanFunctions;
                        this.hasClosuresInLoop = false;
                        this.visitJSStatement((JSStatement)node);
                        if (this.shouldRescanFunctions && this.hasClosuresInLoop) {
                            this.visitJSStatement((JSStatement)node);
                        }
                        this.myLoopStatement = prev;
                        this.changedInCurrentLoop = changed;
                        this.hasClosuresInLoop = prevHasClosuresInLoop;
                        this.shouldRescanFunctions = prevShouldRescanFunctions;
                    }
                });
            }
        };
        if (jSElementVisitor == null) {
            JSReferencingMutableVariableFromClosureInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/inspections/JSReferencingMutableVariableFromClosureInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

