/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.core.NodeTypingsInfo;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeTypingsDownloader {
    private static final String NODE_TYPINGS = "@types/node";
    private final NodeJsInterpreter myInterpreter;
    private final SemVer myInterpreterVersion;
    private final File myTypingsDir;
    private final NodePackage myNpmPackage;

    public NodeTypingsDownloader(@NotNull NodeJsInterpreter interpreter, @NotNull SemVer interpreterVersion, @Nullable NodePackage npmPackage, @NotNull File typingsDir) {
        if (interpreter == null) {
            NodeTypingsDownloader.$$$reportNull$$$0(0);
        }
        if (interpreterVersion == null) {
            NodeTypingsDownloader.$$$reportNull$$$0(1);
        }
        if (typingsDir == null) {
            NodeTypingsDownloader.$$$reportNull$$$0(2);
        }
        this.myInterpreter = interpreter;
        this.myInterpreterVersion = interpreterVersion;
        this.myNpmPackage = npmPackage;
        this.myTypingsDir = typingsDir;
    }

    @NotNull
    public Future<NodeTypingsInfo> download(@Nullable ProgressIndicator progress) {
        FutureTask<NodeTypingsInfo> future = new FutureTask<NodeTypingsInfo>(() -> this.doDownload(progress));
        ApplicationManager.getApplication().executeOnPooledThread(future);
        FutureTask<NodeTypingsInfo> futureTask = future;
        if (futureTask == null) {
            NodeTypingsDownloader.$$$reportNull$$$0(3);
        }
        return futureTask;
    }

    @NotNull
    private NodeTypingsInfo doDownload(@Nullable ProgressIndicator progress) throws ExecutionException {
        if (this.myNpmPackage == null) {
            throw new ExecutionException("Cannot find npm package");
        }
        ArrayList args = ContainerUtil.newArrayList((Object[])new String[]{NODE_TYPINGS, "--ignore-scripts"});
        File nodeModulesDir = new File(this.myTypingsDir, "node_modules");
        FileUtil.createDirectory((File)nodeModulesDir);
        GeneralCommandLine commandLine = NpmUtil.createNpmCommandLine(this.myTypingsDir, this.myInterpreter, this.myNpmPackage, NpmCommand.ADD, (List<String>)args);
        KillableColoredProcessHandler handler = NodeCommandLineUtil.createKillableColoredProcessHandler(commandLine, false);
        CapturingProcessRunner runner = new CapturingProcessRunner((BaseProcessHandler)handler);
        runner.runProcess(EmptyProgressIndicator.notNullize((ProgressIndicator)progress), (int)TimeUnit.SECONDS.toMillis(120L), true);
        File file2 = new File(nodeModulesDir, NODE_TYPINGS);
        if (file2.isDirectory()) {
            NodeTypingsInfo nodeTypingsInfo = new NodeTypingsInfo(new NodePackage(file2.getAbsolutePath()));
            if (nodeTypingsInfo == null) {
                NodeTypingsDownloader.$$$reportNull$$$0(4);
            }
            return nodeTypingsInfo;
        }
        throw new ExecutionException("Cannot find @types/node package");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterVersion";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typingsDir";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeTypingsDownloader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeTypingsDownloader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "download";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doDownload";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

