/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.impl.analysis.InsertRequiredAttributeFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.htmltools.codeInspection.htmlInspections.InspectionUtils;
import com.intellij.htmltools.codeInspection.htmlInspections.htmlAddLabelToForm.CreateNewLabelAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class HtmlRequiredTitleAttributeInspection
extends HtmlLocalInspectionTool {
    private static final Set<String> ourElementsWithoutTitle = ContainerUtil.immutableSet((Object[])new String[]{"frame", "iframe", "dl", "a", "router-link"});
    private static final String TITLE = "title";

    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            HtmlRequiredTitleAttributeInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            HtmlRequiredTitleAttributeInspection.$$$reportNull$$$0(1);
        }
        if (!HtmlUtil.isHtmlTagContainingFile((PsiElement)tag)) {
            return;
        }
        String tagName = tag.getName().toLowerCase();
        if (ourElementsWithoutTitle.contains(tagName)) {
            XmlAttribute title = tag.getAttribute(TITLE);
            if (title != null) {
                return;
            }
            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
            if (!ourElementsWithoutTitle.contains(tag.getName())) {
                fixes.add(new CreateNewLabelAction(tag.getName()));
            }
            if (holder.isOnTheFly()) {
                fixes.add((LocalQuickFix)new InsertRequiredAttributeFix(tag, TITLE, new String[0]){

                    @NotNull
                    public String getText() {
                        String string = MessageFormat.format("Insert ''{0}'' attribute", HtmlRequiredTitleAttributeInspection.TITLE);
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/htmltools/codeInspection/htmlInspections/HtmlRequiredTitleAttributeInspection$1", "getText"));
                    }
                });
            }
            InspectionUtils.RegisterProblem(tag, holder, fixes, XmlBundle.message((String)"html.inspections.check.required.title", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"html.inspections.check.required.title", (Object[])new Object[0]);
        if (string == null) {
            HtmlRequiredTitleAttributeInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("HtmlRequiredTitleAttribute" == null) {
            HtmlRequiredTitleAttributeInspection.$$$reportNull$$$0(3);
        }
        return "HtmlRequiredTitleAttribute";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlRequiredTitleAttributeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlRequiredTitleAttributeInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkTag";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

