/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.opassign;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.SideEffectChecker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.BinaryOperatorUtils;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSReplaceWithOperatorAssignmentIntention
extends JSMutablyNamedIntention {
    private static final TokenSet ACCEPTABLE_OPERATORS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.MULT, JSTokenTypes.DIV, JSTokenTypes.PERC, JSTokenTypes.PLUS, JSTokenTypes.MINUS, JSTokenTypes.LTLT, JSTokenTypes.GTGT, JSTokenTypes.GTGTGT, JSTokenTypes.AND, JSTokenTypes.XOR, JSTokenTypes.OR, JSTokenTypes.MULTMULT});

    @Override
    public String getTextForElement(PsiElement element) {
        JSAssignmentExpression exp = (JSAssignmentExpression)element;
        JSBinaryExpression rhs = (JSBinaryExpression)exp.getROperand();
        assert (rhs != null);
        IElementType sign = rhs.getOperationSign();
        return this.getText(BinaryOperatorUtils.getOperatorText((IElementType)sign));
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        Predicate predicate = new Predicate();
        if (predicate == null) {
            JSReplaceWithOperatorAssignmentIntention.$$$reportNull$$$0(0);
        }
        return predicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSReplaceWithOperatorAssignmentIntention.$$$reportNull$$$0(1);
        }
        JSAssignmentExpression exp = (JSAssignmentExpression)element;
        JSBinaryExpression rhs = (JSBinaryExpression)exp.getROperand();
        JSExpression lhs = exp.getLOperand();
        assert (rhs != null);
        IElementType sign = rhs.getOperationSign();
        String operand = BinaryOperatorUtils.getOperatorText((IElementType)sign);
        JSExpression rhsrhs = rhs.getROperand();
        assert (rhsrhs != null);
        JSElementFactory.replaceExpression((JSExpression)exp, lhs.getText() + operand + '=' + rhsrhs.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/opassign/JSReplaceWithOperatorAssignmentIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/opassign/JSReplaceWithOperatorAssignmentIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Predicate
    implements JSElementPredicate {
        private Predicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                Predicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSAssignmentExpression)) {
                return false;
            }
            if (ErrorUtil.containsError((PsiElement)element)) {
                return false;
            }
            JSAssignmentExpression assignment = (JSAssignmentExpression)element;
            IElementType tokenType = assignment.getOperationSign();
            if (!JSTokenTypes.EQ.equals(tokenType)) {
                return false;
            }
            JSExpression lhs = assignment.getLOperand();
            JSExpression rhs = assignment.getROperand();
            if (lhs instanceof JSDefinitionExpression) {
                lhs = ((JSDefinitionExpression)lhs).getExpression();
            }
            if (lhs == null || rhs == null) {
                return false;
            }
            if (!(rhs instanceof JSBinaryExpression)) {
                return false;
            }
            JSBinaryExpression binaryRhs = (JSBinaryExpression)rhs;
            JSExpression rhsRhs = binaryRhs.getROperand();
            JSExpression rhsLhs = binaryRhs.getLOperand();
            if (rhsRhs == null) {
                return false;
            }
            IElementType rhsTokenType = binaryRhs.getOperationSign();
            if (!ACCEPTABLE_OPERATORS.contains(rhsTokenType)) {
                return false;
            }
            if (SideEffectChecker.mayHaveSideEffects((JSExpression)lhs)) {
                return false;
            }
            return EquivalenceChecker.expressionsAreEquivalent((JSExpression)lhs, (JSExpression)rhsLhs);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/opassign/JSReplaceWithOperatorAssignmentIntention$Predicate", "satisfiedBy"));
        }
    }
}

