/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.BinaryOperatorNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public abstract class BinaryOperatorBaseNode
extends Node
implements BinaryOperatorNode {
    private Node firstNode;
    private Node secondNode;

    public BinaryOperatorBaseNode(SourcePosition position, Node firstNode, Node secondNode) {
        super(position);
        assert (firstNode != null) : "ArgsCatNode.first == null";
        assert (secondNode != null) : "ArgsCatNode.second == null";
        this.firstNode = this.adopt(firstNode);
        this.secondNode = this.adopt(secondNode);
    }

    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        BinaryOperatorBaseNode other = (BinaryOperatorBaseNode)node;
        return this.getFirst() == other.getFirst() && this.getSecond() == other.getSecond();
    }

    public NodeType getNodeType() {
        return NodeType.ARGSCATNODE;
    }

    public Node getFirst() {
        return this.firstNode;
    }

    public Node getSecond() {
        return this.secondNode;
    }
}

