/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.CommonBundle;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.DiffFragmentBuilder;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.highlighting.Util;
import com.intellij.openapi.diff.impl.processing.DiffCorrection;
import com.intellij.openapi.diff.impl.processing.Formatting;
import com.intellij.openapi.diff.impl.processing.Word;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComparisonPolicy {
    public static final ComparisonPolicy DEFAULT = new DefaultPolicy();
    public static final ComparisonPolicy TRIM_SPACE = new TrimSpacePolicy();
    public static final ComparisonPolicy IGNORE_SPACE = new IgnoreSpacePolicy();
    public static final ComparisonPolicy[] COMPARISON_POLICIES = new ComparisonPolicy[]{DEFAULT, IGNORE_SPACE, TRIM_SPACE};
    private final String myName;

    protected ComparisonPolicy(String name) {
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public DiffFragment[] buildFragments(@NotNull DiffString[] strings1, @NotNull DiffString[] strings2) throws FilesTooBigForDiffException {
        if (strings1 == null) {
            ComparisonPolicy.$$$reportNull$$$0(0);
        }
        if (strings2 == null) {
            ComparisonPolicy.$$$reportNull$$$0(1);
        }
        DiffFragmentBuilder builder = new DiffFragmentBuilder(strings1, strings2);
        Object[] wrappers1 = this.getWrappers(strings1);
        Object[] wrappers2 = this.getWrappers(strings2);
        Diff.Change change = Diff.buildChanges(wrappers1, wrappers2);
        DiffFragment[] diffFragmentArray = builder.buildFragments(Util.concatEquals(change, wrappers1, wrappers2));
        if (diffFragmentArray == null) {
            ComparisonPolicy.$$$reportNull$$$0(2);
        }
        return diffFragmentArray;
    }

    @NotNull
    public DiffFragment[] buildDiffFragmentsFromLines(@NotNull DiffString[] lines1, @NotNull DiffString[] lines2) throws FilesTooBigForDiffException {
        if (lines1 == null) {
            ComparisonPolicy.$$$reportNull$$$0(3);
        }
        if (lines2 == null) {
            ComparisonPolicy.$$$reportNull$$$0(4);
        }
        DiffFragmentBuilder builder = new DiffFragmentBuilder(lines1, lines2);
        Object[] wrappers1 = this.getLineWrappers(lines1);
        Object[] wrappers2 = this.getLineWrappers(lines2);
        Diff.Change change = Diff.buildChanges(wrappers1, wrappers2);
        DiffFragment[] diffFragmentArray = builder.buildFragments(change);
        if (diffFragmentArray == null) {
            ComparisonPolicy.$$$reportNull$$$0(5);
        }
        return diffFragmentArray;
    }

    @NotNull
    public DiffFragment createFragment(@Nullable DiffString text1, @Nullable DiffString text2) {
        text1 = ComparisonPolicy.toNull(text1);
        text2 = ComparisonPolicy.toNull(text2);
        if (text1 == null && text2 == null) {
            DiffFragment diffFragment = new DiffFragment(DiffString.EMPTY, DiffString.EMPTY);
            if (diffFragment == null) {
                ComparisonPolicy.$$$reportNull$$$0(6);
            }
            return diffFragment;
        }
        DiffFragment result = new DiffFragment(text1, text2);
        if (text1 != null && text2 != null) {
            result.setModified(!this.getWrapper(text1).equals(this.getWrapper(text2)));
        }
        DiffFragment diffFragment = result;
        if (diffFragment == null) {
            ComparisonPolicy.$$$reportNull$$$0(7);
        }
        return diffFragment;
    }

    @NotNull
    public abstract DiffFragment createFragment(@NotNull Word var1, @NotNull Word var2);

    @NotNull
    protected abstract Object[] getWrappers(@NotNull DiffString[] var1);

    @NotNull
    protected abstract Object[] getLineWrappers(@NotNull DiffString[] var1);

    @NotNull
    private Object getWrapper(@NotNull DiffString text) {
        if (text == null) {
            ComparisonPolicy.$$$reportNull$$$0(8);
        }
        Object object = this.getWrappers(new DiffString[]{text})[0];
        if (object == null) {
            ComparisonPolicy.$$$reportNull$$$0(9);
        }
        return object;
    }

    @Nullable
    private static DiffString toNull(@Nullable DiffString text1) {
        return text1 == null || text1.isEmpty() ? null : text1;
    }

    @NotNull
    private static DiffString toNotNull(@Nullable DiffString text) {
        DiffString diffString = text == null ? DiffString.EMPTY : text;
        if (diffString == null) {
            ComparisonPolicy.$$$reportNull$$$0(10);
        }
        return diffString;
    }

    @NotNull
    protected Object[] trimStrings(@NotNull DiffString[] strings) {
        if (strings == null) {
            ComparisonPolicy.$$$reportNull$$$0(11);
        }
        Object[] result = new Object[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            DiffString string = strings[i];
            result[i] = string.trim();
        }
        if (result == null) {
            ComparisonPolicy.$$$reportNull$$$0(12);
        }
        return result;
    }

    public boolean isEqual(@NotNull DiffFragment fragment) {
        if (fragment == null) {
            ComparisonPolicy.$$$reportNull$$$0(13);
        }
        if (fragment.isOneSide()) {
            return false;
        }
        Object[] wrappers = this.getLineWrappers(new DiffString[]{fragment.getText1(), fragment.getText2()});
        return Comparing.equal(wrappers[0], wrappers[1]);
    }

    @NotNull
    public Word createFormatting(@NotNull DiffString text, @NotNull TextRange textRange) {
        if (text == null) {
            ComparisonPolicy.$$$reportNull$$$0(14);
        }
        if (textRange == null) {
            ComparisonPolicy.$$$reportNull$$$0(15);
        }
        Formatting formatting = new Formatting(text, textRange);
        if (formatting == null) {
            ComparisonPolicy.$$$reportNull$$$0(16);
        }
        return formatting;
    }

    @NotNull
    public static ComparisonPolicy[] getAllInstances() {
        if (COMPARISON_POLICIES == null) {
            ComparisonPolicy.$$$reportNull$$$0(17);
        }
        return COMPARISON_POLICIES;
    }

    @NotNull
    protected Object[] getWrappers(@NotNull String[] lines) {
        if (lines == null) {
            ComparisonPolicy.$$$reportNull$$$0(18);
        }
        DiffString[] unsafeStrings = new DiffString[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            unsafeStrings[i] = DiffString.createNullable(lines[i]);
        }
        Object[] objectArray = this.getWrappers(unsafeStrings);
        if (objectArray == null) {
            ComparisonPolicy.$$$reportNull$$$0(19);
        }
        return objectArray;
    }

    @NotNull
    protected Object[] getLineWrappers(@NotNull String[] lines) {
        if (lines == null) {
            ComparisonPolicy.$$$reportNull$$$0(20);
        }
        DiffString[] unsafeStrings = new DiffString[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            unsafeStrings[i] = DiffString.createNullable(lines[i]);
        }
        Object[] objectArray = this.getLineWrappers(unsafeStrings);
        if (objectArray == null) {
            ComparisonPolicy.$$$reportNull$$$0(21);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings2";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/ComparisonPolicy";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines2";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/ComparisonPolicy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFragments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDiffFragmentsFromLines";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createFragment";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapper";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toNotNull";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "trimStrings";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createFormatting";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInstances";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrappers";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineWrappers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFragments";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildDiffFragmentsFromLines";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getWrapper";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "trimStrings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isEqual";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFormatting";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getWrappers";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLineWrappers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IgnoreSpacePolicy
    extends ComparisonPolicy
    implements DiffCorrection.FragmentProcessor<DiffCorrection.FragmentsCollector> {
        IgnoreSpacePolicy() {
            super(CommonBundle.message("comparison.policy.ignore.spaces.name", new Object[0]));
        }

        @Override
        @NotNull
        protected Object[] getLineWrappers(@NotNull DiffString[] lines) {
            if (lines == null) {
                IgnoreSpacePolicy.$$$reportNull$$$0(0);
            }
            Object[] result = new Object[lines.length];
            for (int i = 0; i < lines.length; ++i) {
                DiffString line = lines[i];
                result[i] = IgnoreSpacePolicy.getWrapper(line);
            }
            if (result == null) {
                IgnoreSpacePolicy.$$$reportNull$$$0(1);
            }
            return result;
        }

        @Override
        @NotNull
        public DiffFragment[] buildFragments(@NotNull DiffString[] strings1, @NotNull DiffString[] strings2) throws FilesTooBigForDiffException {
            if (strings1 == null) {
                IgnoreSpacePolicy.$$$reportNull$$$0(2);
            }
            if (strings2 == null) {
                IgnoreSpacePolicy.$$$reportNull$$$0(3);
            }
            DiffFragment[] fragments = super.buildFragments(strings1, strings2);
            DiffCorrection.FragmentsCollector collector = new DiffCorrection.FragmentsCollector();
            collector.processAll(fragments, this);
            DiffFragment[] diffFragmentArray = collector.toArray();
            if (diffFragmentArray == null) {
                IgnoreSpacePolicy.$$$reportNull$$$0(4);
            }
            return diffFragmentArray;
        }

        @NotNull
        private static Object getWrapper(@NotNull DiffString line) {
            if (line == null) {
                IgnoreSpacePolicy.$$$reportNull$$$0(5);
            }
            DiffString diffString = line.skipSpaces();
            if (diffString == null) {
                IgnoreSpacePolicy.$$$reportNull$$$0(6);
            }
            return diffString;
        }

        @Override
        @NotNull
        public DiffFragment createFragment(@NotNull Word word1, @NotNull Word word2) {
            if (word1 == null) {
                IgnoreSpacePolicy.$$$reportNull$$$0(7);
            }
            if (word2 == null) {
                IgnoreSpacePolicy.$$$reportNull$$$0(8);
            }
            DiffString text1 = word1.getText();
            DiffString text2 = word2.getText();
            DiffFragment diffFragment = word1.isWhitespace() && word2.isWhitespace() ? DiffFragment.unchanged(text1, text2) : this.createFragment(text1, text2);
            if (diffFragment == null) {
                IgnoreSpacePolicy.$$$reportNull$$$0(9);
            }
            return diffFragment;
        }

        @Override
        @NotNull
        public DiffFragment createFragment(DiffString text1, DiffString text2) {
            DiffString toCompare1 = ComparisonPolicy.toNotNull(text1);
            DiffString toCompare2 = ComparisonPolicy.toNotNull(text2);
            if (IgnoreSpacePolicy.getWrapper(toCompare1).equals(IgnoreSpacePolicy.getWrapper(toCompare2))) {
                DiffFragment diffFragment = DiffFragment.unchanged(toCompare1, toCompare2);
                if (diffFragment == null) {
                    IgnoreSpacePolicy.$$$reportNull$$$0(10);
                }
                return diffFragment;
            }
            DiffFragment diffFragment = new DiffFragment(text1, text2);
            if (diffFragment == null) {
                IgnoreSpacePolicy.$$$reportNull$$$0(11);
            }
            return diffFragment;
        }

        @Override
        @NotNull
        protected Object[] getWrappers(@NotNull DiffString[] strings) {
            if (strings == null) {
                IgnoreSpacePolicy.$$$reportNull$$$0(12);
            }
            Object[] objectArray = this.trimStrings(strings);
            if (objectArray == null) {
                IgnoreSpacePolicy.$$$reportNull$$$0(13);
            }
            return objectArray;
        }

        public String toString() {
            return "IGNORE";
        }

        @Override
        public void process(@NotNull DiffFragment fragment, @NotNull DiffCorrection.FragmentsCollector collector) {
            FragmentSide side;
            DiffString text;
            if (fragment == null) {
                IgnoreSpacePolicy.$$$reportNull$$$0(14);
            }
            if (collector == null) {
                IgnoreSpacePolicy.$$$reportNull$$$0(15);
            }
            if (fragment.isEqual()) {
                collector.add(fragment);
                return;
            }
            if (fragment.isOneSide() && StringUtil.isEmptyOrSpaces(text = (side = FragmentSide.chooseSide(fragment)).getText(fragment))) {
                collector.add(side.createFragment(text, DiffString.EMPTY, false));
                return;
            }
            collector.add(fragment);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/impl/ComparisonPolicy$IgnoreSpacePolicy";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strings1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strings2";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word1";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word2";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strings";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/impl/ComparisonPolicy$IgnoreSpacePolicy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLineWrappers";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildFragments";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWrapper";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFragment";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWrappers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLineWrappers";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "buildFragments";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getWrapper";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "createFragment";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getWrappers";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TrimSpacePolicy
    extends ComparisonPolicy {
        TrimSpacePolicy() {
            super(CommonBundle.message("comparison.policy.trim.space.name", new Object[0]));
        }

        @Override
        @NotNull
        protected Object[] getLineWrappers(@NotNull DiffString[] lines) {
            if (lines == null) {
                TrimSpacePolicy.$$$reportNull$$$0(0);
            }
            Object[] objectArray = this.trimStrings(lines);
            if (objectArray == null) {
                TrimSpacePolicy.$$$reportNull$$$0(1);
            }
            return objectArray;
        }

        @Override
        @NotNull
        public DiffFragment createFragment(@NotNull Word word1, @NotNull Word word2) {
            if (word1 == null) {
                TrimSpacePolicy.$$$reportNull$$$0(2);
            }
            if (word2 == null) {
                TrimSpacePolicy.$$$reportNull$$$0(3);
            }
            DiffString text1 = word1.getText();
            DiffString text2 = word2.getText();
            if (word1.isWhitespace() && word2.isWhitespace() && word1.atEndOfLine() && word2.atEndOfLine()) {
                DiffFragment diffFragment = DiffFragment.unchanged(text1, text2);
                if (diffFragment == null) {
                    TrimSpacePolicy.$$$reportNull$$$0(4);
                }
                return diffFragment;
            }
            DiffFragment diffFragment = this.createFragment(text1, text2);
            if (diffFragment == null) {
                TrimSpacePolicy.$$$reportNull$$$0(5);
            }
            return diffFragment;
        }

        @Override
        @NotNull
        protected Object[] getWrappers(@NotNull DiffString[] strings) {
            if (strings == null) {
                TrimSpacePolicy.$$$reportNull$$$0(6);
            }
            Object[] result = new Object[strings.length];
            boolean atBeginning = true;
            for (int i = 0; i < strings.length; ++i) {
                DiffString wrapper;
                DiffString string = strings[i];
                DiffString diffString = wrapper = atBeginning ? string.trimLeading() : string;
                if (wrapper.endsWith('\n')) {
                    atBeginning = true;
                    wrapper = wrapper.trimTrailing();
                } else {
                    atBeginning = false;
                }
                result[i] = wrapper;
            }
            if (result == null) {
                TrimSpacePolicy.$$$reportNull$$$0(7);
            }
            return result;
        }

        public String toString() {
            return "TRIM";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/impl/ComparisonPolicy$TrimSpacePolicy";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word2";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/impl/ComparisonPolicy$TrimSpacePolicy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLineWrappers";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFragment";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWrappers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLineWrappers";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createFragment";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getWrappers";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DefaultPolicy
    extends ComparisonPolicy {
        DefaultPolicy() {
            super(CommonBundle.message("comparison.policy.default.name", new Object[0]));
        }

        @Override
        @NotNull
        protected Object[] getWrappers(@NotNull DiffString[] strings) {
            if (strings == null) {
                DefaultPolicy.$$$reportNull$$$0(0);
            }
            if (strings == null) {
                DefaultPolicy.$$$reportNull$$$0(1);
            }
            return strings;
        }

        @Override
        @NotNull
        protected Object[] getLineWrappers(@NotNull DiffString[] lines) {
            if (lines == null) {
                DefaultPolicy.$$$reportNull$$$0(2);
            }
            if (lines == null) {
                DefaultPolicy.$$$reportNull$$$0(3);
            }
            return lines;
        }

        @Override
        @NotNull
        public DiffFragment createFragment(@NotNull Word word1, @NotNull Word word2) {
            if (word1 == null) {
                DefaultPolicy.$$$reportNull$$$0(4);
            }
            if (word2 == null) {
                DefaultPolicy.$$$reportNull$$$0(5);
            }
            DiffFragment diffFragment = this.createFragment(word1.getText(), word2.getText());
            if (diffFragment == null) {
                DefaultPolicy.$$$reportNull$$$0(6);
            }
            return diffFragment;
        }

        public String toString() {
            return "DEFAULT";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strings";
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/diff/impl/ComparisonPolicy$DefaultPolicy";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word1";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/diff/impl/ComparisonPolicy$DefaultPolicy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWrappers";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLineWrappers";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getWrappers";
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getLineWrappers";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createFragment";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

