/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.codeinsight.lineMarkers;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinFeature;
import org.jetbrains.plugins.cucumber.psi.GherkinPsiElement;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.cucumber.CucumberUtil;
import org.jetbrains.plugins.ruby.cucumber.actions.CucumberStepDefinitionListCellRenderer;
import org.jetbrains.plugins.ruby.rails.codeInsight.daemon.RailsLineMarkerNavigator;
import org.jetbrains.plugins.ruby.rails.codeInsight.daemon.StaticTooltipProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers.RubyLineMarkerProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers.RubyLineMarkerProviderDescriptor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers.RubyLineSeparatorProvider;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class CucumberLineMarkerProvider
extends RubyLineMarkerProviderDescriptor
implements RubyLineSeparatorProvider {
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            CucumberLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (CucumberUtil.isCucumberStepDefinition(element)) {
            boolean duplicated;
            List<AbstractStepDefinition> stepDefinitionList = CucumberUtil.getSameStepDefinitionList(element);
            boolean bl = duplicated = stepDefinitionList.size() > 1;
            if (duplicated) {
                PsiElement command = (PsiElement)ObjectUtils.notNull((Object)((RPossibleCall)element).getPsiCommand(), (Object)element);
                PsiElement identifier = PsiTreeUtil.getDeepestFirst((PsiElement)command);
                String tooltip = RBundle.message((String)"inspection.duplicate.step.definition.gutter.tooltip.message");
                return new LineMarkerInfo(identifier, identifier.getTextRange(), AllIcons.Gutter.OverridingMethod, 11, (Function)new StaticTooltipProvider(tooltip), (GutterIconNavigationHandler)new StepNavigationHandler(stepDefinitionList), GutterIconRenderer.Alignment.RIGHT);
            }
        }
        if (DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS && (element instanceof RPsiElement || element instanceof GherkinPsiElement)) {
            return RubyLineMarkerProvider.getLineSeparator((RubyLineSeparatorProvider)this, (PsiElement)element);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            CucumberLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            CucumberLineMarkerProvider.$$$reportNull$$$0(2);
        }
    }

    public boolean isSeparatorAllowed(PsiElement element) {
        VirtualFile virtualFile;
        PsiFile file;
        if (element instanceof GherkinFeature) {
            return true;
        }
        if (element instanceof RBlockCall && (file = element.getContainingFile()) instanceof RFile && (virtualFile = file.getVirtualFile()) != null && CucumberUtil.isStepDefinitionLikeFile(virtualFile)) {
            return element.getParent() == ((RFile)file).getCompoundStatement();
        }
        return false;
    }

    @Nullable
    public String getName() {
        return RBundle.message((String)"inspection.duplicate.step.definition.gutter.title");
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Gutter.OverridingMethod;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/codeinsight/lineMarkers/CucumberLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class StepNavigationHandler
    implements GutterIconNavigationHandler<PsiElement> {
        private final List<AbstractStepDefinition> myStepDefinitionList;

        private StepNavigationHandler(List<AbstractStepDefinition> stepDefinitionList) {
            this.myStepDefinitionList = stepDefinitionList;
        }

        public void navigate(MouseEvent e, PsiElement elt) {
            ArrayList<PsiElement> navigateElementList = new ArrayList<PsiElement>();
            RCall call = (RCall)PsiTreeUtil.getParentOfType((PsiElement)elt, RCall.class);
            for (AbstractStepDefinition asd : this.myStepDefinitionList) {
                PsiElement stepDefElement = asd.getElement();
                if (stepDefElement == null || stepDefElement.equals(call) || !(stepDefElement instanceof Navigatable)) continue;
                navigateElementList.add(stepDefElement);
            }
            Navigatable[] navigateElementArray = navigateElementList.toArray(new Navigatable[0]);
            RailsLineMarkerNavigator.openTargets((Navigatable[])navigateElementArray, (String)RBundle.message((String)"inspection.duplicate.step.definition.gutter.balloon.title"), (ListCellRenderer)((Object)new CucumberStepDefinitionListCellRenderer()), (RelativePoint)new RelativePoint(e));
        }
    }
}

