/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.cucumber.CucumberUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyElementNameAndDescriptionProvider;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyDocumentationMarkupUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;

public class CucumberRubyElementNameAndDescriptionProvider
implements RubyElementNameAndDescriptionProvider {
    @Nullable
    public String getPresentableName(PsiElement element) {
        if (CucumberUtil.isCucumberStepDefinition(element) && element instanceof RBlockCall) {
            RBlockCall blockCall = (RBlockCall)element;
            StringBuilder buff = new StringBuilder();
            buff.append(blockCall.getCall().getText());
            buff.append(" do");
            RBlockArgumentList vars = blockCall.getBlock().getBlockArguments();
            if (vars != null) {
                buff.append(" |");
                boolean first = true;
                for (RArgument var : vars.getArguments()) {
                    if (!first) {
                        buff.append(", ");
                    }
                    buff.append(var.getName());
                    first = false;
                }
                buff.append("|");
            }
            buff.append("\n  (...)\nend");
            return buff.toString();
        }
        return null;
    }

    public void appendVisibilityAndLocation(PsiElement targetElement, StringBuilder builder, boolean useHtmlLayout) {
        if (CucumberUtil.isCucumberStepDefinition(targetElement)) {
            String newLine;
            String space = useHtmlLayout ? "&nbsp;" : " ";
            VirtualFile file = targetElement.getContainingFile().getVirtualFile();
            assert (file != null);
            String string = newLine = useHtmlLayout ? "<br>" : "\n";
            if (builder.length() != 0) {
                builder.append(newLine);
            }
            builder.append(RBundle.message((String)"in")).append(space);
            String stepDefinitionPath = CucumberRubyElementNameAndDescriptionProvider.calcRelativePathToFile(file, targetElement.getProject());
            if (useHtmlLayout) {
                RubyDocumentationMarkupUtil.appendCode((StringBuilder)builder, (String)stepDefinitionPath);
            } else {
                builder.append(stepDefinitionPath);
            }
        }
    }

    @Nullable
    public String getType(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            CucumberRubyElementNameAndDescriptionProvider.$$$reportNull$$$0(0);
        }
        if (CucumberUtil.isCucumberStepDefinition(psiElement)) {
            return CucumberBundle.message((String)"cucumber.step", (Object[])new Object[0]);
        }
        return null;
    }

    private static String calcRelativePathToFile(@NotNull VirtualFile file, @Nullable Project project) {
        String projectHomeUrl;
        VirtualFile baseDir;
        if (file == null) {
            CucumberRubyElementNameAndDescriptionProvider.$$$reportNull$$$0(1);
        }
        String url = file.getPresentableUrl();
        if (project != null && (baseDir = project.getBaseDir()) != null && url.startsWith(projectHomeUrl = baseDir.getPresentableUrl())) {
            url = "..." + url.substring(projectHomeUrl.length());
        }
        return url;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/CucumberRubyElementNameAndDescriptionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calcRelativePathToFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

