/**
 * Handle add/remove competency links.
 *
 * @module     tool_lp/competencies
 * @copyright  2015 Damyon Wiese <damyon@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_lp/competencies",["jquery","core/notification","core/ajax","core/templates","core/str","tool_lp/competencypicker","tool_lp/dragdrop-reorder","core/pending"],(function($,notification,ajax,templates,str,Picker,dragdrop,Pending){var competencies=function(itemid,itemtype,pagectxid){this.itemid=itemid,this.itemtype=itemtype,this.pageContextId=pagectxid,this.pickerInstance=null,$('[data-region="actions"] button').prop("disabled",!1),this.registerEvents(),this.registerDragDrop()};return competencies.prototype.registerDragDrop=function(){var localthis=this;str.get_string("movecompetency","tool_lp").done((function(movestring){dragdrop.dragdrop("movecompetency",movestring,{identifier:"movecompetency",component:"tool_lp"},{identifier:"movecompetencyafter",component:"tool_lp"},"drag-samenode","drag-parentnode","drag-handlecontainer",(function(drag,drop){localthis.handleDrop(drag,drop)}))})).fail(notification.exception)},competencies.prototype.handleDrop=function(drag,drop){var fromid=$(drag).data("id"),toid=$(drop).data("id"),requests=[];if("course"==this.itemtype)requests=ajax.call([{methodname:"core_competency_reorder_course_competency",args:{courseid:this.itemid,competencyidfrom:fromid,competencyidto:toid}}]);else if("template"==this.itemtype)requests=ajax.call([{methodname:"core_competency_reorder_template_competency",args:{templateid:this.itemid,competencyidfrom:fromid,competencyidto:toid}}]);else{if("plan"!=this.itemtype)return;requests=ajax.call([{methodname:"core_competency_reorder_plan_competency",args:{planid:this.itemid,competencyidfrom:fromid,competencyidto:toid}}])}requests[0].fail(notification.exception)},competencies.prototype.pickCompetency=function(){var requests,pagerender,pageregion,pageContextIncludes,self=this;return self.pickerInstance||("template"!==self.itemtype&&"course"!==self.itemtype||(pageContextIncludes="parents"),self.pickerInstance=new Picker(self.pageContextId,!1,pageContextIncludes),self.pickerInstance.on("save",(function(e,data){var compIds=data.competencyIds,pendingPromise=new Pending;"course"===self.itemtype?(requests=[],$.each(compIds,(function(index,compId){requests.push({methodname:"core_competency_add_competency_to_course",args:{courseid:self.itemid,competencyid:compId}})})),requests.push({methodname:"tool_lp_data_for_course_competencies_page",args:{courseid:self.itemid,moduleid:0}}),pagerender="tool_lp/course_competencies_page",pageregion="coursecompetenciespage"):"template"===self.itemtype?(requests=[],$.each(compIds,(function(index,compId){requests.push({methodname:"core_competency_add_competency_to_template",args:{templateid:self.itemid,competencyid:compId}})})),requests.push({methodname:"tool_lp_data_for_template_competencies_page",args:{templateid:self.itemid,pagecontext:{contextid:self.pageContextId}}}),pagerender="tool_lp/template_competencies_page",pageregion="templatecompetenciespage"):"plan"===self.itemtype&&(requests=[],$.each(compIds,(function(index,compId){requests.push({methodname:"core_competency_add_competency_to_plan",args:{planid:self.itemid,competencyid:compId}})})),requests.push({methodname:"tool_lp_data_for_plan_page",args:{planid:self.itemid}}),pagerender="tool_lp/plan_page",pageregion="plan-page"),ajax.call(requests)[requests.length-1].then((function(context){return templates.render(pagerender,context)})).then((function(html,js){templates.replaceNode($('[data-region="'+pageregion+'"]'),html,js)})).then(pendingPromise.resolve).catch(notification.exception)}))),self.pickerInstance.display()},competencies.prototype.doDelete=function(deleteid){var requests=[],pagerender="",pageregion="";"course"==this.itemtype?(requests=ajax.call([{methodname:"core_competency_remove_competency_from_course",args:{courseid:this.itemid,competencyid:deleteid}},{methodname:"tool_lp_data_for_course_competencies_page",args:{courseid:this.itemid,moduleid:0}}]),pagerender="tool_lp/course_competencies_page",pageregion="coursecompetenciespage"):"template"==this.itemtype?(requests=ajax.call([{methodname:"core_competency_remove_competency_from_template",args:{templateid:this.itemid,competencyid:deleteid}},{methodname:"tool_lp_data_for_template_competencies_page",args:{templateid:this.itemid,pagecontext:{contextid:this.pageContextId}}}]),pagerender="tool_lp/template_competencies_page",pageregion="templatecompetenciespage"):"plan"==this.itemtype&&(requests=ajax.call([{methodname:"core_competency_remove_competency_from_plan",args:{planid:this.itemid,competencyid:deleteid}},{methodname:"tool_lp_data_for_plan_page",args:{planid:this.itemid}}]),pagerender="tool_lp/plan_page",pageregion="plan-page"),requests[1].done((function(context){templates.render(pagerender,context).done((function(html,js){$('[data-region="'+pageregion+'"]').replaceWith(html),templates.runTemplateJS(js)})).fail(notification.exception)})).fail(notification.exception)},competencies.prototype.deleteHandler=function(deleteid){var message,localthis=this;if("course"==localthis.itemtype)message="unlinkcompetencycourse";else if("template"==localthis.itemtype)message="unlinkcompetencytemplate";else{if("plan"!=localthis.itemtype)return;message="unlinkcompetencyplan"}ajax.call([{methodname:"core_competency_read_competency",args:{id:deleteid}}])[0].done((function(competency){str.get_strings([{key:"confirm",component:"moodle"},{key:message,component:"tool_lp",param:competency.shortname},{key:"confirm",component:"moodle"},{key:"cancel",component:"moodle"}]).done((function(strings){notification.confirm(strings[0],strings[1],strings[2],strings[3],(function(){localthis.doDelete(deleteid)}))})).fail(notification.exception)})).fail(notification.exception)},competencies.prototype.registerEvents=function(){var localthis=this;"course"==localthis.itemtype&&$('[data-region="coursecompetenciespage"]').on("change",'select[data-field="ruleoutcome"]',(function(e){var pendingPromise=new Pending,coursecompetencyid=$(e.target).data("id"),ruleoutcome=$(e.target).val();ajax.call([{methodname:"core_competency_set_course_competency_ruleoutcome",args:{coursecompetencyid:coursecompetencyid,ruleoutcome:ruleoutcome}},{methodname:"tool_lp_data_for_course_competencies_page",args:{courseid:localthis.itemid,moduleid:0}}])[1].then((function(context){return templates.render("tool_lp/course_competencies_page",context)})).then((function(html,js){return templates.replaceNode($('[data-region="coursecompetenciespage"]'),html,js)})).then(pendingPromise.resolve).catch(notification.exception)})),$('[data-region="actions"] button').click((function(e){var pendingPromise=new Pending;e.preventDefault(),localthis.pickCompetency().then(pendingPromise.resolve).catch()})),$('[data-action="delete-competency-link"]').click((function(e){e.preventDefault();var deleteid=$(e.target).closest("[data-id]").data("id");localthis.deleteHandler(deleteid)}))},competencies}));

//# sourceMappingURL=competencies.min.js.map