/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid;

import com.birosoft.liquid.FileChooserBasicUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Position;
import sun.awt.shell.ShellFolder;

public class FileChooserBasicUI
extends BasicFileChooserUI {
    private static final Dimension hstrut5 = new Dimension(5, 1);
    private static final Dimension hstrut11 = new Dimension(11, 1);
    private static final Dimension vstrut5 = new Dimension(1, 5);
    private static final Insets shrinkwrap = new Insets(2, 2, 2, 2);
    private static int PREF_WIDTH = 500;
    private static int PREF_HEIGHT = 326;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 500;
    private static int MIN_HEIGHT = 326;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_PREF_WIDTH = 405;
    private static int LIST_PREF_HEIGHT = 135;
    private static Dimension LIST_PREF_SIZE = new Dimension(LIST_PREF_WIDTH, LIST_PREF_HEIGHT);
    private static final int COLUMN_FILENAME = 0;
    private static final int COLUMN_FILESIZE = 1;
    private static final int COLUMN_FILETYPE = 2;
    private static final int COLUMN_FILEDATE = 3;
    private static final int COLUMN_FILEATTR = 4;
    private static final int COLUMN_COLCOUNT = 5;
    static final int space = 10;
    private JPanel centerPanel;
    private JLabel lookInLabel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField fileNameTextField;
    private JToggleButton listViewButton;
    private JToggleButton detailsViewButton;
    private JPanel listViewPanel;
    private JPanel detailsViewPanel;
    private JPanel currentViewPanel;
    private FocusListener editorFocusListener = new 1(this);
    private boolean useShellFolder;
    private ListSelectionModel listSelectionModel;
    private JList list;
    private JTable detailsTable;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox filterComboBox;
    private int[] COLUMN_WIDTHS = new int[]{150, 75, 130, 130, 40};
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String listViewButtonToolTipText = null;
    private String listViewButtonAccessibleName = null;
    private String detailsViewButtonToolTipText = null;
    private String detailsViewButtonAccessibleName = null;
    private String fileNameHeaderText = null;
    private String fileSizeHeaderText = null;
    private String fileTypeHeaderText = null;
    private String fileDateHeaderText = null;
    private String fileAttrHeaderText = null;
    int lastIndex = -1;
    File editFile = null;
    int editX = 20;
    JTextField editCell = null;
    private static /* synthetic */ Class class$Ljava$io$File;
    private static /* synthetic */ Class class$Ljava$util$Date;
    private static /* synthetic */ Class class$Ljava$lang$Object;

    public static ComponentUI createUI(JComponent c) {
        return new FileChooserBasicUI((JFileChooser)c);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
    }

    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
        this.bottomPanel = null;
        this.buttonPanel = null;
    }

    public void installComponents(JFileChooser fc) {
        File[] cbFolders;
        FileSystemView fsv = fc.getFileSystemView();
        fc.setBorder(new EmptyBorder(12, 12, 11, 11));
        fc.setLayout(new BorderLayout(0, 11));
        JPanel topPanel = new JPanel(new BorderLayout(11, 0));
        JPanel topButtonPanel = new JPanel();
        topButtonPanel.setLayout(new BoxLayout(topButtonPanel, 2));
        topPanel.add((Component)topButtonPanel, "After");
        fc.add((Component)topPanel, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        topPanel.add((Component)this.lookInLabel, "Before");
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.0f);
        this.directoryComboBox.setMaximumRowCount(8);
        topPanel.add((Component)this.directoryComboBox, "Center");
        JButton upFolderButton = new JButton(this.getChangeToParentDirectoryAction());
        upFolderButton.putClientProperty("JToolBar.isToolbarButton", Boolean.TRUE);
        upFolderButton.setOpaque(false);
        upFolderButton.setText(null);
        upFolderButton.setIcon(this.upFolderIcon);
        upFolderButton.setToolTipText(this.upFolderToolTipText);
        upFolderButton.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        upFolderButton.setAlignmentX(0.0f);
        upFolderButton.setAlignmentY(0.5f);
        upFolderButton.setMargin(new Insets(5, 5, 5, 5));
        topButtonPanel.add(upFolderButton);
        topButtonPanel.add(Box.createRigidArea(hstrut5));
        File homeDir = fsv.getHomeDirectory();
        String toolTipText = this.homeFolderToolTipText;
        if (fsv.isRoot(homeDir)) {
            toolTipText = this.getFileView(fc).getName(homeDir);
        }
        JButton b = new JButton(this.homeFolderIcon);
        b.putClientProperty("JToolBar.isToolbarButton", Boolean.TRUE);
        b.setToolTipText(toolTipText);
        b.getAccessibleContext().setAccessibleName(this.homeFolderAccessibleName);
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.setMargin(new Insets(5, 5, 5, 5));
        b.addActionListener(this.getGoHomeAction());
        topButtonPanel.add(b);
        topButtonPanel.add(Box.createRigidArea(hstrut5));
        b = new JButton(this.getNewFolderAction());
        b.putClientProperty("JToolBar.isToolbarButton", Boolean.TRUE);
        b.setText(null);
        b.setIcon(this.newFolderIcon);
        b.setToolTipText(this.newFolderToolTipText);
        b.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.setMargin(new Insets(5, 5, 5, 5));
        topButtonPanel.add(b);
        topButtonPanel.add(Box.createRigidArea(hstrut5));
        ButtonGroup viewButtonGroup = new ButtonGroup();
        class ViewButtonListener
        implements ActionListener {
            JFileChooser fc;
            private final /* synthetic */ FileChooserBasicUI this$0;

            public void actionPerformed(ActionEvent e) {
                JToggleButton b = (JToggleButton)e.getSource();
                JPanel oldViewPanel = FileChooserBasicUI.access$6(this.this$0);
                if (b == FileChooserBasicUI.access$7(this.this$0)) {
                    if (FileChooserBasicUI.access$8(this.this$0) == null) {
                        FileChooserBasicUI.access$9(this.this$0, this.this$0.createDetailsView(this.fc));
                        FileChooserBasicUI.access$8(this.this$0).setPreferredSize(FileChooserBasicUI.access$10());
                    }
                    FileChooserBasicUI.access$11(this.this$0, FileChooserBasicUI.access$8(this.this$0));
                } else {
                    FileChooserBasicUI.access$11(this.this$0, FileChooserBasicUI.access$12(this.this$0));
                }
                if (FileChooserBasicUI.access$6(this.this$0) != oldViewPanel) {
                    FileChooserBasicUI.access$13(this.this$0).remove(oldViewPanel);
                    FileChooserBasicUI.access$13(this.this$0).add((Component)FileChooserBasicUI.access$6(this.this$0), "Center");
                    FileChooserBasicUI.access$13(this.this$0).revalidate();
                    FileChooserBasicUI.access$13(this.this$0).repaint();
                }
            }

            /* synthetic */ ViewButtonListener(FileChooserBasicUI this$0, JFileChooser fc) {
                this.this$0 = this$0;
                this.constructor$0(this$0, fc);
            }

            private final void constructor$0(FileChooserBasicUI fileChooserBasicUI, JFileChooser fc) {
                this.fc = fc;
            }
        }
        ViewButtonListener viewButtonListener = new ViewButtonListener(this, fc);
        this.listViewButton = new JToggleButton(this.listViewIcon);
        this.listViewButton.putClientProperty("JToolBar.isToolbarButton", Boolean.TRUE);
        this.listViewButton.setToolTipText(this.listViewButtonToolTipText);
        this.listViewButton.getAccessibleContext().setAccessibleName(this.listViewButtonAccessibleName);
        this.listViewButton.setSelected(true);
        this.listViewButton.setAlignmentX(0.0f);
        this.listViewButton.setAlignmentY(0.5f);
        this.listViewButton.setMargin(shrinkwrap);
        this.listViewButton.addActionListener(viewButtonListener);
        topButtonPanel.add(this.listViewButton);
        viewButtonGroup.add(this.listViewButton);
        this.detailsViewButton = new JToggleButton(this.detailsViewIcon);
        this.detailsViewButton.putClientProperty("JToolBar.isToolbarButton", Boolean.TRUE);
        this.detailsViewButton.setToolTipText(this.detailsViewButtonToolTipText);
        this.detailsViewButton.getAccessibleContext().setAccessibleName(this.detailsViewButtonAccessibleName);
        this.detailsViewButton.setAlignmentX(0.0f);
        this.detailsViewButton.setAlignmentY(0.5f);
        this.detailsViewButton.setMargin(shrinkwrap);
        this.detailsViewButton.addActionListener(viewButtonListener);
        topButtonPanel.add(this.detailsViewButton);
        viewButtonGroup.add(this.detailsViewButton);
        this.useShellFolder = false;
        File[] roots = fsv.getRoots();
        if (roots != null && roots.length == 1 && (cbFolders = (File[])ShellFolder.get("fileChooserComboBoxFolders")) != null && cbFolders.length > 0 && roots[0] == cbFolders[0]) {
            this.useShellFolder = true;
        }
        this.centerPanel = new JPanel(new BorderLayout());
        this.listViewPanel = this.createList(fc);
        this.listSelectionModel = this.list.getSelectionModel();
        this.listViewPanel.setPreferredSize(LIST_PREF_SIZE);
        this.centerPanel.add((Component)this.listViewPanel, "Center");
        this.currentViewPanel = this.listViewPanel;
        this.centerPanel.add((Component)this.getAccessoryPanel(), "After");
        JComponent accessory = fc.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        }
        fc.add((Component)this.centerPanel, "Center");
        JPanel bottomPanel = this.getBottomPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        fc.add((Component)bottomPanel, "South");
        JPanel fileNamePanel = new JPanel();
        fileNamePanel.setLayout(new BoxLayout(fileNamePanel, 2));
        bottomPanel.add(fileNamePanel);
        bottomPanel.add(Box.createRigidArea(vstrut5));
        AlignedLabel fileNameLabel = new AlignedLabel(this.fileNameLabelText);
        fileNameLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        fileNamePanel.add(fileNameLabel);
        this.fileNameTextField = new JTextField(this){
            private final /* synthetic */ FileChooserBasicUI this$0;

            public final Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(FileChooserBasicUI fileChooserBasicUI) {
            }
        };
        fileNamePanel.add(this.fileNameTextField);
        fileNameLabel.setLabelFor(this.fileNameTextField);
        this.fileNameTextField.addFocusListener(new FocusAdapter(this){
            private final /* synthetic */ FileChooserBasicUI this$0;

            public final void focusGained(FocusEvent e) {
                if (!this.this$0.getFileChooser().isMultiSelectionEnabled()) {
                    FileChooserBasicUI.access$14(this.this$0).clearSelection();
                }
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(FileChooserBasicUI fileChooserBasicUI) {
            }
        });
        if (fc.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(fc.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(fc.getSelectedFile()));
        }
        JPanel filesOfTypePanel = new JPanel();
        filesOfTypePanel.setLayout(new BoxLayout(filesOfTypePanel, 2));
        bottomPanel.add(filesOfTypePanel);
        AlignedLabel filesOfTypeLabel = new AlignedLabel(this.filesOfTypeLabelText);
        filesOfTypeLabel.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        filesOfTypePanel.add(filesOfTypeLabel);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        fc.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox(this.filterComboBoxModel);
        filesOfTypeLabel.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        filesOfTypePanel.add(this.filterComboBox);
        this.getButtonPanel().setLayout(new ButtonAreaLayout());
        this.approveButton = new JButton(this.getApproveButtonText(fc));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.getButtonPanel().add(this.approveButton);
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.getButtonPanel().add(this.cancelButton);
        if (fc.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
        FileChooserBasicUI.groupLabels(new AlignedLabel[]{fileNameLabel, filesOfTypeLabel});
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
        }
        return this.bottomPanel;
    }

    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        Locale l = fc.getLocale();
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", l);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", l);
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", l);
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", l);
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", l);
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", l);
        this.homeFolderToolTipText = UIManager.getString((Object)"FileChooser.homeFolderToolTipText", l);
        this.homeFolderAccessibleName = UIManager.getString((Object)"FileChooser.homeFolderAccessibleName", l);
        this.newFolderToolTipText = UIManager.getString((Object)"FileChooser.newFolderToolTipText", l);
        this.newFolderAccessibleName = UIManager.getString((Object)"FileChooser.newFolderAccessibleName", l);
        this.listViewButtonToolTipText = UIManager.getString((Object)"FileChooser.listViewButtonToolTipText", l);
        this.listViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.listViewButtonAccessibleName", l);
        this.detailsViewButtonToolTipText = UIManager.getString((Object)"FileChooser.detailsViewButtonToolTipText", l);
        this.detailsViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.detailsViewButtonAccessibleName", l);
        this.fileNameHeaderText = UIManager.getString((Object)"FileChooser.fileNameHeaderText", l);
        this.fileSizeHeaderText = UIManager.getString((Object)"FileChooser.fileSizeHeaderText", l);
        this.fileTypeHeaderText = UIManager.getString((Object)"FileChooser.fileTypeHeaderText", l);
        this.fileDateHeaderText = UIManager.getString((Object)"FileChooser.fileDateHeaderText", l);
        this.fileAttrHeaderText = UIManager.getString((Object)"FileChooser.fileAttrHeaderText", l);
    }

    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(fc, actionMap);
    }

    protected ActionMap getActionMap() {
        return this.createActionMap();
    }

    protected ActionMap createActionMap() {
        AbstractAction escAction = new AbstractAction(this){
            private final /* synthetic */ FileChooserBasicUI this$0;

            public final void actionPerformed(ActionEvent e) {
                if (this.this$0.editFile != null) {
                    FileChooserBasicUI.access$15(this.this$0);
                } else {
                    this.this$0.getFileChooser().cancelSelection();
                }
            }

            public final boolean isEnabled() {
                return this.this$0.getFileChooser().isEnabled();
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(FileChooserBasicUI fileChooserBasicUI) {
            }
        };
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("approveSelection", this.getApproveSelectionAction());
        map.put("cancelSelection", escAction);
        map.put("Go Up", this.getChangeToParentDirectoryAction());
        return map;
    }

    protected JPanel createList(JFileChooser fc) {
        JPanel p = new JPanel(new BorderLayout());
        JFileChooser fileChooser = fc;
        this.list = new JList(this, fileChooser){
            private final /* synthetic */ FileChooserBasicUI this$0;
            private final /* synthetic */ JFileChooser val$fileChooser;

            /*
             * Handled impossible loop by adding 'first' condition
             * Enabled aggressive block sorting
             */
            public final int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
                boolean bl;
                ListModel<E> model = this.getModel();
                int max = model.getSize();
                if (prefix == null) throw new IllegalArgumentException();
                if (startIndex < 0) throw new IllegalArgumentException();
                if (startIndex >= max) {
                    throw new IllegalArgumentException();
                }
                boolean backwards = bias == Position.Bias.Backward;
                int i = startIndex;
                boolean bl2 = true;
                do {
                    if (!bl2 || (bl2 = false) || !true) {
                        String filename = this.val$fileChooser.getName((File)model.getElementAt(i));
                        if (filename.regionMatches(true, 0, prefix, 0, prefix.length())) {
                            return i;
                        }
                        i += backwards ? -1 : 1;
                    }
                    if (backwards) {
                        if (i < 0) {
                            return -1;
                        }
                        bl = true;
                        continue;
                    }
                    if (i >= max) {
                        return -1;
                    }
                    bl = true;
                } while (bl);
                return -1;
            }
            {
                this.val$fileChooser = val$fileChooser;
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(FileChooserBasicUI fileChooserBasicUI) {
            }
        };
        this.list.setCellRenderer(new FileRenderer());
        this.list.setLayoutOrientation(1);
        this.list.setVisibleRowCount(-1);
        if (fc.isMultiSelectionEnabled()) {
            this.list.setSelectionMode(2);
        } else {
            this.list.setSelectionMode(0);
        }
        this.list.setModel(this.getModel());
        this.list.addListSelectionListener(this.createListSelectionListener(fc));
        this.list.addMouseListener(this.createDoubleClickListener(fc, this.list));
        this.list.addMouseListener(this.createSingleClickListener(fc, this.list));
        this.getModel().addListDataListener(new ListDataListener(this){
            private final /* synthetic */ FileChooserBasicUI this$0;

            public final void contentsChanged(ListDataEvent e) {
                FileChooserBasicUI fileChooserBasicUI = this.this$0;
                if (fileChooserBasicUI == null) {
                    throw null;
                }
                fileChooserBasicUI.new DelayedSelectionUpdater();
            }

            public final void intervalAdded(ListDataEvent e) {
                FileChooserBasicUI fileChooserBasicUI = this.this$0;
                if (fileChooserBasicUI == null) {
                    throw null;
                }
                fileChooserBasicUI.new DelayedSelectionUpdater();
            }

            public final void intervalRemoved(ListDataEvent e) {
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(FileChooserBasicUI fileChooserBasicUI) {
            }
        });
        JScrollPane scrollpane = new JScrollPane(this.list);
        p.add((Component)scrollpane, "Center");
        return p;
    }

    protected JPanel createDetailsView(JFileChooser fc) {
        JFileChooser chooser = fc;
        JPanel p = new JPanel(new BorderLayout());
        DetailsTableModel detailsTableModel = new DetailsTableModel(chooser);
        this.detailsTable = new JTable(this, chooser, detailsTableModel){
            private final /* synthetic */ FileChooserBasicUI this$0;
            private final /* synthetic */ JFileChooser val$chooser;

            protected final boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.getKeyCode() == 27 && this.getCellEditor() == null) {
                    this.val$chooser.dispatchEvent(e);
                    return true;
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }
            {
                this.val$chooser = val$chooser;
                this.this$0 = this$0;
                this.constructor$0(this$0, $1);
            }

            private final void constructor$0(FileChooserBasicUI fileChooserBasicUI, TableModel $1) {
            }
        };
        this.detailsTable.setComponentOrientation(chooser.getComponentOrientation());
        this.detailsTable.setAutoResizeMode(0);
        this.detailsTable.setShowGrid(false);
        this.detailsTable.setSelectionModel(this.listSelectionModel);
        this.detailsTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        Font font = this.detailsTable.getFont();
        this.detailsTable.setRowHeight(Math.max(font.getSize(), 19) + 3);
        TableColumnModel columnModel = this.detailsTable.getColumnModel();
        TableColumn[] columns = new TableColumn[5];
        int i = 0;
        while (i < 5) {
            columns[i] = columnModel.getColumn(i);
            columns[i].setPreferredWidth(this.COLUMN_WIDTHS[i]);
            ++i;
        }
        if (!System.getProperty("os.name").startsWith("Windows")) {
            columnModel.removeColumn(columns[2]);
            columnModel.removeColumn(columns[4]);
        }
        DetailsTableCellRenderer cellRenderer = new DetailsTableCellRenderer(chooser);
        this.detailsTable.setDefaultRenderer(class$Ljava$io$File != null ? class$Ljava$io$File : (class$Ljava$io$File = FileChooserBasicUI.class$("java.io.File")), cellRenderer);
        this.detailsTable.setDefaultRenderer(class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = FileChooserBasicUI.class$("java.util.Date")), cellRenderer);
        this.detailsTable.setDefaultRenderer(class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = FileChooserBasicUI.class$("java.lang.Object")), cellRenderer);
        JTextField tf = new JTextField();
        tf.addFocusListener(this.editorFocusListener);
        columns[0].setCellEditor(new DefaultCellEditor(this, chooser, tf, tf){
            private final /* synthetic */ FileChooserBasicUI this$0;
            private final /* synthetic */ JFileChooser val$chooser;
            private final /* synthetic */ JTextField val$tf;

            public final boolean isCellEditable(EventObject e) {
                if (e instanceof MouseEvent) {
                    MouseEvent me = (MouseEvent)e;
                    int index = FileChooserBasicUI.access$16(this.this$0).rowAtPoint(me.getPoint());
                    return me.getClickCount() == 1 && FileChooserBasicUI.access$16(this.this$0).isRowSelected(index);
                }
                return super.isCellEditable(e);
            }

            public final Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                if (value instanceof File) {
                    this.val$tf.setText(this.val$chooser.getName((File)value));
                    this.val$tf.requestFocus();
                    this.val$tf.selectAll();
                }
                return comp;
            }
            {
                this.val$chooser = val$chooser;
                this.val$tf = val$tf;
                this.this$0 = this$0;
                this.constructor$0(this$0, $1);
            }

            private final void constructor$0(FileChooserBasicUI fileChooserBasicUI, JTextField $1) {
            }
        });
        JList fakeList = new JList(this, detailsTableModel.listModel){
            JTable table;
            private final /* synthetic */ FileChooserBasicUI this$0;

            public final int locationToIndex(Point location) {
                return this.table.rowAtPoint(location);
            }

            public final Rectangle getCellBounds(int index0, int index1) {
                Rectangle r0 = this.table.getCellRect(index0, 0, false);
                Rectangle r1 = this.table.getCellRect(index1, 0, false);
                return r0.union(r1);
            }

            public final Object getSelectedValue() {
                return this.table.getValueAt(this.table.getSelectedRow(), 0);
            }

            public final Component add(Component comp) {
                if (comp instanceof JTextField) {
                    return this.table.add(comp);
                }
                return super.add(comp);
            }

            public final void repaint() {
                if (this.table != null) {
                    this.table.repaint();
                }
            }

            public final TransferHandler getTransferHandler() {
                if (this.table != null) {
                    return this.table.getTransferHandler();
                }
                return super.getTransferHandler();
            }

            public final void setTransferHandler(TransferHandler newHandler) {
                if (this.table != null) {
                    this.table.setTransferHandler(newHandler);
                } else {
                    super.setTransferHandler(newHandler);
                }
            }

            public final boolean getDragEnabled() {
                if (this.table != null) {
                    return this.table.getDragEnabled();
                }
                return super.getDragEnabled();
            }

            public final void setDragEnabled(boolean b) {
                if (this.table != null) {
                    this.table.setDragEnabled(b);
                } else {
                    super.setDragEnabled(b);
                }
            }
            {
                this.this$0 = this$0;
                this.table = FileChooserBasicUI.access$16(this.this$0);
                this.constructor$0(this$0, $1);
            }

            private final void constructor$0(FileChooserBasicUI fileChooserBasicUI, ListModel $1) {
            }
        };
        fakeList.setSelectionModel(this.listSelectionModel);
        this.detailsTable.addMouseListener(this.createDoubleClickListener(chooser, fakeList));
        JScrollPane scrollpane = new JScrollPane(this.detailsTable);
        scrollpane.setComponentOrientation(chooser.getComponentOrientation());
        LookAndFeel.installColors(scrollpane.getViewport(), "Table.background", "Table.foreground");
        scrollpane.addComponentListener(new ComponentAdapter(this){
            private final /* synthetic */ FileChooserBasicUI this$0;

            public final void componentResized(ComponentEvent e) {
                JScrollPane sp = (JScrollPane)e.getComponent();
                FileChooserBasicUI.access$18(this.this$0, sp.getViewport().getSize().width);
                sp.removeComponentListener(this);
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(FileChooserBasicUI fileChooserBasicUI) {
            }
        });
        p.add((Component)scrollpane, "Center");
        return p;
    }

    private final void fixNameColumnWidth(int viewWidth) {
        TableColumn nameCol = this.detailsTable.getColumnModel().getColumn(0);
        int tableWidth = this.detailsTable.getPreferredSize().width;
        if (tableWidth < viewWidth) {
            nameCol.setPreferredWidth(nameCol.getPreferredWidth() + viewWidth - tableWidth);
        }
    }

    public ListSelectionListener createListSelectionListener(JFileChooser fc) {
        return new BasicFileChooserUI.SelectionListener(this, this){
            private final /* synthetic */ FileChooserBasicUI this$0;

            public final void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    JFileChooser chooser = this.this$0.getFileChooser();
                    FileSystemView fsv = chooser.getFileSystemView();
                    JList list = (JList)e.getSource();
                    if (chooser.isMultiSelectionEnabled()) {
                        File[] files = null;
                        Object[] objects = list.getSelectedValues();
                        if (objects != null) {
                            if (objects.length == 1 && ((File)objects[0]).isDirectory() && chooser.isTraversable((File)objects[0]) && (chooser.getFileSelectionMode() == JFileChooser.FILES_ONLY || !fsv.isFileSystem((File)objects[0]))) {
                                this.this$0.setDirectorySelected(true);
                                FileChooserBasicUI.access$19(this.this$0, (File)objects[0]);
                            } else {
                                files = new File[objects.length];
                                int j = 0;
                                int i = 0;
                                while (i < objects.length) {
                                    File f = (File)objects[i];
                                    if (chooser.isFileSelectionEnabled() && f.isFile() || chooser.isDirectorySelectionEnabled() && fsv.isFileSystem(f) && f.isDirectory()) {
                                        files[j++] = f;
                                    }
                                    ++i;
                                }
                                if (j == 0) {
                                    files = null;
                                } else if (j < objects.length) {
                                    File[] tmpFiles = new File[j];
                                    System.arraycopy(files, 0, tmpFiles, 0, j);
                                    files = tmpFiles;
                                }
                                this.this$0.setDirectorySelected(false);
                            }
                        }
                        chooser.setSelectedFiles(files);
                    } else {
                        File file = (File)list.getSelectedValue();
                        if (file != null && file.isDirectory() && chooser.isTraversable(file) && (chooser.getFileSelectionMode() == JFileChooser.FILES_ONLY || !fsv.isFileSystem(file))) {
                            this.this$0.setDirectorySelected(true);
                            FileChooserBasicUI.access$19(this.this$0, file);
                            chooser.setSelectedFile(null);
                        } else {
                            this.this$0.setDirectorySelected(false);
                            if (file != null) {
                                chooser.setSelectedFile(file);
                            }
                        }
                    }
                }
            }
            {
                BasicFileChooserUI basicFileChooserUI = $0;
                if (basicFileChooserUI == null) {
                    throw null;
                }
                super(basicFileChooserUI);
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(FileChooserBasicUI fileChooserBasicUI) {
            }
        };
    }

    private final MouseListener createSingleClickListener(JFileChooser fc, JList list) {
        return new SingleClickListener(list);
    }

    private final int getEditIndex() {
        return this.lastIndex;
    }

    private final void setEditIndex(int i) {
        this.lastIndex = i;
    }

    private final void resetEditIndex() {
        this.lastIndex = -1;
    }

    private final void cancelEdit() {
        if (this.editFile != null) {
            this.editFile = null;
            this.list.remove(this.editCell);
            this.centerPanel.repaint();
        } else if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().cancelCellEditing();
        }
    }

    private final void editFileName(int index) {
        this.ensureIndexIsVisible(index);
        if (this.listViewPanel.isVisible()) {
            this.editFile = (File)this.getModel().getElementAt(index);
            Rectangle r = this.list.getCellBounds(index, index);
            if (this.editCell == null) {
                this.editCell = new JTextField();
                this.editCell.addActionListener(new EditActionListener());
                this.editCell.addFocusListener(this.editorFocusListener);
                this.editCell.setNextFocusableComponent(this.list);
            }
            this.list.add(this.editCell);
            this.editCell.setText(this.getFileChooser().getName(this.editFile));
            if (this.list.getComponentOrientation().isLeftToRight()) {
                this.editCell.setBounds(this.editX + r.x, r.y, r.width - this.editX, r.height);
            } else {
                this.editCell.setBounds(r.x, r.y, r.width - this.editX, r.height);
            }
            this.editCell.requestFocus();
            this.editCell.selectAll();
        } else if (this.detailsViewPanel.isVisible()) {
            this.detailsTable.editCellAt(index, 0);
        }
    }

    private final void applyEdit() {
        if (this.editFile != null && this.editFile.exists()) {
            JFileChooser chooser = this.getFileChooser();
            String oldDisplayName = chooser.getName(this.editFile);
            String oldFileName = this.editFile.getName();
            String newDisplayName = this.editCell.getText().trim();
            if (!newDisplayName.equals(oldDisplayName)) {
                FileSystemView fsv;
                File f2;
                int i2;
                String newFileName = newDisplayName;
                int i1 = oldFileName.length();
                if (i1 > (i2 = oldDisplayName.length()) && oldFileName.charAt(i2) == '.') {
                    newFileName = newDisplayName + oldFileName.substring(i2);
                }
                if (!(f2 = (fsv = chooser.getFileSystemView()).createFileObject(this.editFile.getParentFile(), newFileName)).exists() && this.getModel().renameFile(this.editFile, f2) && fsv.isParent(chooser.getCurrentDirectory(), f2)) {
                    if (chooser.isMultiSelectionEnabled()) {
                        chooser.setSelectedFiles(new File[]{f2});
                    } else {
                        chooser.setSelectedFile(f2);
                    }
                }
            }
        }
        if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().stopCellEditing();
        }
        this.cancelEdit();
    }

    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(c);
    }

    public Dimension getPreferredSize(JComponent c) {
        int prefWidth = FileChooserBasicUI.PREF_SIZE.width;
        Dimension d = c.getLayout().preferredLayoutSize(c);
        if (d != null) {
            return new Dimension(d.width < prefWidth ? prefWidth : d.width, d.height < FileChooserBasicUI.PREF_SIZE.height ? FileChooserBasicUI.PREF_SIZE.height : d.height);
        }
        return new Dimension(prefWidth, FileChooserBasicUI.PREF_SIZE.height);
    }

    public Dimension getMinimumSize(JComponent c) {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    void setFileSelected() {
        if (this.getFileChooser().isMultiSelectionEnabled() && !this.isDirectorySelected()) {
            int index;
            boolean found;
            File[] files = this.getFileChooser().getSelectedFiles();
            Object[] selectedObjects = this.list.getSelectedValues();
            int j = 0;
            while (j < selectedObjects.length) {
                found = false;
                int i = 0;
                while (i < files.length) {
                    if (files[i].equals(selectedObjects[j])) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found && (index = this.getModel().indexOf(selectedObjects[j])) >= 0) {
                    this.listSelectionModel.removeSelectionInterval(index, index);
                }
                ++j;
            }
            int i = 0;
            while (i < files.length) {
                found = false;
                int j2 = 0;
                while (j2 < selectedObjects.length) {
                    if (files[i].equals(selectedObjects[j2])) {
                        found = true;
                        break;
                    }
                    ++j2;
                }
                if (!found && (index = this.getModel().indexOf(files[i])) >= 0) {
                    this.listSelectionModel.addSelectionInterval(index, index);
                }
                ++i;
            }
        } else {
            int i;
            JFileChooser chooser = this.getFileChooser();
            File f = null;
            f = this.isDirectorySelected() ? this.getDirectory() : chooser.getSelectedFile();
            if (f != null && (i = this.getModel().indexOf(f)) >= 0) {
                this.listSelectionModel.setSelectionInterval(i, i);
                this.ensureIndexIsVisible(i);
            } else {
                this.listSelectionModel.clearSelection();
            }
        }
    }

    private final String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser fc = this.getFileChooser();
        if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private final String fileNameString(File[] files) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (files != null && i < files.length) {
            if (i > 0) {
                buf.append(" ");
            }
            if (files.length > 1) {
                buf.append("\"");
            }
            buf.append(this.fileNameString(files[i]));
            if (files.length > 1) {
                buf.append("\"");
            }
            ++i;
        }
        return buf.toString();
    }

    private final void doSelectedFileChanged(PropertyChangeEvent e) {
        this.applyEdit();
        File f = (File)e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (f != null && (fc.isFileSelectionEnabled() && !f.isDirectory() || f.isDirectory() && fc.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(f));
            this.setFileSelected();
        }
    }

    private final void doSelectedFilesChanged(PropertyChangeEvent e) {
        this.applyEdit();
        File[] files = (File[])e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || !files[0].isDirectory())) {
            this.setFileName(this.fileNameString(files));
            this.setFileSelected();
        }
    }

    private final void doDirectoryChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        this.ensureIndexIsVisible(0);
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null) {
            this.directoryComboBoxModel.addItem(currentDirectory);
            this.getNewFolderAction().setEnabled(currentDirectory.canWrite());
            this.getChangeToParentDirectoryAction().setEnabled(!fsv.isRoot(currentDirectory));
            if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
                if (fsv.isFileSystem(currentDirectory)) {
                    this.setFileName(currentDirectory.getPath());
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    private final void doFilterChanged(PropertyChangeEvent e) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
    }

    private final void doFileSelectionModeChanged(PropertyChangeEvent e) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearIconCache();
        this.listSelectionModel.clearSelection();
        JFileChooser fc = this.getFileChooser();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null && fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystem(currentDirectory)) {
            this.setFileName(currentDirectory.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private final void doMultiSelectionChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.listSelectionModel.setSelectionMode(2);
        } else {
            this.listSelectionModel.setSelectionMode(0);
            this.listSelectionModel.clearSelection();
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    private final void doAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent accessory;
            if (e.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)e.getOldValue());
            }
            if ((accessory = (JComponent)e.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)accessory, "Center");
            }
        }
    }

    private final void doApproveButtonTextChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
    }

    private final void doDialogTypeChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        if (chooser.getDialogType() == 1) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    private final void doApproveButtonMnemonicChanged(PropertyChangeEvent e) {
    }

    private final void doControlButtonsChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(this){
            private final /* synthetic */ FileChooserBasicUI this$0;

            public final void propertyChange(PropertyChangeEvent e) {
                String s = e.getPropertyName();
                if (s.equals("SelectedFileChangedProperty")) {
                    FileChooserBasicUI.access$20(this.this$0, e);
                } else if (s.equals("SelectedFilesChangedProperty")) {
                    FileChooserBasicUI.access$21(this.this$0, e);
                } else if (s.equals("directoryChanged")) {
                    FileChooserBasicUI.access$22(this.this$0, e);
                } else if (s.equals("fileFilterChanged")) {
                    FileChooserBasicUI.access$23(this.this$0, e);
                } else if (s.equals("fileSelectionChanged")) {
                    FileChooserBasicUI.access$24(this.this$0, e);
                } else if (s.equals("MultiSelectionEnabledChangedProperty")) {
                    FileChooserBasicUI.access$25(this.this$0, e);
                } else if (s.equals("AccessoryChangedProperty")) {
                    FileChooserBasicUI.access$26(this.this$0, e);
                } else if (s.equals("ApproveButtonTextChangedProperty") || s.equals("ApproveButtonToolTipTextChangedProperty")) {
                    FileChooserBasicUI.access$27(this.this$0, e);
                } else if (s.equals("DialogTypeChangedProperty")) {
                    FileChooserBasicUI.access$28(this.this$0, e);
                } else if (s.equals("ApproveButtonMnemonicChangedProperty")) {
                    FileChooserBasicUI.access$29(this.this$0, e);
                } else if (s.equals("ControlButtonsAreShownChangedProperty")) {
                    FileChooserBasicUI.access$30(this.this$0, e);
                } else if (s.equals("CancelSelection")) {
                    FileChooserBasicUI.access$0(this.this$0);
                } else if (s.equals("componentOrientation")) {
                    ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                    JFileChooser cc = (JFileChooser)e.getSource();
                    if (o != (ComponentOrientation)e.getOldValue()) {
                        cc.applyComponentOrientation(o);
                    }
                    if (FileChooserBasicUI.access$16(this.this$0) != null) {
                        FileChooserBasicUI.access$16(this.this$0).setComponentOrientation(o);
                        FileChooserBasicUI.access$16(this.this$0).getParent().getParent().setComponentOrientation(o);
                    }
                } else if (s.equals("ancestor") && e.getOldValue() == null && e.getNewValue() != null) {
                    FileChooserBasicUI.access$31(this.this$0).selectAll();
                    FileChooserBasicUI.access$31(this.this$0).requestFocus();
                }
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(FileChooserBasicUI fileChooserBasicUI) {
            }
        };
    }

    protected void removeControlButtons() {
        this.getBottomPanel().remove(this.getButtonPanel());
    }

    protected void addControlButtons() {
        this.getBottomPanel().add(this.getButtonPanel());
    }

    private final void ensureIndexIsVisible(int i) {
        if (i >= 0) {
            this.list.ensureIndexIsVisible(i);
            if (this.detailsTable != null) {
                this.detailsTable.scrollRectToVisible(this.detailsTable.getCellRect(i, 0, true));
            }
        }
    }

    public void ensureFileIsVisible(JFileChooser fc, File f) {
        this.ensureIndexIsVisible(this.getModel().indexOf(f));
    }

    public void rescanCurrentDirectory(JFileChooser fc) {
        this.getModel().validateFileCache();
    }

    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    public void setFileName(String filename) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(filename);
        }
    }

    protected void setDirectorySelected(boolean directorySelected) {
        super.setDirectorySelected(directorySelected);
        JFileChooser chooser = this.getFileChooser();
        if (directorySelected) {
            this.approveButton.setText(this.directoryOpenButtonText);
            this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
        } else {
            this.approveButton.setText(this.getApproveButtonText(chooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        }
    }

    public String getDirectoryName() {
        return null;
    }

    public void setDirectoryName(String dirname) {
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new DirectoryComboBoxRenderer(this);
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent e) {
        JFileChooser fc = this.getFileChooser();
        File f = fc.getSelectedFile();
        if (!e.getValueIsAdjusting() && f != null && !this.getFileChooser().isTraversable(f)) {
            this.setFileName(this.fileNameString(f));
        }
    }

    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    private static final void groupLabels(AlignedLabel[] group) {
        int i = 0;
        while (i < group.length) {
            group[i].group = group;
            ++i;
        }
    }

    static /* synthetic */ JPanel access$6(FileChooserBasicUI fileChooserBasicUI) {
        return fileChooserBasicUI.currentViewPanel;
    }

    static /* synthetic */ JToggleButton access$7(FileChooserBasicUI fileChooserBasicUI) {
        return fileChooserBasicUI.detailsViewButton;
    }

    static /* synthetic */ JPanel access$8(FileChooserBasicUI fileChooserBasicUI) {
        return fileChooserBasicUI.detailsViewPanel;
    }

    static /* synthetic */ void access$9(FileChooserBasicUI fileChooserBasicUI, JPanel jPanel) {
        fileChooserBasicUI.detailsViewPanel = jPanel;
    }

    static /* synthetic */ Dimension access$10() {
        return LIST_PREF_SIZE;
    }

    static /* synthetic */ void access$11(FileChooserBasicUI fileChooserBasicUI, JPanel jPanel) {
        fileChooserBasicUI.currentViewPanel = jPanel;
    }

    static /* synthetic */ JPanel access$12(FileChooserBasicUI fileChooserBasicUI) {
        return fileChooserBasicUI.listViewPanel;
    }

    static /* synthetic */ JPanel access$13(FileChooserBasicUI fileChooserBasicUI) {
        return fileChooserBasicUI.centerPanel;
    }

    static /* synthetic */ ListSelectionModel access$14(FileChooserBasicUI fileChooserBasicUI) {
        return fileChooserBasicUI.listSelectionModel;
    }

    static /* synthetic */ void access$15(FileChooserBasicUI fileChooserBasicUI) {
        fileChooserBasicUI.cancelEdit();
    }

    static /* synthetic */ JTable access$16(FileChooserBasicUI fileChooserBasicUI) {
        return fileChooserBasicUI.detailsTable;
    }

    static /* synthetic */ int access$17() {
        return COLUMN_FILENAME;
    }

    static /* synthetic */ void access$18(FileChooserBasicUI fileChooserBasicUI, int n) {
        fileChooserBasicUI.fixNameColumnWidth(n);
    }

    static /* synthetic */ void access$19(FileChooserBasicUI fileChooserBasicUI, File file) {
        super.setDirectory(file);
    }

    static /* synthetic */ void access$20(FileChooserBasicUI fileChooserBasicUI, PropertyChangeEvent propertyChangeEvent) {
        fileChooserBasicUI.doSelectedFileChanged(propertyChangeEvent);
    }

    static /* synthetic */ void access$21(FileChooserBasicUI fileChooserBasicUI, PropertyChangeEvent propertyChangeEvent) {
        fileChooserBasicUI.doSelectedFilesChanged(propertyChangeEvent);
    }

    static /* synthetic */ void access$22(FileChooserBasicUI fileChooserBasicUI, PropertyChangeEvent propertyChangeEvent) {
        fileChooserBasicUI.doDirectoryChanged(propertyChangeEvent);
    }

    static /* synthetic */ void access$23(FileChooserBasicUI fileChooserBasicUI, PropertyChangeEvent propertyChangeEvent) {
        fileChooserBasicUI.doFilterChanged(propertyChangeEvent);
    }

    static /* synthetic */ void access$24(FileChooserBasicUI fileChooserBasicUI, PropertyChangeEvent propertyChangeEvent) {
        fileChooserBasicUI.doFileSelectionModeChanged(propertyChangeEvent);
    }

    static /* synthetic */ void access$25(FileChooserBasicUI fileChooserBasicUI, PropertyChangeEvent propertyChangeEvent) {
        fileChooserBasicUI.doMultiSelectionChanged(propertyChangeEvent);
    }

    static /* synthetic */ void access$26(FileChooserBasicUI fileChooserBasicUI, PropertyChangeEvent propertyChangeEvent) {
        fileChooserBasicUI.doAccessoryChanged(propertyChangeEvent);
    }

    static /* synthetic */ void access$27(FileChooserBasicUI fileChooserBasicUI, PropertyChangeEvent propertyChangeEvent) {
        fileChooserBasicUI.doApproveButtonTextChanged(propertyChangeEvent);
    }

    static /* synthetic */ void access$28(FileChooserBasicUI fileChooserBasicUI, PropertyChangeEvent propertyChangeEvent) {
        fileChooserBasicUI.doDialogTypeChanged(propertyChangeEvent);
    }

    static /* synthetic */ void access$29(FileChooserBasicUI fileChooserBasicUI, PropertyChangeEvent propertyChangeEvent) {
        fileChooserBasicUI.doApproveButtonMnemonicChanged(propertyChangeEvent);
    }

    static /* synthetic */ void access$30(FileChooserBasicUI fileChooserBasicUI, PropertyChangeEvent propertyChangeEvent) {
        fileChooserBasicUI.doControlButtonsChanged(propertyChangeEvent);
    }

    static /* synthetic */ JTextField access$31(FileChooserBasicUI fileChooserBasicUI) {
        return fileChooserBasicUI.fileNameTextField;
    }

    static /* synthetic */ int access$32() {
        return COLUMN_COLCOUNT;
    }

    static /* synthetic */ int access$35() {
        return COLUMN_FILEDATE;
    }

    static /* synthetic */ int access$38() {
        return COLUMN_FILESIZE;
    }

    static /* synthetic */ int access$39() {
        return COLUMN_FILETYPE;
    }

    static /* synthetic */ int access$40() {
        return COLUMN_FILEATTR;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public FileChooserBasicUI(JFileChooser filechooser) {
        super(filechooser);
    }

    class DetailsTableModel
    extends AbstractTableModel
    implements ListDataListener {
        String[] columnNames;
        JFileChooser chooser;
        ListModel listModel;

        public int getRowCount() {
            return this.listModel.getSize();
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    Class clazz;
                    if (class$Ljava$io$File != null) {
                        clazz = class$Ljava$io$File;
                    } else {
                        Class clazz2 = FileChooserBasicUI.class$("java.io.File");
                        clazz = clazz2;
                        class$Ljava$io$File = clazz2;
                    }
                    return clazz;
                }
                case 3: {
                    Class clazz;
                    if (class$Ljava$util$Date != null) {
                        clazz = class$Ljava$util$Date;
                    } else {
                        Class clazz3 = FileChooserBasicUI.class$("java.util.Date");
                        clazz = clazz3;
                        class$Ljava$util$Date = clazz3;
                    }
                    return clazz;
                }
            }
            return super.getColumnClass(column);
        }

        public Object getValueAt(int row, int col) {
            File f = (File)this.listModel.getElementAt(row);
            switch (col) {
                case 0: {
                    return f;
                }
                case 1: {
                    if (!f.exists() || f.isDirectory()) {
                        return null;
                    }
                    long len = f.length() / 1024L;
                    if (len < 1024L) {
                        return (len == 0L ? 1L : len) + " KB";
                    }
                    if ((len /= 1024L) < 1024L) {
                        return len + " MB";
                    }
                    return (len /= 1024L) + " GB";
                }
                case 2: {
                    if (!f.exists()) {
                        return null;
                    }
                    return this.chooser.getFileSystemView().getSystemTypeDescription(f);
                }
                case 3: {
                    if (!f.exists() || this.chooser.getFileSystemView().isFileSystemRoot(f)) {
                        return null;
                    }
                    long time = f.lastModified();
                    return time == 0L ? null : new Date(time);
                }
                case 4: {
                    if (!f.exists() || this.chooser.getFileSystemView().isFileSystemRoot(f)) {
                        return null;
                    }
                    String attributes = "";
                    if (!f.canWrite()) {
                        attributes = attributes + "R";
                    }
                    if (f.isHidden()) {
                        attributes = attributes + "H";
                    }
                    return attributes;
                }
            }
            return null;
        }

        public void setValueAt(Object value, int row, int col) {
            block6: {
                if (col != 0) break block6;
                JFileChooser chooser = FileChooserBasicUI.this.getFileChooser();
                File f = (File)this.getValueAt(row, col);
                if (f != null) {
                    String oldDisplayName = chooser.getName(f);
                    String oldFileName = f.getName();
                    String newDisplayName = ((String)value).trim();
                    if (!newDisplayName.equals(oldDisplayName)) {
                        FileSystemView fsv;
                        File f2;
                        int i2;
                        String newFileName = newDisplayName;
                        int i1 = oldFileName.length();
                        if (i1 > (i2 = oldDisplayName.length()) && oldFileName.charAt(i2) == '.') {
                            newFileName = newDisplayName + oldFileName.substring(i2);
                        }
                        if (!(f2 = (fsv = chooser.getFileSystemView()).createFileObject(f.getParentFile(), newFileName)).exists() && FileChooserBasicUI.this.getModel().renameFile(f, f2) && fsv.isParent(chooser.getCurrentDirectory(), f2)) {
                            if (chooser.isMultiSelectionEnabled()) {
                                chooser.setSelectedFiles(new File[]{f2});
                            } else {
                                chooser.setSelectedFile(f2);
                            }
                        }
                    }
                }
            }
        }

        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        public void contentsChanged(ListDataEvent e) {
            this.fireTableDataChanged();
        }

        public void intervalAdded(ListDataEvent e) {
            this.fireTableDataChanged();
        }

        public void intervalRemoved(ListDataEvent e) {
            this.fireTableDataChanged();
        }

        DetailsTableModel(JFileChooser fc) {
            this.columnNames = new String[]{FileChooserBasicUI.this.fileNameHeaderText, FileChooserBasicUI.this.fileSizeHeaderText, FileChooserBasicUI.this.fileTypeHeaderText, FileChooserBasicUI.this.fileDateHeaderText, FileChooserBasicUI.this.fileAttrHeaderText};
            this.chooser = fc;
            this.listModel = FileChooserBasicUI.this.getModel();
            this.listModel.addListDataListener(this);
        }
    }

    class DetailsTableCellRenderer
    extends DefaultTableCellRenderer {
        JFileChooser chooser;
        DateFormat df;

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 1 || column == 4) {
                this.setHorizontalAlignment(11);
            } else {
                this.setHorizontalAlignment(10);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        public void setValue(Object value) {
            this.setIcon(null);
            if (value instanceof File) {
                File file = (File)value;
                String fileName = this.chooser.getName(file);
                this.setText(fileName);
                Icon icon = this.chooser.getIcon(file);
                this.setIcon(icon);
            } else if (value instanceof Date) {
                this.setText(value == null ? "" : this.df.format((Date)value));
            } else {
                super.setValue(value);
            }
        }

        DetailsTableCellRenderer(JFileChooser chooser) {
            this.chooser = chooser;
            this.df = DateFormat.getDateTimeInstance(3, 3, chooser.getLocale());
        }
    }

    private class DelayedSelectionUpdater
    implements Runnable {
        public void run() {
            FileChooserBasicUI.this.setFileSelected();
        }

        DelayedSelectionUpdater() {
            SwingUtilities.invokeLater(this);
        }
    }

    protected class SingleClickListener
    extends MouseAdapter {
        JList list;

        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (e.getClickCount() == 1) {
                    JFileChooser fc = FileChooserBasicUI.this.getFileChooser();
                    int index = this.list.locationToIndex(e.getPoint());
                    if ((!fc.isMultiSelectionEnabled() || fc.getSelectedFiles().length <= 1) && index >= 0 && this.list.isSelectedIndex(index) && FileChooserBasicUI.this.getEditIndex() == index && FileChooserBasicUI.this.editFile == null) {
                        FileChooserBasicUI.this.editFileName(index);
                    } else if (index >= 0) {
                        FileChooserBasicUI.this.setEditIndex(index);
                    } else {
                        FileChooserBasicUI.this.resetEditIndex();
                    }
                } else {
                    FileChooserBasicUI.this.resetEditIndex();
                }
            }
        }

        public SingleClickListener(JList list) {
            this.list = list;
        }
    }

    class EditActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            FileChooserBasicUI.this.applyEdit();
        }

        EditActionListener() {
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            File file = (File)value;
            String fileName = FileChooserBasicUI.this.getFileChooser().getName(file);
            this.setText(fileName);
            Icon icon = FileChooserBasicUI.this.getFileChooser().getIcon(file);
            this.setIcon(icon);
            if (isSelected) {
                FileChooserBasicUI.this.editX = icon.getIconWidth() + 4;
            }
            return this;
        }

        FileRenderer() {
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;
        private final /* synthetic */ FileChooserBasicUI this$0;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("");
                return this;
            }
            File directory = (File)value;
            this.setText(this.this$0.getFileChooser().getName(directory));
            this.ii.icon = icon = this.this$0.getFileChooser().getIcon(directory);
            this.ii.depth = this.this$0.directoryComboBoxModel.getDepth(index);
            this.setIcon(this.ii);
            return this;
        }

        DirectoryComboBoxRenderer(FileChooserBasicUI fileChooserBasicUI) {
            FileChooserBasicUI fileChooserBasicUI2 = this.this$0 = fileChooserBasicUI;
            if (fileChooserBasicUI2 == null) {
                throw null;
            }
            this.ii = fileChooserBasicUI2.new IndentIcon();
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(c, g, x + this.depth * 10, y);
            } else {
                this.icon.paintIcon(c, g, x, y);
            }
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        IndentIcon() {
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser = FileChooserBasicUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        private final void addItem(File directory) {
            File[] baseFolders;
            if (directory == null) {
                return;
            }
            this.directories.clear();
            if (FileChooserBasicUI.this.useShellFolder) {
                File[] fileArray = (File[])ShellFolder.get("fileChooserComboBoxFolders");
            } else {
                baseFolders = this.fsv.getRoots();
            }
            this.directories.addAll(Arrays.asList(baseFolders));
            File canonical = null;
            try {
                canonical = directory.getCanonicalFile();
            }
            catch (IOException e) {
                canonical = directory;
            }
            try {
                ShellFolder sf;
                File f = sf = ShellFolder.getShellFolder(canonical);
                Vector<ShellFolder> path = new Vector<ShellFolder>(10);
                do {
                    path.addElement((ShellFolder)f);
                } while ((f = ((File)f).getParentFile()) != null);
                int pathCount = path.size();
                int i = 0;
                while (i < pathCount) {
                    f = (File)path.get(i);
                    if (this.directories.contains(f)) {
                        int topIndex = this.directories.indexOf(f);
                        int j = i - 1;
                        while (j >= 0) {
                            this.directories.insertElementAt(path.get(j), topIndex + i - j);
                            --j;
                        }
                        break;
                    }
                    ++i;
                }
                this.calculateDepths();
                this.setSelectedItem(sf);
            }
            catch (FileNotFoundException ex) {
                this.calculateDepths();
            }
        }

        private final void calculateDepths() {
            this.depths = new int[this.directories.size()];
            int i = 0;
            while (i < this.depths.length) {
                File dir = (File)this.directories.get(i);
                File parent = dir.getParentFile();
                this.depths[i] = 0;
                if (parent != null) {
                    int j = i - 1;
                    while (j >= 0) {
                        if (parent.equals((File)this.directories.get(j))) {
                            this.depths[i] = this.depths[j] + 1;
                            break;
                        }
                        --j;
                    }
                }
                ++i;
            }
        }

        public int getDepth(int i) {
            return this.depths != null && i >= 0 && i < this.depths.length ? this.depths[i] : 0;
        }

        public void setSelectedItem(Object selectedDirectory) {
            this.selectedDirectory = (File)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }

        public DirectoryComboBoxModel() {
            File dir = FileChooserBasicUI.this.getFileChooser().getCurrentDirectory();
            if (dir != null) {
                this.addItem(dir);
            }
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof FileFilter) {
                this.setText(((FileFilter)value).getDescription());
            }
            return this;
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object filter) {
            if (filter != null) {
                FileChooserBasicUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                FileChooserBasicUI.this.setFileName(null);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter currentFilter = FileChooserBasicUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                int i = 0;
                while (i < this.filters.length) {
                    if (this.filters[i] == currentFilter) {
                        found = true;
                    }
                    ++i;
                }
                if (!found) {
                    FileChooserBasicUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return FileChooserBasicUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return FileChooserBasicUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }

        protected FilterComboBoxModel() {
            this.filters = FileChooserBasicUI.this.getFileChooser().getChoosableFileFilters();
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            File f = (File)FileChooserBasicUI.this.directoryComboBox.getSelectedItem();
            FileChooserBasicUI.this.getFileChooser().setCurrentDirectory(f);
        }

        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }
    }

    private static class ButtonAreaLayout
    implements LayoutManager {
        private int hGap = 5;
        private int topMargin = 17;

        public void addLayoutComponent(String string, Component comp) {
        }

        public void layoutContainer(Container container) {
            Component[] children = container.getComponents();
            if (children != null && children.length > 0) {
                int xOffset;
                int xLocation;
                int numChildren = children.length;
                Dimension[] sizes = new Dimension[numChildren];
                Insets insets = container.getInsets();
                int yLocation = insets.top + this.topMargin;
                int maxWidth = 0;
                int counter = 0;
                while (counter < numChildren) {
                    sizes[counter] = children[counter].getPreferredSize();
                    maxWidth = Math.max(maxWidth, sizes[counter].width);
                    ++counter;
                }
                if (container.getComponentOrientation().isLeftToRight()) {
                    xLocation = container.getSize().width - insets.left - maxWidth;
                    int n = this.hGap + maxWidth;
                } else {
                    xLocation = insets.left;
                    xOffset = -(this.hGap + maxWidth);
                }
                int counter2 = numChildren - 1;
                while (counter2 >= 0) {
                    children[counter2].setBounds(xLocation, yLocation, maxWidth, sizes[counter2].height);
                    xLocation -= xOffset;
                    --counter2;
                }
            }
        }

        public Dimension minimumLayoutSize(Container c) {
            Component[] children;
            if (c != null && (children = c.getComponents()) != null && children.length > 0) {
                int numChildren = children.length;
                int height = 0;
                Insets cInsets = c.getInsets();
                int extraHeight = this.topMargin + cInsets.top + cInsets.bottom;
                int extraWidth = cInsets.left + cInsets.right;
                int maxWidth = 0;
                int counter = 0;
                while (counter < numChildren) {
                    Dimension aSize = children[counter].getPreferredSize();
                    height = Math.max(height, aSize.height);
                    maxWidth = Math.max(maxWidth, aSize.width);
                    ++counter;
                }
                return new Dimension(extraWidth + numChildren * maxWidth + (numChildren - 1) * this.hGap, extraHeight + height);
            }
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        public void removeLayoutComponent(Component c) {
        }

        ButtonAreaLayout() {
        }
    }

    private class AlignedLabel
    extends JLabel {
        private AlignedLabel[] group;
        private int maxWidth = 0;

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return new Dimension(this.getMaxWidth() + 11, d.height);
        }

        private final int getMaxWidth() {
            if (this.maxWidth == 0 && this.group != null) {
                int max = 0;
                int i = 0;
                while (i < this.group.length) {
                    max = Math.max(this.group[i].getSuperPreferredWidth(), max);
                    ++i;
                }
                i = 0;
                while (i < this.group.length) {
                    this.group[i].maxWidth = max;
                    ++i;
                }
            }
            return this.maxWidth;
        }

        private final int getSuperPreferredWidth() {
            return super.getPreferredSize().width;
        }

        static /* synthetic */ AlignedLabel[] access$0(AlignedLabel alignedLabel) {
            return alignedLabel.group;
        }

        AlignedLabel(String text) {
            super(text);
            this.setAlignmentX(0.0f);
        }
    }
}

