/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util.nio;

import htsjdk.samtools.util.Log;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;

public class DeleteOnExitPathHook {
    private static final Log LOG = Log.getInstance(DeleteOnExitPathHook.class);
    private static LinkedHashSet<Path> paths = new LinkedHashSet();

    private DeleteOnExitPathHook() {
    }

    public static synchronized void add(Path path) {
        if (paths == null) {
            throw new IllegalStateException("Shutdown in progress");
        }
        paths.add(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runHooks() {
        Class<DeleteOnExitPathHook> clazz = DeleteOnExitPathHook.class;
        synchronized (DeleteOnExitPathHook.class) {
            LinkedHashSet<Path> thePaths = paths;
            paths = null;
            // ** MonitorExit[var1] (shouldn't be in output)
            ArrayList<Path> toBeDeleted = new ArrayList<Path>(thePaths);
            Collections.reverse(toBeDeleted);
            for (Path path : toBeDeleted) {
                try {
                    Files.delete(path);
                }
                catch (Exception e) {
                    LOG.debug(e, "Failed to delete file: ", path, " during shutdown because we encountered an exception.");
                }
            }
            return;
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(DeleteOnExitPathHook::runHooks));
    }
}

