/*
 * Decompiled with CFR 0.152.
 */
package imp;

import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.stream.IntStream;
import vcf.Marker;

public final class ImputedRecBuilder {
    private static final DecimalFormat DF = new DecimalFormat("#.##");
    private static final DecimalFormat DF2 = new DecimalFormat("0.00");
    private static final DecimalFormat DF4 = new DecimalFormat("0.0000");
    private static final String[] DS_VALS = (String[])IntStream.range(0, 201).mapToObj(n -> DF.format((double)n / 100.0)).toArray(String[]::new);
    private static final String[] R2_VALS = (String[])IntStream.range(0, 101).limit(101L).mapToObj(n -> DS_VALS[n].length() != 4 ? DF2.format((double)n / 100.0) : DS_VALS[n]).toArray(String[]::new);
    private static final String[] DEFAULT_HOM_REF_FIELDS = ImputedRecBuilder.defaultHomRefFields();
    private final Marker marker;
    private final int nAlleles;
    private final int nInputTargHaps;
    private final boolean ap;
    private final boolean gp;
    private final float[] sumAlProbs;
    private final float[] sumAlProbs2;
    private final String[] homRefField;
    private final StringBuilder sampleData;
    private int hapCnt;

    public ImputedRecBuilder(Marker marker, int n, boolean bl, boolean bl2) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.marker = marker;
        this.nAlleles = marker.nAlleles();
        this.nInputTargHaps = n;
        this.ap = bl;
        this.gp = bl2;
        this.sumAlProbs = new float[this.nAlleles];
        this.sumAlProbs2 = new float[this.nAlleles];
        this.sampleData = new StringBuilder(200 + n * 5);
        this.homRefField = bl || bl2 ? ImputedRecBuilder.homRefFields(bl, bl2) : DEFAULT_HOM_REF_FIELDS;
        this.hapCnt = 0;
    }

    public Marker marker() {
        return this.marker;
    }

    public int nInputTargHaps() {
        return this.nInputTargHaps;
    }

    public int hapCnt() {
        return this.hapCnt;
    }

    public void addSampleData(float[] fArray, float[] fArray2) {
        this.hapCnt += 2;
        if (fArray[0] == 1.0f && fArray2[0] == 1.0f && fArray.length < DEFAULT_HOM_REF_FIELDS.length) {
            this.sampleData.append(this.homRefField[fArray.length]);
        } else {
            float f;
            int n;
            ImputedRecBuilder.scale(fArray);
            ImputedRecBuilder.scale(fArray2);
            this.sampleData.append('\t');
            this.sampleData.append(ImputedRecBuilder.maxIndex(fArray));
            this.sampleData.append('|');
            this.sampleData.append(ImputedRecBuilder.maxIndex(fArray2));
            for (n = 1; n < this.nAlleles; ++n) {
                float f2 = fArray[n] + fArray2[n];
                f = fArray[n] * fArray[n] + fArray2[n] * fArray2[n];
                int n2 = n;
                this.sumAlProbs[n2] = this.sumAlProbs[n2] + f2;
                int n3 = n;
                this.sumAlProbs2[n3] = this.sumAlProbs2[n3] + f;
                this.sampleData.append(n == 1 ? (char)':' : ',');
                this.sampleData.append(DS_VALS[(int)Math.rint(100.0f * f2)]);
            }
            if (this.ap) {
                for (n = 1; n < this.nAlleles; ++n) {
                    this.sampleData.append(n == 1 ? (char)':' : ',');
                    this.sampleData.append(DS_VALS[(int)Math.rint(100.0f * fArray[n])]);
                }
                for (n = 1; n < this.nAlleles; ++n) {
                    this.sampleData.append(n == 1 ? (char)':' : ',');
                    this.sampleData.append(DS_VALS[(int)Math.rint(100.0f * fArray2[n])]);
                }
            }
            if (this.gp) {
                for (n = 0; n < this.nAlleles; ++n) {
                    for (int i = 0; i <= n; ++i) {
                        f = fArray[i] * fArray2[n];
                        if (i != n) {
                            f += fArray[n] * fArray2[i];
                        }
                        this.sampleData.append(n == 0 ? (char)':' : ',');
                        this.sampleData.append(DS_VALS[(int)Math.rint(100.0f * f)]);
                    }
                }
            }
        }
    }

    public void addSampleData(float[] fArray) {
        int n;
        ++this.hapCnt;
        ImputedRecBuilder.scale(fArray);
        this.sampleData.append('\t');
        this.sampleData.append(ImputedRecBuilder.maxIndex(fArray));
        for (n = 1; n < this.nAlleles; ++n) {
            float f = fArray[n];
            float f2 = fArray[n] * fArray[n];
            int n2 = n;
            this.sumAlProbs[n2] = this.sumAlProbs[n2] + f;
            int n3 = n;
            this.sumAlProbs2[n3] = this.sumAlProbs2[n3] + f2;
            this.sampleData.append(n == 1 ? (char)':' : ',');
            this.sampleData.append(DS_VALS[(int)Math.rint(100.0f * f)]);
        }
        if (this.ap) {
            for (n = 1; n < this.nAlleles; ++n) {
                this.sampleData.append(n == 1 ? (char)':' : ',');
                this.sampleData.append(DS_VALS[(int)Math.rint(100.0f * fArray[n])]);
            }
        }
    }

    private static void scale(float[] fArray) {
        float f = 0.0f;
        for (float f2 : fArray) {
            f += f2;
        }
        int n = 0;
        while (n < fArray.length) {
            int n2 = n++;
            fArray[n2] = fArray[n2] / f;
        }
    }

    private static int maxIndex(float[] fArray) {
        int n = 0;
        for (int i = 1; i < fArray.length; ++i) {
            if (!(fArray[i] > fArray[n])) continue;
            n = i;
        }
        return n;
    }

    public void printRec(PrintWriter printWriter, boolean bl) {
        if (this.hapCnt != this.nInputTargHaps) {
            throw new IllegalStateException("inconsistent data");
        }
        ImputedRecBuilder.printMarkerFields(this.marker, printWriter);
        printWriter.print('\t');
        printWriter.print('.');
        printWriter.print('\t');
        printWriter.print("PASS");
        printWriter.print('\t');
        this.printInfoField(printWriter, bl);
        printWriter.print('\t');
        printWriter.print("GT:DS");
        if (this.ap) {
            printWriter.print(":AP1:AP2");
        }
        if (this.gp) {
            printWriter.print(":GP");
        }
        printWriter.println(this.sampleData);
    }

    private static void printMarkerFields(Marker marker, PrintWriter printWriter) {
        int n;
        printWriter.print(marker.chrom());
        printWriter.print('\t');
        printWriter.print(marker.pos());
        int n2 = marker.nIds();
        if (n2 == 0) {
            printWriter.print('\t');
            printWriter.print('.');
        } else {
            for (n = 0; n < n2; ++n) {
                printWriter.print(n == 0 ? (char)'\t' : ';');
                printWriter.print(marker.id(n));
            }
        }
        n = marker.nAlleles();
        if (n == 1) {
            printWriter.print('\t');
            printWriter.print(marker.allele(0));
            printWriter.print('\t');
            printWriter.print('.');
        } else {
            for (int i = 0; i < n; ++i) {
                printWriter.print(i < 2 ? (char)'\t' : ',');
                printWriter.print(marker.allele(i));
            }
        }
    }

    private void printInfoField(PrintWriter printWriter, boolean bl) {
        if (this.nAlleles == 1) {
            if (bl) {
                printWriter.print("IMP");
            }
        } else {
            int n;
            for (n = 1; n < this.nAlleles; ++n) {
                printWriter.print(n == 1 ? "DR2=" : Character.valueOf(','));
                printWriter.print(R2_VALS[(int)Math.rint(100.0f * this.r2(n))]);
            }
            for (n = 1; n < this.nAlleles; ++n) {
                printWriter.print(n == 1 ? ";AF=" : Character.valueOf(','));
                printWriter.print(DF4.format(this.sumAlProbs[n] / (float)this.nInputTargHaps));
            }
            if (this.marker.end() != -1) {
                printWriter.print(";END=");
                printWriter.print(this.marker.end());
            }
            if (bl) {
                printWriter.print(";IMP");
            }
        }
    }

    private float r2(int n) {
        float f = this.sumAlProbs[n];
        if (f == 0.0f) {
            return 0.0f;
        }
        float f2 = this.sumAlProbs2[n];
        float f3 = f * f / (float)this.nInputTargHaps;
        float f4 = f2 - f3;
        float f5 = f - f3;
        return f4 <= 0.0f ? 0.0f : f4 / f5;
    }

    private static String[] defaultHomRefFields() {
        String[] stringArray = new String[5];
        stringArray[1] = "\t0|0";
        stringArray[2] = "\t0|0:0";
        for (int i = 3; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i - 1] + ",0";
        }
        return stringArray;
    }

    private static String[] homRefFields(boolean bl, boolean bl2) {
        String[] stringArray = new String[DEFAULT_HOM_REF_FIELDS.length];
        for (int i = 1; i < stringArray.length; ++i) {
            int n;
            StringBuilder stringBuilder = new StringBuilder(DEFAULT_HOM_REF_FIELDS[i]);
            if (bl) {
                for (n = 1; n < i; ++n) {
                    stringBuilder.append(n == 1 ? (char)':' : ',');
                    stringBuilder.append(DS_VALS[0]);
                }
                for (n = 1; n < i; ++n) {
                    stringBuilder.append(n == 1 ? (char)':' : ',');
                    stringBuilder.append(DS_VALS[0]);
                }
            }
            if (bl2) {
                stringBuilder.append(':');
                stringBuilder.append(DS_VALS[100]);
                for (n = 1; n < i; ++n) {
                    for (int j = 0; j <= n; ++j) {
                        stringBuilder.append(',');
                        stringBuilder.append(DS_VALS[0]);
                    }
                }
            }
            stringArray[i] = stringBuilder.toString();
        }
        return stringArray;
    }
}

