/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.bluecow.spectro.ClipPanel;
import net.bluecow.spectro.PaintbrushTool;
import net.bluecow.spectro.PlayerThread;

public class ToolboxPanel {
    private final ClipPanel clipPanel;
    private final JPanel panel;

    public ToolboxPanel(ClipPanel clipPanel) {
        this.clipPanel = clipPanel;
        this.panel = new JPanel();
        this.panel.add(this.makeBrightnessSlider());
        this.panel.add(this.makeShuttleControls());
        this.panel.add(this.makeSaveButton());
        this.panel.add(this.makePaintControls());
    }

    private JComponent makePaintControls() {
        PaintbrushTool paintbrush = new PaintbrushTool(this.clipPanel);
        JLabel paintLabel = new JLabel("Paintbrush size: " + paintbrush.getRadius());
        return paintLabel;
    }

    private Component makeShuttleControls() {
        try {
            final PlayerThread playerThread = new PlayerThread(this.clipPanel.getClip());
            playerThread.start();
            final JButton playPause = new JButton("Play");
            JButton rewind = new JButton("Rewind");
            playPause.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if ("Play".equals(playPause.getText())) {
                        playerThread.startPlaying();
                        playPause.setText("Pause");
                    } else if ("Pause".equals(playPause.getText())) {
                        playerThread.stopPlaying();
                        playPause.setText("Play");
                    }
                }
            });
            rewind.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    playerThread.setPlaybackPosition(0);
                }
            });
            JPanel p = new JPanel(new FlowLayout());
            p.add(playPause);
            p.add(rewind);
            return p;
        }
        catch (LineUnavailableException ex) {
            throw new RuntimeException(ex);
        }
    }

    public JComponent makeBrightnessSlider() {
        final JSlider brightness = new JSlider(0, 5000000, (int)(this.clipPanel.getSpectralToScreenMultiplier() * 100.0));
        brightness.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ToolboxPanel.this.clipPanel.setSpectralToScreenMultiplier((double)brightness.getValue() / 100.0);
            }
        });
        Box box = Box.createVerticalBox();
        box.add(new JLabel("Brightness"));
        box.add(brightness);
        return box;
    }

    private JButton makeSaveButton() {
        JButton saveButton = new JButton("Save...");
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Window owner = SwingUtilities.getWindowAncestor(ToolboxPanel.this.panel);
                    FileDialog fd = owner instanceof Frame ? new FileDialog((Frame)owner, "Save sample as", 1) : new FileDialog((Dialog)owner, "Save sample as", 1);
                    fd.setVisible(true);
                    String dir = fd.getDirectory();
                    String file = fd.getFile();
                    if (file == null) {
                        return;
                    }
                    if (!file.toLowerCase().endsWith(".wav")) {
                        file = file + ".wav";
                    }
                    AudioSystem.write(ToolboxPanel.this.clipPanel.getClip().getAudio(), AudioFileFormat.Type.WAVE, new File(dir, file));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        return saveButton;
    }

    public JPanel getPanel() {
        return this.panel;
    }
}

