#    Jools -- a graphical puzzle game in the Tetris tradition
#    
#    Copyright (C) 2002-2003 Paul Pelzl
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# initialize.py
#
# Take care of pygame initialization, image and sound loading, etc.
#

import pygame, os, sys
from globals import *
from joolsutils import *
from config import *
import playlist, audiostatus, sound

# storage for audio status
class audioStatus:
   def __init__(self):
      pass
audio = audioStatus()

# initialize pygame
audio.Capable = 1
try:
   pygame.mixer.pre_init()
except:
   audio.Capable = 0

pygame.init()
screen = pygame.display.set_mode((SCREENW,SCREENH))
pygame.display.set_caption('Jools')
pygame.mouse.set_visible(1)
pygame.key.set_repeat()  # turns repeat OFF

if not audio.Capable or not pygame.mixer.get_init():
   audio.Capable = 0
   print "Warning: Unable to initialize sound via pygame.mixer.  Audio will be disabled."

try:
   pygame.font.init()
except:
   sys.exit("Error: Jools requires a Pygame library built with SDL_ttf support.")

   
audio.soundEnabled    = audio.Capable
audio.musicEnabled    = audio.Capable
audio.soundMultiplier = 1.0
audio.musicMultiplier = 1.0
audio.soundSet        = DEFAULT_SOUND_SET


# Create and draw a simple background
background = pygame.Surface(screen.get_size())
background = background.convert()
background.fill((1, 1, 1))
screen.blit(background, (0, 0))

# Draw the Jools logo
os.chdir(os.path.join(MEDIAROOT, "images"))
bigLogoImage, bigLogoRect = load_image("jools-logo-large.png", -1)
screen.blit(bigLogoImage, ((SCREENW - bigLogoRect.width)/2, 40))

# Inform the user that the game is loading
loadingImage, loadingRect = load_image("loading.png", -1)
screen.blit(loadingImage, ((SCREENW-loadingRect.width)/2, 350))
pygame.display.flip()


os.chdir("..")

# Loading sounds
point1 = sound.Sound(audio, 
   ("sounds/00/point1.wav", "sounds/01/point1.wav"),
   (POINT1_00_BASE_VOL, POINT1_01_BASE_VOL),
   DEFAULT_SOUND_SET)
point2 = sound.Sound(audio, 
   ("sounds/00/point2.wav", "sounds/01/point2.wav"),
   (POINT2_00_BASE_VOL, POINT2_01_BASE_VOL),
   DEFAULT_SOUND_SET)
point3 = sound.Sound(audio, 
   ("sounds/00/point3.wav", "sounds/01/point3.wav"),
   (POINT3_00_BASE_VOL, POINT3_01_BASE_VOL),
   DEFAULT_SOUND_SET)
point4 = sound.Sound(audio, 
   ("sounds/00/point4.wav", "sounds/01/point4.wav"),
   (POINT4_00_BASE_VOL, POINT4_01_BASE_VOL),
   DEFAULT_SOUND_SET)
point5 = sound.Sound(audio, 
   ("sounds/00/point5.wav", "sounds/01/point5.wav"),
   (POINT5_00_BASE_VOL, POINT5_01_BASE_VOL),
   DEFAULT_SOUND_SET)
point6 = sound.Sound(audio, 
   ("sounds/00/point6.wav", "sounds/01/point6.wav"),
   (POINT6_00_BASE_VOL, POINT6_01_BASE_VOL),
   DEFAULT_SOUND_SET)
click = sound.Sound(audio, 
   ("sounds/00/click.wav", "sounds/01/click.wav"),
   (CLICK_00_BASE_VOL, CLICK_01_BASE_VOL),
   DEFAULT_SOUND_SET)
buzz = sound.Sound(audio, 
   ("sounds/00/buzz.wav", "sounds/01/buzz.wav"),
   (BUZZ_00_BASE_VOL, BUZZ_01_BASE_VOL),
   DEFAULT_SOUND_SET)
levelup = sound.Sound(audio, 
   ("sounds/00/levelup.wav", "sounds/01/levelup.wav"),
   (LEVELUP_00_BASE_VOL, LEVELUP_01_BASE_VOL),
   DEFAULT_SOUND_SET)



# initialize music playlist
joolsPlaylist = playlist.Playlist(audio)

if audio.Capable:
   try:
      # FIXME: Would be better to allocate more channels,
      # but for some reason it fails on some platforms...
      # pygame.mixer.set_num_channels(30)
      pygame.mixer.set_num_channels(8)
   except:
      print "Warning: Unable to modify default number of audio channels."



# Get a font
#joolsFont = pygame.font.Font(None, 23)
joolsFont = pygame.font.Font("fonts/detonate.ttf", 16)
authorFont = pygame.font.Font("fonts/detonate.ttf", 20)
highScoreTitleFont = pygame.font.Font(None, 45)
highScoreFont1 = pygame.font.Font(None, 35)
highScoreFont2 = pygame.font.Font(None, 25)

# List of sprites to render at every update
spritesToRender = pygame.sprite.RenderUpdates()

# Load the jool images
imageCache = cacheImages()

# Load the timer image
timerImage, timerRect         = load_image("images/timer-gradient.png")
gameOverImage, gameOverRect   = load_image("images/gameover.png", -1)
levelUpImage, levelUpRect     = load_image("images/levelup.png", -1)
noMovesImage, noMovesRect     = load_image("images/nomoves.png", -1)
highScoreImage, highScoreRect = load_image("images/highscore.png", -1)
pausedImage, pausedRect       = load_image("images/paused.png", -1)

# Load the titlescreen images
timeTrialButton, timeTrialButtonRect = load_image("images/timetrial-button.png", -1)
timeTrialButtonOn, dummy             = load_image("images/timetrial-button-on.png", -1)
untimedButton, untimedButtonRect     = load_image("images/untimed-button.png", -1)
untimedButtonOn, dummy               = load_image("images/untimed-button-on.png", -1)
scoresButton, scoresButtonRect       = load_image("images/scores-button.png", -1)
scoresButtonOn, dummy                = load_image("images/scores-button-on.png", -1)
optionsButton, optionsButtonRect     = load_image("images/options-button.png", -1)
optionsButtonOn, dummy               = load_image("images/options-button-on.png", -1)
quitButton, quitButtonRect           = load_image("images/quit-button.png", -1)
quitButtonOn, dummy                  = load_image("images/quit-button-on.png", -1)


# Load the audio status images
notesOnImage, notesOnRect   = load_image("images/notes-on.png", -1)
notesOffImage, notesOffRect = load_image("images/notes-off.png", -1)
megaOnImage, megaOnRect     = load_image("images/megaphone-on.png", -1)
megaOffImage, megaOffRect   = load_image("images/megaphone-off.png", -1)

audioDisplay = audiostatus.AudioStatus(audio, screen)


# Load the images for the options screen
scaleImage, scaleRect         = load_image("images/scale.png", -1)
sliderImage, sliderRect       = load_image("images/slider.png", -1)
testButton, testRect          = load_image("images/test-button.png", -1)
testButtonOn, dummy           = load_image("images/test-button-on.png", -1)
backButton, backRect          = load_image("images/back-button.png", -1)
backButtonOn, dummy           = load_image("images/back-button-on.png", -1)
arrowUpImage, arrowUpRect     = load_image("images/arrowup.png", -1)
arrowDownImage, arrowDownRect = load_image("images/arrowdown.png", -1)


# Prep the display to show the main menu
logoImage, logoRect = load_image("images/jools-logo-small.png", -1)
logoEraser = pygame.Surface((logoRect.width, logoRect.height)).convert()
logoEraser.fill((1,1,1))

screen.blit(background, (0,0))
screen.blit(logoImage, ((SCREENW - logoRect.width)/2, 0), logoRect)


# arch-tag: load and initialize media
