/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.DirectNIOBuffer;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.io.nio.NIOBuffer;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.spdy.SPDYAsyncConnection;
import org.eclipse.jetty.spdy.api.ByteBufferDataInfo;
import org.eclipse.jetty.spdy.api.BytesDataInfo;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.Handler;
import org.eclipse.jetty.spdy.api.Headers;
import org.eclipse.jetty.spdy.api.ReplyInfo;
import org.eclipse.jetty.spdy.api.RstInfo;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamStatus;
import org.eclipse.jetty.spdy.api.SynInfo;
import org.eclipse.jetty.spdy.http.HTTPSPDYHeader;
import org.eclipse.jetty.spdy.http.PushStrategy;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ServerHTTPSPDYAsyncConnection
extends AbstractHttpConnection
implements AsyncConnection {
    private static final Logger logger = Log.getLogger(ServerHTTPSPDYAsyncConnection.class);
    private static final ByteBuffer ZERO_BYTES = ByteBuffer.allocate(0);
    private static final DataInfo END_OF_CONTENT = new ByteBufferDataInfo(ZERO_BYTES, true);
    private final Queue<Runnable> tasks = new LinkedList<Runnable>();
    private final BlockingQueue<DataInfo> dataInfos = new LinkedBlockingQueue<DataInfo>();
    private final short version;
    private final SPDYAsyncConnection connection;
    private final PushStrategy pushStrategy;
    private final Stream stream;
    private Headers headers;
    private DataInfo dataInfo;
    private NIOBuffer buffer;
    private volatile State state = State.INITIAL;
    private boolean dispatched;

    public ServerHTTPSPDYAsyncConnection(Connector connector, AsyncEndPoint endPoint, Server server, short version, SPDYAsyncConnection connection, PushStrategy pushStrategy, Stream stream) {
        super(connector, (EndPoint)endPoint, server);
        this.version = version;
        this.connection = connection;
        this.pushStrategy = pushStrategy;
        this.stream = stream;
        this.getParser().setPersistent(true);
    }

    protected HttpParser newHttpParser(Buffers requestBuffers, EndPoint endPoint, HttpParser.EventHandler requestHandler) {
        return new HTTPSPDYParser(requestBuffers, endPoint);
    }

    protected HttpGenerator newHttpGenerator(Buffers responseBuffers, EndPoint endPoint) {
        return new HTTPSPDYGenerator(responseBuffers, endPoint);
    }

    public AsyncEndPoint getEndPoint() {
        return (AsyncEndPoint)super.getEndPoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void post(Runnable task) {
        Queue<Runnable> queue = this.tasks;
        synchronized (queue) {
            logger.debug("Posting task {}", new Object[]{task});
            this.tasks.offer(task);
            this.dispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch() {
        Queue<Runnable> queue = this.tasks;
        synchronized (queue) {
            if (this.dispatched) {
                return;
            }
            final Runnable task = this.tasks.poll();
            if (task != null) {
                this.dispatched = true;
                logger.debug("Dispatching task {}", new Object[]{task});
                this.execute(new Runnable(){

                    @Override
                    public void run() {
                        logger.debug("Executing task {}", new Object[]{task});
                        task.run();
                        logger.debug("Completing task {}", new Object[]{task});
                        ServerHTTPSPDYAsyncConnection.this.dispatched = false;
                        ServerHTTPSPDYAsyncConnection.this.dispatch();
                    }
                });
            }
        }
    }

    protected void execute(Runnable task) {
        this.getServer().getThreadPool().dispatch(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection handle() {
        ServerHTTPSPDYAsyncConnection.setCurrentConnection((AbstractHttpConnection)this);
        try {
            ServerHTTPSPDYAsyncConnection buffer;
            switch (this.state) {
                case INITIAL: {
                    break;
                }
                case REQUEST: {
                    Headers.Header method = this.headers.get(HTTPSPDYHeader.METHOD.name(this.version));
                    Headers.Header uri = this.headers.get(HTTPSPDYHeader.URI.name(this.version));
                    Headers.Header version = this.headers.get(HTTPSPDYHeader.VERSION.name(this.version));
                    if (method == null || uri == null || version == null) {
                        throw new HttpException(400);
                    }
                    String m = method.value();
                    String u = uri.value();
                    String v = version.value();
                    logger.debug("HTTP > {} {} {}", new Object[]{m, u, v});
                    this.startRequest((Buffer)new ByteArrayBuffer(m), (Buffer)new ByteArrayBuffer(u), (Buffer)new ByteArrayBuffer(v));
                    Headers.Header schemeHeader = this.headers.get(HTTPSPDYHeader.SCHEME.name(this.version));
                    if (schemeHeader != null) {
                        this._request.setScheme(schemeHeader.value());
                    }
                    this.updateState(State.HEADERS);
                    this.handle();
                    break;
                }
                case HEADERS: {
                    block25: for (Headers.Header header : this.headers) {
                        String name = header.name();
                        HTTPSPDYHeader specialHeader = HTTPSPDYHeader.from(this.version, name);
                        if (specialHeader != null) {
                            if (specialHeader != HTTPSPDYHeader.HOST) continue;
                            name = "host";
                        }
                        switch (name) {
                            case "connection": 
                            case "keep-alive": 
                            case "proxy-connection": 
                            case "transfer-encoding": {
                                continue block25;
                            }
                        }
                        String value = header.value();
                        logger.debug("HTTP > {}: {}", new Object[]{name, value});
                        this.parsedHeader((Buffer)new ByteArrayBuffer(name), (Buffer)new ByteArrayBuffer(value));
                    }
                    break;
                }
                case HEADERS_COMPLETE: {
                    this.headerComplete();
                    break;
                }
                case CONTENT: {
                    buffer = this.buffer;
                    if (buffer == null || buffer.length() <= 0) break;
                    this.content((Buffer)buffer);
                    break;
                }
                case FINAL: {
                    this.messageComplete(0L);
                    break;
                }
                case ASYNC: {
                    this.handleRequest();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            buffer = this;
            return buffer;
        }
        catch (HttpException x) {
            this.respond(this.stream, x.getStatus());
            ServerHTTPSPDYAsyncConnection serverHTTPSPDYAsyncConnection = this;
            return serverHTTPSPDYAsyncConnection;
        }
        catch (IOException x) {
            this.close(this.stream);
            ServerHTTPSPDYAsyncConnection serverHTTPSPDYAsyncConnection = this;
            return serverHTTPSPDYAsyncConnection;
        }
        finally {
            ServerHTTPSPDYAsyncConnection.setCurrentConnection(null);
        }
    }

    private void respond(Stream stream, int status) {
        if (stream.isUnidirectional()) {
            stream.getSession().rst(new RstInfo(stream.getId(), StreamStatus.INTERNAL_ERROR));
        } else {
            Headers headers = new Headers();
            headers.put(HTTPSPDYHeader.STATUS.name(this.version), String.valueOf(status));
            headers.put(HTTPSPDYHeader.VERSION.name(this.version), "HTTP/1.1");
            stream.reply(new ReplyInfo(headers, true));
        }
    }

    private void close(Stream stream) {
        stream.getSession().goAway();
    }

    public void onInputShutdown() throws IOException {
    }

    private void updateState(State newState) {
        logger.debug("State update {} -> {}", new Object[]{this.state, newState});
        this.state = newState;
    }

    public void beginRequest(final Headers headers, final boolean endRequest) {
        this.headers = headers.isEmpty() ? null : headers;
        this.post(new Runnable(){

            @Override
            public void run() {
                if (!headers.isEmpty()) {
                    ServerHTTPSPDYAsyncConnection.this.updateState(State.REQUEST);
                }
                ServerHTTPSPDYAsyncConnection.this.handle();
                if (endRequest) {
                    ServerHTTPSPDYAsyncConnection.this.performEndRequest();
                }
            }
        });
    }

    public void headers(Headers headers) {
        this.headers = headers;
        this.post(new Runnable(){

            @Override
            public void run() {
                ServerHTTPSPDYAsyncConnection.this.updateState(ServerHTTPSPDYAsyncConnection.this.state == State.INITIAL ? State.REQUEST : State.HEADERS);
                ServerHTTPSPDYAsyncConnection.this.handle();
            }
        });
    }

    public void content(final DataInfo dataInfo, boolean endRequest) {
        ByteBufferDataInfo copyDataInfo = new ByteBufferDataInfo(dataInfo.asByteBuffer(false), dataInfo.isClose(), dataInfo.isCompress()){

            public void consume(int delta) {
                super.consume(delta);
                dataInfo.consume(delta);
            }
        };
        logger.debug("Queuing last={} content {}", new Object[]{endRequest, copyDataInfo});
        this.dataInfos.offer((DataInfo)copyDataInfo);
        if (endRequest) {
            this.dataInfos.offer(END_OF_CONTENT);
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                logger.debug("HTTP > {} bytes of content", new Object[]{dataInfo.length()});
                if (ServerHTTPSPDYAsyncConnection.this.state == State.HEADERS) {
                    ServerHTTPSPDYAsyncConnection.this.updateState(State.HEADERS_COMPLETE);
                    ServerHTTPSPDYAsyncConnection.this.handle();
                }
                ServerHTTPSPDYAsyncConnection.this.updateState(State.CONTENT);
                ServerHTTPSPDYAsyncConnection.this.handle();
            }
        });
    }

    public void endRequest() {
        this.post(new Runnable(){

            @Override
            public void run() {
                ServerHTTPSPDYAsyncConnection.this.performEndRequest();
            }
        });
    }

    private void performEndRequest() {
        if (this.state == State.HEADERS) {
            this.updateState(State.HEADERS_COMPLETE);
            this.handle();
        }
        this.updateState(State.FINAL);
        this.handle();
    }

    public void async() {
        this.post(new Runnable(){

            @Override
            public void run() {
                State oldState = ServerHTTPSPDYAsyncConnection.this.state;
                ServerHTTPSPDYAsyncConnection.this.updateState(State.ASYNC);
                ServerHTTPSPDYAsyncConnection.this.handle();
                ServerHTTPSPDYAsyncConnection.this.updateState(oldState);
            }
        });
    }

    protected void reply(Stream stream, ReplyInfo replyInfo) {
        if (!stream.isUnidirectional()) {
            stream.reply(replyInfo);
        }
        if (replyInfo.getHeaders().get(HTTPSPDYHeader.STATUS.name(this.version)).value().startsWith("200") && !stream.isClosed()) {
            Headers.Header scheme = this.headers.get(HTTPSPDYHeader.SCHEME.name(this.version));
            Headers.Header host = this.headers.get(HTTPSPDYHeader.HOST.name(this.version));
            Headers.Header uri = this.headers.get(HTTPSPDYHeader.URI.name(this.version));
            Set<String> pushResources = this.pushStrategy.apply(stream, this.headers, replyInfo.getHeaders());
            for (String pushResourcePath : pushResources) {
                final Headers requestHeaders = this.createRequestHeaders(scheme, host, uri, pushResourcePath);
                Headers pushHeaders = this.createPushHeaders(scheme, host, pushResourcePath);
                stream.syn(new SynInfo(pushHeaders, false), (long)this.getMaxIdleTime(), TimeUnit.MILLISECONDS, (Handler)new Handler.Adapter<Stream>(){

                    public void completed(Stream pushStream) {
                        ServerHTTPSPDYAsyncConnection pushConnection = new ServerHTTPSPDYAsyncConnection(ServerHTTPSPDYAsyncConnection.this.getConnector(), ServerHTTPSPDYAsyncConnection.this.getEndPoint(), ServerHTTPSPDYAsyncConnection.this.getServer(), ServerHTTPSPDYAsyncConnection.this.version, ServerHTTPSPDYAsyncConnection.this.connection, ServerHTTPSPDYAsyncConnection.this.pushStrategy, pushStream);
                        pushConnection.beginRequest(requestHeaders, true);
                    }
                });
            }
        }
    }

    private Headers createRequestHeaders(Headers.Header scheme, Headers.Header host, Headers.Header uri, String pushResourcePath) {
        Headers requestHeaders = new Headers();
        requestHeaders.put(HTTPSPDYHeader.METHOD.name(this.version), "GET");
        requestHeaders.put(HTTPSPDYHeader.VERSION.name(this.version), "HTTP/1.1");
        requestHeaders.put(scheme);
        requestHeaders.put(host);
        requestHeaders.put(HTTPSPDYHeader.URI.name(this.version), pushResourcePath);
        String referrer = scheme.value() + "://" + host.value() + uri.value();
        requestHeaders.put("referer", referrer);
        requestHeaders.put(this.headers.get("accept-encoding"));
        requestHeaders.put("x-spdy-push", "true");
        return requestHeaders;
    }

    private Headers createPushHeaders(Headers.Header scheme, Headers.Header host, String pushResourcePath) {
        Headers pushHeaders = new Headers();
        if (this.version == 2) {
            pushHeaders.put(HTTPSPDYHeader.URI.name(this.version), scheme.value() + "://" + host.value() + pushResourcePath);
        } else {
            pushHeaders.put(HTTPSPDYHeader.URI.name(this.version), pushResourcePath);
            pushHeaders.put(scheme);
            pushHeaders.put(host);
        }
        pushHeaders.put(HTTPSPDYHeader.STATUS.name(this.version), "200");
        pushHeaders.put(HTTPSPDYHeader.VERSION.name(this.version), "HTTP/1.1");
        return pushHeaders;
    }

    private Buffer consumeContent(long maxIdleTime) throws IOException, InterruptedException {
        while (true) {
            State state;
            if ((state = this.state) != State.HEADERS_COMPLETE && state != State.CONTENT && state != State.FINAL) {
                throw new IllegalStateException();
            }
            if (this.buffer != null) {
                if (this.buffer.length() > 0) {
                    logger.debug("Consuming content bytes, {} available", new Object[]{this.buffer.length()});
                    return this.buffer;
                }
                this.dataInfo.consume(this.dataInfo.length());
                logger.debug("Consumed {} content bytes, queue size {}", new Object[]{this.dataInfo.consumed(), this.dataInfos.size()});
                this.dataInfo = null;
                this.buffer = null;
                continue;
            }
            logger.debug("Waiting at most {} ms for content bytes", new Object[]{maxIdleTime});
            long begin = System.nanoTime();
            this.dataInfo = this.dataInfos.poll(maxIdleTime, TimeUnit.MILLISECONDS);
            long elapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - begin);
            logger.debug("Waited {} ms for content bytes", new Object[]{elapsed});
            if (this.dataInfo == null) break;
            if (this.dataInfo == END_OF_CONTENT) {
                logger.debug("End of content bytes, queue size {}", new Object[]{this.dataInfos.size()});
                return null;
            }
            ByteBuffer byteBuffer = this.dataInfo.asByteBuffer(false);
            this.buffer = (NIOBuffer)(byteBuffer.isDirect() ? new DirectNIOBuffer(byteBuffer, false) : new IndirectNIOBuffer(byteBuffer, false));
        }
        this.stream.getSession().goAway();
        throw new EOFException("read timeout");
    }

    private int availableContent() {
        State state = this.state;
        if (state != State.HEADERS_COMPLETE && state != State.CONTENT) {
            throw new IllegalStateException();
        }
        return this.buffer == null ? 0 : this.buffer.length();
    }

    public void commitResponse(boolean last) throws IOException {
        super.commitResponse(last);
    }

    public void flushResponse() throws IOException {
        this.commitResponse(false);
    }

    public void completeResponse() throws IOException {
        super.completeResponse();
    }

    private class HTTPSPDYGenerator
    extends HttpGenerator {
        private boolean closed;

        private HTTPSPDYGenerator(Buffers buffers, EndPoint endPoint) {
            super(buffers, endPoint);
        }

        public void send1xx(int code) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void sendResponse(Buffer response) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void sendError(int code, String reason, String content, boolean close) throws IOException {
            super.sendError(code, reason, content, close);
        }

        public void completeHeader(HttpFields fields, boolean allContentAdded) throws IOException {
            Headers headers = new Headers();
            String version = "HTTP/1.1";
            headers.put(HTTPSPDYHeader.VERSION.name(ServerHTTPSPDYAsyncConnection.this.version), version);
            StringBuilder status = new StringBuilder().append(this._status);
            if (this._reason != null) {
                status.append(" ").append(this._reason.toString("UTF-8"));
            }
            headers.put(HTTPSPDYHeader.STATUS.name(ServerHTTPSPDYAsyncConnection.this.version), status.toString());
            logger.debug("HTTP < {} {}", new Object[]{version, status});
            if (fields != null) {
                for (int i = 0; i < fields.size(); ++i) {
                    HttpFields.Field field = fields.getField(i);
                    String name = field.getName().toLowerCase(Locale.ENGLISH);
                    String value = field.getValue();
                    headers.put(name, value);
                    logger.debug("HTTP < {}: {}", new Object[]{name, value});
                }
            }
            Buffer content = this.getContentBuffer();
            ServerHTTPSPDYAsyncConnection.this.reply(ServerHTTPSPDYAsyncConnection.this.stream, new ReplyInfo(headers, content == null));
            if (content != null) {
                this.closed = false;
                this._state = 2;
            } else {
                this.closed = true;
                this._state = 4;
            }
        }

        private Buffer getContentBuffer() {
            if (this._buffer != null && this._buffer.length() > 0) {
                return this._buffer;
            }
            if (this._content != null && this._content.length() > 0) {
                return this._content;
            }
            return null;
        }

        public void addContent(Buffer content, boolean last) throws IOException {
            super.addContent(content, last);
        }

        public void flush(long maxIdleTime) throws IOException {
            try {
                Buffer content = this.getContentBuffer();
                while (content != null) {
                    DataInfo dataInfo = this.toDataInfo(content, this.closed);
                    logger.debug("HTTP < {} bytes of content", new Object[]{dataInfo.length()});
                    ServerHTTPSPDYAsyncConnection.this.stream.data(dataInfo).get(maxIdleTime, TimeUnit.MILLISECONDS);
                    content.clear();
                    this._bypass = false;
                    content = this.getContentBuffer();
                }
            }
            catch (TimeoutException x) {
                ServerHTTPSPDYAsyncConnection.this.stream.getSession().goAway();
                throw new EOFException("write timeout");
            }
            catch (InterruptedException x) {
                throw new InterruptedIOException();
            }
            catch (ExecutionException x) {
                throw new IOException(x.getCause());
            }
        }

        private DataInfo toDataInfo(Buffer buffer, boolean close) {
            if (buffer instanceof ByteArrayBuffer) {
                return new BytesDataInfo(buffer.array(), buffer.getIndex(), buffer.length(), close);
            }
            if (buffer instanceof NIOBuffer) {
                ByteBuffer byteBuffer = ((NIOBuffer)buffer).getByteBuffer();
                byteBuffer.limit(buffer.putIndex());
                byteBuffer.position(buffer.getIndex());
                return new ByteBufferDataInfo(byteBuffer, close);
            }
            return new BytesDataInfo(buffer.asArray(), close);
        }

        public int flushBuffer() throws IOException {
            throw new UnsupportedOperationException();
        }

        public void blockForOutput(long maxIdleTime) throws IOException {
            this.flush(maxIdleTime);
        }

        public void complete() throws IOException {
            Buffer content = this.getContentBuffer();
            if (content != null) {
                this.closed = true;
                this._state = 4;
                this.flush(ServerHTTPSPDYAsyncConnection.this.getMaxIdleTime());
            } else if (!this.closed) {
                this.closed = true;
                this._state = 4;
                ServerHTTPSPDYAsyncConnection.this.stream.data((DataInfo)new ByteBufferDataInfo(ZERO_BYTES, true));
            }
        }
    }

    private static class HTTPSPDYParserHandler
    extends HttpParser.EventHandler {
        private HTTPSPDYParserHandler() {
        }

        public void startRequest(Buffer method, Buffer url, Buffer version) throws IOException {
        }

        public void content(Buffer ref) throws IOException {
        }

        public void startResponse(Buffer version, int status, Buffer reason) throws IOException {
        }
    }

    private class HTTPSPDYParser
    extends HttpParser {
        public HTTPSPDYParser(Buffers buffers, EndPoint endPoint) {
            super(buffers, endPoint, (HttpParser.EventHandler)new HTTPSPDYParserHandler());
        }

        public Buffer blockForContent(long maxIdleTime) throws IOException {
            try {
                return ServerHTTPSPDYAsyncConnection.this.consumeContent(maxIdleTime);
            }
            catch (InterruptedException x) {
                throw new InterruptedIOException();
            }
        }

        public int available() throws IOException {
            return ServerHTTPSPDYAsyncConnection.this.availableContent();
        }
    }

    private static enum State {
        INITIAL,
        REQUEST,
        HEADERS,
        HEADERS_COMPLETE,
        CONTENT,
        FINAL,
        ASYNC;

    }
}

