/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ResourceManager;

public final class IndianSettlementPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(IndianSettlementPanel.class.getName());

    public IndianSettlementPanel(FreeColClient freeColClient, IndianSettlement settlement) {
        super(freeColClient, new MigLayout("wrap 2, gapx 20", "", ""));
        ImageLibrary lib = this.getImageLibrary();
        JLabel settlementLabel = new JLabel(new ImageIcon(lib.getSettlementImage(settlement)));
        Player indian = settlement.getOwner();
        Player player = this.getMyPlayer();
        boolean contacted = settlement.hasContacted(player);
        boolean visited = settlement.hasVisited(player);
        String text = Messages.message(settlement.getLocationLabelFor(player)) + ", " + Messages.message(StringTemplate.template(settlement.isCapital() ? "indianSettlementPanel.indianCapital" : "indianSettlementPanel.indianSettlement").addStringTemplate("%nation%", indian.getNationLabel()));
        Tension tension = settlement.getAlarm(player);
        if (tension != null) {
            text = text + " (" + Messages.getName(tension) + ")";
        }
        if (settlement.worthScouting(player)) {
            text = text + ResourceManager.getString("unscoutedIndianSettlement");
        }
        settlementLabel.setText(text);
        this.add(settlementLabel);
        Unit missionary = settlement.getMissionary();
        if (missionary != null) {
            this.add(Utility.localizedLabel(missionary.getLabel(Unit.UnitLabelType.NATIONAL), new ImageIcon(lib.getSmallUnitImage(missionary)), 0));
        }
        this.add((Component)Utility.localizedLabel("indianSettlementPanel.learnableSkill"), "newline");
        UnitType skillType = settlement.getLearnableSkill();
        this.add(Utility.localizedLabel(settlement.getLearnableSkillLabel(visited), visited && skillType != null ? new ImageIcon(lib.getSmallUnitImage(skillType)) : null, 0));
        this.add((Component)Utility.localizedLabel("indianSettlementPanel.mostHated"), "newline");
        Player mostHated = settlement.getMostHated();
        this.add(Utility.localizedLabel(settlement.getMostHatedLabel(contacted), contacted && mostHated != null ? new ImageIcon(lib.getSmallMiscIconImage(mostHated.getNation())) : null, 0));
        GoodsType[] wantedGoods = settlement.getWantedGoods();
        int n = visited ? settlement.getWantedGoodsAmount() : 2;
        this.add((Component)Utility.localizedLabel("indianSettlementPanel.highlyWanted"), "newline");
        this.add(Utility.localizedLabel(settlement.getWantedGoodsLabel(0, player), visited && wantedGoods[0] != null ? new ImageIcon(lib.getIconImage(wantedGoods[0])) : null, 0));
        this.add((Component)Utility.localizedLabel("indianSettlementPanel.otherWanted"), "newline");
        String x = "split " + Integer.toString(n - 1);
        for (int i = 1; i < n; ++i) {
            this.add((Component)Utility.localizedLabel(settlement.getWantedGoodsLabel(i, player), visited && wantedGoods[i] != null ? new ImageIcon(lib.getIconImage(wantedGoods[i])) : null, 0), x);
            x = null;
        }
        this.add((Component)this.okButton, "newline 20, span, tag ok");
        this.setSize(this.getPreferredSize());
    }
}

